/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.AsyncQueryHandler;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.SystemClock;
import android.provider.ContactsContract;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.QuickContactBadge;
import android.widget.TextView;

public class ContactHeaderWidget
extends FrameLayout
implements View.OnClickListener {
    private static final String TAG = "ContactHeaderWidget";
    private TextView mDisplayNameView;
    private View mAggregateBadge;
    private TextView mPhoneticNameView;
    private CheckBox mStarredView;
    private QuickContactBadge mPhotoView;
    private ImageView mPresenceView;
    private TextView mStatusView;
    private TextView mStatusAttributionView;
    private int mNoPhotoResource;
    private QueryHandler mQueryHandler;
    protected Uri mContactUri;
    protected String[] mExcludeMimes = null;
    protected ContentResolver mContentResolver = this.mContext.getContentResolver();
    private ContactHeaderListener mListener;
    protected static final String[] PHONE_LOOKUP_PROJECTION = new String[]{"_id", "lookup"};
    protected static final int PHONE_LOOKUP_CONTACT_ID_COLUMN_INDEX = 0;
    protected static final int PHONE_LOOKUP_CONTACT_LOOKUP_KEY_COLUMN_INDEX = 1;
    protected static final String[] EMAIL_LOOKUP_PROJECTION = new String[]{"contact_id", "lookup"};
    protected static final int EMAIL_LOOKUP_CONTACT_ID_COLUMN_INDEX = 0;
    protected static final int EMAIL_LOOKUP_CONTACT_LOOKUP_KEY_COLUMN_INDEX = 1;
    protected static final String[] CONTACT_LOOKUP_PROJECTION = new String[]{"_id"};
    protected static final int CONTACT_LOOKUP_ID_COLUMN_INDEX = 0;
    private static final int TOKEN_CONTACT_INFO = 0;
    private static final int TOKEN_PHONE_LOOKUP = 1;
    private static final int TOKEN_EMAIL_LOOKUP = 2;
    private static final int TOKEN_PHOTO_QUERY = 3;

    public ContactHeaderWidget(Context context) {
        this(context, null);
    }

    public ContactHeaderWidget(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ContactHeaderWidget(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        inflater.inflate(17367070, (ViewGroup)this);
        this.mDisplayNameView = (TextView)this.findViewById(16908695);
        this.mAggregateBadge = this.findViewById(16908694);
        this.mPhoneticNameView = (TextView)this.findViewById(16908696);
        this.mStarredView = (CheckBox)this.findViewById(16908700);
        this.mStarredView.setOnClickListener(this);
        this.mPhotoView = (QuickContactBadge)this.findViewById(16908693);
        this.mPresenceView = (ImageView)this.findViewById(16908699);
        this.mStatusView = (TextView)this.findViewById(16908697);
        this.mStatusAttributionView = (TextView)this.findViewById(16908698);
        long now = SystemClock.elapsedRealtime();
        int num = (int)now & 0xF;
        this.mNoPhotoResource = num < 9 ? 17301905 : (num < 14 ? 17301906 : 17301907);
        this.resetAsyncQueryHandler();
    }

    public void enableClickListeners() {
        this.mDisplayNameView.setOnClickListener(this);
        this.mPhotoView.setOnClickListener(this);
    }

    public void setContactHeaderListener(ContactHeaderListener listener) {
        this.mListener = listener;
    }

    private void performPhotoClick() {
        if (this.mListener != null) {
            this.mListener.onPhotoClick(this.mPhotoView);
        }
    }

    private void performDisplayNameClick() {
        if (this.mListener != null) {
            this.mListener.onDisplayNameClick(this.mDisplayNameView);
        }
    }

    public void setSelectedContactsAppTabIndex(int value) {
        this.mPhotoView.setSelectedContactsAppTabIndex(value);
    }

    public void showAggregateBadge(boolean showBagde) {
        this.mAggregateBadge.setVisibility(showBagde ? 0 : 8);
    }

    public void showStar(boolean showStar) {
        this.mStarredView.setVisibility(showStar ? 0 : 8);
    }

    public void setStared(boolean starred) {
        this.mStarredView.setChecked(starred);
    }

    public void setPresence(int presence) {
        this.mPresenceView.setImageResource(ContactsContract.StatusUpdates.getPresenceIconResourceId(presence));
    }

    public void setContactUri(Uri uri) {
        this.setContactUri(uri, true);
    }

    public void setContactUri(Uri uri, boolean sendToFastrack) {
        this.mContactUri = uri;
        if (sendToFastrack) {
            this.mPhotoView.assignContactUri(uri);
        }
    }

    public void setPhoto(Bitmap bitmap) {
        this.mPhotoView.setImageBitmap(bitmap);
    }

    public void setDisplayName(CharSequence displayName, CharSequence phoneticName) {
        this.mDisplayNameView.setText(displayName);
        if (!TextUtils.isEmpty(phoneticName)) {
            this.mPhoneticNameView.setText(phoneticName);
            this.mPhoneticNameView.setVisibility(0);
        } else {
            this.mPhoneticNameView.setVisibility(8);
        }
    }

    public void setSocialSnippet(CharSequence snippet) {
        if (snippet == null) {
            this.mStatusView.setVisibility(8);
            this.mStatusAttributionView.setVisibility(8);
        } else {
            this.mStatusView.setText(snippet);
            this.mStatusView.setVisibility(0);
        }
    }

    public void setExcludeMimes(String[] excludeMimes) {
        this.mExcludeMimes = excludeMimes;
        this.mPhotoView.setExcludeMimes(excludeMimes);
    }

    public void bindFromContactLookupUri(Uri contactLookupUri) {
        this.bindFromContactUriInternal(contactLookupUri, true);
    }

    private void bindFromContactUriInternal(Uri contactUri, boolean resetQueryHandler) {
        this.mContactUri = contactUri;
        this.startContactQuery(contactUri, resetQueryHandler);
    }

    public void bindFromEmail(String emailAddress) {
        this.resetAsyncQueryHandler();
        this.mQueryHandler.startQuery(2, emailAddress, Uri.withAppendedPath(ContactsContract.CommonDataKinds.Email.CONTENT_LOOKUP_URI, Uri.encode(emailAddress)), EMAIL_LOOKUP_PROJECTION, null, null, null);
    }

    public void bindFromPhoneNumber(String number) {
        this.resetAsyncQueryHandler();
        this.mQueryHandler.startQuery(1, number, Uri.withAppendedPath(ContactsContract.PhoneLookup.CONTENT_FILTER_URI, Uri.encode(number)), PHONE_LOOKUP_PROJECTION, null, null, null);
    }

    private void startContactQuery(Uri contactUri, boolean resetQueryHandler) {
        if (resetQueryHandler) {
            this.resetAsyncQueryHandler();
        }
        this.mQueryHandler.startQuery(0, contactUri, contactUri, ContactQuery.COLUMNS, null, null, null);
    }

    protected void startPhotoQuery(long photoId, Uri lookupKey, boolean resetQueryHandler) {
        if (resetQueryHandler) {
            this.resetAsyncQueryHandler();
        }
        this.mQueryHandler.startQuery(3, lookupKey, ContentUris.withAppendedId(ContactsContract.Data.CONTENT_URI, photoId), PhotoQuery.COLUMNS, null, null, null);
    }

    public void wipeClean() {
        this.resetAsyncQueryHandler();
        this.setDisplayName(null, null);
        this.setPhoto(this.loadPlaceholderPhoto(null));
        this.setSocialSnippet(null);
        this.setPresence(0);
        this.mContactUri = null;
        this.mExcludeMimes = null;
    }

    private void resetAsyncQueryHandler() {
        this.mQueryHandler = new QueryHandler(this.mContentResolver);
    }

    protected void bindContactInfo(Cursor c) {
        String displayName = c.getString(3);
        String phoneticName = c.getString(4);
        this.setDisplayName(displayName, phoneticName);
        boolean starred = c.getInt(5) != 0;
        this.mStarredView.setChecked(starred);
        if (!c.isNull(6)) {
            int presence = c.getInt(6);
            this.mPresenceView.setImageResource(ContactsContract.StatusUpdates.getPresenceIconResourceId(presence));
            this.mPresenceView.setVisibility(0);
        } else {
            this.mPresenceView.setVisibility(8);
        }
        String status = c.getString(7);
        if (!TextUtils.isEmpty(status)) {
            CharSequence attribution;
            this.mStatusView.setText(status);
            this.mStatusView.setVisibility(0);
            CharSequence timestamp = null;
            if (!c.isNull(8)) {
                long date = c.getLong(8);
                int flags = 262144;
                timestamp = DateUtils.getRelativeTimeSpanString(date, System.currentTimeMillis(), 60000L, flags);
            }
            String label = null;
            if (!c.isNull(10)) {
                Resources resources;
                String resPackage = c.getString(9);
                int labelResource = c.getInt(10);
                if (TextUtils.isEmpty(resPackage)) {
                    resources = this.getResources();
                } else {
                    PackageManager pm = this.getContext().getPackageManager();
                    try {
                        resources = pm.getResourcesForApplication(resPackage);
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Log.w(TAG, "Contact status update resource package not found: " + resPackage);
                        resources = null;
                    }
                }
                if (resources != null) {
                    try {
                        label = resources.getString(labelResource);
                    }
                    catch (Resources.NotFoundException e) {
                        Log.w(TAG, "Contact status update resource not found: " + resPackage + "@" + labelResource);
                    }
                }
            }
            if ((attribution = timestamp != null && label != null ? this.getContext().getString(17040005, timestamp, label) : (timestamp == null && label != null ? this.getContext().getString(17040004, label) : (timestamp != null ? timestamp : null))) != null) {
                this.mStatusAttributionView.setText(attribution);
                this.mStatusAttributionView.setVisibility(0);
            } else {
                this.mStatusAttributionView.setVisibility(8);
            }
        } else {
            this.mStatusView.setVisibility(8);
            this.mStatusAttributionView.setVisibility(8);
        }
    }

    public void onClick(View view) {
        switch (view.getId()) {
            case 16908700: {
                if (this.mContactUri == null) break;
                ContentValues values = new ContentValues(1);
                values.put("starred", this.mStarredView.isChecked());
                this.mContentResolver.update(this.mContactUri, values, null, null);
                break;
            }
            case 16908693: {
                this.performPhotoClick();
                break;
            }
            case 16908695: {
                this.performDisplayNameClick();
            }
        }
    }

    private Bitmap loadPlaceholderPhoto(BitmapFactory.Options options) {
        if (this.mNoPhotoResource == 0) {
            return null;
        }
        return BitmapFactory.decodeResource(this.mContext.getResources(), this.mNoPhotoResource, options);
    }

    private class QueryHandler
    extends AsyncQueryHandler {
        public QueryHandler(ContentResolver cr) {
            super(cr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onQueryComplete(int token, Object cookie, Cursor cursor) {
            try {
                if (this != ContactHeaderWidget.this.mQueryHandler) {
                    Log.d(ContactHeaderWidget.TAG, "onQueryComplete: discard result, the query handler is reset!");
                    Object var8_4 = null;
                    if (cursor != null) {
                        cursor.close();
                    }
                    return;
                }
                switch (token) {
                    case 3: {
                        Bitmap photoBitmap = null;
                        if (cursor != null && cursor.moveToFirst() && !cursor.isNull(0)) {
                            byte[] photoData = cursor.getBlob(0);
                            photoBitmap = BitmapFactory.decodeByteArray(photoData, 0, photoData.length, null);
                        }
                        if (photoBitmap == null) {
                            photoBitmap = ContactHeaderWidget.this.loadPlaceholderPhoto(null);
                        }
                        ContactHeaderWidget.this.mPhotoView.setImageBitmap(photoBitmap);
                        if (cookie != null && cookie instanceof Uri) {
                            ContactHeaderWidget.this.mPhotoView.assignContactUri((Uri)cookie);
                        }
                        ContactHeaderWidget.this.invalidate();
                        break;
                    }
                    case 0: {
                        if (cursor != null && cursor.moveToFirst()) {
                            ContactHeaderWidget.this.bindContactInfo(cursor);
                            Uri lookupUri = ContactsContract.Contacts.getLookupUri(cursor.getLong(0), cursor.getString(1));
                            long photoId = cursor.getLong(2);
                            if (photoId == 0L) {
                                ContactHeaderWidget.this.mPhotoView.setImageBitmap(ContactHeaderWidget.this.loadPlaceholderPhoto(null));
                                if (cookie != null && cookie instanceof Uri) {
                                    ContactHeaderWidget.this.mPhotoView.assignContactUri((Uri)cookie);
                                }
                                ContactHeaderWidget.this.invalidate();
                                break;
                            }
                            ContactHeaderWidget.this.startPhotoQuery(photoId, lookupUri, false);
                            break;
                        }
                        ContactHeaderWidget.this.setDisplayName(null, null);
                        ContactHeaderWidget.this.setSocialSnippet(null);
                        ContactHeaderWidget.this.setPhoto(ContactHeaderWidget.this.loadPlaceholderPhoto(null));
                        break;
                    }
                    case 1: {
                        if (cursor != null && cursor.moveToFirst()) {
                            long contactId = cursor.getLong(0);
                            String lookupKey = cursor.getString(1);
                            ContactHeaderWidget.this.bindFromContactUriInternal(ContactsContract.Contacts.getLookupUri(contactId, lookupKey), false);
                            break;
                        }
                        String phoneNumber = (String)cookie;
                        ContactHeaderWidget.this.setDisplayName(phoneNumber, null);
                        ContactHeaderWidget.this.setSocialSnippet(null);
                        ContactHeaderWidget.this.setPhoto(ContactHeaderWidget.this.loadPlaceholderPhoto(null));
                        ContactHeaderWidget.this.mPhotoView.assignContactFromPhone(phoneNumber, true);
                        break;
                    }
                    case 2: {
                        if (cursor != null && cursor.moveToFirst()) {
                            long contactId = cursor.getLong(0);
                            String lookupKey = cursor.getString(1);
                            ContactHeaderWidget.this.bindFromContactUriInternal(ContactsContract.Contacts.getLookupUri(contactId, lookupKey), false);
                            break;
                        }
                        String emailAddress = (String)cookie;
                        ContactHeaderWidget.this.setDisplayName(emailAddress, null);
                        ContactHeaderWidget.this.setSocialSnippet(null);
                        ContactHeaderWidget.this.setPhoto(ContactHeaderWidget.this.loadPlaceholderPhoto(null));
                        ContactHeaderWidget.this.mPhotoView.assignContactFromEmail(emailAddress, true);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                if (cursor != null) {
                    cursor.close();
                }
                throw throwable;
            }
            Object var8_5 = null;
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    private static interface PhotoQuery {
        public static final String[] COLUMNS = new String[]{"data15"};
        public static final int PHOTO = 0;
    }

    private static interface ContactQuery {
        public static final String[] COLUMNS = new String[]{"_id", "lookup", "photo_id", "display_name", "phonetic_name", "starred", "contact_presence", "contact_status", "contact_status_ts", "contact_status_res_package", "contact_status_label"};
        public static final int _ID = 0;
        public static final int LOOKUP_KEY = 1;
        public static final int PHOTO_ID = 2;
        public static final int DISPLAY_NAME = 3;
        public static final int PHONETIC_NAME = 4;
        public static final int STARRED = 5;
        public static final int CONTACT_PRESENCE_STATUS = 6;
        public static final int CONTACT_STATUS = 7;
        public static final int CONTACT_STATUS_TIMESTAMP = 8;
        public static final int CONTACT_STATUS_RES_PACKAGE = 9;
        public static final int CONTACT_STATUS_LABEL = 10;
    }

    public static interface ContactHeaderListener {
        public void onPhotoClick(View var1);

        public void onDisplayNameClick(View var1);
    }
}

