/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.test;

import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import com.android.internal.telephony.test.InterpreterEx;
import com.android.internal.telephony.test.LineReader;
import com.android.internal.telephony.test.SimulatedGsmCallState;
import com.android.internal.telephony.test.SimulatedRadioControl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;

public class ModelInterpreter
implements Runnable,
SimulatedRadioControl {
    static final int MAX_CALLS = 6;
    static final int CONNECTING_PAUSE_MSEC = 500;
    static final String LOG_TAG = "ModelInterpreter";
    InputStream in;
    OutputStream out;
    LineReader lineReader;
    ServerSocket ss;
    private String finalResponse;
    SimulatedGsmCallState simulatedCallState;
    HandlerThread mHandlerThread;
    int pausedResponseCount;
    Object pausedResponseMonitor = new Object();
    static final int PROGRESS_CALL_STATE = 1;
    static final String[][] sDefaultResponses = new String[][]{{"E0Q0V1", null}, {"+CMEE=2", null}, {"+CREG=2", null}, {"+CGREG=2", null}, {"+CCWA=1", null}, {"+COPS=0", null}, {"+CFUN=1", null}, {"+CGMI", "+CGMI: Android Model AT Interpreter\r"}, {"+CGMM", "+CGMM: Android Model AT Interpreter\r"}, {"+CGMR", "+CGMR: 1.0\r"}, {"+CGSN", "000000000000000\r"}, {"+CIMI", "320720000000000\r"}, {"+CSCS=?", "+CSCS: (\"HEX\",\"UCS2\")\r"}, {"+CFUN?", "+CFUN: 1\r"}, {"+COPS=3,0;+COPS?;+COPS=3,1;+COPS?;+COPS=3,2;+COPS?", "+COPS: 0,0,\"Android\"\r+COPS: 0,1,\"Android\"\r+COPS: 0,2,\"310995\"\r"}, {"+CREG?", "+CREG: 2,5, \"0113\", \"6614\"\r"}, {"+CGREG?", "+CGREG: 2,0\r"}, {"+CSQ", "+CSQ: 16,99\r"}, {"+CNMI?", "+CNMI: 1,2,2,1,1\r"}, {"+CLIR?", "+CLIR: 1,3\r"}, {"%CPVWI=2", "%CPVWI: 0\r"}, {"+CUSD=1,\"#646#\"", "+CUSD=0,\"You have used 23 minutes\"\r"}, {"+CRSM=176,12258,0,0,10", "+CRSM: 144,0,981062200050259429F6\r"}, {"+CRSM=192,12258,0,0,15", "+CRSM: 144,0,0000000A2FE204000FF55501020000\r"}, {"+CRSM=192,28474,0,0,15", "+CRSM: 144,0,0000005a6f3a040011f5220102011e\r"}, {"+CRSM=178,28474,1,4,30", "+CRSM: 144,0,437573746f6d65722043617265ffffff07818100398799f7ffffffffffff\r"}, {"+CRSM=178,28474,2,4,30", "+CRSM: 144,0,566f696365204d61696cffffffffffff07918150367742f3ffffffffffff\r"}, {"+CRSM=178,28474,3,4,30", "+CRSM: 144,0,4164676a6dffffffffffffffffffffff0b918188551512c221436587ff01\r"}, {"+CRSM=178,28474,4,4,30", "+CRSM: 144,0,810101c1ffffffffffffffffffffffff068114455245f8ffffffffffffff\r"}, {"+CRSM=192,28490,0,0,15", "+CRSM: 144,0,000000416f4a040011f5550102010d\r"}, {"+CRSM=178,28490,1,4,13", "+CRSM: 144,0,0206092143658709ffffffffff\r"}};

    public ModelInterpreter(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        this.init();
    }

    public ModelInterpreter(InetSocketAddress sa) throws IOException {
        this.ss = new ServerSocket();
        this.ss.setReuseAddress(true);
        this.ss.bind(sa);
        this.init();
    }

    private void init() {
        new Thread((Runnable)this, LOG_TAG).start();
        this.mHandlerThread = new HandlerThread(LOG_TAG);
        this.mHandlerThread.start();
        Looper looper = this.mHandlerThread.getLooper();
        this.simulatedCallState = new SimulatedGsmCallState(looper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            String line;
            if (this.ss != null) {
                Socket s;
                try {
                    s = this.ss.accept();
                }
                catch (IOException ex) {
                    Log.w(LOG_TAG, "IOException on socket.accept(); stopping", ex);
                    return;
                }
                try {
                    this.in = s.getInputStream();
                    this.out = s.getOutputStream();
                }
                catch (IOException ex) {
                    Log.w(LOG_TAG, "IOException on accepted socket(); re-listening", ex);
                    continue;
                }
                Log.i(LOG_TAG, "New connection accepted");
            }
            this.lineReader = new LineReader(this.in);
            this.println("Welcome");
            while ((line = this.lineReader.getNextLine()) != null) {
                Object object = this.pausedResponseMonitor;
                synchronized (object) {
                    while (this.pausedResponseCount > 0) {
                        try {
                            this.pausedResponseMonitor.wait();
                        }
                        catch (InterruptedException ex) {}
                    }
                }
                object = this;
                synchronized (object) {
                    try {
                        this.finalResponse = "OK";
                        this.processLine(line);
                        this.println(this.finalResponse);
                    }
                    catch (InterpreterEx ex) {
                        this.println(ex.result);
                    }
                    catch (RuntimeException ex) {
                        ex.printStackTrace();
                        this.println("ERROR");
                    }
                }
            }
            Log.i(LOG_TAG, "Disconnected");
            if (this.ss == null) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerRing(String number) {
        ModelInterpreter modelInterpreter = this;
        synchronized (modelInterpreter) {
            boolean success = this.simulatedCallState.triggerRing(number);
            if (success) {
                this.println("RING");
            }
        }
    }

    public void progressConnectingCallState() {
        this.simulatedCallState.progressConnectingCallState();
    }

    public void progressConnectingToActive() {
        this.simulatedCallState.progressConnectingToActive();
    }

    public void setAutoProgressConnectingCall(boolean b) {
        this.simulatedCallState.setAutoProgressConnectingCall(b);
    }

    public void setNextDialFailImmediately(boolean b) {
        this.simulatedCallState.setNextDialFailImmediately(b);
    }

    public void setNextCallFailCause(int gsmCause) {
    }

    public void triggerHangupForeground() {
        boolean success = this.simulatedCallState.triggerHangupForeground();
        if (success) {
            this.println("NO CARRIER");
        }
    }

    public void triggerHangupBackground() {
        boolean success = this.simulatedCallState.triggerHangupBackground();
        if (success) {
            this.println("NO CARRIER");
        }
    }

    public void triggerHangupAll() {
        boolean success = this.simulatedCallState.triggerHangupAll();
        if (success) {
            this.println("NO CARRIER");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUnsolicited(String unsol) {
        ModelInterpreter modelInterpreter = this;
        synchronized (modelInterpreter) {
            this.println(unsol);
        }
    }

    public void triggerSsn(int a, int b) {
    }

    public void triggerIncomingUssd(String statusCode, String message) {
    }

    public void triggerIncomingSMS(String message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseResponses() {
        Object object = this.pausedResponseMonitor;
        synchronized (object) {
            ++this.pausedResponseCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeResponses() {
        Object object = this.pausedResponseMonitor;
        synchronized (object) {
            --this.pausedResponseCount;
            if (this.pausedResponseCount == 0) {
                this.pausedResponseMonitor.notifyAll();
            }
        }
    }

    private void onAnswer() throws InterpreterEx {
        boolean success = this.simulatedCallState.onAnswer();
        if (!success) {
            throw new InterpreterEx("ERROR");
        }
    }

    private void onHangup() throws InterpreterEx {
        boolean success = false;
        success = this.simulatedCallState.onAnswer();
        if (!success) {
            throw new InterpreterEx("ERROR");
        }
        this.finalResponse = "NO CARRIER";
    }

    private void onCHLD(String command) throws InterpreterEx {
        boolean success;
        char c1 = '\u0000';
        char c0 = command.charAt(6);
        if (command.length() >= 8) {
            c1 = command.charAt(7);
        }
        if (!(success = this.simulatedCallState.onChld(c0, c1))) {
            throw new InterpreterEx("ERROR");
        }
    }

    private void releaseHeldOrUDUB() throws InterpreterEx {
        boolean success = this.simulatedCallState.releaseHeldOrUDUB();
        if (!success) {
            throw new InterpreterEx("ERROR");
        }
    }

    private void releaseActiveAcceptHeldOrWaiting() throws InterpreterEx {
        boolean success = this.simulatedCallState.releaseActiveAcceptHeldOrWaiting();
        if (!success) {
            throw new InterpreterEx("ERROR");
        }
    }

    private void switchActiveAndHeldOrWaiting() throws InterpreterEx {
        boolean success = this.simulatedCallState.switchActiveAndHeldOrWaiting();
        if (!success) {
            throw new InterpreterEx("ERROR");
        }
    }

    private void separateCall(int index) throws InterpreterEx {
        boolean success = this.simulatedCallState.separateCall(index);
        if (!success) {
            throw new InterpreterEx("ERROR");
        }
    }

    private void conference() throws InterpreterEx {
        boolean success = this.simulatedCallState.conference();
        if (!success) {
            throw new InterpreterEx("ERROR");
        }
    }

    private void onDial(String command) throws InterpreterEx {
        boolean success = this.simulatedCallState.onDial(command.substring(1));
        if (!success) {
            throw new InterpreterEx("ERROR");
        }
    }

    private void onCLCC() throws InterpreterEx {
        List<String> lines = this.simulatedCallState.getClccLines();
        int s = lines.size();
        for (int i = 0; i < s; ++i) {
            this.println(lines.get(i));
        }
    }

    private void onSMSSend(String command) throws InterpreterEx {
        this.print("> ");
        String pdu = this.lineReader.getNextLineCtrlZ();
        this.println("+CMGS: 1");
    }

    void processLine(String line) throws InterpreterEx {
        String[] commands = this.splitCommands(line);
        for (int i = 0; i < commands.length; ++i) {
            String command = commands[i];
            if (command.equals("A")) {
                this.onAnswer();
                continue;
            }
            if (command.equals("H")) {
                this.onHangup();
                continue;
            }
            if (command.startsWith("+CHLD=")) {
                this.onCHLD(command);
                continue;
            }
            if (command.equals("+CLCC")) {
                this.onCLCC();
                continue;
            }
            if (command.startsWith("D")) {
                this.onDial(command);
                continue;
            }
            if (command.startsWith("+CMGS=")) {
                this.onSMSSend(command);
                continue;
            }
            boolean found = false;
            for (int j = 0; j < sDefaultResponses.length; ++j) {
                if (!command.equals(sDefaultResponses[j][0])) continue;
                String r = sDefaultResponses[j][1];
                if (r != null) {
                    this.println(r);
                }
                found = true;
                break;
            }
            if (found) continue;
            throw new InterpreterEx("ERROR");
        }
    }

    String[] splitCommands(String line) throws InterpreterEx {
        if (!line.startsWith("AT")) {
            throw new InterpreterEx("ERROR");
        }
        if (line.length() == 2) {
            return new String[0];
        }
        String[] ret = new String[]{line.substring(2)};
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void println(String s) {
        ModelInterpreter modelInterpreter = this;
        synchronized (modelInterpreter) {
            try {
                byte[] bytes = s.getBytes("US-ASCII");
                this.out.write(bytes);
                this.out.write(13);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void print(String s) {
        ModelInterpreter modelInterpreter = this;
        synchronized (modelInterpreter) {
            try {
                byte[] bytes = s.getBytes("US-ASCII");
                this.out.write(bytes);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void shutdown() {
        Looper looper = this.mHandlerThread.getLooper();
        if (looper != null) {
            looper.quit();
        }
        try {
            this.in.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

