/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.IccSmsInterfaceManager;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.IntRangeManager;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsRawData;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.SmsBroadcastConfigInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimSmsInterfaceManager
extends IccSmsInterfaceManager {
    static final String LOG_TAG = "GSM";
    static final boolean DBG = true;
    private final Object mLock = new Object();
    private boolean mSuccess;
    private List<SmsRawData> mSms;
    private CellBroadcastRangeManager mCellBroadcastRangeManager = new CellBroadcastRangeManager();
    private static final int EVENT_LOAD_DONE = 1;
    private static final int EVENT_UPDATE_DONE = 2;
    private static final int EVENT_SET_BROADCAST_ACTIVATION_DONE = 3;
    private static final int EVENT_SET_BROADCAST_CONFIG_DONE = 4;
    private static final int SMS_CB_CODE_SCHEME_MIN = 0;
    private static final int SMS_CB_CODE_SCHEME_MAX = 255;
    Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Object object = SimSmsInterfaceManager.this.mLock;
                    synchronized (object) {
                        SimSmsInterfaceManager.this.mSuccess = ar.exception == null;
                        SimSmsInterfaceManager.this.mLock.notifyAll();
                        break;
                    }
                }
                case 1: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Object object = SimSmsInterfaceManager.this.mLock;
                    synchronized (object) {
                        if (ar.exception == null) {
                            SimSmsInterfaceManager.this.mSms = SimSmsInterfaceManager.this.buildValidRawData((ArrayList)ar.result);
                        } else {
                            SimSmsInterfaceManager.this.log("Cannot load Sms records");
                            if (SimSmsInterfaceManager.this.mSms != null) {
                                SimSmsInterfaceManager.this.mSms.clear();
                            }
                        }
                        SimSmsInterfaceManager.this.mLock.notifyAll();
                        break;
                    }
                }
                case 3: 
                case 4: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Object object = SimSmsInterfaceManager.this.mLock;
                    synchronized (object) {
                        SimSmsInterfaceManager.this.mSuccess = ar.exception == null;
                        SimSmsInterfaceManager.this.mLock.notifyAll();
                        break;
                    }
                }
            }
        }
    };

    public SimSmsInterfaceManager(GSMPhone phone, SMSDispatcher dispatcher) {
        super(phone);
        this.mDispatcher = dispatcher;
    }

    public void dispose() {
    }

    @Override
    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            Log.e(LOG_TAG, "Error while finalizing:", throwable);
        }
        Log.d(LOG_TAG, "SimSmsInterfaceManager finalized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateMessageOnIccEf(int index, int status, byte[] pdu) {
        this.log("updateMessageOnIccEf: index=" + index + " status=" + status + " ==> " + "(" + Arrays.toString(pdu) + ")");
        this.enforceReceiveAndSend("Updating message on SIM");
        Object object = this.mLock;
        synchronized (object) {
            this.mSuccess = false;
            Message response = this.mHandler.obtainMessage(2);
            if (status == 0) {
                this.mPhone.mCM.deleteSmsOnSim(index, response);
            } else {
                byte[] record = this.makeSmsRecordData(status, pdu);
                this.mPhone.getIccFileHandler().updateEFLinearFixed(28476, index, record, null, response);
            }
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to update by index");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean copyMessageToIccEf(int status, byte[] pdu, byte[] smsc) {
        this.log("copyMessageToIccEf: status=" + status + " ==> " + "pdu=(" + Arrays.toString(pdu) + "), smsm=(" + Arrays.toString(smsc) + ")");
        this.enforceReceiveAndSend("Copying message to SIM");
        Object object = this.mLock;
        synchronized (object) {
            this.mSuccess = false;
            Message response = this.mHandler.obtainMessage(2);
            this.mPhone.mCM.writeSmsToSim(status, IccUtils.bytesToHexString(smsc), IccUtils.bytesToHexString(pdu), response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to update by index");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SmsRawData> getAllMessagesFromIccEf() {
        this.log("getAllMessagesFromEF");
        Context context = this.mPhone.getContext();
        context.enforceCallingPermission("android.permission.RECEIVE_SMS", "Reading messages from SIM");
        Object object = this.mLock;
        synchronized (object) {
            Message response = this.mHandler.obtainMessage(1);
            this.mPhone.getIccFileHandler().loadEFLinearFixedAll(28476, response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to load from the SIM");
            }
        }
        return this.mSms;
    }

    @Override
    public boolean enableCellBroadcast(int messageIdentifier) {
        return this.enableCellBroadcastRange(messageIdentifier, messageIdentifier);
    }

    @Override
    public boolean disableCellBroadcast(int messageIdentifier) {
        return this.disableCellBroadcastRange(messageIdentifier, messageIdentifier);
    }

    @Override
    public boolean enableCellBroadcastRange(int startMessageId, int endMessageId) {
        this.log("enableCellBroadcastRange");
        Context context = this.mPhone.getContext();
        context.enforceCallingPermission("android.permission.RECEIVE_SMS", "Enabling cell broadcast SMS");
        String client = context.getPackageManager().getNameForUid(Binder.getCallingUid());
        if (!this.mCellBroadcastRangeManager.enableRange(startMessageId, endMessageId, client)) {
            this.log("Failed to add cell broadcast subscription for MID range " + startMessageId + " to " + endMessageId + " from client " + client);
            return false;
        }
        this.log("Added cell broadcast subscription for MID range " + startMessageId + " to " + endMessageId + " from client " + client);
        return true;
    }

    @Override
    public boolean disableCellBroadcastRange(int startMessageId, int endMessageId) {
        this.log("disableCellBroadcastRange");
        Context context = this.mPhone.getContext();
        context.enforceCallingPermission("android.permission.RECEIVE_SMS", "Disabling cell broadcast SMS");
        String client = context.getPackageManager().getNameForUid(Binder.getCallingUid());
        if (!this.mCellBroadcastRangeManager.disableRange(startMessageId, endMessageId, client)) {
            this.log("Failed to remove cell broadcast subscription for MID range " + startMessageId + " to " + endMessageId + " from client " + client);
            return false;
        }
        this.log("Removed cell broadcast subscription for MID range " + startMessageId + " to " + endMessageId + " from client " + client);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setCellBroadcastConfig(SmsBroadcastConfigInfo[] configs) {
        this.log("Calling setGsmBroadcastConfig with " + configs.length + " configurations");
        Object object = this.mLock;
        synchronized (object) {
            Message response = this.mHandler.obtainMessage(4);
            this.mSuccess = false;
            this.mPhone.mCM.setGsmBroadcastConfig(configs, response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to set cell broadcast config");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setCellBroadcastActivation(boolean activate) {
        this.log("Calling setCellBroadcastActivation(" + activate + ')');
        Object object = this.mLock;
        synchronized (object) {
            Message response = this.mHandler.obtainMessage(3);
            this.mSuccess = false;
            this.mPhone.mCM.setGsmBroadcastActivation(activate, response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to set cell broadcast activation");
            }
        }
        return this.mSuccess;
    }

    @Override
    protected void log(String msg) {
        Log.d(LOG_TAG, "[SimSmsInterfaceManager] " + msg);
    }

    class CellBroadcastRangeManager
    extends IntRangeManager {
        private ArrayList<SmsBroadcastConfigInfo> mConfigList = new ArrayList();

        CellBroadcastRangeManager() {
        }

        protected void startUpdate() {
            this.mConfigList.clear();
        }

        protected void addRange(int startId, int endId, boolean selected) {
            this.mConfigList.add(new SmsBroadcastConfigInfo(startId, endId, 0, 255, selected));
        }

        protected boolean finishUpdate() {
            if (this.mConfigList.isEmpty()) {
                return SimSmsInterfaceManager.this.setCellBroadcastActivation(false);
            }
            SmsBroadcastConfigInfo[] configs = this.mConfigList.toArray(new SmsBroadcastConfigInfo[this.mConfigList.size()]);
            return SimSmsInterfaceManager.this.setCellBroadcastConfig(configs) && SimSmsInterfaceManager.this.setCellBroadcastActivation(true);
        }
    }
}

