/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.IConnectivityManager;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Message;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.telephony.DataCallState;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.DataConnectionTracker;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.RetryManager;
import com.android.internal.telephony.gsm.ApnSetting;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.GsmDataConnection;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GsmDataConnectionTracker
extends DataConnectionTracker {
    protected final String LOG_TAG = "GSM";
    private GSMPhone mGsmPhone;
    private boolean noAutoAttach = false;
    private boolean mReregisterOnReconnectFailure = false;
    private ContentResolver mResolver;
    private boolean mPingTestActive = false;
    private int mPdpResetCount = 0;
    private boolean mIsScreenOn = true;
    protected static final int APN_DELAY_MILLIS = 5000;
    boolean failNextConnect = false;
    private ArrayList<ApnSetting> allApns = null;
    private ArrayList<ApnSetting> waitingApns = null;
    private int waitingApnsPermanentFailureCountDown = 0;
    private ApnSetting preferredApn = null;
    protected ApnSetting mActiveApn;
    private ArrayList<DataConnection> pdpList;
    private GsmDataConnection mActivePdp;
    private boolean mIsPsRestricted = false;
    private static final int PDP_CONNECTION_POOL_SIZE = 1;
    private static final int POLL_PDP_MILLIS = 5000;
    private static final String INTENT_RECONNECT_ALARM = "com.android.internal.telephony.gprs-reconnect";
    private static final String INTENT_RECONNECT_ALARM_EXTRA_REASON = "reason";
    static final Uri PREFERAPN_URI = Uri.parse("content://telephony/carriers/preferapn");
    static final String APN_ID = "apn_id";
    private boolean canSetPreferApn = false;
    private RetryManager mDefaultRetryManager;
    private RetryManager mSecondaryRetryManager;
    BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.SCREEN_ON")) {
                GsmDataConnectionTracker.this.mIsScreenOn = true;
                GsmDataConnectionTracker.this.stopNetStatPoll();
                GsmDataConnectionTracker.this.startNetStatPoll();
            } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                GsmDataConnectionTracker.this.mIsScreenOn = false;
                GsmDataConnectionTracker.this.stopNetStatPoll();
                GsmDataConnectionTracker.this.startNetStatPoll();
            } else if (action.equals(GsmDataConnectionTracker.INTENT_RECONNECT_ALARM)) {
                Log.d("GSM", "GPRS reconnect alarm. Previous state was " + (Object)((Object)GsmDataConnectionTracker.this.state));
                String reason = intent.getStringExtra(GsmDataConnectionTracker.INTENT_RECONNECT_ALARM_EXTRA_REASON);
                if (GsmDataConnectionTracker.this.state == DataConnectionTracker.State.FAILED) {
                    Message msg = GsmDataConnectionTracker.this.obtainMessage(34);
                    msg.arg1 = 0;
                    msg.obj = reason;
                    GsmDataConnectionTracker.this.sendMessage(msg);
                }
                GsmDataConnectionTracker.this.sendMessage(GsmDataConnectionTracker.this.obtainMessage(5));
            } else if (action.equals("android.net.wifi.STATE_CHANGE")) {
                NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                GsmDataConnectionTracker.this.mIsWifiConnected = networkInfo != null && networkInfo.isConnected();
            } else if (action.equals("android.net.wifi.WIFI_STATE_CHANGED")) {
                boolean enabled;
                boolean bl = enabled = intent.getIntExtra("wifi_state", 4) == 3;
                if (!enabled) {
                    GsmDataConnectionTracker.this.mIsWifiConnected = false;
                }
            }
        }
    };
    private ApnChangeObserver apnObserver;
    private Runnable mPollNetStat = new Runnable(){

        public void run() {
            long preTxPkts = -1L;
            long preRxPkts = -1L;
            preTxPkts = GsmDataConnectionTracker.this.txPkts;
            preRxPkts = GsmDataConnectionTracker.this.rxPkts;
            GsmDataConnectionTracker.this.txPkts = TrafficStats.getMobileTxPackets();
            GsmDataConnectionTracker.this.rxPkts = TrafficStats.getMobileRxPackets();
            if (GsmDataConnectionTracker.this.netStatPollEnabled && (preTxPkts > 0L || preRxPkts > 0L)) {
                DataConnectionTracker.Activity newActivity;
                long sent = GsmDataConnectionTracker.this.txPkts - preTxPkts;
                long received = GsmDataConnectionTracker.this.rxPkts - preRxPkts;
                if (sent > 0L && received > 0L) {
                    GsmDataConnectionTracker.this.sentSinceLastRecv = 0L;
                    newActivity = DataConnectionTracker.Activity.DATAINANDOUT;
                    GsmDataConnectionTracker.this.mPdpResetCount = 0;
                } else if (sent > 0L && received == 0L) {
                    if (GsmDataConnectionTracker.this.phone.getState() == Phone.State.IDLE) {
                        GsmDataConnectionTracker.this.sentSinceLastRecv += sent;
                    } else {
                        GsmDataConnectionTracker.this.sentSinceLastRecv = 0L;
                    }
                    newActivity = DataConnectionTracker.Activity.DATAOUT;
                } else if (sent == 0L && received > 0L) {
                    GsmDataConnectionTracker.this.sentSinceLastRecv = 0L;
                    newActivity = DataConnectionTracker.Activity.DATAIN;
                    GsmDataConnectionTracker.this.mPdpResetCount = 0;
                } else if (sent == 0L && received == 0L) {
                    newActivity = DataConnectionTracker.Activity.NONE;
                } else {
                    GsmDataConnectionTracker.this.sentSinceLastRecv = 0L;
                    newActivity = DataConnectionTracker.Activity.NONE;
                }
                if (GsmDataConnectionTracker.this.activity != newActivity && GsmDataConnectionTracker.this.mIsScreenOn) {
                    GsmDataConnectionTracker.this.activity = newActivity;
                    GsmDataConnectionTracker.this.phone.notifyDataActivity();
                }
            }
            int watchdogTrigger = Settings.Secure.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_trigger_packet_count", 10);
            if (GsmDataConnectionTracker.this.sentSinceLastRecv >= (long)watchdogTrigger) {
                if (GsmDataConnectionTracker.this.mNoRecvPollCount == 0) {
                    EventLog.writeEvent(50101, GsmDataConnectionTracker.this.sentSinceLastRecv);
                }
                int noRecvPollLimit = Settings.Secure.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_error_poll_count", 24);
                if (GsmDataConnectionTracker.this.mNoRecvPollCount < noRecvPollLimit) {
                    ((GsmDataConnectionTracker)GsmDataConnectionTracker.this).phone.mCM.getDataCallList(GsmDataConnectionTracker.this.obtainMessage(11));
                    GsmDataConnectionTracker.this.mNoRecvPollCount++;
                    GsmDataConnectionTracker.this.netStatPollPeriod = Settings.Secure.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_error_poll_interval_ms", 5000);
                } else {
                    GsmDataConnectionTracker.this.stopNetStatPoll();
                    Thread pingTest = new Thread(){

                        public void run() {
                            GsmDataConnectionTracker.this.runPingTest();
                        }
                    };
                    GsmDataConnectionTracker.this.mPingTestActive = true;
                    pingTest.start();
                }
            } else {
                GsmDataConnectionTracker.this.mNoRecvPollCount = 0;
                if (GsmDataConnectionTracker.this.mIsScreenOn) {
                    GsmDataConnectionTracker.this.netStatPollPeriod = Settings.Secure.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_poll_interval_ms", 1000);
                } else {
                    GsmDataConnectionTracker.this.netStatPollPeriod = Settings.Secure.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_long_poll_interval_ms", 600000);
                }
            }
            if (GsmDataConnectionTracker.this.netStatPollEnabled) {
                GsmDataConnectionTracker.this.mDataConnectionTracker.postDelayed(this, GsmDataConnectionTracker.this.netStatPollPeriod);
            }
        }
    };

    GsmDataConnectionTracker(GSMPhone p) {
        super(p);
        this.mGsmPhone = p;
        p.mCM.registerForAvailable(this, 3, null);
        p.mCM.registerForOffOrNotAvailable(this, 12, null);
        p.mSIMRecords.registerForRecordsLoaded(this, 4, null);
        p.mCM.registerForDataStateChanged(this, 6, null);
        p.mCT.registerForVoiceCallEnded(this, 15, null);
        p.mCT.registerForVoiceCallStarted(this, 14, null);
        p.mSST.registerForGprsAttached(this, 26, null);
        p.mSST.registerForGprsDetached(this, 19, null);
        p.mSST.registerForRoamingOn(this, 21, null);
        p.mSST.registerForRoamingOff(this, 22, null);
        p.mSST.registerForPsRestrictedEnabled(this, 32, null);
        p.mSST.registerForPsRestrictedDisabled(this, 33, null);
        IntentFilter filter = new IntentFilter();
        filter.addAction(INTENT_RECONNECT_ALARM);
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.net.wifi.STATE_CHANGE");
        filter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        p.getContext().registerReceiver(this.mIntentReceiver, filter, null, p);
        this.mDataConnectionTracker = this;
        this.mResolver = this.phone.getContext().getContentResolver();
        this.apnObserver = new ApnChangeObserver();
        p.getContext().getContentResolver().registerContentObserver(Telephony.Carriers.CONTENT_URI, true, this.apnObserver);
        this.createAllPdpList();
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.phone.getContext());
        boolean dataEnabledSetting = true;
        try {
            dataEnabledSetting = IConnectivityManager.Stub.asInterface(ServiceManager.getService("connectivity")).getMobileDataEnabled();
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl = this.dataEnabled[0] = !sp.getBoolean("disabled_on_boot_key", false) && dataEnabledSetting;
        if (this.dataEnabled[0]) {
            ++this.enabledCount;
        }
        boolean bl2 = this.noAutoAttach = !this.dataEnabled[0];
        if (!this.mRetryMgr.configure(SystemProperties.get("ro.gsm.data_retry_config")) && !this.mRetryMgr.configure("default_randomization=2000,5000,10000,20000,40000,80000:5000,160000:5000,320000:5000,640000:5000,1280000:5000,1800000:5000")) {
            Log.e("GSM", "Could not configure using DEFAULT_DATA_RETRY_CONFIG=default_randomization=2000,5000,10000,20000,40000,80000:5000,160000:5000,320000:5000,640000:5000,1280000:5000,1800000:5000");
            this.mRetryMgr.configure(20, 2000, 1000);
        }
        this.mDefaultRetryManager = this.mRetryMgr;
        this.mSecondaryRetryManager = new RetryManager();
        if (!this.mSecondaryRetryManager.configure(SystemProperties.get("ro.gsm.2nd_data_retry_config")) && !this.mSecondaryRetryManager.configure("max_retries=3, 5000, 5000, 5000")) {
            Log.e("GSM", "Could note configure using SECONDARY_DATA_RETRY_CONFIG=max_retries=3, 5000, 5000, 5000");
            this.mSecondaryRetryManager.configure("max_retries=3, 333, 333, 333");
        }
    }

    @Override
    public void dispose() {
        this.phone.mCM.unregisterForAvailable(this);
        this.phone.mCM.unregisterForOffOrNotAvailable(this);
        this.mGsmPhone.mSIMRecords.unregisterForRecordsLoaded(this);
        this.phone.mCM.unregisterForDataStateChanged(this);
        this.mGsmPhone.mCT.unregisterForVoiceCallEnded(this);
        this.mGsmPhone.mCT.unregisterForVoiceCallStarted(this);
        this.mGsmPhone.mSST.unregisterForGprsAttached(this);
        this.mGsmPhone.mSST.unregisterForGprsDetached(this);
        this.mGsmPhone.mSST.unregisterForRoamingOn(this);
        this.mGsmPhone.mSST.unregisterForRoamingOff(this);
        this.mGsmPhone.mSST.unregisterForPsRestrictedEnabled(this);
        this.mGsmPhone.mSST.unregisterForPsRestrictedDisabled(this);
        this.phone.getContext().unregisterReceiver(this.mIntentReceiver);
        this.phone.getContext().getContentResolver().unregisterContentObserver(this.apnObserver);
        this.destroyAllPdpList();
    }

    protected void finalize() {
    }

    @Override
    protected void setState(DataConnectionTracker.State s) {
        if (this.state != s) {
            EventLog.writeEvent(50113, this.state.toString(), s.toString());
            this.state = s;
        }
        if (this.state == DataConnectionTracker.State.FAILED && this.waitingApns != null) {
            this.waitingApns.clear();
        }
    }

    @Override
    public String[] getActiveApnTypes() {
        String[] result = this.mActiveApn != null ? this.mActiveApn.types : new String[]{"default"};
        return result;
    }

    @Override
    protected String getActiveApnString() {
        String result = null;
        if (this.mActiveApn != null) {
            result = this.mActiveApn.apn;
        }
        return result;
    }

    @Override
    public boolean isDataConnectionAsDesired() {
        boolean roaming = this.phone.getServiceState().getRoaming();
        if (!(!this.mGsmPhone.mSIMRecords.getRecordsLoaded() || this.mGsmPhone.mSST.getCurrentGprsState() != 0 || roaming && !this.getDataOnRoamingEnabled() || this.mIsWifiConnected || this.mIsPsRestricted)) {
            return this.state == DataConnectionTracker.State.CONNECTED;
        }
        return true;
    }

    @Override
    protected boolean isApnTypeActive(String type) {
        ApnSetting dunApn;
        if ("dun".equals(type) && (dunApn = this.fetchDunApn()) != null) {
            return this.mActiveApn != null && dunApn.toString().equals(this.mActiveApn.toString());
        }
        return this.mActiveApn != null && this.mActiveApn.canHandleType(type);
    }

    @Override
    protected boolean isApnTypeAvailable(String type) {
        if (type.equals("dun")) {
            return this.fetchDunApn() != null;
        }
        if (this.allApns != null) {
            for (ApnSetting apn : this.allApns) {
                if (!apn.canHandleType(type)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ArrayList<DataConnection> getAllDataConnections() {
        ArrayList pdps = (ArrayList)this.pdpList.clone();
        return pdps;
    }

    private boolean isDataAllowed() {
        boolean roaming = this.phone.getServiceState().getRoaming();
        return this.getAnyDataEnabled() && (!roaming || this.getDataOnRoamingEnabled()) && this.mMasterDataEnabled;
    }

    protected void onGprsDetached() {
        this.stopNetStatPoll();
        this.phone.notifyDataConnection("gprsDetached");
    }

    private void onGprsAttached() {
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            this.startNetStatPoll();
            this.phone.notifyDataConnection("gprsAttached");
        } else {
            if (this.state == DataConnectionTracker.State.FAILED) {
                this.cleanUpConnection(false, "gprsAttached");
                this.mRetryMgr.resetRetryCount();
            }
            this.trySetupData("gprsAttached");
        }
    }

    private boolean trySetupData(String reason) {
        Log.d("GSM", "[DSAC DEB] trySetupData with mIsPsRestricted=" + this.mIsPsRestricted);
        if (this.phone.getSimulatedRadioControl() != null) {
            this.setState(DataConnectionTracker.State.CONNECTED);
            this.phone.notifyDataConnection(reason);
            Log.i("GSM", "(fix?) We're on the simulator; assuming data is connected");
            return true;
        }
        int gprsState = this.mGsmPhone.mSST.getCurrentGprsState();
        boolean desiredPowerState = this.mGsmPhone.mSST.getDesiredPowerState();
        if ((this.state == DataConnectionTracker.State.IDLE || this.state == DataConnectionTracker.State.SCANNING) && (gprsState == 0 || this.noAutoAttach) && this.mGsmPhone.mSIMRecords.getRecordsLoaded() && this.phone.getState() == Phone.State.IDLE && this.isDataAllowed() && !this.mIsPsRestricted && desiredPowerState) {
            if (this.state == DataConnectionTracker.State.IDLE) {
                this.waitingApns = this.buildWaitingApns();
                this.waitingApnsPermanentFailureCountDown = this.waitingApns.size();
                if (this.waitingApns.isEmpty()) {
                    this.notifyNoData(DataConnection.FailCause.MISSING_UNKNOWN_APN);
                    return false;
                }
                this.log("Create from allApns : " + this.apnListToString(this.allApns));
            }
            return this.setupData(reason);
        }
        return false;
    }

    private void cleanUpConnection(boolean tearDown, String reason) {
        if (this.mReconnectIntent != null) {
            AlarmManager am = (AlarmManager)this.phone.getContext().getSystemService("alarm");
            am.cancel(this.mReconnectIntent);
            this.mReconnectIntent = null;
        }
        this.setState(DataConnectionTracker.State.DISCONNECTING);
        boolean notificationDeferred = false;
        for (DataConnection conn : this.pdpList) {
            if (tearDown) {
                conn.disconnect(this.obtainMessage(25, reason));
                notificationDeferred = true;
                continue;
            }
            conn.resetSynchronously();
            notificationDeferred = false;
        }
        this.stopNetStatPoll();
        if (!notificationDeferred) {
            this.gotoIdleAndNotifyDataConnection(reason);
        }
    }

    private String[] parseTypes(String types) {
        String[] result = types == null || types.equals("") ? new String[]{"*"} : types.split(",");
        return result;
    }

    private ArrayList<ApnSetting> createApnList(Cursor cursor) {
        ArrayList<ApnSetting> result = new ArrayList<ApnSetting>();
        if (cursor.moveToFirst()) {
            do {
                String[] types = this.parseTypes(cursor.getString(cursor.getColumnIndexOrThrow("type")));
                ApnSetting apn = new ApnSetting(cursor.getInt(cursor.getColumnIndexOrThrow("_id")), cursor.getString(cursor.getColumnIndexOrThrow("numeric")), cursor.getString(cursor.getColumnIndexOrThrow("name")), cursor.getString(cursor.getColumnIndexOrThrow("apn")), cursor.getString(cursor.getColumnIndexOrThrow("proxy")), cursor.getString(cursor.getColumnIndexOrThrow("port")), cursor.getString(cursor.getColumnIndexOrThrow("mmsc")), cursor.getString(cursor.getColumnIndexOrThrow("mmsproxy")), cursor.getString(cursor.getColumnIndexOrThrow("mmsport")), cursor.getString(cursor.getColumnIndexOrThrow("user")), cursor.getString(cursor.getColumnIndexOrThrow("password")), cursor.getInt(cursor.getColumnIndexOrThrow("authtype")), types, cursor.getString(cursor.getColumnIndexOrThrow("protocol")), cursor.getString(cursor.getColumnIndexOrThrow("roaming_protocol")));
                result.add(apn);
            } while (cursor.moveToNext());
        }
        return result;
    }

    private GsmDataConnection findFreePdp() {
        for (DataConnection conn : this.pdpList) {
            GsmDataConnection pdp = (GsmDataConnection)conn;
            if (!pdp.isInactive()) continue;
            return pdp;
        }
        return null;
    }

    private boolean setupData(String reason) {
        ApnSetting apn = this.getNextApn();
        if (apn == null) {
            return false;
        }
        GsmDataConnection pdp = this.findFreePdp();
        if (pdp == null) {
            return false;
        }
        this.mActiveApn = apn;
        this.mActivePdp = pdp;
        Message msg = this.obtainMessage();
        msg.what = 1;
        msg.obj = reason;
        pdp.connect(msg, apn);
        this.setState(DataConnectionTracker.State.INITING);
        this.phone.notifyDataConnection(reason);
        return true;
    }

    @Override
    protected String getInterfaceName(String apnType) {
        if (this.mActivePdp != null && (apnType == null || this.mActiveApn != null && this.mActiveApn.canHandleType(apnType))) {
            return this.mActivePdp.getInterface();
        }
        return null;
    }

    @Override
    protected String getIpAddress(String apnType) {
        if (this.mActivePdp != null && (apnType == null || this.mActiveApn != null && this.mActiveApn.canHandleType(apnType))) {
            return this.mActivePdp.getIpAddress();
        }
        return null;
    }

    @Override
    public String getGateway(String apnType) {
        if (this.mActivePdp != null && (apnType == null || this.mActiveApn != null && this.mActiveApn.canHandleType(apnType))) {
            return this.mActivePdp.getGatewayAddress();
        }
        return null;
    }

    @Override
    protected String[] getDnsServers(String apnType) {
        if (this.mActivePdp != null && (apnType == null || this.mActiveApn != null && this.mActiveApn.canHandleType(apnType))) {
            return this.mActivePdp.getDnsServers();
        }
        return null;
    }

    private boolean pdpStatesHasCID(ArrayList<DataCallState> states, int cid) {
        int s = states.size();
        for (int i = 0; i < s; ++i) {
            if (states.get((int)i).cid != cid) continue;
            return true;
        }
        return false;
    }

    private boolean pdpStatesHasActiveCID(ArrayList<DataCallState> states, int cid) {
        int s = states.size();
        for (int i = 0; i < s; ++i) {
            if (states.get((int)i).cid != cid || states.get((int)i).active == 0) continue;
            return true;
        }
        return false;
    }

    private void onApnChanged() {
        boolean isConnected = this.state != DataConnectionTracker.State.IDLE && this.state != DataConnectionTracker.State.FAILED;
        this.mGsmPhone.updateCurrentCarrierInProvider();
        this.createAllApnList();
        if (this.state != DataConnectionTracker.State.DISCONNECTING) {
            this.cleanUpConnection(isConnected, "apnChanged");
            if (!isConnected) {
                this.mRetryMgr.resetRetryCount();
                this.mReregisterOnReconnectFailure = false;
                this.trySetupData("apnChanged");
            }
        }
    }

    protected void onPdpStateChanged(AsyncResult ar, boolean explicitPoll) {
        ArrayList pdpStates = (ArrayList)ar.result;
        if (ar.exception != null) {
            return;
        }
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            if (!this.pdpStatesHasCID(pdpStates, this.cidActive)) {
                Log.i("GSM", "PDP connection has dropped. Reconnecting");
                GsmCellLocation loc = (GsmCellLocation)this.phone.getCellLocation();
                EventLog.writeEvent(50109, loc != null ? loc.getCid() : -1, TelephonyManager.getDefault().getNetworkType());
                this.cleanUpConnection(true, null);
                return;
            }
            if (!this.pdpStatesHasActiveCID(pdpStates, this.cidActive)) {
                if (!explicitPoll) {
                    this.phone.mCM.getPDPContextList(this.obtainMessage(11));
                } else {
                    Log.i("GSM", "PDP connection has dropped (active=false case).  Reconnecting");
                    GsmCellLocation loc = (GsmCellLocation)this.phone.getCellLocation();
                    EventLog.writeEvent(50109, loc != null ? loc.getCid() : -1, TelephonyManager.getDefault().getNetworkType());
                    this.cleanUpConnection(true, null);
                }
            }
        }
    }

    private void notifyDefaultData(String reason) {
        this.setState(DataConnectionTracker.State.CONNECTED);
        this.phone.notifyDataConnection(reason);
        this.startNetStatPoll();
        this.mRetryMgr.resetRetryCount();
        this.mReregisterOnReconnectFailure = false;
    }

    private void gotoIdleAndNotifyDataConnection(String reason) {
        this.setState(DataConnectionTracker.State.IDLE);
        this.phone.notifyDataConnection(reason);
        this.mActiveApn = null;
    }

    private void startPeriodicPdpPoll() {
        this.removeMessages(7);
        this.sendMessageDelayed(this.obtainMessage(7), 5000L);
    }

    private void resetPollStats() {
        this.txPkts = -1L;
        this.rxPkts = -1L;
        this.sentSinceLastRecv = 0L;
        this.netStatPollPeriod = 1000;
        this.mNoRecvPollCount = 0;
    }

    private void doRecovery() {
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            int maxPdpReset = Settings.Secure.getInt(this.mResolver, "pdp_watchdog_max_pdp_reset_fail_count", 3);
            if (this.mPdpResetCount < maxPdpReset) {
                ++this.mPdpResetCount;
                EventLog.writeEvent(50102, this.sentSinceLastRecv);
                this.cleanUpConnection(true, "pdpReset");
            } else {
                this.mPdpResetCount = 0;
                EventLog.writeEvent(50104, this.sentSinceLastRecv);
                this.mGsmPhone.mSST.reRegisterNetwork(null);
            }
        }
    }

    @Override
    protected void startNetStatPoll() {
        if (this.state == DataConnectionTracker.State.CONNECTED && !this.mPingTestActive && !this.netStatPollEnabled) {
            Log.d("GSM", "[DataConnection] Start poll NetStat");
            this.resetPollStats();
            this.netStatPollEnabled = true;
            this.mPollNetStat.run();
        }
    }

    @Override
    protected void stopNetStatPoll() {
        this.netStatPollEnabled = false;
        this.removeCallbacks(this.mPollNetStat);
        Log.d("GSM", "[DataConnection] Stop poll NetStat");
    }

    @Override
    protected void restartRadio() {
        Log.d("GSM", "************TURN OFF RADIO**************");
        this.cleanUpConnection(true, "radioTurnedOff");
        this.mGsmPhone.mSST.powerOffRadioSafely();
        int reset = Integer.parseInt(SystemProperties.get("net.ppp.reset-by-timeout", "0"));
        SystemProperties.set("net.ppp.reset-by-timeout", String.valueOf(reset + 1));
    }

    private void runPingTest() {
        int status = -1;
        try {
            String address = Settings.Secure.getString(this.mResolver, "pdp_watchdog_ping_address");
            int deadline = Settings.Secure.getInt(this.mResolver, "pdp_watchdog_ping_deadline", 5);
            if (address != null && !"0.0.0.0".equals(address)) {
                Process p = Runtime.getRuntime().exec("ping -c 1 -i 1 -w " + deadline + " " + address);
                status = p.waitFor();
            }
        }
        catch (IOException e) {
            Log.w("GSM", "ping failed: IOException");
        }
        catch (Exception e) {
            Log.w("GSM", "exception trying to ping");
        }
        if (status == 0) {
            EventLog.writeEvent(50102, -1);
            this.mPdpResetCount = 0;
            this.sendMessage(this.obtainMessage(27));
        } else {
            this.sendMessage(this.obtainMessage(28));
        }
    }

    private boolean shouldPostNotification(DataConnection.FailCause cause) {
        return cause != DataConnection.FailCause.UNKNOWN;
    }

    private boolean retryAfterDisconnected(String reason) {
        boolean retry = true;
        if ("radioTurnedOff".equals(reason)) {
            retry = false;
        }
        return retry;
    }

    private void reconnectAfterFail(DataConnection.FailCause lastFailCauseCode, String reason) {
        if (this.state == DataConnectionTracker.State.FAILED) {
            if (!this.mRetryMgr.isRetryNeeded()) {
                if (!this.mRequestedApnType.equals("default")) {
                    this.phone.notifyDataConnection("apnFailed");
                    this.onEnableApn(this.apnTypeToId(this.mRequestedApnType), 0);
                    return;
                }
                if (this.mReregisterOnReconnectFailure) {
                    this.mRetryMgr.retryForeverUsingLastTimeout();
                } else {
                    Log.d("GSM", "PDP activate failed, Reregistering to the network");
                    this.mReregisterOnReconnectFailure = true;
                    this.mGsmPhone.mSST.reRegisterNetwork(null);
                    this.mRetryMgr.resetRetryCount();
                    return;
                }
            }
            int nextReconnectDelay = this.mRetryMgr.getRetryTimer();
            Log.d("GSM", "PDP activate failed. Scheduling next attempt for " + nextReconnectDelay / 1000 + "s");
            AlarmManager am = (AlarmManager)this.phone.getContext().getSystemService("alarm");
            Intent intent = new Intent(INTENT_RECONNECT_ALARM);
            intent.putExtra(INTENT_RECONNECT_ALARM_EXTRA_REASON, reason);
            this.mReconnectIntent = PendingIntent.getBroadcast(this.phone.getContext(), 0, intent, 0);
            am.set(2, SystemClock.elapsedRealtime() + (long)nextReconnectDelay, this.mReconnectIntent);
            this.mRetryMgr.increaseRetryCount();
            if (!this.shouldPostNotification(lastFailCauseCode)) {
                Log.d("GSM", "NOT Posting GPRS Unavailable notification -- likely transient error");
            } else {
                this.notifyNoData(lastFailCauseCode);
            }
        }
    }

    private void notifyNoData(DataConnection.FailCause lastFailCauseCode) {
        this.setState(DataConnectionTracker.State.FAILED);
    }

    protected void onRecordsLoaded() {
        this.createAllApnList();
        if (this.state == DataConnectionTracker.State.FAILED) {
            this.cleanUpConnection(false, null);
        }
        this.sendMessage(this.obtainMessage(5, "simLoaded"));
    }

    @Override
    protected void onEnableNewApn() {
        this.mRetryMgr = this.mRequestedApnType.equals("default") ? this.mDefaultRetryManager : this.mSecondaryRetryManager;
        this.mRetryMgr.resetRetryCount();
        this.cleanUpConnection(true, "apnSwitched");
    }

    @Override
    protected boolean onTrySetupData(String reason) {
        return this.trySetupData(reason);
    }

    @Override
    protected void onRoamingOff() {
        this.trySetupData("roamingOff");
    }

    @Override
    protected void onRoamingOn() {
        if (this.getDataOnRoamingEnabled()) {
            this.trySetupData("roamingOn");
        } else {
            this.cleanUpConnection(true, "roamingOn");
        }
    }

    @Override
    protected void onRadioAvailable() {
        if (this.phone.getSimulatedRadioControl() != null) {
            this.setState(DataConnectionTracker.State.CONNECTED);
            this.phone.notifyDataConnection(null);
            Log.i("GSM", "We're on the simulator; assuming data is connected");
        }
        if (this.state != DataConnectionTracker.State.IDLE) {
            this.cleanUpConnection(true, null);
        }
    }

    @Override
    protected void onRadioOffOrNotAvailable() {
        this.mRetryMgr.resetRetryCount();
        this.mReregisterOnReconnectFailure = false;
        if (this.phone.getSimulatedRadioControl() != null) {
            Log.i("GSM", "We're on the simulator; assuming radio off is meaningless");
        } else {
            this.cleanUpConnection(false, "radioTurnedOff");
        }
    }

    @Override
    protected void onDataSetupComplete(AsyncResult ar) {
        String reason = null;
        if (ar.userObj instanceof String) {
            reason = (String)ar.userObj;
        }
        if (ar.exception == null) {
            if (this.isApnTypeActive("default")) {
                SystemProperties.set("gsm.defaultpdpcontext.active", "true");
                if (this.canSetPreferApn && this.preferredApn == null) {
                    Log.d("GSM", "PREFERRED APN is null");
                    this.preferredApn = this.mActiveApn;
                    this.setPreferredApn(this.preferredApn.id);
                }
            } else {
                SystemProperties.set("gsm.defaultpdpcontext.active", "false");
            }
            this.notifyDefaultData(reason);
        } else {
            DataConnection.FailCause cause = (DataConnection.FailCause)((Object)ar.result);
            if (cause.isEventLoggable()) {
                GsmCellLocation loc = (GsmCellLocation)this.phone.getCellLocation();
                EventLog.writeEvent(50105, cause.ordinal(), loc != null ? loc.getCid() : -1, TelephonyManager.getDefault().getNetworkType());
            }
            this.waitingApnsPermanentFailureCountDown -= cause.isPermanentFail() ? 1 : 0;
            this.waitingApns.remove(0);
            if (this.waitingApns.isEmpty()) {
                if (this.waitingApnsPermanentFailureCountDown == 0) {
                    this.notifyNoData(cause);
                    this.phone.notifyDataConnection("apnFailed");
                } else {
                    this.startDelayedRetry(cause, reason);
                }
            } else {
                this.setState(DataConnectionTracker.State.SCANNING);
                this.sendMessageDelayed(this.obtainMessage(5, reason), 5000L);
            }
        }
    }

    @Override
    protected void onDisconnectDone(AsyncResult ar) {
        String reason = null;
        if (ar.userObj instanceof String) {
            reason = (String)ar.userObj;
        }
        this.setState(DataConnectionTracker.State.IDLE);
        this.phone.notifyDataConnection(reason);
        this.mActiveApn = null;
        if (this.retryAfterDisconnected(reason)) {
            this.trySetupData(reason);
        }
    }

    @Override
    protected void onResetDone(AsyncResult ar) {
        String reason = null;
        if (ar.userObj instanceof String) {
            reason = (String)ar.userObj;
        }
        this.gotoIdleAndNotifyDataConnection(reason);
    }

    protected void onPollPdp() {
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            this.phone.mCM.getPDPContextList(this.obtainMessage(11));
            this.sendMessageDelayed(this.obtainMessage(7), 5000L);
        }
    }

    @Override
    protected void onVoiceCallStarted() {
        if (this.state == DataConnectionTracker.State.CONNECTED && !this.mGsmPhone.mSST.isConcurrentVoiceAndData()) {
            this.stopNetStatPoll();
            this.phone.notifyDataConnection("2GVoiceCallStarted");
        }
    }

    @Override
    protected void onVoiceCallEnded() {
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            if (!this.mGsmPhone.mSST.isConcurrentVoiceAndData()) {
                this.startNetStatPoll();
                this.phone.notifyDataConnection("2GVoiceCallEnded");
            } else {
                this.resetPollStats();
            }
        } else {
            this.mRetryMgr.resetRetryCount();
            this.mReregisterOnReconnectFailure = false;
            this.trySetupData("2GVoiceCallEnded");
        }
    }

    @Override
    protected void onCleanUpConnection(boolean tearDown, String reason) {
        this.cleanUpConnection(tearDown, reason);
    }

    private void createAllApnList() {
        this.allApns = new ArrayList();
        String operator = this.mGsmPhone.mSIMRecords.getSIMOperatorNumeric();
        if (operator != null) {
            String selection = "numeric = '" + operator + "'";
            Cursor cursor = this.phone.getContext().getContentResolver().query(Telephony.Carriers.CONTENT_URI, null, selection, null, null);
            if (cursor != null) {
                if (cursor.getCount() > 0) {
                    this.allApns = this.createApnList(cursor);
                }
                cursor.close();
            }
        }
        if (this.allApns.isEmpty()) {
            this.preferredApn = null;
            this.notifyNoData(DataConnection.FailCause.MISSING_UNKNOWN_APN);
        } else {
            this.preferredApn = this.getPreferredApn();
            Log.d("GSM", "Get PreferredAPN");
            if (this.preferredApn != null && !this.preferredApn.numeric.equals(operator)) {
                this.preferredApn = null;
                this.setPreferredApn(-1);
            }
        }
    }

    private void createAllPdpList() {
        this.pdpList = new ArrayList();
        for (int i = 0; i < 1; ++i) {
            GsmDataConnection pdp = GsmDataConnection.makeDataConnection(this.mGsmPhone);
            this.pdpList.add(pdp);
        }
    }

    private void destroyAllPdpList() {
        if (this.pdpList != null) {
            this.pdpList.removeAll(this.pdpList);
        }
    }

    private ApnSetting fetchDunApn() {
        Context c = this.phone.getContext();
        String apnData = Settings.Secure.getString(c.getContentResolver(), "tether_dun_apn");
        ApnSetting dunSetting = ApnSetting.fromString(apnData);
        if (dunSetting != null) {
            return dunSetting;
        }
        apnData = c.getResources().getString(17039383);
        return ApnSetting.fromString(apnData);
    }

    private ArrayList<ApnSetting> buildWaitingApns() {
        ArrayList<ApnSetting> apnList = new ArrayList<ApnSetting>();
        if (this.mRequestedApnType.equals("dun")) {
            ApnSetting dun = this.fetchDunApn();
            if (dun != null) {
                apnList.add(dun);
            }
            return apnList;
        }
        String operator = this.mGsmPhone.mSIMRecords.getSIMOperatorNumeric();
        if (this.mRequestedApnType.equals("default") && this.canSetPreferApn && this.preferredApn != null) {
            Log.i("GSM", "Preferred APN:" + operator + ":" + this.preferredApn.numeric + ":" + this.preferredApn);
            if (this.preferredApn.numeric.equals(operator)) {
                Log.i("GSM", "Waiting APN set to preferred APN");
                apnList.add(this.preferredApn);
                return apnList;
            }
            this.setPreferredApn(-1);
            this.preferredApn = null;
        }
        if (this.allApns != null) {
            for (ApnSetting apn : this.allApns) {
                if (!apn.canHandleType(this.mRequestedApnType)) continue;
                apnList.add(apn);
            }
        }
        return apnList;
    }

    private ApnSetting getNextApn() {
        ArrayList<ApnSetting> list = this.waitingApns;
        ApnSetting apn = null;
        if (list != null && !list.isEmpty()) {
            apn = list.get(0);
        }
        return apn;
    }

    private String apnListToString(ArrayList<ApnSetting> apns) {
        StringBuilder result = new StringBuilder();
        int size = apns.size();
        for (int i = 0; i < size; ++i) {
            result.append('[').append(apns.get(i).toString()).append(']');
        }
        return result.toString();
    }

    private void startDelayedRetry(DataConnection.FailCause cause, String reason) {
        this.notifyNoData(cause);
        this.reconnectAfterFail(cause, reason);
    }

    private void setPreferredApn(int pos) {
        if (!this.canSetPreferApn) {
            return;
        }
        ContentResolver resolver = this.phone.getContext().getContentResolver();
        resolver.delete(PREFERAPN_URI, null, null);
        if (pos >= 0) {
            ContentValues values = new ContentValues();
            values.put(APN_ID, pos);
            resolver.insert(PREFERAPN_URI, values);
        }
    }

    private ApnSetting getPreferredApn() {
        if (this.allApns.isEmpty()) {
            return null;
        }
        Cursor cursor = this.phone.getContext().getContentResolver().query(PREFERAPN_URI, new String[]{"_id", "name", "apn"}, null, null, "name ASC");
        this.canSetPreferApn = cursor != null;
        if (this.canSetPreferApn && cursor.getCount() > 0) {
            cursor.moveToFirst();
            int pos = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
            for (ApnSetting p : this.allApns) {
                if (p.id != pos || !p.canHandleType(this.mRequestedApnType)) continue;
                cursor.close();
                return p;
            }
        }
        if (cursor != null) {
            cursor.close();
        }
        return null;
    }

    @Override
    public void handleMessage(Message msg) {
        if (!this.mGsmPhone.mIsTheCurrentActivePhone) {
            Log.d("GSM", "Ignore GSM msgs since GSM phone is inactive");
            return;
        }
        switch (msg.what) {
            case 4: {
                this.onRecordsLoaded();
                break;
            }
            case 19: {
                this.onGprsDetached();
                break;
            }
            case 26: {
                this.onGprsAttached();
                break;
            }
            case 6: {
                this.onPdpStateChanged((AsyncResult)msg.obj, false);
                break;
            }
            case 11: {
                this.onPdpStateChanged((AsyncResult)msg.obj, true);
                break;
            }
            case 7: {
                this.onPollPdp();
                break;
            }
            case 27: {
                this.mPingTestActive = false;
                this.startNetStatPoll();
                break;
            }
            case 28: {
                this.mPingTestActive = false;
                this.doRecovery();
                break;
            }
            case 29: {
                this.onApnChanged();
                break;
            }
            case 32: {
                Log.d("GSM", "[DSAC DEB] EVENT_PS_RESTRICT_ENABLED " + this.mIsPsRestricted);
                this.stopNetStatPoll();
                this.mIsPsRestricted = true;
                break;
            }
            case 33: {
                Log.d("GSM", "[DSAC DEB] EVENT_PS_RESTRICT_DISABLED " + this.mIsPsRestricted);
                this.mIsPsRestricted = false;
                if (this.state == DataConnectionTracker.State.CONNECTED) {
                    this.startNetStatPoll();
                    break;
                }
                if (this.state == DataConnectionTracker.State.FAILED) {
                    this.cleanUpConnection(false, "psRestrictEnabled");
                    this.mRetryMgr.resetRetryCount();
                    this.mReregisterOnReconnectFailure = false;
                }
                this.trySetupData("psRestrictEnabled");
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    @Override
    protected void log(String s) {
        Log.d("GSM", "[GsmDataConnectionTracker] " + s);
    }

    private class ApnChangeObserver
    extends ContentObserver {
        public ApnChangeObserver() {
            super(GsmDataConnectionTracker.this.mDataConnectionTracker);
        }

        public void onChange(boolean selfChange) {
            GsmDataConnectionTracker.this.sendMessage(GsmDataConnectionTracker.this.obtainMessage(29));
        }
    }
}

