/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.app.PendingIntent;
import android.content.ContentValues;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.database.Cursor;
import android.database.SQLException;
import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.telephony.SmsMessage;
import android.util.Log;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.WspTypeDecoder;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.cdma.SmsMessage;
import com.android.internal.telephony.cdma.sms.UserData;
import com.android.internal.util.HexDump;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CdmaSMSDispatcher
extends SMSDispatcher {
    private static final String TAG = "CDMA";
    private byte[] mLastDispatchedSmsFingerprint;
    private byte[] mLastAcknowledgedSmsFingerprint;
    private boolean mCheckForDuplicatePortsInOmadmWapPush = Resources.getSystem().getBoolean(17629212);

    CdmaSMSDispatcher(CDMAPhone phone) {
        super(phone);
    }

    @Override
    protected void handleStatusReport(AsyncResult ar) {
        Log.d(TAG, "handleStatusReport is a special GSM function, should never be called in CDMA!");
    }

    private void handleCdmaStatusReport(SmsMessage sms) {
        int count = this.deliveryPendingList.size();
        for (int i = 0; i < count; ++i) {
            SMSDispatcher.SmsTracker tracker = (SMSDispatcher.SmsTracker)this.deliveryPendingList.get(i);
            if (tracker.mMessageRef != sms.messageRef) continue;
            this.deliveryPendingList.remove(i);
            PendingIntent intent = tracker.mDeliveryIntent;
            Intent fillIn = new Intent();
            fillIn.putExtra("pdu", sms.getPdu());
            try {
                intent.send(this.mContext, -1, fillIn);
            }
            catch (PendingIntent.CanceledException ex) {}
            break;
        }
    }

    @Override
    protected int dispatchMessage(SmsMessageBase smsb) {
        if (smsb == null) {
            Log.e(TAG, "dispatchMessage: message is null");
            return 2;
        }
        String inEcm = SystemProperties.get("ril.cdma.inecmmode", "false");
        if (inEcm.equals("true")) {
            return -1;
        }
        SmsMessage sms = (SmsMessage)smsb;
        this.mLastDispatchedSmsFingerprint = sms.getIncomingSmsFingerprint();
        if (this.mLastAcknowledgedSmsFingerprint != null && Arrays.equals(this.mLastDispatchedSmsFingerprint, this.mLastAcknowledgedSmsFingerprint)) {
            return 1;
        }
        sms.parseSms();
        int teleService = sms.getTeleService();
        boolean handled = false;
        if (4099 == teleService || 262144 == teleService) {
            int voicemailCount = sms.getNumOfVoicemails();
            Log.d(TAG, "Voicemail count=" + voicemailCount);
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mPhone.getContext());
            SharedPreferences.Editor editor = sp.edit();
            editor.putInt("vm_count_key_cdma", voicemailCount);
            editor.apply();
            ((CDMAPhone)this.mPhone).updateMessageWaitingIndicator(voicemailCount);
            handled = true;
        } else if ((4098 == teleService || 4101 == teleService) && sms.isStatusReportMessage()) {
            this.handleCdmaStatusReport(sms);
            handled = true;
        } else if (sms.getUserData() == null) {
            Log.d(TAG, "Received SMS without user data");
            handled = true;
        }
        if (handled) {
            return 1;
        }
        if (!this.mStorageAvailable && sms.getMessageClass() != SmsMessage.MessageClass.CLASS_0) {
            return 3;
        }
        if (4100 == teleService) {
            return this.processCdmaWapPdu(sms.getUserData(), sms.messageRef, sms.getOriginatingAddress());
        }
        if (4098 != teleService && 4101 != teleService && 1 != sms.getMessageType()) {
            return 4;
        }
        SmsHeader smsHeader = sms.getUserDataHeader();
        if (smsHeader == null || smsHeader.concatRef == null) {
            byte[][] pdus = new byte[][]{sms.getPdu()};
            if (smsHeader != null && smsHeader.portAddrs != null) {
                if (smsHeader.portAddrs.destPort == 2948) {
                    return this.mWapPush.dispatchWapPdu(sms.getUserData());
                }
                this.dispatchPortAddressedPdus(pdus, smsHeader.portAddrs.destPort);
            } else {
                this.dispatchPdus(pdus);
            }
            return -1;
        }
        return this.processMessagePart(sms, smsHeader.concatRef, smsHeader.portAddrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int processCdmaWapPdu(byte[] pdu, int referenceNumber, String address) {
        int cursorCount;
        Cursor cursor;
        Object pdus;
        String[] whereArgs;
        StringBuilder where;
        byte segment;
        int totalSegments;
        int destinationPort;
        int index;
        block18: {
            int n;
            block19: {
                byte msgType;
                index = 0;
                int sourcePort = 0;
                destinationPort = 0;
                if ((msgType = pdu[index++]) != 0) {
                    Log.w(TAG, "Received a WAP SMS which is not WDP. Discard.");
                    return 1;
                }
                totalSegments = pdu[index++];
                if ((segment = pdu[index++]) == 0) {
                    sourcePort = (0xFF & pdu[index++]) << 8;
                    sourcePort |= 0xFF & pdu[index++];
                    destinationPort = (0xFF & pdu[index++]) << 8;
                    destinationPort |= 0xFF & pdu[index++];
                    if (this.mCheckForDuplicatePortsInOmadmWapPush && this.checkDuplicatePortOmadmWappush(pdu, index)) {
                        index += 4;
                    }
                }
                where = new StringBuilder("reference_number =");
                where.append(referenceNumber);
                where.append(" AND address = ?");
                whereArgs = new String[]{address};
                Log.i(TAG, "Received WAP PDU. Type = " + msgType + ", originator = " + address + ", src-port = " + sourcePort + ", dst-port = " + destinationPort + ", ID = " + referenceNumber + ", segment# = " + segment + "/" + totalSegments);
                pdus = null;
                cursor = null;
                cursor = this.mResolver.query(this.mRawUri, RAW_PROJECTION, where.toString(), whereArgs, null);
                cursorCount = cursor.getCount();
                if (cursorCount == totalSegments - 1) break block18;
                ContentValues values = new ContentValues();
                values.put("date", 0L);
                values.put("pdu", HexDump.toHexString(pdu, index, pdu.length - index));
                values.put("address", address);
                values.put("reference_number", referenceNumber);
                values.put("count", totalSegments);
                values.put("sequence", Integer.valueOf(segment));
                values.put("destination_port", destinationPort);
                this.mResolver.insert(this.mRawUri, values);
                n = 1;
                Object var21_23 = null;
                if (cursor == null) break block19;
                cursor.close();
            }
            return n;
        }
        try {
            try {
                int pduColumn = cursor.getColumnIndex("pdu");
                int sequenceColumn = cursor.getColumnIndex("sequence");
                pdus = new byte[totalSegments][];
                for (int i = 0; i < cursorCount; ++i) {
                    cursor.moveToNext();
                    int cursorSequence = (int)cursor.getLong(sequenceColumn);
                    if (cursorSequence == 0) {
                        int destinationPortColumn = cursor.getColumnIndex("destination_port");
                        destinationPort = (int)cursor.getLong(destinationPortColumn);
                    }
                    pdus[cursorSequence] = HexDump.hexStringToByteArray(cursor.getString(pduColumn));
                }
                this.mResolver.delete(this.mRawUri, where.toString(), whereArgs);
            }
            catch (SQLException e) {
                Log.e(TAG, "Can't access multipart SMS database", e);
                int pduColumn = 2;
                Object var21_25 = null;
                if (cursor != null) {
                    cursor.close();
                }
                return pduColumn;
            }
            Object var21_24 = null;
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (Throwable throwable) {
            Object var21_26 = null;
            if (cursor != null) {
                cursor.close();
            }
            throw throwable;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        for (int i = 0; i < totalSegments; ++i) {
            if (i == segment) {
                output.write(pdu, index, pdu.length - index);
                continue;
            }
            output.write(pdus[i], 0, pdus[i].length);
        }
        byte[] datagram = output.toByteArray();
        switch (destinationPort) {
            case 2948: {
                return this.mWapPush.dispatchWapPdu(datagram);
            }
        }
        pdus = new byte[1][];
        pdus[0] = datagram;
        this.dispatchPortAddressedPdus((byte[][])pdus, destinationPort);
        return -1;
    }

    @Override
    protected void sendData(String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        SmsMessage.SubmitPdu pdu = SmsMessage.getSubmitPdu(scAddr, destAddr, destPort, data, deliveryIntent != null);
        this.sendSubmitPdu(pdu, sentIntent, deliveryIntent);
    }

    @Override
    protected void sendText(String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        SmsMessage.SubmitPdu pdu = SmsMessage.getSubmitPdu(scAddr, destAddr, text, deliveryIntent != null, null);
        this.sendSubmitPdu(pdu, sentIntent, deliveryIntent);
    }

    @Override
    protected void sendMultipartText(String destAddr, String scAddr, ArrayList<String> parts, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents) {
        int i;
        int refNumber = CdmaSMSDispatcher.getNextConcatenatedRef() & 0xFF;
        int msgCount = parts.size();
        int encoding = 0;
        for (i = 0; i < msgCount; ++i) {
            SmsMessageBase.TextEncodingDetails details = SmsMessage.calculateLength(parts.get(i), false);
            if (encoding == details.codeUnitSize || encoding != 0 && encoding != 1) continue;
            encoding = details.codeUnitSize;
        }
        for (i = 0; i < msgCount; ++i) {
            SmsHeader.ConcatRef concatRef = new SmsHeader.ConcatRef();
            concatRef.refNumber = refNumber;
            concatRef.seqNumber = i + 1;
            concatRef.msgCount = msgCount;
            concatRef.isEightBits = true;
            SmsHeader smsHeader = new SmsHeader();
            smsHeader.concatRef = concatRef;
            PendingIntent sentIntent = null;
            if (sentIntents != null && sentIntents.size() > i) {
                sentIntent = sentIntents.get(i);
            }
            PendingIntent deliveryIntent = null;
            if (deliveryIntents != null && deliveryIntents.size() > i) {
                deliveryIntent = deliveryIntents.get(i);
            }
            UserData uData = new UserData();
            uData.payloadStr = parts.get(i);
            uData.userDataHeader = smsHeader;
            uData.msgEncoding = encoding == 1 ? 9 : 4;
            uData.msgEncodingSet = true;
            SmsMessage.SubmitPdu submitPdu = SmsMessage.getSubmitPdu(destAddr, uData, deliveryIntent != null && i == msgCount - 1);
            this.sendSubmitPdu(submitPdu, sentIntent, deliveryIntent);
        }
    }

    protected void sendSubmitPdu(SmsMessage.SubmitPdu pdu, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        if (SystemProperties.getBoolean("ril.cdma.inecmmode", false)) {
            if (sentIntent != null) {
                try {
                    sentIntent.send(4);
                }
                catch (PendingIntent.CanceledException ex) {
                    // empty catch block
                }
            }
            Log.d(TAG, "Block SMS in Emergency Callback mode");
            return;
        }
        this.sendRawPdu(pdu.encodedScAddress, pdu.encodedMessage, sentIntent, deliveryIntent);
    }

    @Override
    protected void sendSms(SMSDispatcher.SmsTracker tracker) {
        HashMap map = tracker.mData;
        byte[] pdu = (byte[])map.get("pdu");
        Message reply = this.obtainMessage(2, tracker);
        this.mCm.sendCdmaSms(pdu, reply);
    }

    @Override
    protected void sendMultipartSms(SMSDispatcher.SmsTracker tracker) {
        Log.d(TAG, "TODO: CdmaSMSDispatcher.sendMultipartSms not implemented");
    }

    @Override
    protected void acknowledgeLastIncomingSms(boolean success, int result, Message response) {
        String inEcm = SystemProperties.get("ril.cdma.inecmmode", "false");
        if (inEcm.equals("true")) {
            return;
        }
        if (this.mCm != null) {
            int causeCode = this.resultToCause(result);
            this.mCm.acknowledgeLastIncomingCdmaSms(success, causeCode, response);
            if (causeCode == 0) {
                this.mLastAcknowledgedSmsFingerprint = this.mLastDispatchedSmsFingerprint;
            }
            this.mLastDispatchedSmsFingerprint = null;
        }
    }

    @Override
    protected void handleBroadcastSms(AsyncResult ar) {
        Log.e(TAG, "Error! Not implemented for CDMA.");
    }

    private int resultToCause(int rc) {
        switch (rc) {
            case -1: 
            case 1: {
                return 0;
            }
            case 3: {
                return 35;
            }
            case 4: {
                return 4;
            }
        }
        return 96;
    }

    private boolean checkDuplicatePortOmadmWappush(byte[] origPdu, int index) {
        int binaryContentType;
        byte[] omaPdu = new byte[origPdu.length - (index += 4)];
        System.arraycopy(origPdu, index, omaPdu, 0, omaPdu.length);
        WspTypeDecoder pduDecoder = new WspTypeDecoder(omaPdu);
        int wspIndex = 2;
        if (!pduDecoder.decodeUintvarInteger(wspIndex)) {
            return false;
        }
        if (!pduDecoder.decodeContentType(wspIndex += pduDecoder.getDecodedDataLength())) {
            return false;
        }
        String mimeType = pduDecoder.getValueString();
        return mimeType == null && (binaryContentType = (int)pduDecoder.getValue32()) == 68;
    }
}

