/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.net.Credentials;
import android.net.LocalSocket;
import android.os.SystemProperties;
import android.util.Log;
import com.android.internal.os.RuntimeInit;
import com.android.internal.os.ZygoteInit;
import com.android.internal.os.ZygoteSecurityException;
import dalvik.system.PathClassLoader;
import dalvik.system.Zygote;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;

class ZygoteConnection {
    private static final String TAG = "Zygote";
    private static final int[][] intArray2d = new int[0][0];
    private static final int CONNECTION_TIMEOUT_MILLIS = 1000;
    private static final int MAX_ZYGOTE_ARGC = 1024;
    private final LocalSocket mSocket;
    private final DataOutputStream mSocketOutStream;
    private final BufferedReader mSocketReader;
    private final Credentials peer;
    private static LocalSocket sPeerWaitSocket = null;

    ZygoteConnection(LocalSocket socket) throws IOException {
        this.mSocket = socket;
        this.mSocketOutStream = new DataOutputStream(socket.getOutputStream());
        this.mSocketReader = new BufferedReader(new InputStreamReader(socket.getInputStream()), 256);
        this.mSocket.setSoTimeout(1000);
        try {
            this.peer = this.mSocket.getPeerCredentials();
        }
        catch (IOException ex) {
            Log.e(TAG, "Cannot read peer credentials", ex);
            throw ex;
        }
    }

    FileDescriptor getFileDesciptor() {
        return this.mSocket.getFileDescriptor();
    }

    void run() throws ZygoteInit.MethodAndArgsCaller {
        int loopCount = 10;
        do {
            if (loopCount <= 0) {
                ZygoteInit.gc();
                loopCount = 10;
                continue;
            }
            --loopCount;
        } while (!this.runOnce());
    }

    boolean runOnce() throws ZygoteInit.MethodAndArgsCaller {
        int pid;
        FileDescriptor[] descriptors;
        String[] args;
        Arguments parsedArgs = null;
        try {
            args = this.readArgumentList();
            descriptors = this.mSocket.getAncillaryFileDescriptors();
        }
        catch (IOException ex) {
            Log.w(TAG, "IOException on command socket " + ex.getMessage());
            this.closeSocket();
            return true;
        }
        if (args == null) {
            this.closeSocket();
            return true;
        }
        PrintStream newStderr = null;
        if (descriptors != null && descriptors.length >= 3) {
            newStderr = new PrintStream(new FileOutputStream(descriptors[2]));
        }
        try {
            parsedArgs = new Arguments(args);
            ZygoteConnection.applyUidSecurityPolicy(parsedArgs, this.peer);
            ZygoteConnection.applyDebuggerSecurityPolicy(parsedArgs);
            ZygoteConnection.applyRlimitSecurityPolicy(parsedArgs, this.peer);
            ZygoteConnection.applyCapabilitiesSecurityPolicy(parsedArgs, this.peer);
            int[][] rlimits = null;
            if (parsedArgs.rlimits != null) {
                rlimits = (int[][])parsedArgs.rlimits.toArray((T[])intArray2d);
            }
            pid = Zygote.forkAndSpecialize((int)parsedArgs.uid, (int)parsedArgs.gid, (int[])parsedArgs.gids, (int)parsedArgs.debugFlags, (int[][])rlimits);
        }
        catch (IllegalArgumentException ex) {
            ZygoteConnection.logAndPrintError(newStderr, "Invalid zygote arguments", ex);
            pid = -1;
        }
        catch (ZygoteSecurityException ex) {
            ZygoteConnection.logAndPrintError(newStderr, "Zygote security policy prevents request: ", ex);
            pid = -1;
        }
        if (pid == 0) {
            this.handleChildProc(parsedArgs, descriptors, newStderr);
            return true;
        }
        return this.handleParentProc(pid, descriptors, parsedArgs);
    }

    void closeSocket() {
        try {
            this.mSocket.close();
        }
        catch (IOException ex) {
            Log.e(TAG, "Exception while closing command socket in parent", ex);
        }
    }

    private String[] readArgumentList() throws IOException {
        int argc;
        try {
            String s = this.mSocketReader.readLine();
            if (s == null) {
                return null;
            }
            argc = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            Log.e(TAG, "invalid Zygote wire format: non-int at argc");
            throw new IOException("invalid wire format");
        }
        if (argc > 1024) {
            throw new IOException("max arg count exceeded");
        }
        String[] result = new String[argc];
        for (int i = 0; i < argc; ++i) {
            result[i] = this.mSocketReader.readLine();
            if (result[i] != null) continue;
            throw new IOException("truncated request");
        }
        return result;
    }

    private static void applyUidSecurityPolicy(Arguments args, Credentials peer) throws ZygoteSecurityException {
        int peerUid = peer.getUid();
        if (peerUid != 0) {
            if (peerUid == 1000) {
                boolean uidRestricted;
                String factoryTest = SystemProperties.get("ro.factorytest");
                boolean bl = uidRestricted = !factoryTest.equals("1") && !factoryTest.equals("2");
                if (uidRestricted && args.uidSpecified && args.uid < 1000) {
                    throw new ZygoteSecurityException("System UID may not launch process with UID < 1000");
                }
            } else if (args.uidSpecified || args.gidSpecified || args.gids != null) {
                throw new ZygoteSecurityException("App UIDs may not specify uid's or gid's");
            }
        }
        if (!args.uidSpecified) {
            args.uid = peer.getUid();
            args.uidSpecified = true;
        }
        if (!args.gidSpecified) {
            args.gid = peer.getGid();
            args.gidSpecified = true;
        }
    }

    private static void applyDebuggerSecurityPolicy(Arguments args) {
        if ("1".equals(SystemProperties.get("ro.debuggable"))) {
            args.debugFlags |= 1;
        }
    }

    private static void applyRlimitSecurityPolicy(Arguments args, Credentials peer) throws ZygoteSecurityException {
        int peerUid = peer.getUid();
        if (peerUid != 0 && peerUid != 1000 && args.rlimits != null) {
            throw new ZygoteSecurityException("This UID may not specify rlimits.");
        }
    }

    private static void applyCapabilitiesSecurityPolicy(Arguments args, Credentials peer) throws ZygoteSecurityException {
        long permittedCaps;
        if (args.permittedCapabilities == 0L && args.effectiveCapabilities == 0L) {
            return;
        }
        if (peer.getUid() == 0) {
            return;
        }
        try {
            permittedCaps = ZygoteInit.capgetPermitted(peer.getPid());
        }
        catch (IOException ex) {
            throw new ZygoteSecurityException("Error retrieving peer's capabilities.");
        }
        if (((args.permittedCapabilities ^ 0xFFFFFFFFFFFFFFFFL) & args.effectiveCapabilities) != 0L) {
            throw new ZygoteSecurityException("Effective capabilities cannot be superset of  permitted capabilities");
        }
        if (((permittedCaps ^ 0xFFFFFFFFFFFFFFFFL) & args.permittedCapabilities) != 0L) {
            throw new ZygoteSecurityException("Peer specified unpermitted capabilities");
        }
    }

    private void handleChildProc(Arguments parsedArgs, FileDescriptor[] descriptors, PrintStream newStderr) throws ZygoteInit.MethodAndArgsCaller {
        if (parsedArgs.peerWait) {
            try {
                ZygoteInit.setCloseOnExec(this.mSocket.getFileDescriptor(), true);
                sPeerWaitSocket = this.mSocket;
            }
            catch (IOException ex) {
                Log.e(TAG, "Zygote Child: error setting peer wait socket to be close-on-exec", ex);
            }
        } else {
            this.closeSocket();
            ZygoteInit.closeServerSocket();
        }
        if (descriptors != null) {
            try {
                ZygoteInit.reopenStdio(descriptors[0], descriptors[1], descriptors[2]);
                for (FileDescriptor fd : descriptors) {
                    ZygoteInit.closeDescriptor(fd);
                }
                newStderr = System.err;
            }
            catch (IOException ex) {
                Log.e(TAG, "Error reopening stdio", ex);
            }
        }
        if (parsedArgs.runtimeInit) {
            RuntimeInit.zygoteInit(parsedArgs.remainingArgs);
        } else {
            String className;
            ClassLoader cloader = parsedArgs.classpath != null ? new PathClassLoader(parsedArgs.classpath, ClassLoader.getSystemClassLoader()) : ClassLoader.getSystemClassLoader();
            try {
                className = parsedArgs.remainingArgs[0];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ZygoteConnection.logAndPrintError(newStderr, "Missing required class name argument", null);
                return;
            }
            String[] mainArgs = new String[parsedArgs.remainingArgs.length - 1];
            System.arraycopy(parsedArgs.remainingArgs, 1, mainArgs, 0, mainArgs.length);
            try {
                ZygoteInit.invokeStaticMain(cloader, className, mainArgs);
            }
            catch (RuntimeException ex) {
                ZygoteConnection.logAndPrintError(newStderr, "Error starting. ", ex);
            }
        }
    }

    private boolean handleParentProc(int pid, FileDescriptor[] descriptors, Arguments parsedArgs) {
        if (pid > 0) {
            try {
                ZygoteInit.setpgid(pid, ZygoteInit.getpgid(this.peer.getPid()));
            }
            catch (IOException ex) {
                Log.i(TAG, "Zygote: setpgid failed. This is normal if peer is not in our session");
            }
        }
        try {
            if (descriptors != null) {
                for (FileDescriptor fd : descriptors) {
                    ZygoteInit.closeDescriptor(fd);
                }
            }
        }
        catch (IOException ex) {
            Log.e(TAG, "Error closing passed descriptors in parent process", ex);
        }
        try {
            this.mSocketOutStream.writeInt(pid);
        }
        catch (IOException ex) {
            Log.e(TAG, "Error reading from command socket", ex);
            return true;
        }
        if (parsedArgs.peerWait) {
            try {
                this.mSocket.close();
            }
            catch (IOException ex) {
                Log.e(TAG, "Zygote: error closing sockets", ex);
            }
            return true;
        }
        return false;
    }

    private static void logAndPrintError(PrintStream newStderr, String message, Throwable ex) {
        Log.e(TAG, message, ex);
        if (newStderr != null) {
            newStderr.println(message + (ex == null ? "" : ex));
        }
    }

    static class Arguments {
        int uid = 0;
        boolean uidSpecified;
        int gid = 0;
        boolean gidSpecified;
        int[] gids;
        boolean peerWait;
        int debugFlags;
        String classpath;
        boolean runtimeInit;
        boolean capabilitiesSpecified;
        long permittedCapabilities;
        long effectiveCapabilities;
        ArrayList<int[]> rlimits;
        String[] remainingArgs;

        Arguments(String[] args) throws IllegalArgumentException {
            this.parseArgs(args);
        }

        private void parseArgs(String[] args) throws IllegalArgumentException {
            int curArg;
            for (curArg = 0; curArg < args.length; ++curArg) {
                String arg = args[curArg];
                if (arg.equals("--")) {
                    ++curArg;
                    break;
                }
                if (arg.startsWith("--setuid=")) {
                    if (this.uidSpecified) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    this.uidSpecified = true;
                    this.uid = Integer.parseInt(arg.substring(arg.indexOf(61) + 1));
                    continue;
                }
                if (arg.startsWith("--setgid=")) {
                    if (this.gidSpecified) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    this.gidSpecified = true;
                    this.gid = Integer.parseInt(arg.substring(arg.indexOf(61) + 1));
                    continue;
                }
                if (arg.equals("--enable-debugger")) {
                    this.debugFlags |= 1;
                    continue;
                }
                if (arg.equals("--enable-safemode")) {
                    this.debugFlags |= 8;
                    continue;
                }
                if (arg.equals("--enable-checkjni")) {
                    this.debugFlags |= 2;
                    continue;
                }
                if (arg.equals("--enable-assert")) {
                    this.debugFlags |= 4;
                    continue;
                }
                if (arg.equals("--peer-wait")) {
                    this.peerWait = true;
                    continue;
                }
                if (arg.equals("--runtime-init")) {
                    this.runtimeInit = true;
                    continue;
                }
                if (arg.startsWith("--capabilities=")) {
                    if (this.capabilitiesSpecified) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    this.capabilitiesSpecified = true;
                    String capString = arg.substring(arg.indexOf(61) + 1);
                    String[] capStrings = capString.split(",", 2);
                    if (capStrings.length == 1) {
                        this.permittedCapabilities = this.effectiveCapabilities = Long.decode(capStrings[0]).longValue();
                        continue;
                    }
                    this.permittedCapabilities = Long.decode(capStrings[0]);
                    this.effectiveCapabilities = Long.decode(capStrings[1]);
                    continue;
                }
                if (arg.startsWith("--rlimit=")) {
                    String[] limitStrings = arg.substring(arg.indexOf(61) + 1).split(",");
                    if (limitStrings.length != 3) {
                        throw new IllegalArgumentException("--rlimit= should have 3 comma-delimited ints");
                    }
                    int[] rlimitTuple = new int[limitStrings.length];
                    for (int i = 0; i < limitStrings.length; ++i) {
                        rlimitTuple[i] = Integer.parseInt(limitStrings[i]);
                    }
                    if (this.rlimits == null) {
                        this.rlimits = new ArrayList();
                    }
                    this.rlimits.add(rlimitTuple);
                    continue;
                }
                if (arg.equals("-classpath")) {
                    if (this.classpath != null) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    try {
                        this.classpath = args[++curArg];
                        continue;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new IllegalArgumentException("-classpath requires argument");
                    }
                }
                if (!arg.startsWith("--setgroups=")) break;
                if (this.gids != null) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                String[] params = arg.substring(arg.indexOf(61) + 1).split(",");
                this.gids = new int[params.length];
                for (int i = params.length - 1; i >= 0; --i) {
                    this.gids[i] = Integer.parseInt(params[i]);
                }
            }
            if (this.runtimeInit && this.classpath != null) {
                throw new IllegalArgumentException("--runtime-init and -classpath are incompatible");
            }
            this.remainingArgs = new String[args.length - curArg];
            System.arraycopy(args, curArg, this.remainingArgs, 0, this.remainingArgs.length);
        }
    }
}

