/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.Context;
import android.content.res.XmlResourceParser;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParserException;

public class PowerProfile {
    public static final String POWER_NONE = "none";
    public static final String POWER_CPU_IDLE = "cpu.idle";
    public static final String POWER_CPU_AWAKE = "cpu.awake";
    public static final String POWER_CPU_ACTIVE = "cpu.active";
    public static final String POWER_WIFI_SCAN = "wifi.scan";
    public static final String POWER_WIFI_ON = "wifi.on";
    public static final String POWER_WIFI_ACTIVE = "wifi.active";
    public static final String POWER_GPS_ON = "gps.on";
    public static final String POWER_BLUETOOTH_ON = "bluetooth.on";
    public static final String POWER_BLUETOOTH_ACTIVE = "bluetooth.active";
    public static final String POWER_BLUETOOTH_AT_CMD = "bluetooth.at";
    public static final String POWER_SCREEN_ON = "screen.on";
    public static final String POWER_RADIO_ON = "radio.on";
    public static final String POWER_RADIO_SCANNING = "radio.scanning";
    public static final String POWER_RADIO_ACTIVE = "radio.active";
    public static final String POWER_SCREEN_FULL = "screen.full";
    public static final String POWER_AUDIO = "dsp.audio";
    public static final String POWER_VIDEO = "dsp.video";
    public static final String POWER_CPU_SPEEDS = "cpu.speeds";
    public static final String POWER_BATTERY_CAPACITY = "battery.capacity";
    static final HashMap<String, Object> sPowerMap = new HashMap();
    private static final String TAG_DEVICE = "device";
    private static final String TAG_ITEM = "item";
    private static final String TAG_ARRAY = "array";
    private static final String TAG_ARRAYITEM = "value";
    private static final String ATTR_NAME = "name";

    public PowerProfile(Context context) {
        if (sPowerMap.size() == 0) {
            this.readPowerValuesFromXml(context);
        }
    }

    private void readPowerValuesFromXml(Context context) {
        int id2 = 17498122;
        XmlResourceParser parser = context.getResources().getXml(id2);
        boolean parsingArray = false;
        ArrayList<Double> array2 = new ArrayList<Double>();
        String arrayName = null;
        try {
            XmlUtils.beginDocument(parser, TAG_DEVICE);
            while (true) {
                XmlUtils.nextElement(parser);
                String element = parser.getName();
                if (element == null) break;
                if (parsingArray && !element.equals(TAG_ARRAYITEM)) {
                    sPowerMap.put(arrayName, array2.toArray(new Double[array2.size()]));
                    parsingArray = false;
                }
                if (element.equals(TAG_ARRAY)) {
                    parsingArray = true;
                    array2.clear();
                    arrayName = parser.getAttributeValue(null, ATTR_NAME);
                    continue;
                }
                if (!element.equals(TAG_ITEM) && !element.equals(TAG_ARRAYITEM)) continue;
                String name = null;
                if (!parsingArray) {
                    name = parser.getAttributeValue(null, ATTR_NAME);
                }
                if (parser.next() != 4) continue;
                String power = parser.getText();
                double value = 0.0;
                try {
                    value = Double.valueOf(power);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if (element.equals(TAG_ITEM)) {
                    sPowerMap.put(name, value);
                    continue;
                }
                if (!parsingArray) continue;
                array2.add(value);
            }
            if (parsingArray) {
                sPowerMap.put(arrayName, array2.toArray(new Double[array2.size()]));
            }
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            parser.close();
        }
    }

    public double getAveragePower(String type) {
        if (sPowerMap.containsKey(type)) {
            Object data = sPowerMap.get(type);
            if (data instanceof Double[]) {
                return ((Double[])data)[0];
            }
            return (Double)sPowerMap.get(type);
        }
        return 0.0;
    }

    public double getAveragePower(String type, int level) {
        if (sPowerMap.containsKey(type)) {
            Object data = sPowerMap.get(type);
            if (data instanceof Double[]) {
                Double[] values = (Double[])data;
                if (values.length > level && level >= 0) {
                    return values[level];
                }
                if (level < 0) {
                    return 0.0;
                }
                return values[values.length - 1];
            }
            return (Double)data;
        }
        return 0.0;
    }

    public double getBatteryCapacity() {
        return this.getAveragePower(POWER_BATTERY_CAPACITY);
    }

    public int getNumSpeedSteps() {
        Object value = sPowerMap.get(POWER_CPU_SPEEDS);
        if (value != null && value instanceof Double[]) {
            return ((Double[])value).length;
        }
        return 1;
    }
}

