/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.nfc;

import android.nfc.ErrorCodes;
import android.nfc.ILlcpServiceSocket;
import android.nfc.ILlcpSocket;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.nfc.LlcpException;
import com.android.internal.nfc.LlcpSocket;
import java.io.IOException;

public class LlcpServiceSocket {
    private static final String TAG = "LlcpServiceSocket";
    protected int mHandle;
    protected ILlcpServiceSocket mService;
    private final ILlcpSocket mLlcpSocketService;

    static LlcpException convertErrorToLlcpException(int errorCode) {
        return LlcpServiceSocket.convertErrorToLlcpException(errorCode, null);
    }

    static LlcpException convertErrorToLlcpException(int errorCode, String message) {
        message = message == null ? "" : " (" + message + ")";
        switch (errorCode) {
            case -10: {
                return new LlcpException("Error during the creation of an Llcp socket" + message);
            }
            case -9: {
                return new LlcpException("Not enough ressources are available" + message);
            }
        }
        return new LlcpException("Unkown error code " + errorCode + message);
    }

    public LlcpServiceSocket(ILlcpServiceSocket service, ILlcpSocket socketService, int handle) {
        this.mService = service;
        this.mHandle = handle;
        this.mLlcpSocketService = socketService;
    }

    public LlcpSocket accept() throws IOException, LlcpException {
        try {
            int handle = this.mService.accept(this.mHandle);
            if (ErrorCodes.isError(handle)) {
                if (handle == -1) {
                    throw new IOException();
                }
                throw LlcpServiceSocket.convertErrorToLlcpException(handle);
            }
            return new LlcpSocket(this.mLlcpSocketService, handle);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in accept(): ", e);
            return null;
        }
    }

    public void close() {
        try {
            this.mService.close(this.mHandle);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in close(): ", e);
        }
    }
}

