/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.os.Build;
import android.os.FileUtils;
import android.os.SystemProperties;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeLibraryHelper {
    private static final String TAG = "NativeHelper";
    private static final boolean DEBUG_NATIVE = false;
    private static final int PACKAGE_INSTALL_NATIVE_FOUND_LIBRARIES = 0;
    private static final int PACKAGE_INSTALL_NATIVE_NO_LIBRARIES = 1;
    private static final int PACKAGE_INSTALL_NATIVE_ABI_MISMATCH = 2;
    private static final String APK_LIB = "lib/";
    private static final int APK_LIB_LENGTH = "lib/".length();
    private static final String LIB_PREFIX = "lib";
    private static final int LIB_PREFIX_LENGTH = "lib".length();
    private static final String LIB_SUFFIX = ".so";
    private static final int LIB_SUFFIX_LENGTH = ".so".length();
    private static final String GDBSERVER = "gdbserver";
    private static final int MIN_ENTRY_LENGTH = APK_LIB_LENGTH + 2 + LIB_PREFIX_LENGTH + 1 + LIB_SUFFIX_LENGTH;

    private static int listPackageSharedLibsForAbiLI(ZipFile zipFile, String cpuAbi, List<Pair<ZipEntry, String>> libEntries) throws IOException, ZipException {
        int cpuAbiLen = cpuAbi.length();
        boolean hasNativeLibraries = false;
        boolean installedNativeLibraries = false;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            String libFileName;
            int lastSlash;
            String entryName;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || (entryName = entry.getName()).length() < MIN_ENTRY_LENGTH || !entryName.endsWith(LIB_SUFFIX) || !entryName.startsWith(APK_LIB) || (lastSlash = entryName.lastIndexOf(47)) < 0 || !entryName.regionMatches(lastSlash + 1, LIB_PREFIX, 0, LIB_PREFIX_LENGTH)) continue;
            hasNativeLibraries = true;
            if (lastSlash != APK_LIB_LENGTH + cpuAbiLen || !entryName.regionMatches(APK_LIB_LENGTH, cpuAbi, 0, cpuAbiLen) || !FileUtils.isFilenameSafe(new File(libFileName = entryName.substring(lastSlash + 1)))) continue;
            installedNativeLibraries = true;
            libEntries.add(Pair.create(entry, libFileName));
        }
        if (!hasNativeLibraries) {
            return 1;
        }
        if (!installedNativeLibraries) {
            return 2;
        }
        return 0;
    }

    private static int listPackageGdbServerLI(ZipFile zipFile, String cpuAbi, List<Pair<ZipEntry, String>> nativeFiles) throws IOException, ZipException {
        String apkGdbServerPath = APK_LIB + cpuAbi + "/" + GDBSERVER;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            String entryName;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || !(entryName = entry.getName()).equals(apkGdbServerPath)) continue;
            Log.d(TAG, "Found gdbserver: " + entry.getName());
            String installGdbServerPath = GDBSERVER;
            nativeFiles.add(Pair.create(entry, GDBSERVER));
            return 0;
        }
        return 1;
    }

    public static int listPackageNativeBinariesLI(ZipFile zipFile, List<Pair<ZipEntry, String>> nativeFiles) throws ZipException, IOException {
        String cpuAbi = Build.CPU_ABI;
        int result = NativeLibraryHelper.listPackageSharedLibsForAbiLI(zipFile, cpuAbi, nativeFiles);
        if (result == 2) {
            String cpuAbi2 = SystemProperties.get("ro.product.cpu.abi2", null);
            if (cpuAbi2 != null) {
                result = NativeLibraryHelper.listPackageSharedLibsForAbiLI(zipFile, cpuAbi2, nativeFiles);
            }
            if (result == 2) {
                Slog.w(TAG, "Native ABI mismatch from package file");
                return -2;
            }
            if (result == 0) {
                cpuAbi = cpuAbi2;
            }
        }
        if (result == 0) {
            NativeLibraryHelper.listPackageGdbServerLI(zipFile, cpuAbi, nativeFiles);
        }
        return 1;
    }

    public static int copyNativeBinariesLI(File scanFile, File sharedLibraryDir) {
        try {
            ZipFile zipFile = new ZipFile(scanFile);
            LinkedList<Pair<ZipEntry, String>> nativeFiles = new LinkedList<Pair<ZipEntry, String>>();
            NativeLibraryHelper.listPackageNativeBinariesLI(zipFile, nativeFiles);
            int N = nativeFiles.size();
            for (int i = 0; i < N; ++i) {
                Pair entry = (Pair)nativeFiles.get(i);
                File destFile = new File(sharedLibraryDir, (String)entry.second);
                NativeLibraryHelper.copyNativeBinaryLI(zipFile, (ZipEntry)entry.first, sharedLibraryDir, destFile);
            }
        }
        catch (ZipException e) {
            Slog.w(TAG, "Failed to extract data from package file", e);
            return -2;
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed to cache package shared libs", e);
            return -4;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyNativeBinaryLI(ZipFile zipFile, ZipEntry entry, File binaryDir, File binaryFile) throws IOException {
        InputStream inputStream = zipFile.getInputStream(entry);
        try {
            File tempFile = File.createTempFile("tmp", "tmp", binaryDir);
            String tempFilePath = tempFile.getPath();
            if (!(FileUtils.copyToFile(inputStream, tempFile) && tempFile.setLastModified(entry.getTime()) && FileUtils.setPermissions(tempFilePath, 493, -1, -1) == 0 && tempFile.renameTo(binaryFile))) {
                tempFile.delete();
                throw new IOException("Couldn't create cached binary " + binaryFile + " in " + binaryDir);
            }
        }
        finally {
            inputStream.close();
        }
    }

    public static boolean removeNativeBinariesLI(String nativeLibraryPath) {
        return NativeLibraryHelper.removeNativeBinariesFromDirLI(new File(nativeLibraryPath));
    }

    public static boolean removeNativeBinariesFromDirLI(File nativeLibraryDir) {
        File[] binaries;
        boolean deletedFiles = false;
        if (nativeLibraryDir.exists() && (binaries = nativeLibraryDir.listFiles()) != null) {
            for (int nn = 0; nn < binaries.length; ++nn) {
                if (!binaries[nn].delete()) {
                    Slog.w(TAG, "Could not delete native binary: " + binaries[nn].getPath());
                    continue;
                }
                deletedFiles = true;
            }
        }
        return deletedFiles;
    }
}

