/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.provider.Settings;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.TextView;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;

public final class RingtonePickerActivity
extends AlertActivity
implements AdapterView.OnItemSelectedListener,
Runnable,
DialogInterface.OnClickListener,
AlertController.AlertParams.OnPrepareListViewListener {
    private static final String TAG = "RingtonePickerActivity";
    private static final int DELAY_MS_SELECTION_PLAYED = 300;
    private RingtoneManager mRingtoneManager;
    private Cursor mCursor;
    private Handler mHandler;
    private int mSilentPos = -1;
    private int mDefaultRingtonePos = -1;
    private int mClickedPos = -1;
    private int mSampleRingtonePos = -1;
    private boolean mHasSilentItem;
    private Uri mExistingUri;
    private int mStaticItemCount;
    private boolean mHasDefaultItem;
    private Uri mUriForDefaultItem;
    private Ringtone mDefaultRingtone;
    private DialogInterface.OnClickListener mRingtoneClickListener = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int which) {
            RingtonePickerActivity.this.mClickedPos = which;
            RingtonePickerActivity.this.playRingtone(which, 0);
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mHandler = new Handler();
        Intent intent = this.getIntent();
        this.mHasDefaultItem = intent.getBooleanExtra("android.intent.extra.ringtone.SHOW_DEFAULT", true);
        this.mUriForDefaultItem = (Uri)intent.getParcelableExtra("android.intent.extra.ringtone.DEFAULT_URI");
        if (this.mUriForDefaultItem == null) {
            this.mUriForDefaultItem = Settings.System.DEFAULT_RINGTONE_URI;
        }
        this.mHasSilentItem = intent.getBooleanExtra("android.intent.extra.ringtone.SHOW_SILENT", true);
        this.mRingtoneManager = new RingtoneManager(this);
        boolean includeDrm = intent.getBooleanExtra("android.intent.extra.ringtone.INCLUDE_DRM", true);
        this.mRingtoneManager.setIncludeDrm(includeDrm);
        int types = intent.getIntExtra("android.intent.extra.ringtone.TYPE", -1);
        if (types != -1) {
            this.mRingtoneManager.setType(types);
        }
        this.mCursor = this.mRingtoneManager.getCursor();
        this.setVolumeControlStream(this.mRingtoneManager.inferStreamType());
        this.mExistingUri = (Uri)intent.getParcelableExtra("android.intent.extra.ringtone.EXISTING_URI");
        AlertController.AlertParams p = this.mAlertParams;
        p.mCursor = this.mCursor;
        p.mOnClickListener = this.mRingtoneClickListener;
        p.mLabelColumn = "title";
        p.mIsSingleChoice = true;
        p.mOnItemSelectedListener = this;
        p.mPositiveButtonText = this.getString(17039370);
        p.mPositiveButtonListener = this;
        p.mNegativeButtonText = this.getString(0x1040000);
        p.mPositiveButtonListener = this;
        p.mOnPrepareListViewListener = this;
        p.mTitle = intent.getCharSequenceExtra("android.intent.extra.ringtone.TITLE");
        if (p.mTitle == null) {
            p.mTitle = this.getString(17040159);
        }
        this.setupAlert();
    }

    public void onPrepareListView(ListView listView) {
        if (this.mHasDefaultItem) {
            this.mDefaultRingtonePos = this.addDefaultRingtoneItem(listView);
            if (RingtoneManager.isDefault(this.mExistingUri)) {
                this.mClickedPos = this.mDefaultRingtonePos;
            }
        }
        if (this.mHasSilentItem) {
            this.mSilentPos = this.addSilentItem(listView);
            if (this.mExistingUri == null) {
                this.mClickedPos = this.mSilentPos;
            }
        }
        if (this.mClickedPos == -1) {
            this.mClickedPos = this.getListPosition(this.mRingtoneManager.getRingtonePosition(this.mExistingUri));
        }
        this.mAlertParams.mCheckedItem = this.mClickedPos;
    }

    private int addStaticItem(ListView listView, int textResId) {
        TextView textView = (TextView)this.getLayoutInflater().inflate(17367058, (ViewGroup)listView, false);
        textView.setText(textResId);
        listView.addHeaderView(textView);
        ++this.mStaticItemCount;
        return listView.getHeaderViewsCount() - 1;
    }

    private int addDefaultRingtoneItem(ListView listView) {
        return this.addStaticItem(listView, 17040156);
    }

    private int addSilentItem(ListView listView) {
        return this.addStaticItem(listView, 17040158);
    }

    public void onClick(DialogInterface dialog, int which) {
        boolean positiveResult = which == -1;
        this.mRingtoneManager.stopPreviousRingtone();
        if (positiveResult) {
            Intent resultIntent = new Intent();
            Object uri = null;
            uri = this.mClickedPos == this.mDefaultRingtonePos ? this.mUriForDefaultItem : (this.mClickedPos == this.mSilentPos ? null : this.mRingtoneManager.getRingtoneUri(this.getRingtoneManagerPosition(this.mClickedPos)));
            resultIntent.putExtra("android.intent.extra.ringtone.PICKED_URI", (Parcelable)uri);
            this.setResult(-1, resultIntent);
        } else {
            this.setResult(0);
        }
        this.getWindow().getDecorView().post(new Runnable(){

            public void run() {
                RingtonePickerActivity.this.mCursor.deactivate();
            }
        });
        this.finish();
    }

    public void onItemSelected(AdapterView parent, View view, int position, long id2) {
        this.playRingtone(position, 300);
    }

    public void onNothingSelected(AdapterView parent) {
    }

    private void playRingtone(int position, int delayMs) {
        this.mHandler.removeCallbacks(this);
        this.mSampleRingtonePos = position;
        this.mHandler.postDelayed(this, delayMs);
    }

    public void run() {
        Ringtone ringtone;
        if (this.mSampleRingtonePos == this.mSilentPos) {
            this.mRingtoneManager.stopPreviousRingtone();
            return;
        }
        if (this.mDefaultRingtone != null && this.mDefaultRingtone.isPlaying()) {
            this.mDefaultRingtone.stop();
            this.mDefaultRingtone = null;
        }
        if (this.mSampleRingtonePos == this.mDefaultRingtonePos) {
            if (this.mDefaultRingtone == null) {
                this.mDefaultRingtone = RingtoneManager.getRingtone(this, this.mUriForDefaultItem);
            }
            ringtone = this.mDefaultRingtone;
            this.mRingtoneManager.stopPreviousRingtone();
        } else {
            ringtone = this.mRingtoneManager.getRingtone(this.getRingtoneManagerPosition(this.mSampleRingtonePos));
        }
        if (ringtone != null) {
            ringtone.play();
        }
    }

    protected void onStop() {
        super.onStop();
        this.stopAnyPlayingRingtone();
    }

    protected void onPause() {
        super.onPause();
        this.stopAnyPlayingRingtone();
    }

    private void stopAnyPlayingRingtone() {
        if (this.mDefaultRingtone != null && this.mDefaultRingtone.isPlaying()) {
            this.mDefaultRingtone.stop();
        }
        if (this.mRingtoneManager != null) {
            this.mRingtoneManager.stopPreviousRingtone();
        }
    }

    private int getRingtoneManagerPosition(int listPos) {
        return listPos - this.mStaticItemCount;
    }

    private int getListPosition(int ringtoneManagerPos) {
        if (ringtoneManagerPos < 0) {
            return ringtoneManagerPos;
        }
        return ringtoneManagerPos + this.mStaticItemCount;
    }
}

