/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.webkit.CallbackProxy;
import android.webkit.WebHistoryItem;
import java.io.Serializable;
import java.util.ArrayList;

public class WebBackForwardList
implements Cloneable,
Serializable {
    private int mCurrentIndex = -1;
    private ArrayList<WebHistoryItem> mArray = new ArrayList();
    private boolean mClearPending;
    private final CallbackProxy mCallbackProxy;

    WebBackForwardList(CallbackProxy proxy) {
        this.mCallbackProxy = proxy;
    }

    public synchronized WebHistoryItem getCurrentItem() {
        return this.getItemAtIndex(this.mCurrentIndex);
    }

    public synchronized int getCurrentIndex() {
        return this.mCurrentIndex;
    }

    public synchronized WebHistoryItem getItemAtIndex(int index) {
        if (index < 0 || index >= this.getSize()) {
            return null;
        }
        return this.mArray.get(index);
    }

    public synchronized int getSize() {
        return this.mArray.size();
    }

    synchronized void setClearPending() {
        this.mClearPending = true;
    }

    synchronized boolean getClearPending() {
        return this.mClearPending;
    }

    synchronized void addHistoryItem(WebHistoryItem item) {
        ++this.mCurrentIndex;
        int newPos = this.mCurrentIndex;
        int size = this.mArray.size();
        if (newPos != size) {
            for (int i = size - 1; i >= newPos; --i) {
                WebHistoryItem h = this.mArray.remove(i);
            }
        }
        this.mArray.add(item);
        if (this.mCallbackProxy != null) {
            this.mCallbackProxy.onNewHistoryItem(item);
        }
    }

    synchronized void close(int nativeFrame) {
        this.mArray.clear();
        this.mCurrentIndex = -1;
        WebBackForwardList.nativeClose(nativeFrame);
        this.mClearPending = false;
    }

    private synchronized void removeHistoryItem(int index) {
        WebHistoryItem h = this.mArray.remove(index);
        --this.mCurrentIndex;
    }

    protected synchronized WebBackForwardList clone() {
        WebBackForwardList l = new WebBackForwardList(null);
        if (this.mClearPending) {
            l.addHistoryItem(this.getCurrentItem());
            return l;
        }
        l.mCurrentIndex = this.mCurrentIndex;
        int size = this.getSize();
        l.mArray = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            l.mArray.add(this.mArray.get(i).clone());
        }
        return l;
    }

    synchronized void setCurrentIndex(int newIndex) {
        this.mCurrentIndex = newIndex;
        if (this.mCallbackProxy != null) {
            this.mCallbackProxy.onIndexChanged(this.getItemAtIndex(newIndex), newIndex);
        }
    }

    static synchronized native void restoreIndex(int var0, int var1);

    private static native void nativeClose(int var0);
}

