/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.security.Credentials;
import android.util.Log;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.jce.netscape.NetscapeCertRequest;
import org.bouncycastle.util.encoders.Base64;

class CertTool {
    private static final String LOGTAG = "CertTool";
    private static final AlgorithmIdentifier MD5_WITH_RSA = new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption);
    static final String CERT = "CERT";
    static final String PKCS12 = "PKCS12";

    static String[] getKeyStrengthList() {
        return new String[]{"High Grade", "Medium Grade"};
    }

    static String getSignedPublicKey(Context context, int index, String challenge) {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(index == 0 ? 2048 : 1024);
            KeyPair pair = generator.genKeyPair();
            NetscapeCertRequest request = new NetscapeCertRequest(challenge, MD5_WITH_RSA, pair.getPublic());
            request.sign(pair.getPrivate());
            byte[] signed = request.toASN1Object().getDEREncoded();
            Credentials.getInstance().install(context, pair);
            return new String(Base64.encode((byte[])signed));
        }
        catch (Exception e) {
            Log.w(LOGTAG, e);
            return null;
        }
    }

    static void addCertificate(Context context, String type, byte[] value) {
        Credentials.getInstance().install(context, type, value);
    }

    private CertTool() {
    }
}

