/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.content.Context;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.IAccessibilityManager;
import android.view.accessibility.IAccessibilityManagerClient;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AccessibilityManager {
    private static final String LOG_TAG = "AccessibilityManager";
    static final Object sInstanceSync = new Object();
    private static AccessibilityManager sInstance;
    private static final int DO_SET_ENABLED = 10;
    final IAccessibilityManager mService;
    final Handler mHandler;
    boolean mIsEnabled;
    final IAccessibilityManagerClient.Stub mClient = new IAccessibilityManagerClient.Stub(){

        public void setEnabled(boolean enabled) {
            AccessibilityManager.this.mHandler.obtainMessage(10, enabled ? 1 : 0, 0).sendToTarget();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessibilityManager getInstance(Context context) {
        Object object = sInstanceSync;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new AccessibilityManager(context);
            }
        }
        return sInstance;
    }

    private AccessibilityManager(Context context) {
        this.mHandler = new MyHandler(context.getMainLooper());
        IBinder iBinder = ServiceManager.getService("accessibility");
        this.mService = IAccessibilityManager.Stub.asInterface(iBinder);
        try {
            this.mService.addClient(this.mClient);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "AccessibilityManagerService is dead", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        Handler handler = this.mHandler;
        synchronized (handler) {
            return this.mIsEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAccessibilityEvent(AccessibilityEvent event) {
        if (!this.mIsEnabled) {
            throw new IllegalStateException("Accessibility off. Did you forget to check that?");
        }
        boolean doRecycle = false;
        try {
            try {
                event.setEventTime(SystemClock.uptimeMillis());
                long identityToken = Binder.clearCallingIdentity();
                doRecycle = this.mService.sendAccessibilityEvent(event);
                Binder.restoreCallingIdentity(identityToken);
            }
            catch (RemoteException re) {
                Log.e(LOG_TAG, "Error during sending " + event + " ", re);
                Object var6_6 = null;
                if (doRecycle) {
                    event.recycle();
                }
            }
            Object var6_5 = null;
            if (doRecycle) {
                event.recycle();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (doRecycle) {
                event.recycle();
            }
            throw throwable;
        }
    }

    public void interrupt() {
        if (!this.mIsEnabled) {
            throw new IllegalStateException("Accessibility off. Did you forget to check that?");
        }
        try {
            this.mService.interrupt();
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while requesting interrupt from all services. ", re);
        }
    }

    public List<ServiceInfo> getAccessibilityServiceList() {
        List<ServiceInfo> services = null;
        try {
            services = this.mService.getAccessibilityServiceList();
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while obtaining the installed AccessibilityServices. ", re);
        }
        return Collections.unmodifiableList(services);
    }

    class MyHandler
    extends Handler {
        MyHandler(Looper mainLooper) {
            super(mainLooper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) {
            switch (message.what) {
                case 10: {
                    Handler handler = AccessibilityManager.this.mHandler;
                    synchronized (handler) {
                        AccessibilityManager.this.mIsEnabled = message.arg1 == 1;
                    }
                    return;
                }
            }
            Log.w(AccessibilityManager.LOG_TAG, "Unknown message type: " + message.what);
        }
    }
}

