/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.IBinder;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewRoot;
import android.view.WindowLeaked;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;

public class WindowManagerImpl
implements WindowManager {
    public static final int RELAYOUT_IN_TOUCH_MODE = 1;
    public static final int RELAYOUT_FIRST_TIME = 2;
    public static final int ADD_FLAG_APP_VISIBLE = 2;
    public static final int ADD_FLAG_IN_TOUCH_MODE = 1;
    public static final int ADD_OKAY = 0;
    public static final int ADD_BAD_APP_TOKEN = -1;
    public static final int ADD_BAD_SUBWINDOW_TOKEN = -2;
    public static final int ADD_NOT_APP_TOKEN = -3;
    public static final int ADD_APP_EXITING = -4;
    public static final int ADD_DUPLICATE_ADD = -5;
    public static final int ADD_STARTING_NOT_NEEDED = -6;
    public static final int ADD_MULTIPLE_SINGLETON = -7;
    public static final int ADD_PERMISSION_DENIED = -8;
    private View[] mViews;
    private ViewRoot[] mRoots;
    private WindowManager.LayoutParams[] mParams;
    private static WindowManagerImpl mWindowManager = new WindowManagerImpl();

    public static WindowManagerImpl getDefault() {
        return mWindowManager;
    }

    public void addView(View view) {
        this.addView(view, new WindowManager.LayoutParams(2, 0, -1));
    }

    public void addView(View view, ViewGroup.LayoutParams params) {
        this.addView(view, params, false);
    }

    public void addViewNesting(View view, ViewGroup.LayoutParams params) {
        this.addView(view, params, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addView(View view, ViewGroup.LayoutParams params, boolean nest) {
        ViewRoot root;
        if (!(params instanceof WindowManager.LayoutParams)) {
            throw new IllegalArgumentException("Params must be WindowManager.LayoutParams");
        }
        WindowManager.LayoutParams wparams = (WindowManager.LayoutParams)params;
        View panelParentView = null;
        WindowManagerImpl windowManagerImpl = this;
        synchronized (windowManagerImpl) {
            int index = this.findViewLocked(view, false);
            if (index >= 0) {
                if (!nest) {
                    throw new IllegalStateException("View " + view + " has already been added to the window manager.");
                }
                ViewRoot root2 = this.mRoots[index];
                ++root2.mAddNesting;
                view.setLayoutParams(wparams);
                root2.setLayoutParams(wparams, true);
                return;
            }
            if (wparams.type >= 1000 && wparams.type <= 1999) {
                int count = this.mViews != null ? this.mViews.length : 0;
                for (int i = 0; i < count; ++i) {
                    if (this.mRoots[i].mWindow.asBinder() != wparams.token) continue;
                    panelParentView = this.mViews[i];
                }
            }
            root = new ViewRoot(view.getContext());
            root.mAddNesting = 1;
            view.setLayoutParams(wparams);
            if (this.mViews == null) {
                index = 1;
                this.mViews = new View[1];
                this.mRoots = new ViewRoot[1];
                this.mParams = new WindowManager.LayoutParams[1];
            } else {
                index = this.mViews.length + 1;
                Object[] old = this.mViews;
                this.mViews = new View[index];
                System.arraycopy(old, 0, this.mViews, 0, index - 1);
                old = this.mRoots;
                this.mRoots = new ViewRoot[index];
                System.arraycopy(old, 0, this.mRoots, 0, index - 1);
                old = this.mParams;
                this.mParams = new WindowManager.LayoutParams[index];
                System.arraycopy(old, 0, this.mParams, 0, index - 1);
            }
            this.mViews[--index] = view;
            this.mRoots[index] = root;
            this.mParams[index] = wparams;
        }
        root.setView(view, wparams, panelParentView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateViewLayout(View view, ViewGroup.LayoutParams params) {
        if (!(params instanceof WindowManager.LayoutParams)) {
            throw new IllegalArgumentException("Params must be WindowManager.LayoutParams");
        }
        WindowManager.LayoutParams wparams = (WindowManager.LayoutParams)params;
        view.setLayoutParams(wparams);
        WindowManagerImpl windowManagerImpl = this;
        synchronized (windowManagerImpl) {
            int index = this.findViewLocked(view, true);
            ViewRoot root = this.mRoots[index];
            this.mParams[index] = wparams;
            root.setLayoutParams(wparams, false);
        }
    }

    public void removeView(View view) {
        WindowManagerImpl windowManagerImpl = this;
        synchronized (windowManagerImpl) {
            int index = this.findViewLocked(view, true);
            View curView = this.removeViewLocked(index);
            if (curView == view) {
                return;
            }
            throw new IllegalStateException("Calling with view " + view + " but the ViewRoot is attached to " + curView);
        }
    }

    public void removeViewImmediate(View view) {
        WindowManagerImpl windowManagerImpl = this;
        synchronized (windowManagerImpl) {
            int index = this.findViewLocked(view, true);
            ViewRoot root = this.mRoots[index];
            View curView = root.getView();
            root.mAddNesting = 0;
            root.die(true);
            this.finishRemoveViewLocked(curView, index);
            if (curView == view) {
                return;
            }
            throw new IllegalStateException("Calling with view " + view + " but the ViewRoot is attached to " + curView);
        }
    }

    View removeViewLocked(int index) {
        ViewRoot root = this.mRoots[index];
        View view = root.getView();
        --root.mAddNesting;
        if (root.mAddNesting > 0) {
            return view;
        }
        InputMethodManager imm = InputMethodManager.getInstance(view.getContext());
        if (imm != null) {
            imm.windowDismissed(this.mViews[index].getWindowToken());
        }
        root.die(false);
        this.finishRemoveViewLocked(view, index);
        return view;
    }

    void finishRemoveViewLocked(View view, int index) {
        int count = this.mViews.length;
        Object[] tmpViews = new View[count - 1];
        WindowManagerImpl.removeItem(tmpViews, this.mViews, index);
        this.mViews = tmpViews;
        Object[] tmpRoots = new ViewRoot[count - 1];
        WindowManagerImpl.removeItem(tmpRoots, this.mRoots, index);
        this.mRoots = tmpRoots;
        Object[] tmpParams = new WindowManager.LayoutParams[count - 1];
        WindowManagerImpl.removeItem(tmpParams, this.mParams, index);
        this.mParams = tmpParams;
        view.assignParent(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll(IBinder token, String who, String what) {
        WindowManagerImpl windowManagerImpl = this;
        synchronized (windowManagerImpl) {
            if (this.mViews == null) {
                return;
            }
            int count = this.mViews.length;
            for (int i = 0; i < count; ++i) {
                if (token != null && this.mParams[i].token != token) continue;
                ViewRoot root = this.mRoots[i];
                root.mAddNesting = 1;
                if (who != null) {
                    WindowLeaked leak = new WindowLeaked(what + " " + who + " has leaked window " + root.getView() + " that was originally added here");
                    leak.setStackTrace(root.getLocation().getStackTrace());
                    Log.e("WindowManager", leak.getMessage(), leak);
                }
                this.removeViewLocked(i);
                --i;
                --count;
            }
        }
    }

    public WindowManager.LayoutParams getRootViewLayoutParameter(View view) {
        ViewParent vp;
        for (vp = view.getParent(); vp != null && !(vp instanceof ViewRoot); vp = vp.getParent()) {
        }
        if (vp == null) {
            return null;
        }
        ViewRoot vr = (ViewRoot)vp;
        int N = this.mRoots.length;
        for (int i = 0; i < N; ++i) {
            if (this.mRoots[i] != vr) continue;
            return this.mParams[i];
        }
        return null;
    }

    public void closeAll() {
        this.closeAll(null, null, null);
    }

    public Display getDefaultDisplay() {
        return new Display(0);
    }

    private static void removeItem(Object[] dst, Object[] src, int index) {
        if (dst.length > 0) {
            if (index > 0) {
                System.arraycopy(src, 0, dst, 0, index);
            }
            if (index < dst.length) {
                System.arraycopy(src, index + 1, dst, index, src.length - index - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findViewLocked(View view, boolean required) {
        WindowManagerImpl windowManagerImpl = this;
        synchronized (windowManagerImpl) {
            int count = this.mViews != null ? this.mViews.length : 0;
            for (int i = 0; i < count; ++i) {
                if (this.mViews[i] != view) continue;
                return i;
            }
            if (required) {
                throw new IllegalArgumentException("View not attached to window manager");
            }
            return -1;
        }
    }
}

