/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Editable;
import android.text.NoCopySpan;
import android.text.Spannable;
import android.text.Spanned;
import android.view.KeyEvent;
import android.view.View;

public abstract class MetaKeyKeyListener {
    public static final int META_SHIFT_ON = 1;
    public static final int META_ALT_ON = 2;
    public static final int META_SYM_ON = 4;
    private static final int LOCKED_SHIFT = 8;
    public static final int META_CAP_LOCKED = 256;
    public static final int META_ALT_LOCKED = 512;
    public static final int META_SYM_LOCKED = 1024;
    public static final int META_SELECTING = 65536;
    private static final int USED_SHIFT = 24;
    private static final long META_CAP_USED = 0x1000000L;
    private static final long META_ALT_USED = 0x2000000L;
    private static final long META_SYM_USED = 0x4000000L;
    private static final int PRESSED_SHIFT = 32;
    private static final long META_CAP_PRESSED = 0x100000000L;
    private static final long META_ALT_PRESSED = 0x200000000L;
    private static final long META_SYM_PRESSED = 0x400000000L;
    private static final int RELEASED_SHIFT = 40;
    private static final long META_CAP_RELEASED = 0x10000000000L;
    private static final long META_ALT_RELEASED = 0x20000000000L;
    private static final long META_SYM_RELEASED = 0x40000000000L;
    private static final long META_SHIFT_MASK = 0x10101000101L;
    private static final long META_ALT_MASK = 0x20202000202L;
    private static final long META_SYM_MASK = 0x40404000404L;
    private static final Object CAP = new NoCopySpan.Concrete();
    private static final Object ALT = new NoCopySpan.Concrete();
    private static final Object SYM = new NoCopySpan.Concrete();
    private static final Object SELECTING = new NoCopySpan.Concrete();
    private static final int PRESSED = 0x1000011;
    private static final int RELEASED = 0x2000011;
    private static final int USED = 0x3000011;
    private static final int LOCKED = 0x4000011;

    public static void resetMetaState(Spannable text) {
        text.removeSpan(CAP);
        text.removeSpan(ALT);
        text.removeSpan(SYM);
        text.removeSpan(SELECTING);
    }

    public static final int getMetaState(CharSequence text) {
        return MetaKeyKeyListener.getActive(text, CAP, 1, 256) | MetaKeyKeyListener.getActive(text, ALT, 2, 512) | MetaKeyKeyListener.getActive(text, SYM, 4, 1024) | MetaKeyKeyListener.getActive(text, SELECTING, 65536, 65536);
    }

    public static final int getMetaState(CharSequence text, int meta) {
        switch (meta) {
            case 1: {
                return MetaKeyKeyListener.getActive(text, CAP, 1, 2);
            }
            case 2: {
                return MetaKeyKeyListener.getActive(text, ALT, 1, 2);
            }
            case 4: {
                return MetaKeyKeyListener.getActive(text, SYM, 1, 2);
            }
            case 65536: {
                return MetaKeyKeyListener.getActive(text, SELECTING, 1, 2);
            }
        }
        return 0;
    }

    private static int getActive(CharSequence text, Object meta, int on, int lock) {
        if (!(text instanceof Spanned)) {
            return 0;
        }
        Spanned sp = (Spanned)text;
        int flag = sp.getSpanFlags(meta);
        if (flag == 0x4000011) {
            return lock;
        }
        if (flag != 0) {
            return on;
        }
        return 0;
    }

    public static void adjustMetaAfterKeypress(Spannable content) {
        MetaKeyKeyListener.adjust(content, CAP);
        MetaKeyKeyListener.adjust(content, ALT);
        MetaKeyKeyListener.adjust(content, SYM);
    }

    public static boolean isMetaTracker(CharSequence text, Object what) {
        return what == CAP || what == ALT || what == SYM || what == SELECTING;
    }

    public static boolean isSelectingMetaTracker(CharSequence text, Object what) {
        return what == SELECTING;
    }

    private static void adjust(Spannable content, Object what) {
        int current = content.getSpanFlags(what);
        if (current == 0x1000011) {
            content.setSpan(what, 0, 0, 0x3000011);
        } else if (current == 0x2000011) {
            content.removeSpan(what);
        }
    }

    protected static void resetLockedMeta(Spannable content) {
        MetaKeyKeyListener.resetLock(content, CAP);
        MetaKeyKeyListener.resetLock(content, ALT);
        MetaKeyKeyListener.resetLock(content, SYM);
        MetaKeyKeyListener.resetLock(content, SELECTING);
    }

    private static void resetLock(Spannable content, Object what) {
        int current = content.getSpanFlags(what);
        if (current == 0x4000011) {
            content.removeSpan(what);
        }
    }

    public boolean onKeyDown(View view, Editable content, int keyCode, KeyEvent event) {
        if (keyCode == 59 || keyCode == 60) {
            this.press(content, CAP);
            return true;
        }
        if (keyCode == 57 || keyCode == 58 || keyCode == 78) {
            this.press(content, ALT);
            return true;
        }
        if (keyCode == 63) {
            this.press(content, SYM);
            return true;
        }
        return false;
    }

    private void press(Editable content, Object what) {
        int state = content.getSpanFlags(what);
        if (state != 0x1000011) {
            if (state == 0x2000011) {
                content.setSpan(what, 0, 0, 0x4000011);
            } else if (state != 0x3000011) {
                if (state == 0x4000011) {
                    content.removeSpan(what);
                } else {
                    content.setSpan(what, 0, 0, 0x1000011);
                }
            }
        }
    }

    public static void startSelecting(View view, Spannable content) {
        content.setSpan(SELECTING, 0, 0, 0x1000011);
    }

    public static void stopSelecting(View view, Spannable content) {
        content.removeSpan(SELECTING);
    }

    public boolean onKeyUp(View view, Editable content, int keyCode, KeyEvent event) {
        if (keyCode == 59 || keyCode == 60) {
            this.release(content, CAP);
            return true;
        }
        if (keyCode == 57 || keyCode == 58 || keyCode == 78) {
            this.release(content, ALT);
            return true;
        }
        if (keyCode == 63) {
            this.release(content, SYM);
            return true;
        }
        return false;
    }

    private void release(Editable content, Object what) {
        int current = content.getSpanFlags(what);
        if (current == 0x3000011) {
            content.removeSpan(what);
        } else if (current == 0x1000011) {
            content.setSpan(what, 0, 0, 0x2000011);
        }
    }

    public void clearMetaKeyState(View view, Editable content, int states) {
        MetaKeyKeyListener.clearMetaKeyState(content, states);
    }

    public static void clearMetaKeyState(Editable content, int states) {
        if ((states & 1) != 0) {
            content.removeSpan(CAP);
        }
        if ((states & 2) != 0) {
            content.removeSpan(ALT);
        }
        if ((states & 4) != 0) {
            content.removeSpan(SYM);
        }
        if ((states & 0x10000) != 0) {
            content.removeSpan(SELECTING);
        }
    }

    public static long resetLockedMeta(long state) {
        state = MetaKeyKeyListener.resetLock(state, 1, 0x10101000101L);
        state = MetaKeyKeyListener.resetLock(state, 2, 0x20202000202L);
        state = MetaKeyKeyListener.resetLock(state, 4, 0x40404000404L);
        return state;
    }

    private static long resetLock(long state, int what, long mask) {
        if ((state & (long)what << 8) != 0L) {
            state &= mask ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return state;
    }

    public static final int getMetaState(long state) {
        return MetaKeyKeyListener.getActive(state, 1, 1, 256) | MetaKeyKeyListener.getActive(state, 2, 2, 512) | MetaKeyKeyListener.getActive(state, 4, 4, 1024);
    }

    public static final int getMetaState(long state, int meta) {
        switch (meta) {
            case 1: {
                return MetaKeyKeyListener.getActive(state, meta, 1, 2);
            }
            case 2: {
                return MetaKeyKeyListener.getActive(state, meta, 1, 2);
            }
            case 4: {
                return MetaKeyKeyListener.getActive(state, meta, 1, 2);
            }
        }
        return 0;
    }

    private static int getActive(long state, int meta, int on, int lock) {
        if ((state & (long)(meta << 8)) != 0L) {
            return lock;
        }
        if ((state & (long)meta) != 0L) {
            return on;
        }
        return 0;
    }

    public static long adjustMetaAfterKeypress(long state) {
        state = MetaKeyKeyListener.adjust(state, 1, 0x10101000101L);
        state = MetaKeyKeyListener.adjust(state, 2, 0x20202000202L);
        state = MetaKeyKeyListener.adjust(state, 4, 0x40404000404L);
        return state;
    }

    private static long adjust(long state, int what, long mask) {
        if ((state & (long)what << 32) != 0L) {
            return state & (mask ^ 0xFFFFFFFFFFFFFFFFL) | (long)what | (long)what << 24;
        }
        if ((state & (long)what << 40) != 0L) {
            return state & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return state;
    }

    public static long handleKeyDown(long state, int keyCode, KeyEvent event) {
        if (keyCode == 59 || keyCode == 60) {
            return MetaKeyKeyListener.press(state, 1, 0x10101000101L);
        }
        if (keyCode == 57 || keyCode == 58 || keyCode == 78) {
            return MetaKeyKeyListener.press(state, 2, 0x20202000202L);
        }
        if (keyCode == 63) {
            return MetaKeyKeyListener.press(state, 4, 0x40404000404L);
        }
        return state;
    }

    private static long press(long state, int what, long mask) {
        if ((state & (long)what << 32) == 0L) {
            if ((state & (long)what << 40) != 0L) {
                state = state & (mask ^ 0xFFFFFFFFFFFFFFFFL) | (long)what | (long)what << 8;
            } else if ((state & (long)what << 24) == 0L) {
                state = (state & (long)what << 8) != 0L ? (state &= mask ^ 0xFFFFFFFFFFFFFFFFL) : state | (long)what | (long)what << 32;
            }
        }
        return state;
    }

    public static long handleKeyUp(long state, int keyCode, KeyEvent event) {
        if (keyCode == 59 || keyCode == 60) {
            return MetaKeyKeyListener.release(state, 1, 0x10101000101L);
        }
        if (keyCode == 57 || keyCode == 58 || keyCode == 78) {
            return MetaKeyKeyListener.release(state, 2, 0x20202000202L);
        }
        if (keyCode == 63) {
            return MetaKeyKeyListener.release(state, 4, 0x40404000404L);
        }
        return state;
    }

    private static long release(long state, int what, long mask) {
        if ((state & (long)what << 24) != 0L) {
            state &= mask ^ 0xFFFFFFFFFFFFFFFFL;
        } else if ((state & (long)what << 32) != 0L) {
            state = state | (long)what | (long)what << 40;
        }
        return state;
    }

    public long clearMetaKeyState(long state, int which) {
        if ((which & 1) != 0) {
            state = MetaKeyKeyListener.resetLock(state, 1, 0x10101000101L);
        }
        if ((which & 2) != 0) {
            state = MetaKeyKeyListener.resetLock(state, 2, 0x20202000202L);
        }
        if ((which & 4) != 0) {
            state = MetaKeyKeyListener.resetLock(state, 4, 0x40404000404L);
        }
        return state;
    }
}

