/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;

public class ServiceState
implements Parcelable {
    static final String LOG_TAG = "PHONE";
    public static final int STATE_IN_SERVICE = 0;
    public static final int STATE_OUT_OF_SERVICE = 1;
    public static final int STATE_EMERGENCY_ONLY = 2;
    public static final int STATE_POWER_OFF = 3;
    public static final int RADIO_TECHNOLOGY_UNKNOWN = 0;
    public static final int RADIO_TECHNOLOGY_GPRS = 1;
    public static final int RADIO_TECHNOLOGY_EDGE = 2;
    public static final int RADIO_TECHNOLOGY_UMTS = 3;
    public static final int RADIO_TECHNOLOGY_IS95A = 4;
    public static final int RADIO_TECHNOLOGY_IS95B = 5;
    public static final int RADIO_TECHNOLOGY_1xRTT = 6;
    public static final int RADIO_TECHNOLOGY_EVDO_0 = 7;
    public static final int RADIO_TECHNOLOGY_EVDO_A = 8;
    public static final int RADIO_TECHNOLOGY_HSDPA = 9;
    public static final int RADIO_TECHNOLOGY_HSUPA = 10;
    public static final int RADIO_TECHNOLOGY_HSPA = 11;
    public static final int RADIO_TECHNOLOGY_EVDO_B = 12;
    public static final int REGISTRATION_STATE_NOT_REGISTERED_AND_NOT_SEARCHING = 0;
    public static final int REGISTRATION_STATE_HOME_NETWORK = 1;
    public static final int REGISTRATION_STATE_NOT_REGISTERED_AND_SEARCHING = 2;
    public static final int REGISTRATION_STATE_REGISTRATION_DENIED = 3;
    public static final int REGISTRATION_STATE_UNKNOWN = 4;
    public static final int REGISTRATION_STATE_ROAMING = 5;
    private int mState = 1;
    private boolean mRoaming;
    private String mOperatorAlphaLong;
    private String mOperatorAlphaShort;
    private String mOperatorNumeric;
    private boolean mIsManualNetworkSelection;
    private boolean mIsEmergencyOnly;
    private int mRadioTechnology;
    private boolean mCssIndicator;
    private int mNetworkId;
    private int mSystemId;
    private int mCdmaRoamingIndicator;
    private int mCdmaDefaultRoamingIndicator;
    private int mCdmaEriIconIndex;
    private int mCdmaEriIconMode;
    public static final Parcelable.Creator<ServiceState> CREATOR = new Parcelable.Creator<ServiceState>(){

        @Override
        public ServiceState createFromParcel(Parcel in) {
            return new ServiceState(in);
        }

        public ServiceState[] newArray(int size) {
            return new ServiceState[size];
        }
    };

    public static ServiceState newFromBundle(Bundle m) {
        ServiceState ret = new ServiceState();
        ret.setFromNotifierBundle(m);
        return ret;
    }

    public ServiceState() {
    }

    public ServiceState(ServiceState s) {
        this.copyFrom(s);
    }

    protected void copyFrom(ServiceState s) {
        this.mState = s.mState;
        this.mRoaming = s.mRoaming;
        this.mOperatorAlphaLong = s.mOperatorAlphaLong;
        this.mOperatorAlphaShort = s.mOperatorAlphaShort;
        this.mOperatorNumeric = s.mOperatorNumeric;
        this.mIsManualNetworkSelection = s.mIsManualNetworkSelection;
        this.mRadioTechnology = s.mRadioTechnology;
        this.mCssIndicator = s.mCssIndicator;
        this.mNetworkId = s.mNetworkId;
        this.mSystemId = s.mSystemId;
        this.mCdmaRoamingIndicator = s.mCdmaRoamingIndicator;
        this.mCdmaDefaultRoamingIndicator = s.mCdmaDefaultRoamingIndicator;
        this.mCdmaEriIconIndex = s.mCdmaEriIconIndex;
        this.mCdmaEriIconMode = s.mCdmaEriIconMode;
        this.mIsEmergencyOnly = s.mIsEmergencyOnly;
    }

    public ServiceState(Parcel in) {
        this.mState = in.readInt();
        this.mRoaming = in.readInt() != 0;
        this.mOperatorAlphaLong = in.readString();
        this.mOperatorAlphaShort = in.readString();
        this.mOperatorNumeric = in.readString();
        this.mIsManualNetworkSelection = in.readInt() != 0;
        this.mRadioTechnology = in.readInt();
        this.mCssIndicator = in.readInt() != 0;
        this.mNetworkId = in.readInt();
        this.mSystemId = in.readInt();
        this.mCdmaRoamingIndicator = in.readInt();
        this.mCdmaDefaultRoamingIndicator = in.readInt();
        this.mCdmaEriIconIndex = in.readInt();
        this.mCdmaEriIconMode = in.readInt();
        this.mIsEmergencyOnly = in.readInt() != 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mState);
        out.writeInt(this.mRoaming ? 1 : 0);
        out.writeString(this.mOperatorAlphaLong);
        out.writeString(this.mOperatorAlphaShort);
        out.writeString(this.mOperatorNumeric);
        out.writeInt(this.mIsManualNetworkSelection ? 1 : 0);
        out.writeInt(this.mRadioTechnology);
        out.writeInt(this.mCssIndicator ? 1 : 0);
        out.writeInt(this.mNetworkId);
        out.writeInt(this.mSystemId);
        out.writeInt(this.mCdmaRoamingIndicator);
        out.writeInt(this.mCdmaDefaultRoamingIndicator);
        out.writeInt(this.mCdmaEriIconIndex);
        out.writeInt(this.mCdmaEriIconMode);
        out.writeInt(this.mIsEmergencyOnly ? 1 : 0);
    }

    public int describeContents() {
        return 0;
    }

    public int getState() {
        return this.mState;
    }

    public boolean getRoaming() {
        return this.mRoaming;
    }

    public boolean isEmergencyOnly() {
        return this.mIsEmergencyOnly;
    }

    public int getCdmaRoamingIndicator() {
        return this.mCdmaRoamingIndicator;
    }

    public int getCdmaDefaultRoamingIndicator() {
        return this.mCdmaDefaultRoamingIndicator;
    }

    public int getCdmaEriIconIndex() {
        return this.mCdmaEriIconIndex;
    }

    public int getCdmaEriIconMode() {
        return this.mCdmaEriIconMode;
    }

    public String getOperatorAlphaLong() {
        return this.mOperatorAlphaLong;
    }

    public String getOperatorAlphaShort() {
        return this.mOperatorAlphaShort;
    }

    public String getOperatorNumeric() {
        return this.mOperatorNumeric;
    }

    public boolean getIsManualSelection() {
        return this.mIsManualNetworkSelection;
    }

    public int hashCode() {
        return this.mState * 4660 + (this.mRoaming ? 1 : 0) + (this.mIsManualNetworkSelection ? 1 : 0) + (null == this.mOperatorAlphaLong ? 0 : this.mOperatorAlphaLong.hashCode()) + (null == this.mOperatorAlphaShort ? 0 : this.mOperatorAlphaShort.hashCode()) + (null == this.mOperatorNumeric ? 0 : this.mOperatorNumeric.hashCode()) + this.mCdmaRoamingIndicator + this.mCdmaDefaultRoamingIndicator + (this.mIsEmergencyOnly ? 1 : 0);
    }

    public boolean equals(Object o) {
        ServiceState s;
        try {
            s = (ServiceState)o;
        }
        catch (ClassCastException ex) {
            return false;
        }
        if (o == null) {
            return false;
        }
        return this.mState == s.mState && this.mRoaming == s.mRoaming && this.mIsManualNetworkSelection == s.mIsManualNetworkSelection && ServiceState.equalsHandlesNulls(this.mOperatorAlphaLong, s.mOperatorAlphaLong) && ServiceState.equalsHandlesNulls(this.mOperatorAlphaShort, s.mOperatorAlphaShort) && ServiceState.equalsHandlesNulls(this.mOperatorNumeric, s.mOperatorNumeric) && ServiceState.equalsHandlesNulls(this.mRadioTechnology, s.mRadioTechnology) && ServiceState.equalsHandlesNulls(this.mCssIndicator, s.mCssIndicator) && ServiceState.equalsHandlesNulls(this.mNetworkId, s.mNetworkId) && ServiceState.equalsHandlesNulls(this.mSystemId, s.mSystemId) && ServiceState.equalsHandlesNulls(this.mCdmaRoamingIndicator, s.mCdmaRoamingIndicator) && ServiceState.equalsHandlesNulls(this.mCdmaDefaultRoamingIndicator, s.mCdmaDefaultRoamingIndicator) && this.mIsEmergencyOnly == s.mIsEmergencyOnly;
    }

    public String toString() {
        String radioTechnology = new String("Error in radioTechnology");
        switch (this.mRadioTechnology) {
            case 0: {
                radioTechnology = "Unknown";
                break;
            }
            case 1: {
                radioTechnology = "GPRS";
                break;
            }
            case 2: {
                radioTechnology = "EDGE";
                break;
            }
            case 3: {
                radioTechnology = "UMTS";
                break;
            }
            case 4: {
                radioTechnology = "IS95A";
                break;
            }
            case 5: {
                radioTechnology = "IS95B";
                break;
            }
            case 6: {
                radioTechnology = "1xRTT";
                break;
            }
            case 7: {
                radioTechnology = "EvDo rev. 0";
                break;
            }
            case 8: {
                radioTechnology = "EvDo rev. A";
                break;
            }
            case 9: {
                radioTechnology = "HSDPA";
                break;
            }
            case 10: {
                radioTechnology = "HSUPA";
                break;
            }
            case 11: {
                radioTechnology = "HSPA";
                break;
            }
            case 12: {
                radioTechnology = "EvDo rev. B";
                break;
            }
            default: {
                Log.w(LOG_TAG, "mRadioTechnology variable out of range.");
            }
        }
        return this.mState + " " + (this.mRoaming ? "roaming" : "home") + " " + this.mOperatorAlphaLong + " " + this.mOperatorAlphaShort + " " + this.mOperatorNumeric + " " + (this.mIsManualNetworkSelection ? "(manual)" : "") + " " + radioTechnology + " " + (this.mCssIndicator ? "CSS supported" : "CSS not supported") + " " + this.mNetworkId + " " + this.mSystemId + "RoamInd: " + this.mCdmaRoamingIndicator + "DefRoamInd: " + this.mCdmaDefaultRoamingIndicator + "EmergOnly: " + this.mIsEmergencyOnly;
    }

    public void setStateOutOfService() {
        this.mState = 1;
        this.mRoaming = false;
        this.mOperatorAlphaLong = null;
        this.mOperatorAlphaShort = null;
        this.mOperatorNumeric = null;
        this.mIsManualNetworkSelection = false;
        this.mRadioTechnology = 0;
        this.mCssIndicator = false;
        this.mNetworkId = -1;
        this.mSystemId = -1;
        this.mCdmaRoamingIndicator = -1;
        this.mCdmaDefaultRoamingIndicator = -1;
        this.mCdmaEriIconIndex = -1;
        this.mCdmaEriIconMode = -1;
        this.mIsEmergencyOnly = false;
    }

    public void setStateOff() {
        this.mState = 3;
        this.mRoaming = false;
        this.mOperatorAlphaLong = null;
        this.mOperatorAlphaShort = null;
        this.mOperatorNumeric = null;
        this.mIsManualNetworkSelection = false;
        this.mRadioTechnology = 0;
        this.mCssIndicator = false;
        this.mNetworkId = -1;
        this.mSystemId = -1;
        this.mCdmaRoamingIndicator = -1;
        this.mCdmaDefaultRoamingIndicator = -1;
        this.mCdmaEriIconIndex = -1;
        this.mCdmaEriIconMode = -1;
        this.mIsEmergencyOnly = false;
    }

    public void setState(int state) {
        this.mState = state;
    }

    public void setRoaming(boolean roaming) {
        this.mRoaming = roaming;
    }

    public void setEmergencyOnly(boolean emergencyOnly) {
        this.mIsEmergencyOnly = emergencyOnly;
    }

    public void setCdmaRoamingIndicator(int roaming) {
        this.mCdmaRoamingIndicator = roaming;
    }

    public void setCdmaDefaultRoamingIndicator(int roaming) {
        this.mCdmaDefaultRoamingIndicator = roaming;
    }

    public void setCdmaEriIconIndex(int index) {
        this.mCdmaEriIconIndex = index;
    }

    public void setCdmaEriIconMode(int mode) {
        this.mCdmaEriIconMode = mode;
    }

    public void setOperatorName(String longName, String shortName, String numeric) {
        this.mOperatorAlphaLong = longName;
        this.mOperatorAlphaShort = shortName;
        this.mOperatorNumeric = numeric;
    }

    public void setCdmaEriText(String longName) {
        this.mOperatorAlphaLong = longName;
    }

    public void setIsManualSelection(boolean isManual) {
        this.mIsManualNetworkSelection = isManual;
    }

    private static boolean equalsHandlesNulls(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    private void setFromNotifierBundle(Bundle m) {
        this.mState = m.getInt("state");
        this.mRoaming = m.getBoolean("roaming");
        this.mOperatorAlphaLong = m.getString("operator-alpha-long");
        this.mOperatorAlphaShort = m.getString("operator-alpha-short");
        this.mOperatorNumeric = m.getString("operator-numeric");
        this.mIsManualNetworkSelection = m.getBoolean("manual");
        this.mRadioTechnology = m.getInt("radioTechnology");
        this.mCssIndicator = m.getBoolean("cssIndicator");
        this.mNetworkId = m.getInt("networkId");
        this.mSystemId = m.getInt("systemId");
        this.mCdmaRoamingIndicator = m.getInt("cdmaRoamingIndicator");
        this.mCdmaDefaultRoamingIndicator = m.getInt("cdmaDefaultRoamingIndicator");
        this.mIsEmergencyOnly = m.getBoolean("emergencyOnly");
    }

    public void fillInNotifierBundle(Bundle m) {
        m.putInt("state", this.mState);
        m.putBoolean("roaming", this.mRoaming);
        m.putString("operator-alpha-long", this.mOperatorAlphaLong);
        m.putString("operator-alpha-short", this.mOperatorAlphaShort);
        m.putString("operator-numeric", this.mOperatorNumeric);
        m.putBoolean("manual", this.mIsManualNetworkSelection);
        m.putInt("radioTechnology", this.mRadioTechnology);
        m.putBoolean("cssIndicator", this.mCssIndicator);
        m.putInt("networkId", this.mNetworkId);
        m.putInt("systemId", this.mSystemId);
        m.putInt("cdmaRoamingIndicator", this.mCdmaRoamingIndicator);
        m.putInt("cdmaDefaultRoamingIndicator", this.mCdmaDefaultRoamingIndicator);
        m.putBoolean("emergencyOnly", this.mIsEmergencyOnly);
    }

    public void setRadioTechnology(int state) {
        this.mRadioTechnology = state;
    }

    public void setCssIndicator(int css) {
        this.mCssIndicator = css != 0;
    }

    public void setSystemAndNetworkId(int systemId, int networkId) {
        this.mSystemId = systemId;
        this.mNetworkId = networkId;
    }

    public int getRadioTechnology() {
        return this.mRadioTechnology;
    }

    public int getCssIndicator() {
        return this.mCssIndicator ? 1 : 0;
    }

    public int getNetworkId() {
        return this.mNetworkId;
    }

    public int getSystemId() {
        return this.mSystemId;
    }
}

