/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.telephony.PhoneNumberUtils;
import android.text.Editable;
import android.text.Selection;
import android.text.TextWatcher;
import java.util.Locale;

public class PhoneNumberFormattingTextWatcher
implements TextWatcher {
    private static int sFormatType;
    private static Locale sCachedLocale;
    private boolean mFormatting;
    private boolean mDeletingHyphen;
    private int mHyphenStart;
    private boolean mDeletingBackward;

    public PhoneNumberFormattingTextWatcher() {
        if (sCachedLocale == null || sCachedLocale != Locale.getDefault()) {
            sCachedLocale = Locale.getDefault();
            sFormatType = PhoneNumberUtils.getFormatTypeForLocale(sCachedLocale);
        }
    }

    public synchronized void afterTextChanged(Editable text) {
        if (!this.mFormatting) {
            this.mFormatting = true;
            if (this.mDeletingHyphen && this.mHyphenStart > 0) {
                if (this.mDeletingBackward) {
                    if (this.mHyphenStart - 1 < text.length()) {
                        text.delete(this.mHyphenStart - 1, this.mHyphenStart);
                    }
                } else if (this.mHyphenStart < text.length()) {
                    text.delete(this.mHyphenStart, this.mHyphenStart + 1);
                }
            }
            PhoneNumberUtils.formatNumber(text, sFormatType);
            this.mFormatting = false;
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        if (!this.mFormatting) {
            int selStart = Selection.getSelectionStart(s);
            int selEnd = Selection.getSelectionEnd(s);
            if (s.length() > 1 && count == 1 && after == 0 && s.charAt(start) == '-' && selStart == selEnd) {
                this.mDeletingHyphen = true;
                this.mHyphenStart = start;
                this.mDeletingBackward = selStart == start + 1;
            } else {
                this.mDeletingHyphen = false;
            }
        }
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }
}

