/*
 * Decompiled with CFR 0.152.
 */
package android.server;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothDeviceProfileState;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfileState;
import android.bluetooth.BluetoothUuid;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothCallback;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemService;
import android.provider.Settings;
import android.server.BluetoothA2dpService;
import android.server.BluetoothEventLoop;
import android.util.Log;
import android.util.Pair;
import com.android.internal.app.IBatteryStats;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BluetoothService
extends IBluetooth.Stub {
    private static final String TAG = "BluetoothService";
    private static final boolean DBG = true;
    private int mNativeData;
    private BluetoothEventLoop mEventLoop;
    private boolean mIsAirplaneSensitive;
    private boolean mIsAirplaneToggleable;
    private int mBluetoothState;
    private boolean mRestart = false;
    private boolean mIsDiscovering;
    private BluetoothAdapter mAdapter;
    private final BondState mBondState = new BondState();
    private final IBatteryStats mBatteryStats;
    private final Context mContext;
    private static final String BLUETOOTH_ADMIN_PERM = "android.permission.BLUETOOTH_ADMIN";
    private static final String BLUETOOTH_PERM = "android.permission.BLUETOOTH";
    private static final String DOCK_ADDRESS_PATH = "/sys/class/switch/dock/bt_addr";
    private static final String DOCK_PIN_PATH = "/sys/class/switch/dock/bt_pin";
    private static final String SHARED_PREFERENCE_DOCK_ADDRESS = "dock_bluetooth_address";
    private static final String SHARED_PREFERENCES_NAME = "bluetooth_service_settings";
    private static final int MESSAGE_REGISTER_SDP_RECORDS = 1;
    private static final int MESSAGE_FINISH_DISABLE = 2;
    private static final int MESSAGE_UUID_INTENT = 3;
    private static final int MESSAGE_AUTO_PAIRING_FAILURE_ATTEMPT_DELAY = 5;
    private static final long INIT_AUTO_PAIRING_FAILURE_ATTEMPT_DELAY = 3000L;
    private static final long MAX_AUTO_PAIRING_FAILURE_ATTEMPT_DELAY = 12000L;
    private static final int UUID_INTENT_DELAY = 6000;
    private static final ParcelUuid[] RFCOMM_UUIDS = new ParcelUuid[]{BluetoothUuid.Handsfree, BluetoothUuid.HSP, BluetoothUuid.ObexObjectPush};
    private final Map<String, String> mAdapterProperties;
    private final HashMap<String, Map<String, String>> mDeviceProperties;
    private final HashMap<String, Map<ParcelUuid, Integer>> mDeviceServiceChannelCache;
    private final ArrayList<String> mUuidIntentTracker;
    private final HashMap<RemoteService, IBluetoothCallback> mUuidCallbackTracker;
    private final HashMap<Integer, Integer> mServiceRecordToPid;
    private final HashMap<String, BluetoothDeviceProfileState> mDeviceProfileState;
    private final BluetoothProfileState mA2dpProfileState;
    private final BluetoothProfileState mHfpProfileState;
    private BluetoothA2dpService mA2dpService;
    private final HashMap<String, Pair<byte[], byte[]>> mDeviceOobData;
    private static String mDockAddress;
    private String mDockPin;
    private static final String INCOMING_CONNECTION_FILE = "/data/misc/bluetooth/incoming_connection.conf";
    private HashMap<String, Pair<Integer, String>> mIncomingConnections;
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (!BluetoothService.this.isEnabledInternal()) {
                        return;
                    }
                    switch (msg.arg1) {
                        case 1: {
                            Log.d(BluetoothService.TAG, "Registering hfag record");
                            SystemService.start("hfag");
                            BluetoothService.this.mHandler.sendMessageDelayed(BluetoothService.this.mHandler.obtainMessage(1, 2, -1), 500L);
                            break;
                        }
                        case 2: {
                            Log.d(BluetoothService.TAG, "Registering hsag record");
                            SystemService.start("hsag");
                            BluetoothService.this.mHandler.sendMessageDelayed(BluetoothService.this.mHandler.obtainMessage(1, 3, -1), 500L);
                            break;
                        }
                        case 3: {
                            Log.d(BluetoothService.TAG, "Registering opush record");
                            SystemService.start("opush");
                            BluetoothService.this.mHandler.sendMessageDelayed(BluetoothService.this.mHandler.obtainMessage(1, 4, -1), 500L);
                            break;
                        }
                        case 4: {
                            Log.d(BluetoothService.TAG, "Registering pbap record");
                            SystemService.start("pbap");
                        }
                    }
                    break;
                }
                case 2: {
                    BluetoothService.this.finishDisable(msg.arg1 != 0);
                    break;
                }
                case 3: {
                    String address = (String)msg.obj;
                    if (address == null) break;
                    BluetoothService.this.sendUuidIntent(address);
                    BluetoothService.this.makeServiceChannelCallbacks(address);
                    break;
                }
                case 5: {
                    String address = (String)msg.obj;
                    if (address == null) break;
                    BluetoothService.this.createBond(address);
                    return;
                }
            }
        }
    };
    private EnableThread mEnableThread;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent == null) {
                return;
            }
            String action = intent.getAction();
            if (action.equals("android.intent.action.AIRPLANE_MODE")) {
                boolean enabled;
                ContentResolver resolver = context.getContentResolver();
                boolean bl = enabled = !BluetoothService.this.isAirplaneModeOn();
                if (Settings.Secure.getInt(resolver, "bluetooth_on", 0) > 0) {
                    if (enabled) {
                        BluetoothService.this.enable(false);
                    } else {
                        BluetoothService.this.disable(false);
                    }
                }
            } else if ("android.intent.action.DOCK_EVENT".equals(action)) {
                int state = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
                Log.v(BluetoothService.TAG, "Received ACTION_DOCK_EVENT with State:" + state);
                if (state == 0) {
                    mDockAddress = null;
                    BluetoothService.this.mDockPin = null;
                } else {
                    Context context2 = BluetoothService.this.mContext;
                    BluetoothService.this.mContext;
                    SharedPreferences.Editor editor = context2.getSharedPreferences(BluetoothService.SHARED_PREFERENCES_NAME, 0).edit();
                    editor.putBoolean(BluetoothService.SHARED_PREFERENCE_DOCK_ADDRESS + mDockAddress, true);
                    editor.apply();
                }
            }
        }
    };

    public BluetoothService(Context context) {
        this.mContext = context;
        this.mBatteryStats = IBatteryStats.Stub.asInterface(ServiceManager.getService("batteryinfo"));
        this.initializeNativeDataNative();
        if (this.isEnabledNative() == 1) {
            Log.w(TAG, "Bluetooth daemons already running - runtime restart? ");
            this.disableNative();
        }
        this.mBluetoothState = 10;
        this.mIsDiscovering = false;
        this.mAdapterProperties = new HashMap<String, String>();
        this.mDeviceProperties = new HashMap();
        this.mDeviceServiceChannelCache = new HashMap();
        this.mDeviceOobData = new HashMap();
        this.mUuidIntentTracker = new ArrayList();
        this.mUuidCallbackTracker = new HashMap();
        this.mServiceRecordToPid = new HashMap();
        this.mDeviceProfileState = new HashMap();
        this.mA2dpProfileState = new BluetoothProfileState(this.mContext, 1);
        this.mHfpProfileState = new BluetoothProfileState(this.mContext, 0);
        this.mHfpProfileState.start();
        this.mA2dpProfileState.start();
        IntentFilter filter = new IntentFilter();
        this.registerForAirplaneMode(filter);
        filter.addAction("android.intent.action.DOCK_EVENT");
        this.mContext.registerReceiver(this.mReceiver, filter);
        this.mIncomingConnections = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static synchronized String readDockBluetoothAddress() {
        block19: {
            block17: {
                block18: {
                    if (BluetoothService.mDockAddress != null) {
                        return BluetoothService.mDockAddress;
                    }
                    file = null;
                    file = new BufferedInputStream(new FileInputStream("/sys/class/switch/dock/bt_addr"));
                    address = new byte[17];
                    file.read(address);
                    dockAddress = new String(address);
                    dockAddress = dockAddress.toUpperCase();
                    if (!BluetoothAdapter.checkBluetoothAddress(dockAddress)) break block17;
                    var3_5 = BluetoothService.mDockAddress = dockAddress;
                    var5_6 = null;
                    if (file == null) break block18;
                    try {
                        file.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                return var3_5;
            }
            try {
                BluetoothService.log("CheckBluetoothAddress failed for car dock address:" + dockAddress);
                var5_7 = null;
                ** if (file == null) goto lbl-1000
            }
            catch (Throwable var4_16) {
                var5_10 = null;
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw var4_16;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    file.close();
                }
                catch (IOException e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block19;
                catch (FileNotFoundException e) {
                    BluetoothService.log("FileNotFoundException while trying to read dock address");
                    var5_8 = null;
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (IOException e) {}
                    }
                    break block19;
                }
                catch (IOException e) {
                    BluetoothService.log("IOException while trying to read dock address");
                    var5_9 = null;
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        BluetoothService.mDockAddress = null;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean writeDockPin() {
        block13: {
            out = null;
            try {
                try {
                    out = new BufferedWriter(new FileWriter("/sys/class/switch/dock/bt_pin"));
                    pin = (int)Math.floor(Math.random() * 10000.0);
                    this.mDockPin = String.format("%04d", new Object[]{pin});
                    out.write(this.mDockPin);
                    var3_5 = true;
                    var5_6 = null;
                    if (out == null) return var3_5;
                }
                catch (FileNotFoundException e) {
                    BluetoothService.log("FileNotFoundException while trying to write dock pairing pin");
                    var5_7 = null;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {}
                    }
                    break block13;
                }
                catch (IOException e) {
                    BluetoothService.log("IOException while while trying to write dock pairing pin");
                    var5_8 = null;
                    if (out == null) break block13;
                    try {}
                    catch (IOException e) {}
                    out.close();
                    break block13;
                }
            }
            catch (Throwable var4_14) {
                var5_9 = null;
                if (out == null) throw var4_14;
                ** try [egrp 2[TRYBLOCK] [6 : 104->111)] { 
lbl38:
                // 1 sources

                out.close();
                throw var4_14;
lbl40:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                throw var4_14;
            }
            try {}
            catch (IOException e) {
                // empty catch block
                return var3_5;
            }
            out.close();
            return var3_5;
        }
        this.mDockPin = null;
        return false;
    }

    synchronized String getDockPin() {
        return this.mDockPin;
    }

    public synchronized void initAfterRegistration() {
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mEventLoop = new BluetoothEventLoop(this.mContext, this.mAdapter, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finalize() throws Throwable {
        this.mContext.unregisterReceiver(this.mReceiver);
        try {
            this.cleanupNativeDataNative();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    @Override
    public boolean isEnabled() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        return this.isEnabledInternal();
    }

    private boolean isEnabledInternal() {
        return this.mBluetoothState == 12;
    }

    @Override
    public int getBluetoothState() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        return this.mBluetoothState;
    }

    public boolean disable() {
        return this.disable(true);
    }

    @Override
    public synchronized boolean disable(boolean saveSetting) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        switch (this.mBluetoothState) {
            case 10: {
                return true;
            }
            case 12: {
                break;
            }
            default: {
                return false;
            }
        }
        if (this.mEnableThread != null && this.mEnableThread.isAlive()) {
            return false;
        }
        this.setBluetoothState(13);
        this.mHandler.removeMessages(1);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(2, saveSetting ? 1 : 0, 0), 3000L);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void finishDisable(boolean saveSetting) {
        block8: {
            if (this.mBluetoothState != 13) {
                return;
            }
            this.mEventLoop.stop();
            this.tearDownNativeDataNative();
            this.disableNative();
            for (String address : this.mBondState.listInState(11)) {
                this.mBondState.setBondState(address, 10, 3);
            }
            Intent intent = new Intent("android.bluetooth.adapter.action.SCAN_MODE_CHANGED");
            intent.putExtra("android.bluetooth.adapter.extra.SCAN_MODE", 20);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
            this.mIsDiscovering = false;
            this.mAdapterProperties.clear();
            this.mServiceRecordToPid.clear();
            if (saveSetting) {
                this.persistBluetoothOnSetting(false);
            }
            this.setBluetoothState(10);
            long ident = Binder.clearCallingIdentity();
            try {
                try {
                    this.mBatteryStats.noteBluetoothOff();
                }
                catch (RemoteException e) {
                    Object var7_9 = null;
                    Binder.restoreCallingIdentity(ident);
                    break block8;
                }
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
        }
        if (this.mRestart) {
            this.mRestart = false;
            this.enable();
        }
    }

    @Override
    public boolean enable() {
        return this.enable(true);
    }

    public synchronized boolean enable(boolean saveSetting) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (this.mIsAirplaneSensitive && this.isAirplaneModeOn() && !this.mIsAirplaneToggleable) {
            return false;
        }
        if (this.mBluetoothState != 10) {
            return false;
        }
        if (this.mEnableThread != null && this.mEnableThread.isAlive()) {
            return false;
        }
        this.setBluetoothState(11);
        this.mEnableThread = new EnableThread(saveSetting);
        this.mEnableThread.start();
        return true;
    }

    synchronized void restart() {
        if (this.mBluetoothState != 12) {
            return;
        }
        this.mRestart = true;
        if (!this.disable(false)) {
            this.mRestart = false;
        }
    }

    private synchronized void setBluetoothState(int state) {
        if (state == this.mBluetoothState) {
            return;
        }
        BluetoothService.log("Bluetooth state " + this.mBluetoothState + " -> " + state);
        Intent intent = new Intent("android.bluetooth.adapter.action.STATE_CHANGED");
        intent.putExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", this.mBluetoothState);
        intent.putExtra("android.bluetooth.adapter.extra.STATE", state);
        intent.addFlags(0x10000000);
        this.mBluetoothState = state;
        this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
    }

    private void persistBluetoothOnSetting(boolean bluetoothOn) {
        long origCallerIdentityToken = Binder.clearCallingIdentity();
        Settings.Secure.putInt(this.mContext.getContentResolver(), "bluetooth_on", bluetoothOn ? 1 : 0);
        Binder.restoreCallingIdentity(origCallerIdentityToken);
    }

    synchronized boolean attemptAutoPair(String address) {
        if (!this.mBondState.hasAutoPairingFailed(address) && !this.mBondState.isAutoPairingBlacklisted(address)) {
            this.mBondState.attempt(address);
            this.setPin(address, BluetoothDevice.convertPinToBytes("0000"));
            return true;
        }
        return false;
    }

    synchronized void onCreatePairedDeviceResult(String address, int result) {
        if (result == 0) {
            this.setBondState(address, 12);
            if (this.mBondState.isAutoPairingAttemptsInProgress(address)) {
                this.mBondState.clearPinAttempts(address);
            }
        } else if (result == 1 && this.mBondState.getAttempt(address) == 1) {
            this.mBondState.addAutoPairingFailure(address);
            this.pairingAttempt(address, result);
        } else if (result == 4 && this.mBondState.isAutoPairingAttemptsInProgress(address)) {
            this.pairingAttempt(address, result);
        } else {
            this.setBondState(address, 10, result);
            if (this.mBondState.isAutoPairingAttemptsInProgress(address)) {
                this.mBondState.clearPinAttempts(address);
            }
        }
    }

    synchronized String getPendingOutgoingBonding() {
        return this.mBondState.getPendingOutgoingBonding();
    }

    private void pairingAttempt(String address, int result) {
        int attempt = this.mBondState.getAttempt(address);
        if ((long)attempt * 3000L > 12000L) {
            this.mBondState.clearPinAttempts(address);
            this.setBondState(address, 10, result);
            return;
        }
        Message message = this.mHandler.obtainMessage(5);
        message.obj = address;
        boolean postResult = this.mHandler.sendMessageDelayed(message, (long)attempt * 3000L);
        if (!postResult) {
            this.mBondState.clearPinAttempts(address);
            this.setBondState(address, 10, result);
            return;
        }
        this.mBondState.attempt(address);
    }

    private static String toBondStateString(int bondState) {
        switch (bondState) {
            case 10: {
                return "not bonded";
            }
            case 11: {
                return "bonding";
            }
            case 12: {
                return "bonded";
            }
        }
        return "??????";
    }

    synchronized boolean isAdapterPropertiesEmpty() {
        return this.mAdapterProperties.isEmpty();
    }

    synchronized void getAllProperties() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        this.mAdapterProperties.clear();
        String[] properties = (String[])this.getAdapterPropertiesNative();
        if (properties == null) {
            Log.e(TAG, "*Error*: GetAdapterProperties returned NULL");
            return;
        }
        for (int i = 0; i < properties.length; ++i) {
            String name = properties[i];
            String newValue = null;
            if (name == null) {
                Log.e(TAG, "Error:Adapter Property at index" + i + "is null");
                continue;
            }
            if (name.equals("Devices") || name.equals("UUIDs")) {
                StringBuilder str = new StringBuilder();
                int len = Integer.valueOf(properties[++i]);
                for (int j = 0; j < len; ++j) {
                    str.append(properties[++i]);
                    str.append(",");
                }
                if (len > 0) {
                    newValue = str.toString();
                }
            } else {
                newValue = properties[++i];
            }
            this.mAdapterProperties.put(name, newValue);
        }
        String adapterPath = this.getAdapterPathNative();
        if (adapterPath != null) {
            this.mAdapterProperties.put("ObjectPath", adapterPath + "/dev_");
        }
    }

    synchronized void setProperty(String name, String value) {
        this.mAdapterProperties.put(name, value);
    }

    @Override
    public synchronized boolean setName(String name) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (name == null) {
            return false;
        }
        return this.setPropertyString("Name", name);
    }

    private boolean setPropertyString(String key, String value) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        return this.setAdapterPropertyStringNative(key, value);
    }

    private boolean setPropertyInteger(String key, int value) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        return this.setAdapterPropertyIntegerNative(key, value);
    }

    private boolean setPropertyBoolean(String key, boolean value) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        return this.setAdapterPropertyBooleanNative(key, value ? 1 : 0);
    }

    @Override
    public synchronized boolean setDiscoverableTimeout(int timeout) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        return this.setPropertyInteger("DiscoverableTimeout", timeout);
    }

    @Override
    public synchronized boolean setScanMode(int mode, int duration) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS", "Need WRITE_SECURE_SETTINGS permission");
        boolean pairable = false;
        boolean discoverable = false;
        switch (mode) {
            case 20: {
                pairable = false;
                discoverable = false;
                break;
            }
            case 21: {
                pairable = true;
                discoverable = false;
                break;
            }
            case 23: {
                this.setDiscoverableTimeout(duration);
                pairable = true;
                discoverable = true;
                Log.d(TAG, "BT Discoverable for " + duration + " seconds");
                break;
            }
            default: {
                Log.w(TAG, "Requested invalid scan mode " + mode);
                return false;
            }
        }
        this.setPropertyBoolean("Pairable", pairable);
        this.setPropertyBoolean("Discoverable", discoverable);
        return true;
    }

    synchronized String getProperty(String name) {
        if (!this.isEnabledInternal()) {
            return null;
        }
        return this.getPropertyInternal(name);
    }

    synchronized String getPropertyInternal(String name) {
        if (!this.mAdapterProperties.isEmpty()) {
            return this.mAdapterProperties.get(name);
        }
        this.getAllProperties();
        return this.mAdapterProperties.get(name);
    }

    @Override
    public synchronized String getAddress() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        return this.getProperty("Address");
    }

    @Override
    public synchronized String getName() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        return this.getProperty("Name");
    }

    @Override
    public synchronized String getRemoteName(String address) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            return null;
        }
        return this.getRemoteDeviceProperty(address, "Name");
    }

    @Override
    public synchronized int getDiscoverableTimeout() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        String timeout = this.getProperty("DiscoverableTimeout");
        if (timeout != null) {
            return Integer.valueOf(timeout);
        }
        return -1;
    }

    @Override
    public synchronized int getScanMode() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!this.isEnabledInternal()) {
            return 20;
        }
        boolean pairable = this.getProperty("Pairable").equals("true");
        boolean discoverable = this.getProperty("Discoverable").equals("true");
        return BluetoothService.bluezStringToScanMode(pairable, discoverable);
    }

    @Override
    public synchronized boolean startDiscovery() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        return this.startDiscoveryNative();
    }

    @Override
    public synchronized boolean cancelDiscovery() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        return this.stopDiscoveryNative();
    }

    @Override
    public synchronized boolean isDiscovering() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        return this.mIsDiscovering;
    }

    void setIsDiscovering(boolean isDiscovering) {
        this.mIsDiscovering = isDiscovering;
    }

    private boolean isBondingFeasible(String address) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            return false;
        }
        address = address.toUpperCase();
        if (this.mBondState.getPendingOutgoingBonding() != null) {
            BluetoothService.log("Ignoring createBond(): another device is bonding");
            return false;
        }
        if (!this.mBondState.isAutoPairingAttemptsInProgress(address) && this.mBondState.getBondState(address) != 10) {
            BluetoothService.log("Ignoring createBond(): this device is already bonding or bonded");
            return false;
        }
        if (address.equals(mDockAddress) && !this.writeDockPin()) {
            BluetoothService.log("Error while writing Pin for the dock");
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean createBond(String address) {
        if (!this.isBondingFeasible(address)) {
            return false;
        }
        if (!this.createPairedDeviceNative(address, 60000)) {
            return false;
        }
        this.mBondState.setPendingOutgoingBonding(address);
        this.mBondState.setBondState(address, 11);
        return true;
    }

    @Override
    public synchronized boolean createBondOutOfBand(String address, byte[] hash, byte[] randomizer) {
        if (!this.isBondingFeasible(address)) {
            return false;
        }
        if (!this.createPairedDeviceOutOfBandNative(address, 60000)) {
            return false;
        }
        this.setDeviceOutOfBandData(address, hash, randomizer);
        this.mBondState.setPendingOutgoingBonding(address);
        this.mBondState.setBondState(address, 11);
        return true;
    }

    @Override
    public synchronized boolean setDeviceOutOfBandData(String address, byte[] hash, byte[] randomizer) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        Pair<byte[], byte[]> value = new Pair<byte[], byte[]>(hash, randomizer);
        BluetoothService.log("Setting out of band data for:" + address + ":" + Arrays.toString(hash) + ":" + Arrays.toString(randomizer));
        this.mDeviceOobData.put(address, value);
        return true;
    }

    Pair<byte[], byte[]> getDeviceOutOfBandData(BluetoothDevice device) {
        return this.mDeviceOobData.get(device.getAddress());
    }

    @Override
    public synchronized byte[] readOutOfBandData() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!this.isEnabledInternal()) {
            return null;
        }
        return this.readAdapterOutOfBandDataNative();
    }

    @Override
    public synchronized boolean cancelBondProcess(String address) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            return false;
        }
        if (this.mBondState.getBondState(address = address.toUpperCase()) != 11) {
            return false;
        }
        this.mBondState.setBondState(address, 10, 3);
        this.cancelDeviceCreationNative(address);
        return true;
    }

    @Override
    public synchronized boolean removeBond(String address) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            return false;
        }
        BluetoothDeviceProfileState state = this.mDeviceProfileState.get(address);
        if (state != null) {
            state.sendMessage(100);
            return true;
        }
        return false;
    }

    public synchronized boolean removeBondInternal(String address) {
        this.setTrust(address, false);
        return this.removeDeviceNative(this.getObjectPathFromAddress(address));
    }

    @Override
    public synchronized String[] listBonds() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        return this.mBondState.listInState(12);
    }

    synchronized String[] listInState(int state) {
        return this.mBondState.listInState(state);
    }

    @Override
    public synchronized int getBondState(String address) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            return Integer.MIN_VALUE;
        }
        return this.mBondState.getBondState(address.toUpperCase());
    }

    synchronized boolean setBondState(String address, int state) {
        return this.setBondState(address, state, 0);
    }

    synchronized boolean setBondState(String address, int state, int reason) {
        this.mBondState.setBondState(address.toUpperCase(), state);
        return true;
    }

    @Override
    public synchronized boolean isBluetoothDock(String address) {
        SharedPreferences sp = this.mContext.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        return sp.contains(SHARED_PREFERENCE_DOCK_ADDRESS + address);
    }

    boolean isRemoteDeviceInCache(String address) {
        return this.mDeviceProperties.get(address) != null;
    }

    String[] getRemoteDeviceProperties(String address) {
        if (!this.isEnabledInternal()) {
            return null;
        }
        String objectPath = this.getObjectPathFromAddress(address);
        return (String[])this.getDevicePropertiesNative(objectPath);
    }

    synchronized String getRemoteDeviceProperty(String address, String property) {
        Map<String, String> properties = this.mDeviceProperties.get(address);
        if (properties != null) {
            return properties.get(property);
        }
        if (this.updateRemoteDevicePropertiesCache(address)) {
            return this.getRemoteDeviceProperty(address, property);
        }
        Log.e(TAG, "getRemoteDeviceProperty: " + property + "not present:" + address);
        return null;
    }

    synchronized boolean updateRemoteDevicePropertiesCache(String address) {
        String[] propValues = this.getRemoteDeviceProperties(address);
        if (propValues != null) {
            this.addRemoteDeviceProperties(address, propValues);
            return true;
        }
        return false;
    }

    synchronized void addRemoteDeviceProperties(String address, String[] properties) {
        Map<String, String> propertyValues = this.mDeviceProperties.get(address);
        if (propertyValues == null) {
            propertyValues = new HashMap<String, String>();
        }
        for (int i = 0; i < properties.length; ++i) {
            String name = properties[i];
            String newValue = null;
            if (name == null) {
                Log.e(TAG, "Error: Remote Device Property at index" + i + "is null");
                continue;
            }
            if (name.equals("UUIDs") || name.equals("Nodes")) {
                StringBuilder str = new StringBuilder();
                int len = Integer.valueOf(properties[++i]);
                for (int j = 0; j < len; ++j) {
                    str.append(properties[++i]);
                    str.append(",");
                }
                if (len > 0) {
                    newValue = str.toString();
                }
            } else {
                newValue = properties[++i];
            }
            propertyValues.put(name, newValue);
        }
        this.mDeviceProperties.put(address, propertyValues);
        this.updateDeviceServiceChannelCache(address);
    }

    void removeRemoteDeviceProperties(String address) {
        this.mDeviceProperties.remove(address);
    }

    synchronized void setRemoteDeviceProperty(String address, String name, String value) {
        Map<String, String> propVal = this.mDeviceProperties.get(address);
        if (propVal != null) {
            propVal.put(name, value);
            this.mDeviceProperties.put(address, propVal);
        } else {
            Log.e(TAG, "setRemoteDeviceProperty for a device not in cache:" + address);
        }
    }

    @Override
    public synchronized boolean setTrust(String address, boolean value) {
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
            return false;
        }
        if (!this.isEnabledInternal()) {
            return false;
        }
        return this.setDevicePropertyBooleanNative(this.getObjectPathFromAddress(address), "Trusted", value ? 1 : 0);
    }

    @Override
    public synchronized boolean getTrustState(String address) {
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
            return false;
        }
        String val = this.getRemoteDeviceProperty(address, "Trusted");
        if (val == null) {
            return false;
        }
        return val.equals("true");
    }

    @Override
    public synchronized int getRemoteClass(String address) {
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
            return -16777216;
        }
        String val = this.getRemoteDeviceProperty(address, "Class");
        if (val == null) {
            return -16777216;
        }
        return Integer.valueOf(val);
    }

    @Override
    public synchronized ParcelUuid[] getRemoteUuids(String address) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            return null;
        }
        return this.getUuidFromCache(address);
    }

    private ParcelUuid[] getUuidFromCache(String address) {
        String value = this.getRemoteDeviceProperty(address, "UUIDs");
        if (value == null) {
            return null;
        }
        String[] uuidStrings = null;
        uuidStrings = value.split(",");
        ParcelUuid[] uuids = new ParcelUuid[uuidStrings.length];
        for (int i = 0; i < uuidStrings.length; ++i) {
            uuids[i] = ParcelUuid.fromString(uuidStrings[i]);
        }
        return uuids;
    }

    @Override
    public synchronized boolean fetchRemoteUuids(String address, ParcelUuid uuid, IBluetoothCallback callback) {
        boolean ret;
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            return false;
        }
        RemoteService service = new RemoteService(address, uuid);
        if (uuid != null && this.mUuidCallbackTracker.get(service) != null) {
            return false;
        }
        if (this.mUuidIntentTracker.contains(address)) {
            if (uuid != null) {
                this.mUuidCallbackTracker.put(new RemoteService(address, uuid), callback);
            }
            return true;
        }
        if (this.isRemoteDeviceInCache(address) && this.getRemoteUuids(address) != null) {
            String path = this.getObjectPathFromAddress(address);
            if (path == null) {
                return false;
            }
            ret = this.discoverServicesNative(path, "");
        } else {
            ret = this.createDeviceNative(address);
        }
        this.mUuidIntentTracker.add(address);
        if (uuid != null) {
            this.mUuidCallbackTracker.put(new RemoteService(address, uuid), callback);
        }
        Message message = this.mHandler.obtainMessage(3);
        message.obj = address;
        this.mHandler.sendMessageDelayed(message, 6000L);
        return ret;
    }

    @Override
    public int getRemoteServiceChannel(String address, ParcelUuid uuid) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!this.isEnabledInternal()) {
            return -1;
        }
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            return Integer.MIN_VALUE;
        }
        if (this.mDeviceProperties.isEmpty() && !this.updateRemoteDevicePropertiesCache(address)) {
            return -1;
        }
        Map<ParcelUuid, Integer> value = this.mDeviceServiceChannelCache.get(address);
        if (value != null && value.containsKey(uuid)) {
            return value.get(uuid);
        }
        return -1;
    }

    @Override
    public synchronized boolean setPin(String address, byte[] pin) {
        String pinString;
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        if (pin == null || pin.length <= 0 || pin.length > 16 || !BluetoothAdapter.checkBluetoothAddress(address)) {
            return false;
        }
        address = address.toUpperCase();
        Integer data = this.mEventLoop.getPasskeyAgentRequestData().remove(address);
        if (data == null) {
            Log.w(TAG, "setPin(" + address + ") called but no native data available, " + "ignoring. Maybe the PasskeyAgent Request was cancelled by the remote device" + " or by bluez.\n");
            return false;
        }
        try {
            pinString = new String(pin, "UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            Log.e(TAG, "UTF8 not supported?!?");
            return false;
        }
        return this.setPinNative(address, pinString, data);
    }

    @Override
    public synchronized boolean setPasskey(String address, int passkey) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        if (passkey < 0 || passkey > 999999 || !BluetoothAdapter.checkBluetoothAddress(address)) {
            return false;
        }
        address = address.toUpperCase();
        Integer data = this.mEventLoop.getPasskeyAgentRequestData().remove(address);
        if (data == null) {
            Log.w(TAG, "setPasskey(" + address + ") called but no native data available, " + "ignoring. Maybe the PasskeyAgent Request was cancelled by the remote device" + " or by bluez.\n");
            return false;
        }
        return this.setPasskeyNative(address, passkey, data);
    }

    @Override
    public synchronized boolean setPairingConfirmation(String address, boolean confirm) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        address = address.toUpperCase();
        Integer data = this.mEventLoop.getPasskeyAgentRequestData().remove(address);
        if (data == null) {
            Log.w(TAG, "setPasskey(" + address + ") called but no native data available, " + "ignoring. Maybe the PasskeyAgent Request was cancelled by the remote device" + " or by bluez.\n");
            return false;
        }
        return this.setPairingConfirmationNative(address, confirm, data);
    }

    @Override
    public synchronized boolean setRemoteOutOfBandData(String address) {
        byte[] randomizer;
        byte[] hash;
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        address = address.toUpperCase();
        Integer data = this.mEventLoop.getPasskeyAgentRequestData().remove(address);
        if (data == null) {
            Log.w(TAG, "setRemoteOobData(" + address + ") called but no native data available, " + "ignoring. Maybe the PasskeyAgent Request was cancelled by the remote device" + " or by bluez.\n");
            return false;
        }
        Pair<byte[], byte[]> val = this.mDeviceOobData.get(address);
        if (val == null) {
            hash = new byte[16];
            randomizer = new byte[16];
        } else {
            hash = (byte[])val.first;
            randomizer = (byte[])val.second;
        }
        return this.setRemoteOutOfBandDataNative(address, hash, randomizer, data);
    }

    @Override
    public synchronized boolean cancelPairingUserInput(String address) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            return false;
        }
        this.mBondState.setBondState(address, 10, 3);
        address = address.toUpperCase();
        Integer data = this.mEventLoop.getPasskeyAgentRequestData().remove(address);
        if (data == null) {
            Log.w(TAG, "cancelUserInputNative(" + address + ") called but no native data " + "available, ignoring. Maybe the PasskeyAgent Request was already cancelled " + "by the remote or by bluez.\n");
            return false;
        }
        return this.cancelPairingUserInputNative(address, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateDeviceServiceChannelCache(String address) {
        int channel;
        ParcelUuid[] deviceUuids = this.getRemoteUuids(address);
        BluetoothService.log("updateDeviceServiceChannelCache(" + address + ")");
        ArrayList<ParcelUuid> applicationUuids = new ArrayList<ParcelUuid>();
        BluetoothService bluetoothService = this;
        synchronized (bluetoothService) {
            for (RemoteService service : this.mUuidCallbackTracker.keySet()) {
                if (!service.address.equals(address)) continue;
                applicationUuids.add(service.uuid);
            }
        }
        HashMap<ParcelUuid, Integer> value = new HashMap<ParcelUuid, Integer>();
        for (ParcelUuid uuid : RFCOMM_UUIDS) {
            if (!BluetoothUuid.isUuidPresent(deviceUuids, uuid)) continue;
            channel = this.getDeviceServiceChannelNative(this.getObjectPathFromAddress(address), uuid.toString(), 4);
            BluetoothService.log("\tuuid(system): " + uuid + " " + channel);
            value.put(uuid, channel);
        }
        for (ParcelUuid uuid : applicationUuids) {
            if (!BluetoothUuid.isUuidPresent(deviceUuids, uuid)) continue;
            channel = this.getDeviceServiceChannelNative(this.getObjectPathFromAddress(address), uuid.toString(), 4);
            BluetoothService.log("\tuuid(application): " + uuid + " " + channel);
            value.put(uuid, channel);
        }
        BluetoothService bluetoothService2 = this;
        synchronized (bluetoothService2) {
            Iterator<RemoteService> iter = this.mUuidCallbackTracker.keySet().iterator();
            while (iter.hasNext()) {
                RemoteService service = iter.next();
                if (!service.address.equals(address)) continue;
                channel = -1;
                if (value.get(service.uuid) != null) {
                    channel = (Integer)value.get(service.uuid);
                }
                if (channel == -1) continue;
                BluetoothService.log("Making callback for " + service.uuid + " with result " + channel);
                IBluetoothCallback callback = this.mUuidCallbackTracker.get(service);
                if (callback != null) {
                    try {
                        callback.onRfcommChannelFound(channel);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "", e);
                    }
                }
                iter.remove();
            }
            this.mDeviceServiceChannelCache.put(address, value);
        }
    }

    @Override
    public synchronized int addRfcommServiceRecord(String serviceName, ParcelUuid uuid, int channel, IBinder b) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!this.isEnabledInternal()) {
            return -1;
        }
        if (serviceName == null || uuid == null || channel < 1 || channel > 30) {
            return -1;
        }
        if (BluetoothUuid.isUuidPresent(BluetoothUuid.RESERVED_UUIDS, uuid)) {
            Log.w(TAG, "Attempted to register a reserved UUID: " + uuid);
            return -1;
        }
        int handle = this.addRfcommServiceRecordNative(serviceName, uuid.getUuid().getMostSignificantBits(), uuid.getUuid().getLeastSignificantBits(), (short)channel);
        BluetoothService.log("new handle " + Integer.toHexString(handle));
        if (handle == -1) {
            return -1;
        }
        int pid = Binder.getCallingPid();
        this.mServiceRecordToPid.put(new Integer(handle), new Integer(pid));
        try {
            b.linkToDeath(new Reaper(handle, pid), 0);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return handle;
    }

    @Override
    public void removeServiceRecord(int handle) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        this.checkAndRemoveRecord(handle, Binder.getCallingPid());
    }

    private synchronized void checkAndRemoveRecord(int handle, int pid) {
        Integer handleInt = new Integer(handle);
        Integer owner = this.mServiceRecordToPid.get(handleInt);
        if (owner != null && pid == owner) {
            BluetoothService.log("Removing service record " + Integer.toHexString(handle) + " for pid " + pid);
            this.mServiceRecordToPid.remove(handleInt);
            this.removeServiceRecordNative(handle);
        }
    }

    private void registerForAirplaneMode(IntentFilter filter) {
        ContentResolver resolver = this.mContext.getContentResolver();
        String airplaneModeRadios = Settings.System.getString(resolver, "airplane_mode_radios");
        String toggleableRadios = Settings.System.getString(resolver, "airplane_mode_toggleable_radios");
        this.mIsAirplaneSensitive = airplaneModeRadios == null ? true : airplaneModeRadios.contains("bluetooth");
        boolean bl = this.mIsAirplaneToggleable = toggleableRadios == null ? false : toggleableRadios.contains("bluetooth");
        if (this.mIsAirplaneSensitive) {
            filter.addAction("android.intent.action.AIRPLANE_MODE");
        }
    }

    private final boolean isAirplaneModeOn() {
        return Settings.System.getInt(this.mContext.getContentResolver(), "airplane_mode_on", 0) == 1;
    }

    synchronized void sendUuidIntent(String address) {
        Parcelable[] uuid = this.getUuidFromCache(address);
        Intent intent = new Intent("android.bleutooth.device.action.UUID");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(address));
        intent.putExtra("android.bluetooth.device.extra.UUID", uuid);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
        if (this.mUuidIntentTracker.contains(address)) {
            this.mUuidIntentTracker.remove(address);
        }
    }

    synchronized void makeServiceChannelCallbacks(String address) {
        Iterator<RemoteService> iter = this.mUuidCallbackTracker.keySet().iterator();
        while (iter.hasNext()) {
            RemoteService service = iter.next();
            if (!service.address.equals(address)) continue;
            BluetoothService.log("Cleaning up failed UUID channel lookup: " + service.address + " " + service.uuid);
            IBluetoothCallback callback = this.mUuidCallbackTracker.get(service);
            if (callback != null) {
                try {
                    callback.onRfcommChannelFound(-1);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "", e);
                }
            }
            iter.remove();
        }
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        switch (this.mBluetoothState) {
            case 10: {
                pw.println("Bluetooth OFF\n");
                return;
            }
            case 11: {
                pw.println("Bluetooth TURNING ON\n");
                return;
            }
            case 13: {
                pw.println("Bluetooth TURNING OFF\n");
                return;
            }
            case 12: {
                pw.println("Bluetooth ON\n");
            }
        }
        pw.println("mIsAirplaneSensitive = " + this.mIsAirplaneSensitive);
        pw.println("mIsAirplaneToggleable = " + this.mIsAirplaneToggleable);
        pw.println("Local address = " + this.getAddress());
        pw.println("Local name = " + this.getName());
        pw.println("isDiscovering() = " + this.isDiscovering());
        BluetoothHeadset headset = new BluetoothHeadset(this.mContext, null);
        pw.println("\n--Known devices--");
        for (String address : this.mDeviceProperties.keySet()) {
            int bondState = this.mBondState.getBondState(address);
            pw.printf("%s %10s (%d) %s\n", address, BluetoothService.toBondStateString(bondState), this.mBondState.getAttempt(address), this.getRemoteName(address));
            Map<ParcelUuid, Integer> uuidChannels = this.mDeviceServiceChannelCache.get(address);
            if (uuidChannels == null) {
                pw.println("\tuuids = null");
            } else {
                for (ParcelUuid uuid : uuidChannels.keySet()) {
                    Integer channel = uuidChannels.get(uuid);
                    if (channel == null) {
                        pw.println("\t" + uuid);
                        continue;
                    }
                    pw.println("\t" + uuid + " RFCOMM channel = " + channel);
                }
            }
            for (RemoteService service : this.mUuidCallbackTracker.keySet()) {
                if (!service.address.equals(address)) continue;
                pw.println("\tPENDING CALLBACK: " + service.uuid);
            }
        }
        String value = this.getProperty("Devices");
        String[] devicesObjectPath = null;
        if (value != null) {
            devicesObjectPath = value.split(",");
        }
        pw.println("\n--ACL connected devices--");
        if (devicesObjectPath != null) {
            for (String device : devicesObjectPath) {
                pw.println(this.getAddressFromObjectPath(device));
            }
        }
        pw.println("\n--Headset Service--");
        switch (headset.getState(headset.getCurrentHeadset())) {
            case 0: {
                pw.println("getState() = STATE_DISCONNECTED");
                break;
            }
            case 1: {
                pw.println("getState() = STATE_CONNECTING");
                break;
            }
            case 2: {
                pw.println("getState() = STATE_CONNECTED");
                break;
            }
            case -1: {
                pw.println("getState() = STATE_ERROR");
            }
        }
        pw.println("\ngetCurrentHeadset() = " + headset.getCurrentHeadset());
        pw.println("getBatteryUsageHint() = " + headset.getBatteryUsageHint());
        headset.close();
        pw.println("\n--Application Service Records--");
        for (Integer handle : this.mServiceRecordToPid.keySet()) {
            Integer pid = this.mServiceRecordToPid.get(handle);
            pw.println("\tpid " + pid + " handle " + Integer.toHexString(handle));
        }
    }

    static int bluezStringToScanMode(boolean pairable, boolean discoverable) {
        if (pairable && discoverable) {
            return 23;
        }
        if (pairable && !discoverable) {
            return 21;
        }
        return 20;
    }

    static String scanModeToBluezString(int mode) {
        switch (mode) {
            case 20: {
                return "off";
            }
            case 21: {
                return "connectable";
            }
            case 23: {
                return "discoverable";
            }
        }
        return null;
    }

    String getAddressFromObjectPath(String objectPath) {
        String adapterObjectPath = this.getPropertyInternal("ObjectPath");
        if (adapterObjectPath == null || objectPath == null) {
            Log.e(TAG, "getAddressFromObjectPath: AdapterObjectPath:" + adapterObjectPath + "  or deviceObjectPath:" + objectPath + " is null");
            return null;
        }
        if (!objectPath.startsWith(adapterObjectPath)) {
            Log.e(TAG, "getAddressFromObjectPath: AdapterObjectPath:" + adapterObjectPath + "  is not a prefix of deviceObjectPath:" + objectPath + "bluetoothd crashed ?");
            return null;
        }
        String address = objectPath.substring(adapterObjectPath.length());
        if (address != null) {
            return address.replace('_', ':');
        }
        Log.e(TAG, "getAddressFromObjectPath: Address being returned is null");
        return null;
    }

    String getObjectPathFromAddress(String address) {
        String path = this.getPropertyInternal("ObjectPath");
        if (path == null) {
            Log.e(TAG, "Error: Object Path is null");
            return null;
        }
        path = path + address.replace(":", "_");
        return path;
    }

    void setLinkTimeout(String address, int num_slots) {
        String path = this.getObjectPathFromAddress(address);
        boolean result = this.setLinkTimeoutNative(path, num_slots);
        if (!result) {
            BluetoothService.log("Set Link Timeout to:" + num_slots + " slots failed");
        }
    }

    @Override
    public boolean connectHeadset(String address) {
        BluetoothDeviceProfileState state = this.mDeviceProfileState.get(address);
        if (state != null) {
            Message msg = new Message();
            msg.arg1 = 1;
            msg.obj = state;
            this.mHfpProfileState.sendMessage(msg);
            return true;
        }
        return false;
    }

    @Override
    public boolean disconnectHeadset(String address) {
        BluetoothDeviceProfileState state = this.mDeviceProfileState.get(address);
        if (state != null) {
            Message msg = new Message();
            msg.arg1 = 5;
            msg.obj = state;
            this.mHfpProfileState.sendMessage(msg);
            return true;
        }
        return false;
    }

    public boolean connectSink(String address) {
        BluetoothDeviceProfileState state = this.mDeviceProfileState.get(address);
        if (state != null) {
            Message msg = new Message();
            msg.arg1 = 3;
            msg.obj = state;
            this.mA2dpProfileState.sendMessage(msg);
            return true;
        }
        return false;
    }

    public boolean disconnectSink(String address) {
        BluetoothDeviceProfileState state = this.mDeviceProfileState.get(address);
        if (state != null) {
            Message msg = new Message();
            msg.arg1 = 7;
            msg.obj = state;
            this.mA2dpProfileState.sendMessage(msg);
            return true;
        }
        return false;
    }

    private BluetoothDeviceProfileState addProfileState(String address) {
        BluetoothDeviceProfileState state = this.mDeviceProfileState.get(address);
        if (state != null) {
            return state;
        }
        state = new BluetoothDeviceProfileState(this.mContext, address, this, this.mA2dpService);
        this.mDeviceProfileState.put(address, state);
        state.start();
        return state;
    }

    private void initProfileState() {
        String[] bonds = null;
        String val = this.getPropertyInternal("Devices");
        if (val != null) {
            bonds = val.split(",");
        }
        if (bonds == null) {
            return;
        }
        for (String path : bonds) {
            String address = this.getAddressFromObjectPath(path);
            BluetoothDeviceProfileState state = this.addProfileState(address);
            Message msg = new Message();
            msg.what = 101;
            state.sendMessageDelayed(msg, 8000L);
        }
    }

    @Override
    public boolean notifyIncomingConnection(String address) {
        BluetoothDeviceProfileState state = this.mDeviceProfileState.get(address);
        if (state != null) {
            Message msg = new Message();
            msg.what = 2;
            state.sendMessage(msg);
            return true;
        }
        return false;
    }

    boolean notifyIncomingA2dpConnection(String address) {
        BluetoothDeviceProfileState state = this.mDeviceProfileState.get(address);
        if (state != null) {
            Message msg = new Message();
            msg.what = 4;
            state.sendMessage(msg);
            return true;
        }
        return false;
    }

    void setA2dpService(BluetoothA2dpService a2dpService) {
        this.mA2dpService = a2dpService;
    }

    Integer getAuthorizationAgentRequestData(String address) {
        Integer data = this.mEventLoop.getAuthorizationAgentRequestData().remove(address);
        return data;
    }

    public void sendProfileStateMessage(int profile, int cmd) {
        Message msg = new Message();
        msg.what = cmd;
        if (profile == 0) {
            this.mHfpProfileState.sendMessage(msg);
        } else if (profile == 1) {
            this.mA2dpProfileState.sendMessage(msg);
        }
    }

    private void createIncomingConnectionStateFile() {
        File f = new File(INCOMING_CONNECTION_FILE);
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                Log.e(TAG, "IOException: cannot create file");
            }
        }
    }

    public Pair<Integer, String> getIncomingState(String address) {
        if (this.mIncomingConnections.isEmpty()) {
            this.createIncomingConnectionStateFile();
            this.readIncomingConnectionState();
        }
        return this.mIncomingConnections.get(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readIncomingConnectionState() {
        var1_1 = this.mIncomingConnections;
        synchronized (var1_1) {
            block14: {
                fstream = null;
                try {
                    try {
                        fstream = new FileInputStream("/data/misc/bluetooth/incoming_connection.conf");
                        in = new DataInputStream(fstream);
                        file = new BufferedReader(new InputStreamReader(in));
                        while ((line = file.readLine()) != null) {
                            if ((line = line.trim()).length() == 0 || (value = line.split(",")) == null || value.length != 3) continue;
                            val1 = Integer.parseInt(value[1]);
                            val = new Pair<Integer, String>(val1, value[2]);
                            this.mIncomingConnections.put(value[0], val);
                        }
                        var10_11 = null;
                        if (fstream == null) return;
                    }
                    catch (FileNotFoundException e) {
                        BluetoothService.log("FileNotFoundException: readIncomingConnectionState" + e.toString());
                        var10_12 = null;
                        if (fstream == null) return;
                        try {
                            fstream.close();
                        }
                        catch (IOException e) {}
                        break block14;
                    }
                    catch (IOException e) {
                        BluetoothService.log("IOException: readIncomingConnectionState" + e.toString());
                        var10_13 = null;
                        if (fstream == null) return;
                        try {}
                        catch (IOException e) {}
                        fstream.close();
                        break block14;
                    }
                }
                catch (Throwable var9_19) {
                    var10_14 = null;
                    if (fstream == null) throw var9_19;
                    ** try [egrp 3[TRYBLOCK] [6 : 226->233)] { 
lbl44:
                    // 1 sources

                    fstream.close();
                    throw var9_19;
lbl46:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                    throw var9_19;
                }
                try {}
                catch (IOException e) {}
                fstream.close();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void truncateIncomingConnectionFile() {
        RandomAccessFile r = null;
        r = new RandomAccessFile(INCOMING_CONNECTION_FILE, "rw");
        r.setLength(0L);
        Object var4_2 = null;
        if (r == null) return;
        try {
            r.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (FileNotFoundException e) {
                BluetoothService.log("FileNotFoundException: truncateIncomingConnectionState" + e.toString());
                Object var4_3 = null;
                if (r == null) return;
                try {
                    r.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
            catch (IOException e) {
                BluetoothService.log("IOException: truncateIncomingConnectionState" + e.toString());
                Object var4_4 = null;
                if (r == null) return;
                try {
                    r.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (r == null) throw throwable;
            try {
                r.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeIncomingConnectionState(String address, Pair<Integer, String> data) {
        HashMap<String, Pair<Integer, String>> hashMap = this.mIncomingConnections;
        synchronized (hashMap) {
            block17: {
                this.mIncomingConnections.put(address, data);
                this.truncateIncomingConnectionFile();
                BufferedWriter out = null;
                StringBuilder value = new StringBuilder();
                out = new BufferedWriter(new FileWriter(INCOMING_CONNECTION_FILE, true));
                for (String devAddress : this.mIncomingConnections.keySet()) {
                    Pair<Integer, String> val = this.mIncomingConnections.get(devAddress);
                    value.append(devAddress);
                    value.append(",");
                    value.append(((Integer)val.first).toString());
                    value.append(",");
                    value.append((String)val.second);
                    value.append("\n");
                }
                out.write(value.toString());
                Object var10_11 = null;
                if (out == null) return;
                try {
                    out.close();
                }
                catch (IOException e2) {}
                {
                    break block17;
                    catch (FileNotFoundException e) {
                        BluetoothService.log("FileNotFoundException: writeIncomingConnectionState" + e.toString());
                        Object var10_12 = null;
                        if (out == null) return;
                        try {
                            out.close();
                        }
                        catch (IOException e2) {}
                        break block17;
                    }
                    catch (IOException e) {
                        BluetoothService.log("IOException: writeIncomingConnectionState" + e.toString());
                        Object var10_13 = null;
                        if (out == null) return;
                        try {
                            out.close();
                        }
                        catch (IOException e2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    if (out == null) throw throwable;
                    try {
                        out.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            return;
        }
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    private static native void classInitNative();

    private native void initializeNativeDataNative();

    private native boolean setupNativeDataNative();

    private native boolean tearDownNativeDataNative();

    private native void cleanupNativeDataNative();

    private native String getAdapterPathNative();

    private native int isEnabledNative();

    private native int enableNative();

    private native int disableNative();

    private native Object[] getAdapterPropertiesNative();

    private native Object[] getDevicePropertiesNative(String var1);

    private native boolean setAdapterPropertyStringNative(String var1, String var2);

    private native boolean setAdapterPropertyIntegerNative(String var1, int var2);

    private native boolean setAdapterPropertyBooleanNative(String var1, int var2);

    private native boolean startDiscoveryNative();

    private native boolean stopDiscoveryNative();

    private native boolean createPairedDeviceNative(String var1, int var2);

    private native boolean createPairedDeviceOutOfBandNative(String var1, int var2);

    private native byte[] readAdapterOutOfBandDataNative();

    private native boolean cancelDeviceCreationNative(String var1);

    private native boolean removeDeviceNative(String var1);

    private native int getDeviceServiceChannelNative(String var1, String var2, int var3);

    private native boolean cancelPairingUserInputNative(String var1, int var2);

    private native boolean setPinNative(String var1, String var2, int var3);

    private native boolean setPasskeyNative(String var1, int var2, int var3);

    private native boolean setPairingConfirmationNative(String var1, boolean var2, int var3);

    private native boolean setRemoteOutOfBandDataNative(String var1, byte[] var2, byte[] var3, int var4);

    private native boolean setDevicePropertyBooleanNative(String var1, String var2, int var3);

    private native boolean createDeviceNative(String var1);

    native boolean discoverServicesNative(String var1, String var2);

    private native int addRfcommServiceRecordNative(String var1, long var2, long var4, short var6);

    private native boolean removeServiceRecordNative(int var1);

    private native boolean setLinkTimeoutNative(String var1, int var2);

    native boolean setAuthorizationNative(String var1, boolean var2, int var3);

    static {
        BluetoothService.classInitNative();
    }

    private class Reaper
    implements IBinder.DeathRecipient {
        int pid;
        int handle;

        Reaper(int handle, int pid) {
            this.pid = pid;
            this.handle = handle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            BluetoothService bluetoothService = BluetoothService.this;
            synchronized (bluetoothService) {
                BluetoothService.log("Tracked app " + this.pid + " died");
                BluetoothService.this.checkAndRemoveRecord(this.handle, this.pid);
            }
        }
    }

    public class BondState {
        private final HashMap<String, Integer> mState = new HashMap();
        private final HashMap<String, Integer> mPinAttempt = new HashMap();
        private static final String AUTO_PAIRING_BLACKLIST = "/etc/bluetooth/auto_pairing.conf";
        private static final String DYNAMIC_AUTO_PAIRING_BLACKLIST = "/data/misc/bluetooth/dynamic_auto_pairing.conf";
        private ArrayList<String> mAutoPairingAddressBlacklist;
        private ArrayList<String> mAutoPairingExactNameBlacklist;
        private ArrayList<String> mAutoPairingPartialNameBlacklist;
        private ArrayList<String> mAutoPairingDynamicAddressBlacklist;
        private String mPendingOutgoingBonding;

        private synchronized void setPendingOutgoingBonding(String address) {
            this.mPendingOutgoingBonding = address;
        }

        public synchronized String getPendingOutgoingBonding() {
            return this.mPendingOutgoingBonding;
        }

        public synchronized void loadBondState() {
            if (BluetoothService.this.mBluetoothState != 11) {
                return;
            }
            String[] bonds = null;
            String val = BluetoothService.this.getPropertyInternal("Devices");
            if (val != null) {
                bonds = val.split(",");
            }
            if (bonds == null) {
                return;
            }
            this.mState.clear();
            BluetoothService.log("found " + bonds.length + " bonded devices");
            for (String device : bonds) {
                this.mState.put(BluetoothService.this.getAddressFromObjectPath(device).toUpperCase(), 12);
            }
        }

        public synchronized void setBondState(String address, int state) {
            this.setBondState(address, state, 0);
        }

        public synchronized void setBondState(String address, int state, int reason) {
            int oldState = this.getBondState(address);
            if (oldState == state) {
                return;
            }
            if (oldState == 11 && address.equals(this.mPendingOutgoingBonding)) {
                this.mPendingOutgoingBonding = null;
            }
            if (state == 12) {
                BluetoothService.this.addProfileState(address);
            }
            BluetoothService.log(address + " bond state " + oldState + " -> " + state + " (" + reason + ")");
            Intent intent = new Intent("android.bluetooth.device.action.BOND_STATE_CHANGED");
            intent.putExtra("android.bluetooth.device.extra.DEVICE", BluetoothService.this.mAdapter.getRemoteDevice(address));
            intent.putExtra("android.bluetooth.device.extra.BOND_STATE", state);
            intent.putExtra("android.bluetooth.device.extra.PREVIOUS_BOND_STATE", oldState);
            if (state == 10) {
                if (reason <= 0) {
                    Log.w(BluetoothService.TAG, "setBondState() called to unbond device, but reason code is invalid. Overriding reason code with BOND_RESULT_REMOVED");
                    reason = 9;
                }
                intent.putExtra("android.bluetooth.device.extra.REASON", reason);
                this.mState.remove(address);
            } else {
                this.mState.put(address, state);
            }
            BluetoothService.this.mContext.sendBroadcast(intent, BluetoothService.BLUETOOTH_PERM);
        }

        public boolean isAutoPairingBlacklisted(String address) {
            String name;
            if (this.mAutoPairingAddressBlacklist != null) {
                for (String blacklistAddress : this.mAutoPairingAddressBlacklist) {
                    if (!address.startsWith(blacklistAddress)) continue;
                    return true;
                }
            }
            if (this.mAutoPairingDynamicAddressBlacklist != null) {
                for (String blacklistAddress : this.mAutoPairingDynamicAddressBlacklist) {
                    if (!address.equals(blacklistAddress)) continue;
                    return true;
                }
            }
            if ((name = BluetoothService.this.getRemoteName(address)) != null) {
                if (this.mAutoPairingExactNameBlacklist != null) {
                    for (String blacklistName : this.mAutoPairingExactNameBlacklist) {
                        if (!name.equals(blacklistName)) continue;
                        return true;
                    }
                }
                if (this.mAutoPairingPartialNameBlacklist != null) {
                    for (String blacklistName : this.mAutoPairingPartialNameBlacklist) {
                        if (!name.startsWith(blacklistName)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public synchronized int getBondState(String address) {
            Integer state = this.mState.get(address);
            if (state == null) {
                return 10;
            }
            return state;
        }

        synchronized String[] listInState(int state) {
            ArrayList<String> result = new ArrayList<String>(this.mState.size());
            for (Map.Entry<String, Integer> e : this.mState.entrySet()) {
                if (e.getValue() != state) continue;
                result.add(e.getKey());
            }
            return result.toArray(new String[result.size()]);
        }

        public synchronized void addAutoPairingFailure(String address) {
            if (this.mAutoPairingDynamicAddressBlacklist == null) {
                this.mAutoPairingDynamicAddressBlacklist = new ArrayList();
            }
            this.updateAutoPairingData(address);
            this.mAutoPairingDynamicAddressBlacklist.add(address);
        }

        public synchronized boolean isAutoPairingAttemptsInProgress(String address) {
            return this.getAttempt(address) != 0;
        }

        public synchronized void clearPinAttempts(String address) {
            this.mPinAttempt.remove(address);
        }

        public synchronized boolean hasAutoPairingFailed(String address) {
            if (this.mAutoPairingDynamicAddressBlacklist == null) {
                return false;
            }
            return this.mAutoPairingDynamicAddressBlacklist.contains(address);
        }

        public synchronized int getAttempt(String address) {
            Integer attempt = this.mPinAttempt.get(address);
            if (attempt == null) {
                return 0;
            }
            return attempt;
        }

        public synchronized void attempt(String address) {
            Integer attempt = this.mPinAttempt.get(address);
            int newAttempt = attempt == null ? 1 : attempt + 1;
            this.mPinAttempt.put(address, new Integer(newAttempt));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void copyAutoPairingData() {
            block20: {
                block19: {
                    file = null;
                    in = null;
                    out = null;
                    try {
                        try {
                            file = new File("/data/misc/bluetooth/dynamic_auto_pairing.conf");
                            if (file.exists()) {
                                var7_4 = null;
                                break block19;
                            }
                            in = new FileInputStream("/etc/bluetooth/auto_pairing.conf");
                            out = new FileOutputStream("/data/misc/bluetooth/dynamic_auto_pairing.conf");
                            buf = new byte[1024];
                            while ((len = in.read(buf)) > 0) {
                                out.write(buf, 0, len);
                            }
                            break block20;
                        }
                        catch (FileNotFoundException e) {
                            BluetoothService.access$500("FileNotFoundException: in copyAutoPairingData");
                            var7_6 = null;
                            try {
                                if (in != null) {
                                    in.close();
                                }
                                if (out == null) return;
                                out.close();
                                return;
                            }
                            catch (IOException e) {
                                return;
                            }
                        }
                        catch (IOException e) {
                            BluetoothService.access$500("IOException: in copyAutoPairingData");
                            var7_7 = null;
                            try {}
                            catch (IOException e) {
                                return;
                            }
                            if (in != null) {
                                in.close();
                            }
                            if (out == null) return;
                            out.close();
                            return;
                        }
                    }
                    catch (Throwable var6_18) {
                        var7_8 = null;
                        ** try [egrp 2[TRYBLOCK] [9 : 120->139)] { 
lbl46:
                        // 1 sources

                        if (in != null) {
                            in.close();
                        }
                        if (out == null) throw var6_18;
                        out.close();
                        throw var6_18;
lbl51:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        throw var6_18;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [9 : 120->139)] { 
lbl56:
                // 1 sources

                if (in != null) {
                    in.close();
                }
                if (out == null) return;
                out.close();
                return;
lbl61:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return;
            }
            var7_5 = null;
            try {}
            catch (IOException e) {}
            if (in != null) {
                in.close();
            }
            if (out == null) return;
            out.close();
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void readAutoPairingData() {
            String line;
            if (this.mAutoPairingAddressBlacklist != null) {
                return;
            }
            this.copyAutoPairingData();
            FileInputStream fstream = null;
            fstream = new FileInputStream(DYNAMIC_AUTO_PAIRING_BLACKLIST);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader file = new BufferedReader(new InputStreamReader(in));
            while ((line = file.readLine()) != null) {
                String[] value;
                if ((line = line.trim()).length() == 0 || line.startsWith("//") || (value = line.split("=")) == null || value.length != 2) continue;
                String[] val = value[1].split(",");
                if (value[0].equalsIgnoreCase("AddressBlacklist")) {
                    this.mAutoPairingAddressBlacklist = new ArrayList<String>(Arrays.asList(val));
                    continue;
                }
                if (value[0].equalsIgnoreCase("ExactNameBlacklist")) {
                    this.mAutoPairingExactNameBlacklist = new ArrayList<String>(Arrays.asList(val));
                    continue;
                }
                if (value[0].equalsIgnoreCase("PartialNameBlacklist")) {
                    this.mAutoPairingPartialNameBlacklist = new ArrayList<String>(Arrays.asList(val));
                    continue;
                }
                if (value[0].equalsIgnoreCase("DynamicAddressBlacklist")) {
                    this.mAutoPairingDynamicAddressBlacklist = new ArrayList<String>(Arrays.asList(val));
                    continue;
                }
                Log.e(BluetoothService.TAG, "Error parsing Auto pairing blacklist file");
            }
            Object var8_9 = null;
            if (fstream == null) return;
            try {
                fstream.close();
                return;
            }
            catch (IOException e2) {}
            return;
            {
                catch (FileNotFoundException e) {
                    BluetoothService.log("FileNotFoundException: readAutoPairingData" + e.toString());
                    Object var8_10 = null;
                    if (fstream == null) return;
                    try {
                        fstream.close();
                        return;
                    }
                    catch (IOException e2) {}
                    return;
                }
                catch (IOException e) {
                    BluetoothService.log("IOException: readAutoPairingData" + e.toString());
                    Object var8_11 = null;
                    if (fstream == null) return;
                    try {
                        fstream.close();
                        return;
                    }
                    catch (IOException e2) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                if (fstream == null) throw throwable;
                try {
                    fstream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void updateAutoPairingData(String address) {
            BufferedWriter out = null;
            out = new BufferedWriter(new FileWriter(DYNAMIC_AUTO_PAIRING_BLACKLIST, true));
            StringBuilder str = new StringBuilder();
            if (this.mAutoPairingDynamicAddressBlacklist.size() == 0) {
                str.append("DynamicAddressBlacklist=");
            }
            str.append(address);
            str.append(",");
            out.write(str.toString());
            Object var5_6 = null;
            if (out == null) return;
            try {
                out.close();
                return;
            }
            catch (IOException e2) {}
            return;
            {
                catch (FileNotFoundException e) {
                    BluetoothService.log("FileNotFoundException: updateAutoPairingData" + e.toString());
                    Object var5_7 = null;
                    if (out == null) return;
                    try {
                        out.close();
                        return;
                    }
                    catch (IOException e2) {}
                    return;
                }
                catch (IOException e) {
                    BluetoothService.log("IOException: updateAutoPairingData" + e.toString());
                    Object var5_8 = null;
                    if (out == null) return;
                    try {
                        out.close();
                        return;
                    }
                    catch (IOException e2) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                if (out == null) throw throwable;
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private class EnableThread
    extends Thread {
        private final boolean mSaveSetting;

        public EnableThread(boolean saveSetting) {
            this.mSaveSetting = saveSetting;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            boolean res;
            block16: {
                boolean bl = res = BluetoothService.this.enableNative() == 0;
                if (res) {
                    int retryCount = 2;
                    boolean running = false;
                    block6: while (retryCount-- > 0 && !running) {
                        BluetoothService.this.mEventLoop.start();
                        int pollCount = 5;
                        while (pollCount-- > 0 && !running) {
                            if (BluetoothService.this.mEventLoop.isEventLoopRunning()) {
                                running = true;
                                continue block6;
                            }
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {}
                        }
                    }
                    if (!running) {
                        BluetoothService.log("bt EnableThread giving up");
                        res = false;
                        BluetoothService.this.disableNative();
                    }
                }
                if (res) {
                    if (!BluetoothService.this.setupNativeDataNative()) {
                        return;
                    }
                    if (this.mSaveSetting) {
                        BluetoothService.this.persistBluetoothOnSetting(true);
                    }
                    BluetoothService.this.mIsDiscovering = false;
                    BluetoothService.this.mBondState.readAutoPairingData();
                    BluetoothService.this.mBondState.loadBondState();
                    BluetoothService.this.initProfileState();
                    BluetoothService.this.mHandler.sendMessageDelayed(BluetoothService.this.mHandler.obtainMessage(1, 1, -1), 3000L);
                    long ident = Binder.clearCallingIdentity();
                    try {
                        try {
                            BluetoothService.this.mBatteryStats.noteBluetoothOn();
                        }
                        catch (RemoteException e) {
                            Object var7_10 = null;
                            Binder.restoreCallingIdentity(ident);
                            break block16;
                        }
                        Object var7_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        Binder.restoreCallingIdentity(ident);
                        throw throwable;
                    }
                    Binder.restoreCallingIdentity(ident);
                }
            }
            BluetoothService.this.mEnableThread = null;
            BluetoothService.this.setBluetoothState(res ? 12 : 10);
            if (res) {
                String[] propVal = new String[]{"Pairable", BluetoothService.this.getProperty("Pairable")};
                BluetoothService.this.mEventLoop.onPropertyChanged(propVal);
            }
            if (BluetoothService.this.mIsAirplaneSensitive && BluetoothService.this.isAirplaneModeOn() && !BluetoothService.this.mIsAirplaneToggleable) {
                BluetoothService.this.disable(false);
            }
        }
    }

    private static class RemoteService {
        public String address;
        public ParcelUuid uuid;

        public RemoteService(String address, ParcelUuid uuid) {
            this.address = address;
            this.uuid = uuid;
        }

        public boolean equals(Object o) {
            if (o instanceof RemoteService) {
                RemoteService service = (RemoteService)o;
                return this.address.equals(service.address) && this.uuid.equals(service.uuid);
            }
            return false;
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 31 + (this.address == null ? 0 : this.address.hashCode());
            hash = hash * 31 + (this.uuid == null ? 0 : this.uuid.hashCode());
            return hash;
        }
    }
}

