/*
 * Decompiled with CFR 0.152.
 */
package android.server;

import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothUuid;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.os.ParcelUuid;
import android.server.BluetoothService;
import android.util.Log;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BluetoothEventLoop {
    private static final String TAG = "BluetoothEventLoop";
    private static final boolean DBG = false;
    private int mNativeData;
    private Thread mThread;
    private boolean mStarted;
    private boolean mInterrupted;
    private final HashMap<String, Integer> mPasskeyAgentRequestData;
    private final HashMap<String, Integer> mAuthorizationAgentRequestData;
    private final BluetoothService mBluetoothService;
    private final BluetoothAdapter mAdapter;
    private final Context mContext;
    private static final int EVENT_RESTART_BLUETOOTH = 1;
    private static final int EVENT_PAIRING_CONSENT_DELAYED_ACCEPT = 2;
    private static final int EVENT_AGENT_CANCEL = 3;
    private static final int CREATE_DEVICE_ALREADY_EXISTS = 1;
    private static final int CREATE_DEVICE_SUCCESS = 0;
    private static final int CREATE_DEVICE_FAILED = -1;
    private static final String BLUETOOTH_ADMIN_PERM = "android.permission.BLUETOOTH_ADMIN";
    private static final String BLUETOOTH_PERM = "android.permission.BLUETOOTH";
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            String address = null;
            switch (msg.what) {
                case 1: {
                    BluetoothEventLoop.this.mBluetoothService.restart();
                    break;
                }
                case 2: {
                    address = (String)msg.obj;
                    if (address == null) break;
                    BluetoothEventLoop.this.mBluetoothService.setPairingConfirmation(address, true);
                    break;
                }
                case 3: {
                    String[] devices = BluetoothEventLoop.this.mBluetoothService.listInState(11);
                    if (devices.length == 0) break;
                    if (devices.length > 1) {
                        Log.e(BluetoothEventLoop.TAG, " There is more than one device in the Bonding State");
                        break;
                    }
                    address = devices[0];
                    BluetoothEventLoop.this.mBluetoothService.setBondState(address, 10, 8);
                }
            }
        }
    };

    private static native void classInitNative();

    BluetoothEventLoop(Context context, BluetoothAdapter adapter, BluetoothService bluetoothService) {
        this.mBluetoothService = bluetoothService;
        this.mContext = context;
        this.mPasskeyAgentRequestData = new HashMap();
        this.mAuthorizationAgentRequestData = new HashMap();
        this.mAdapter = adapter;
        this.initializeNativeDataNative();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.cleanupNativeDataNative();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    HashMap<String, Integer> getPasskeyAgentRequestData() {
        return this.mPasskeyAgentRequestData;
    }

    HashMap<String, Integer> getAuthorizationAgentRequestData() {
        return this.mAuthorizationAgentRequestData;
    }

    void start() {
        if (!this.isEventLoopRunningNative()) {
            this.startEventLoopNative();
        }
    }

    public void stop() {
        if (this.isEventLoopRunningNative()) {
            this.stopEventLoopNative();
        }
    }

    public boolean isEventLoopRunning() {
        return this.isEventLoopRunningNative();
    }

    private void addDevice(String address, String[] properties) {
        this.mBluetoothService.addRemoteDeviceProperties(address, properties);
        String rssi = this.mBluetoothService.getRemoteDeviceProperty(address, "RSSI");
        String classValue = this.mBluetoothService.getRemoteDeviceProperty(address, "Class");
        String name = this.mBluetoothService.getRemoteDeviceProperty(address, "Name");
        short rssiValue = rssi != null ? (short)((short)Integer.valueOf(rssi).intValue()) : (short)Short.MIN_VALUE;
        if (classValue != null) {
            Intent intent = new Intent("android.bluetooth.device.action.FOUND");
            intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(address));
            intent.putExtra("android.bluetooth.device.extra.CLASS", new BluetoothClass(Integer.valueOf(classValue)));
            intent.putExtra("android.bluetooth.device.extra.RSSI", rssiValue);
            intent.putExtra("android.bluetooth.device.extra.NAME", name);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
        } else {
            BluetoothEventLoop.log("ClassValue: " + classValue + " for remote device: " + address + " is null");
        }
    }

    private void onDeviceFound(String address, String[] properties) {
        if (properties == null) {
            Log.e(TAG, "ERROR: Remote device properties are null");
            return;
        }
        this.addDevice(address, properties);
    }

    private void onDeviceDisappeared(String address) {
        Intent intent = new Intent("android.bluetooth.device.action.DISAPPEARED");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(address));
        this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
    }

    private void onDeviceDisconnectRequested(String deviceObjectPath) {
        String address = this.mBluetoothService.getAddressFromObjectPath(deviceObjectPath);
        if (address == null) {
            Log.e(TAG, "onDeviceDisconnectRequested: Address of the remote device in null");
            return;
        }
        Intent intent = new Intent("android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(address));
        this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
    }

    private void onCreatePairedDeviceResult(String address, int result) {
        address = address.toUpperCase();
        this.mBluetoothService.onCreatePairedDeviceResult(address, result);
    }

    private void onDeviceCreated(String deviceObjectPath) {
        String[] properties;
        String address = this.mBluetoothService.getAddressFromObjectPath(deviceObjectPath);
        if (!this.mBluetoothService.isRemoteDeviceInCache(address) && (properties = this.mBluetoothService.getRemoteDeviceProperties(address)) != null) {
            this.addDevice(address, properties);
        }
    }

    private void onDeviceRemoved(String deviceObjectPath) {
        String address = this.mBluetoothService.getAddressFromObjectPath(deviceObjectPath);
        if (address != null) {
            this.mBluetoothService.setBondState(address.toUpperCase(), 10, 9);
            this.mBluetoothService.setRemoteDeviceProperty(address, "UUIDs", null);
        }
    }

    void onPropertyChanged(String[] propValues) {
        String name;
        if (this.mBluetoothService.isAdapterPropertiesEmpty()) {
            this.mBluetoothService.getAllProperties();
        }
        if ((name = propValues[0]).equals("Name")) {
            this.mBluetoothService.setProperty(name, propValues[1]);
            Intent intent = new Intent("android.bluetooth.adapter.action.LOCAL_NAME_CHANGED");
            intent.putExtra("android.bluetooth.adapter.extra.LOCAL_NAME", propValues[1]);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
        } else if (name.equals("Pairable") || name.equals("Discoverable")) {
            String discoverable;
            String pairable = name.equals("Pairable") ? propValues[1] : this.mBluetoothService.getPropertyInternal("Pairable");
            String string2 = discoverable = name.equals("Discoverable") ? propValues[1] : this.mBluetoothService.getPropertyInternal("Discoverable");
            if (pairable == null || discoverable == null) {
                return;
            }
            this.mBluetoothService.setProperty(name, propValues[1]);
            int mode = BluetoothService.bluezStringToScanMode(pairable.equals("true"), discoverable.equals("true"));
            if (mode >= 0) {
                Intent intent = new Intent("android.bluetooth.adapter.action.SCAN_MODE_CHANGED");
                intent.putExtra("android.bluetooth.adapter.extra.SCAN_MODE", mode);
                intent.addFlags(0x10000000);
                this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
            }
        } else if (name.equals("Discovering")) {
            Intent intent;
            this.mBluetoothService.setProperty(name, propValues[1]);
            if (propValues[1].equals("true")) {
                this.mBluetoothService.setIsDiscovering(true);
                intent = new Intent("android.bluetooth.adapter.action.DISCOVERY_STARTED");
            } else {
                this.mBluetoothService.cancelDiscovery();
                this.mBluetoothService.setIsDiscovering(false);
                intent = new Intent("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
            }
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
        } else if (name.equals("Devices")) {
            String value = null;
            int len = Integer.valueOf(propValues[1]);
            if (len > 0) {
                StringBuilder str = new StringBuilder();
                for (int i = 2; i < propValues.length; ++i) {
                    str.append(propValues[i]);
                    str.append(",");
                }
                value = str.toString();
            }
            this.mBluetoothService.setProperty(name, value);
        } else if (name.equals("Powered") && propValues[1].equals("true")) {
            this.onRestartRequired();
        }
    }

    private void onDevicePropertyChanged(String deviceObjectPath, String[] propValues) {
        String name = propValues[0];
        String address = this.mBluetoothService.getAddressFromObjectPath(deviceObjectPath);
        if (address == null) {
            Log.e(TAG, "onDevicePropertyChanged: Address of the remote device in null");
            return;
        }
        BluetoothDevice device = this.mAdapter.getRemoteDevice(address);
        if (name.equals("Name")) {
            this.mBluetoothService.setRemoteDeviceProperty(address, name, propValues[1]);
            Intent intent = new Intent("android.bluetooth.device.action.NAME_CHANGED");
            intent.putExtra("android.bluetooth.device.extra.DEVICE", device);
            intent.putExtra("android.bluetooth.device.extra.NAME", propValues[1]);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
        } else if (name.equals("Class")) {
            this.mBluetoothService.setRemoteDeviceProperty(address, name, propValues[1]);
            Intent intent = new Intent("android.bluetooth.device.action.CLASS_CHANGED");
            intent.putExtra("android.bluetooth.device.extra.DEVICE", device);
            intent.putExtra("android.bluetooth.device.extra.CLASS", new BluetoothClass(Integer.valueOf(propValues[1])));
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
        } else if (name.equals("Connected")) {
            this.mBluetoothService.setRemoteDeviceProperty(address, name, propValues[1]);
            Intent intent = null;
            if (propValues[1].equals("true")) {
                intent = new Intent("android.bluetooth.device.action.ACL_CONNECTED");
                if (this.mBluetoothService.isBluetoothDock(address)) {
                    this.mBluetoothService.setLinkTimeout(address, 8000);
                }
            } else {
                intent = new Intent("android.bluetooth.device.action.ACL_DISCONNECTED");
            }
            intent.putExtra("android.bluetooth.device.extra.DEVICE", device);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
        } else if (name.equals("UUIDs")) {
            String uuid = null;
            int len = Integer.valueOf(propValues[1]);
            if (len > 0) {
                StringBuilder str = new StringBuilder();
                for (int i = 2; i < propValues.length; ++i) {
                    str.append(propValues[i]);
                    str.append(",");
                }
                uuid = str.toString();
            }
            this.mBluetoothService.setRemoteDeviceProperty(address, name, uuid);
            this.mBluetoothService.updateDeviceServiceChannelCache(address);
            this.mBluetoothService.sendUuidIntent(address);
        } else if (name.equals("Paired")) {
            if (propValues[1].equals("true")) {
                if (null == this.mBluetoothService.getPendingOutgoingBonding()) {
                    this.mBluetoothService.setBondState(address, 12);
                }
            } else {
                this.mBluetoothService.setBondState(address, 10);
                this.mBluetoothService.setRemoteDeviceProperty(address, "Trusted", "false");
            }
        } else if (name.equals("Trusted")) {
            this.mBluetoothService.setRemoteDeviceProperty(address, name, propValues[1]);
        }
    }

    private String checkPairingRequestAndGetAddress(String objectPath, int nativeData) {
        String address = this.mBluetoothService.getAddressFromObjectPath(objectPath);
        if (address == null) {
            Log.e(TAG, "Unable to get device address in checkPairingRequestAndGetAddress, returning null");
            return null;
        }
        address = address.toUpperCase();
        this.mPasskeyAgentRequestData.put(address, new Integer(nativeData));
        if (this.mBluetoothService.getBluetoothState() == 13) {
            this.mBluetoothService.cancelPairingUserInput(address);
            return null;
        }
        if (this.mBluetoothService.getBondState(address) != 12) {
            this.mBluetoothService.setBondState(address, 11);
        }
        return address;
    }

    private void onRequestPairingConsent(String objectPath, int nativeData) {
        String address = this.checkPairingRequestAndGetAddress(objectPath, nativeData);
        if (address == null) {
            return;
        }
        if (this.mBluetoothService.getBondState(address) == 12) {
            Message message = this.mHandler.obtainMessage(2);
            message.obj = address;
            this.mHandler.sendMessageDelayed(message, 1500L);
            return;
        }
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(address));
        intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 3);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
    }

    private void onRequestPasskeyConfirmation(String objectPath, int passkey, int nativeData) {
        String address = this.checkPairingRequestAndGetAddress(objectPath, nativeData);
        if (address == null) {
            return;
        }
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(address));
        intent.putExtra("android.bluetooth.device.extra.PASSKEY", passkey);
        intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 2);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
    }

    private void onRequestPasskey(String objectPath, int nativeData) {
        String address = this.checkPairingRequestAndGetAddress(objectPath, nativeData);
        if (address == null) {
            return;
        }
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(address));
        intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 1);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
    }

    private void onRequestPinCode(String objectPath, int nativeData) {
        String address = this.checkPairingRequestAndGetAddress(objectPath, nativeData);
        if (address == null) {
            return;
        }
        String pendingOutgoingAddress = this.mBluetoothService.getPendingOutgoingBonding();
        if (address.equals(pendingOutgoingAddress)) {
            if (this.mBluetoothService.isBluetoothDock(address)) {
                String pin = this.mBluetoothService.getDockPin();
                this.mBluetoothService.setPin(address, BluetoothDevice.convertPinToBytes(pin));
                return;
            }
            BluetoothClass btClass = new BluetoothClass(this.mBluetoothService.getRemoteClass(address));
            switch (btClass.getDeviceClass()) {
                case 1028: 
                case 1032: 
                case 1048: 
                case 1052: 
                case 1056: 
                case 1064: {
                    if (!this.mBluetoothService.attemptAutoPair(address)) break;
                    return;
                }
            }
        }
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(address));
        intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 0);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
    }

    private void onDisplayPasskey(String objectPath, int passkey, int nativeData) {
        String address = this.checkPairingRequestAndGetAddress(objectPath, nativeData);
        if (address == null) {
            return;
        }
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(address));
        intent.putExtra("android.bluetooth.device.extra.PASSKEY", passkey);
        intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 4);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
    }

    private void onRequestOobData(String objectPath, int nativeData) {
        String address = this.checkPairingRequestAndGetAddress(objectPath, nativeData);
        if (address == null) {
            return;
        }
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(address));
        intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 5);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
    }

    private void onAgentAuthorize(String objectPath, String deviceUuid, int nativeData) {
        String address = this.mBluetoothService.getAddressFromObjectPath(objectPath);
        if (address == null) {
            Log.e(TAG, "Unable to get device address in onAuthAgentAuthorize");
            return;
        }
        boolean authorized = false;
        ParcelUuid uuid = ParcelUuid.fromString(deviceUuid);
        BluetoothA2dp a2dp = new BluetoothA2dp(this.mContext);
        BluetoothDevice device = this.mAdapter.getRemoteDevice(address);
        this.mAuthorizationAgentRequestData.put(address, new Integer(nativeData));
        if (this.mBluetoothService.isEnabled() && (BluetoothUuid.isAudioSource(uuid) || BluetoothUuid.isAvrcpTarget(uuid) || BluetoothUuid.isAdvAudioDist(uuid)) && !this.isOtherSinkInNonDisconnectingState(address)) {
            boolean bl = authorized = a2dp.getSinkPriority(device) > 0;
            if (authorized) {
                Log.i(TAG, "First check pass for incoming A2DP / AVRCP connection from " + address);
                if (!BluetoothUuid.isAvrcpTarget(uuid)) {
                    this.mBluetoothService.notifyIncomingA2dpConnection(address);
                } else {
                    a2dp.allowIncomingConnect(device, authorized);
                }
            } else {
                Log.i(TAG, "Rejecting incoming A2DP / AVRCP connection from " + address);
            }
        } else {
            Log.i(TAG, "Rejecting incoming " + deviceUuid + " connection from " + address);
        }
        BluetoothEventLoop.log("onAgentAuthorize(" + objectPath + ", " + deviceUuid + ") = " + authorized);
        if (!authorized) {
            a2dp.allowIncomingConnect(device, authorized);
        }
    }

    private boolean onAgentOutOfBandDataAvailable(String objectPath) {
        if (!this.mBluetoothService.isEnabled()) {
            return false;
        }
        String address = this.mBluetoothService.getAddressFromObjectPath(objectPath);
        if (address == null) {
            return false;
        }
        return this.mBluetoothService.getDeviceOutOfBandData(this.mAdapter.getRemoteDevice(address)) != null;
    }

    private boolean isOtherSinkInNonDisconnectingState(String address) {
        BluetoothA2dp a2dp = new BluetoothA2dp(this.mContext);
        Set<BluetoothDevice> devices = a2dp.getNonDisconnectedSinks();
        if (devices.size() == 0) {
            return false;
        }
        for (BluetoothDevice dev : devices) {
            if (dev.getAddress().equals(address)) continue;
            return true;
        }
        return false;
    }

    private void onAgentCancel() {
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_CANCEL");
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(3), 1500L);
    }

    private void onDiscoverServicesResult(String deviceObjectPath, boolean result) {
        String address = this.mBluetoothService.getAddressFromObjectPath(deviceObjectPath);
        if (result) {
            this.mBluetoothService.updateRemoteDevicePropertiesCache(address);
        }
        this.mBluetoothService.sendUuidIntent(address);
        this.mBluetoothService.makeServiceChannelCallbacks(address);
    }

    private void onCreateDeviceResult(String address, int result) {
        switch (result) {
            case 1: {
                String path = this.mBluetoothService.getObjectPathFromAddress(address);
                if (path != null) {
                    this.mBluetoothService.discoverServicesNative(path, "");
                    break;
                }
                Log.w(TAG, "Device exists, but we dont have the bluez path, failing");
            }
            case -1: {
                this.mBluetoothService.sendUuidIntent(address);
                this.mBluetoothService.makeServiceChannelCallbacks(address);
                break;
            }
        }
    }

    private void onRestartRequired() {
        if (this.mBluetoothService.isEnabled()) {
            Log.e(TAG, "*** A serious error occurred (did bluetoothd crash?) - restarting Bluetooth ***");
            this.mHandler.sendEmptyMessage(1);
        }
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    private native void initializeNativeDataNative();

    private native void startEventLoopNative();

    private native void stopEventLoopNative();

    private native boolean isEventLoopRunningNative();

    private native void cleanupNativeDataNative();

    static {
        BluetoothEventLoop.classInitNative();
    }
}

