/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.res.Resources;
import android.renderscript.RenderScript;
import android.renderscript.Script;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class ScriptC
extends Script {
    private static final String TAG = "ScriptC";

    ScriptC(int id2, RenderScript rs) {
        super(id2, rs);
    }

    public static class Builder
    extends Script.Builder {
        byte[] mProgram;
        int mProgramLength;
        HashMap<String, Integer> mIntDefines = new HashMap();
        HashMap<String, Float> mFloatDefines = new HashMap();

        public Builder(RenderScript rs) {
            super(rs);
        }

        public void setScript(String s) {
            try {
                this.mProgram = s.getBytes("UTF-8");
                this.mProgramLength = this.mProgram.length;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setScript(Resources resources, int id2) {
            InputStream is = resources.openRawResource(id2);
            try {
                try {
                    this.setScript(is);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new Resources.NotFoundException();
            }
        }

        public void setScript(InputStream is) throws IOException {
            byte[] buf = new byte[1024];
            int currentPos = 0;
            while (true) {
                int bytesRead;
                int bytesLeft;
                if ((bytesLeft = buf.length - currentPos) == 0) {
                    byte[] buf2 = new byte[buf.length * 2];
                    System.arraycopy(buf, 0, buf2, 0, buf.length);
                    buf = buf2;
                    bytesLeft = buf.length - currentPos;
                }
                if ((bytesRead = is.read(buf, currentPos, bytesLeft)) <= 0) break;
                currentPos += bytesRead;
            }
            this.mProgram = buf;
            this.mProgramLength = currentPos;
        }

        static synchronized ScriptC internalCreate(Builder b) {
            b.mRS.nScriptCBegin();
            b.transferCreate();
            for (Map.Entry<String, Integer> entry : b.mIntDefines.entrySet()) {
                b.mRS.nScriptCAddDefineI32(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Number> entry : b.mFloatDefines.entrySet()) {
                b.mRS.nScriptCAddDefineF(entry.getKey(), ((Float)entry.getValue()).floatValue());
            }
            b.mRS.nScriptCSetScript(b.mProgram, 0, b.mProgramLength);
            int id2 = b.mRS.nScriptCCreate();
            ScriptC scriptC = new ScriptC(id2, b.mRS);
            b.transferObject(scriptC);
            return scriptC;
        }

        public void addDefine(String name, int value) {
            this.mIntDefines.put(name, value);
        }

        public void addDefine(String name, float value) {
            this.mFloatDefines.put(name, Float.valueOf(value));
        }

        public void addDefines(Class cl) {
            this.addDefines(cl.getFields(), 25, null);
        }

        public void addDefines(Object o) {
            this.addDefines(o.getClass().getFields(), 1, o);
        }

        void addDefines(Field[] fields, int mask, Object o) {
            for (Field f : fields) {
                try {
                    if ((f.getModifiers() & mask) != mask) continue;
                    Class<?> t = f.getType();
                    if (t == Integer.TYPE) {
                        this.mIntDefines.put(f.getName(), f.getInt(o));
                        continue;
                    }
                    if (t != Float.TYPE) continue;
                    this.mFloatDefines.put(f.getName(), Float.valueOf(f.getFloat(o)));
                }
                catch (IllegalAccessException ex) {
                    Log.d(ScriptC.TAG, "addDefines skipping field " + f.getName());
                }
            }
        }

        public ScriptC create() {
            return Builder.internalCreate(this);
        }
    }
}

