/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.RenderScript;

public class ProgramRaster
extends BaseObj {
    boolean mPointSmooth;
    boolean mLineSmooth;
    boolean mPointSprite;
    float mPointSize;
    float mLineWidth;
    Element mIn;
    Element mOut;

    ProgramRaster(int id2, RenderScript rs) {
        super(rs);
        this.mID = id2;
        this.mPointSize = 1.0f;
        this.mLineWidth = 1.0f;
        this.mPointSmooth = false;
        this.mLineSmooth = false;
        this.mPointSprite = false;
    }

    public void setLineWidth(float w) {
        this.mRS.validate();
        this.mLineWidth = w;
        this.mRS.nProgramRasterSetLineWidth(this.mID, w);
    }

    public void setPointSize(float s) {
        this.mRS.validate();
        this.mPointSize = s;
        this.mRS.nProgramRasterSetPointSize(this.mID, s);
    }

    void internalInit() {
        int inID = 0;
        int outID = 0;
        if (this.mIn != null) {
            inID = this.mIn.mID;
        }
        if (this.mOut != null) {
            outID = this.mOut.mID;
        }
        this.mID = this.mRS.nProgramRasterCreate(inID, outID, this.mPointSmooth, this.mLineSmooth, this.mPointSprite);
    }

    public static class Builder {
        RenderScript mRS;
        ProgramRaster mPR;

        public Builder(RenderScript rs, Element in, Element out) {
            this.mRS = rs;
            this.mPR = new ProgramRaster(0, rs);
        }

        public void setPointSpriteEnable(boolean enable) {
            this.mPR.mPointSprite = enable;
        }

        public void setPointSmoothEnable(boolean enable) {
            this.mPR.mPointSmooth = enable;
        }

        public void setLineSmoothEnable(boolean enable) {
            this.mPR.mLineSmooth = enable;
        }

        static synchronized ProgramRaster internalCreate(RenderScript rs, Builder b) {
            b.mPR.internalInit();
            ProgramRaster pr = b.mPR;
            b.mPR = new ProgramRaster(0, b.mRS);
            return pr;
        }

        public ProgramRaster create() {
            this.mRS.validate();
            return Builder.internalCreate(this.mRS, this);
        }
    }
}

