/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

public class Matrix4f {
    final float[] mMat = new float[16];

    public Matrix4f() {
        this.loadIdentity();
    }

    public float get(int i, int j) {
        return this.mMat[i * 4 + j];
    }

    public void set(int i, int j, float v) {
        this.mMat[i * 4 + j] = v;
    }

    public void loadIdentity() {
        this.mMat[0] = 1.0f;
        this.mMat[1] = 0.0f;
        this.mMat[2] = 0.0f;
        this.mMat[3] = 0.0f;
        this.mMat[4] = 0.0f;
        this.mMat[5] = 1.0f;
        this.mMat[6] = 0.0f;
        this.mMat[7] = 0.0f;
        this.mMat[8] = 0.0f;
        this.mMat[9] = 0.0f;
        this.mMat[10] = 1.0f;
        this.mMat[11] = 0.0f;
        this.mMat[12] = 0.0f;
        this.mMat[13] = 0.0f;
        this.mMat[14] = 0.0f;
        this.mMat[15] = 1.0f;
    }

    public void load(Matrix4f src) {
        System.arraycopy(this.mMat, 0, src, 0, 16);
    }

    public void loadRotate(float rot, float x, float y, float z) {
        this.mMat[3] = 0.0f;
        this.mMat[7] = 0.0f;
        this.mMat[11] = 0.0f;
        this.mMat[12] = 0.0f;
        this.mMat[13] = 0.0f;
        this.mMat[14] = 0.0f;
        this.mMat[15] = 1.0f;
        float c = (float)Math.cos(rot *= (float)Math.PI / 180);
        float s = (float)Math.sin(rot);
        float len = (float)Math.sqrt(x * x + y * y + z * z);
        if (len == 1.0f) {
            float recipLen = 1.0f / len;
            x *= recipLen;
            y *= recipLen;
            z *= recipLen;
        }
        float nc = 1.0f - c;
        float xy = x * y;
        float yz = y * z;
        float zx = z * x;
        float xs = x * s;
        float ys = y * s;
        float zs = z * s;
        this.mMat[0] = x * x * nc + c;
        this.mMat[4] = xy * nc - zs;
        this.mMat[8] = zx * nc + ys;
        this.mMat[1] = xy * nc + zs;
        this.mMat[5] = y * y * nc + c;
        this.mMat[9] = yz * nc - xs;
        this.mMat[2] = zx * nc - ys;
        this.mMat[6] = yz * nc + xs;
        this.mMat[10] = z * z * nc + c;
    }

    public void loadScale(float x, float y, float z) {
        this.loadIdentity();
        this.mMat[0] = x;
        this.mMat[5] = y;
        this.mMat[10] = z;
    }

    public void loadTranslate(float x, float y, float z) {
        this.loadIdentity();
        this.mMat[12] = x;
        this.mMat[13] = y;
        this.mMat[14] = z;
    }

    public void loadMultiply(Matrix4f lhs, Matrix4f rhs) {
        for (int i = 0; i < 4; ++i) {
            float ri0 = 0.0f;
            float ri1 = 0.0f;
            float ri2 = 0.0f;
            float ri3 = 0.0f;
            for (int j = 0; j < 4; ++j) {
                float rhs_ij = rhs.get(i, j);
                ri0 += lhs.get(j, 0) * rhs_ij;
                ri1 += lhs.get(j, 1) * rhs_ij;
                ri2 += lhs.get(j, 2) * rhs_ij;
                ri3 += lhs.get(j, 3) * rhs_ij;
            }
            this.set(i, 0, ri0);
            this.set(i, 1, ri1);
            this.set(i, 2, ri2);
            this.set(i, 3, ri3);
        }
    }

    public void loadOrtho(float l, float r, float b, float t, float n, float f) {
        this.loadIdentity();
        this.mMat[0] = 2.0f / (r - l);
        this.mMat[5] = 2.0f / (t - b);
        this.mMat[10] = -2.0f / (f - n);
        this.mMat[12] = -(r + l) / (r - l);
        this.mMat[13] = -(t + b) / (t - b);
        this.mMat[14] = -(f + n) / (f - n);
    }

    public void loadFrustum(float l, float r, float b, float t, float n, float f) {
        this.loadIdentity();
        this.mMat[0] = 2.0f * n / (r - l);
        this.mMat[5] = 2.0f * n / (t - b);
        this.mMat[8] = (r + l) / (r - l);
        this.mMat[9] = (t + b) / (t - b);
        this.mMat[10] = -(f + n) / (f - n);
        this.mMat[11] = -1.0f;
        this.mMat[14] = -2.0f * f * n / (f - n);
        this.mMat[15] = 0.0f;
    }

    public void multiply(Matrix4f rhs) {
        Matrix4f tmp = new Matrix4f();
        tmp.loadMultiply(this, rhs);
        this.load(tmp);
    }

    public void rotate(float rot, float x, float y, float z) {
        Matrix4f tmp = new Matrix4f();
        tmp.loadRotate(rot, x, y, z);
        this.multiply(tmp);
    }

    public void scale(float x, float y, float z) {
        Matrix4f tmp = new Matrix4f();
        tmp.loadScale(x, y, z);
        this.multiply(tmp);
    }

    public void translate(float x, float y, float z) {
        Matrix4f tmp = new Matrix4f();
        tmp.loadTranslate(x, y, z);
        this.multiply(tmp);
    }
}

