/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.pim.vcard.VCardInterpreter;
import android.text.TextUtils;
import android.util.Log;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCardSourceDetector
implements VCardInterpreter {
    private static final String LOG_TAG = "VCardSourceDetector";
    private static Set<String> APPLE_SIGNS = new HashSet<String>(Arrays.asList("X-PHONETIC-FIRST-NAME", "X-PHONETIC-MIDDLE-NAME", "X-PHONETIC-LAST-NAME", "X-ABADR", "X-ABUID"));
    private static Set<String> JAPANESE_MOBILE_PHONE_SIGNS = new HashSet<String>(Arrays.asList("X-GNO", "X-GN", "X-REDUCTION"));
    private static Set<String> WINDOWS_MOBILE_PHONE_SIGNS = new HashSet<String>(Arrays.asList("X-MICROSOFT-ASST_TEL", "X-MICROSOFT-ASSISTANT", "X-MICROSOFT-OFFICELOC"));
    private static Set<String> FOMA_SIGNS = new HashSet<String>(Arrays.asList("X-SD-VERN", "X-SD-FORMAT_VER", "X-SD-CATEGORIES", "X-SD-CLASS", "X-SD-DCREATED", "X-SD-DESCRIPTION"));
    private static String TYPE_FOMA_CHARSET_SIGN = "X-SD-CHAR_CODE";
    public static final int PARSE_TYPE_UNKNOWN = 0;
    private static final int PARSE_TYPE_APPLE = 1;
    private static final int PARSE_TYPE_MOBILE_PHONE_JP = 2;
    private static final int PARSE_TYPE_DOCOMO_TORELATE_NEST = 3;
    private static final int PARSE_TYPE_WINDOWS_MOBILE_V65_JP = 4;
    private int mParseType = 0;
    private boolean mNeedToParseVersion = false;
    private int mVersion = -1;
    private boolean mNeedToParseCharset;
    private String mSpecifiedCharset;

    @Override
    public void start() {
    }

    @Override
    public void end() {
    }

    @Override
    public void startEntry() {
    }

    @Override
    public void startProperty() {
        this.mNeedToParseCharset = false;
        this.mNeedToParseVersion = false;
    }

    @Override
    public void endProperty() {
    }

    @Override
    public void endEntry() {
    }

    @Override
    public void propertyGroup(String group) {
    }

    @Override
    public void propertyName(String name) {
        if (name.equalsIgnoreCase("VERSION")) {
            this.mNeedToParseVersion = true;
            return;
        }
        if (name.equalsIgnoreCase(TYPE_FOMA_CHARSET_SIGN)) {
            this.mParseType = 3;
            this.mNeedToParseCharset = true;
            return;
        }
        if (this.mParseType != 0) {
            return;
        }
        if (WINDOWS_MOBILE_PHONE_SIGNS.contains(name)) {
            this.mParseType = 4;
        } else if (FOMA_SIGNS.contains(name)) {
            this.mParseType = 3;
        } else if (JAPANESE_MOBILE_PHONE_SIGNS.contains(name)) {
            this.mParseType = 2;
        } else if (APPLE_SIGNS.contains(name)) {
            this.mParseType = 1;
        }
    }

    @Override
    public void propertyParamType(String type) {
    }

    @Override
    public void propertyParamValue(String value) {
    }

    @Override
    public void propertyValues(List<String> values) {
        if (this.mNeedToParseVersion && values.size() > 0) {
            String versionString = values.get(0);
            if (versionString.equals("2.1")) {
                this.mVersion = 0;
            } else if (versionString.equals("3.0")) {
                this.mVersion = 1;
            } else if (versionString.equals("4.0")) {
                this.mVersion = 2;
            } else {
                Log.w(LOG_TAG, "Invalid version string: " + versionString);
            }
        } else if (this.mNeedToParseCharset && values.size() > 0) {
            this.mSpecifiedCharset = values.get(0);
        }
    }

    public int getEstimatedType() {
        switch (this.mParseType) {
            case 3: {
                return 956301320;
            }
            case 2: {
                return 0x18000008;
            }
        }
        if (this.mVersion == 0) {
            return -1073741824;
        }
        if (this.mVersion == 1) {
            return -1073741823;
        }
        if (this.mVersion == 2) {
            return -1073741822;
        }
        return 0;
    }

    public String getEstimatedCharset() {
        if (TextUtils.isEmpty(this.mSpecifiedCharset)) {
            return this.mSpecifiedCharset;
        }
        switch (this.mParseType) {
            case 2: 
            case 3: 
            case 4: {
                return "SHIFT_JIS";
            }
            case 1: {
                return "UTF-8";
            }
        }
        return null;
    }
}

