/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.accounts.Account;
import android.pim.vcard.VCardEntry;
import android.pim.vcard.VCardEntryHandler;
import android.pim.vcard.VCardInterpreter;
import android.pim.vcard.VCardUtils;
import android.text.TextUtils;
import android.util.Base64;
import android.util.CharsetUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCardEntryConstructor
implements VCardInterpreter {
    private static String LOG_TAG = "VCardEntryConstructor";
    private VCardEntry.Property mCurrentProperty = new VCardEntry.Property();
    private VCardEntry mCurrentVCardEntry;
    private String mParamType;
    private final String mSourceCharset;
    private final boolean mStrictLineBreaking;
    private final int mVCardType;
    private final Account mAccount;
    private long mTimePushIntoContentResolver;
    private final List<VCardEntryHandler> mEntryHandlers = new ArrayList<VCardEntryHandler>();

    public VCardEntryConstructor() {
        this(-1073741824, null);
    }

    public VCardEntryConstructor(int vcardType) {
        this(vcardType, null, null, false);
    }

    public VCardEntryConstructor(int vcardType, Account account) {
        this(vcardType, account, null, false);
    }

    public VCardEntryConstructor(int vcardType, Account account, String inputCharset) {
        this(vcardType, account, inputCharset, false);
    }

    public VCardEntryConstructor(int vcardType, Account account, String inputCharset, boolean strictLineBreakParsing) {
        this.mSourceCharset = inputCharset != null ? inputCharset : "ISO-8859-1";
        this.mStrictLineBreaking = strictLineBreakParsing;
        this.mVCardType = vcardType;
        this.mAccount = account;
    }

    public void addEntryHandler(VCardEntryHandler entryHandler) {
        this.mEntryHandlers.add(entryHandler);
    }

    @Override
    public void start() {
        for (VCardEntryHandler entryHandler : this.mEntryHandlers) {
            entryHandler.onStart();
        }
    }

    @Override
    public void end() {
        for (VCardEntryHandler entryHandler : this.mEntryHandlers) {
            entryHandler.onEnd();
        }
    }

    public void clear() {
        this.mCurrentVCardEntry = null;
        this.mCurrentProperty = new VCardEntry.Property();
    }

    @Override
    public void startEntry() {
        if (this.mCurrentVCardEntry != null) {
            Log.e(LOG_TAG, "Nested VCard code is not supported now.");
        }
        this.mCurrentVCardEntry = new VCardEntry(this.mVCardType, this.mAccount);
    }

    @Override
    public void endEntry() {
        this.mCurrentVCardEntry.consolidateFields();
        for (VCardEntryHandler entryHandler : this.mEntryHandlers) {
            entryHandler.onEntryCreated(this.mCurrentVCardEntry);
        }
        this.mCurrentVCardEntry = null;
    }

    @Override
    public void startProperty() {
        this.mCurrentProperty.clear();
    }

    @Override
    public void endProperty() {
        this.mCurrentVCardEntry.addProperty(this.mCurrentProperty);
    }

    @Override
    public void propertyName(String name) {
        this.mCurrentProperty.setPropertyName(name);
    }

    @Override
    public void propertyGroup(String group) {
    }

    @Override
    public void propertyParamType(String type) {
        if (this.mParamType != null) {
            Log.e(LOG_TAG, "propertyParamType() is called more than once before propertyParamValue() is called");
        }
        this.mParamType = type;
    }

    @Override
    public void propertyParamValue(String value) {
        if (this.mParamType == null) {
            this.mParamType = "TYPE";
        }
        if (!VCardUtils.containsOnlyAlphaDigitHyphen(value)) {
            value = VCardUtils.convertStringCharset(value, this.mSourceCharset, "UTF-8");
        }
        this.mCurrentProperty.addParameter(this.mParamType, value);
        this.mParamType = null;
    }

    private String handleOneValue(String value, String sourceCharset, String targetCharset, String encoding) {
        if (TextUtils.isEmpty(value)) {
            return "";
        }
        if (encoding != null) {
            if (encoding.equals("BASE64") || encoding.equals("B")) {
                this.mCurrentProperty.setPropertyBytes(Base64.decode(value.getBytes(), 0));
                return value;
            }
            if (encoding.equals("QUOTED-PRINTABLE")) {
                return VCardUtils.parseQuotedPrintable(value, this.mStrictLineBreaking, sourceCharset, targetCharset);
            }
            Log.w(LOG_TAG, "Unknown encoding. Fall back to default.");
        }
        return VCardUtils.convertStringCharset(value, sourceCharset, targetCharset);
    }

    @Override
    public void propertyValues(List<String> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        Collection<String> charsetCollection = this.mCurrentProperty.getParameters("CHARSET");
        Collection<String> encodingCollection = this.mCurrentProperty.getParameters("ENCODING");
        String encoding = encodingCollection != null ? encodingCollection.iterator().next() : null;
        String targetCharset = CharsetUtils.nameForDefaultVendor(charsetCollection != null ? charsetCollection.iterator().next() : null);
        if (TextUtils.isEmpty(targetCharset)) {
            targetCharset = "UTF-8";
        }
        for (String value : values) {
            this.mCurrentProperty.addToPropertyValueList(this.handleOneValue(value, this.mSourceCharset, targetCharset, encoding));
        }
    }

    public void showPerformanceInfo() {
        Log.d(LOG_TAG, "time for insert ContactStruct to database: " + this.mTimePushIntoContentResolver + " ms");
    }
}

