/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.content.ContentValues;
import android.pim.vcard.VCardConfig;
import android.pim.vcard.VCardUtils;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.util.Base64;
import android.util.CharsetUtils;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCardBuilder {
    private static final String LOG_TAG = "VCardBuilder";
    private static final Set<String> sAllowedAndroidPropertySet = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("vnd.android.cursor.item/nickname", "vnd.android.cursor.item/contact_event", "vnd.android.cursor.item/relation")));
    public static final int DEFAULT_PHONE_TYPE = 1;
    public static final int DEFAULT_POSTAL_TYPE = 1;
    public static final int DEFAULT_EMAIL_TYPE = 3;
    private static final String VCARD_DATA_VCARD = "VCARD";
    private static final String VCARD_DATA_PUBLIC = "PUBLIC";
    private static final String VCARD_PARAM_SEPARATOR = ";";
    private static final String VCARD_END_OF_LINE = "\r\n";
    private static final String VCARD_DATA_SEPARATOR = ":";
    private static final String VCARD_ITEM_SEPARATOR = ";";
    private static final String VCARD_WS = " ";
    private static final String VCARD_PARAM_EQUAL = "=";
    private static final String VCARD_PARAM_ENCODING_QP = "ENCODING=QUOTED-PRINTABLE";
    private static final String VCARD_PARAM_ENCODING_BASE64_V21 = "ENCODING=BASE64";
    private static final String VCARD_PARAM_ENCODING_BASE64_AS_B = "ENCODING=B";
    private static final String SHIFT_JIS = "SHIFT_JIS";
    private final int mVCardType;
    private final boolean mIsV30OrV40;
    private final boolean mIsJapaneseMobilePhone;
    private final boolean mOnlyOneNoteFieldIsAvailable;
    private final boolean mIsDoCoMo;
    private final boolean mShouldUseQuotedPrintable;
    private final boolean mUsesAndroidProperty;
    private final boolean mUsesDefactProperty;
    private final boolean mAppendTypeParamName;
    private final boolean mRefrainsQPToNameProperties;
    private final boolean mNeedsToConvertPhoneticString;
    private final boolean mShouldAppendCharsetParam;
    private final String mCharset;
    private final String mVCardCharsetParameter;
    private StringBuilder mBuilder;
    private boolean mEndAppended;
    private static final Map<Integer, Integer> sPostalTypePriorityMap = new HashMap<Integer, Integer>();

    public VCardBuilder(int vcardType) {
        this(vcardType, null);
    }

    public VCardBuilder(int vcardType, String charset) {
        this.mVCardType = vcardType;
        if (VCardConfig.isVersion40(vcardType)) {
            Log.w(LOG_TAG, "Should not use vCard 4.0 when building vCard. It is not officially published yet.");
        }
        this.mIsV30OrV40 = VCardConfig.isVersion30(vcardType) || VCardConfig.isVersion40(vcardType);
        this.mShouldUseQuotedPrintable = VCardConfig.shouldUseQuotedPrintable(vcardType);
        this.mIsDoCoMo = VCardConfig.isDoCoMo(vcardType);
        this.mIsJapaneseMobilePhone = VCardConfig.needsToConvertPhoneticString(vcardType);
        this.mOnlyOneNoteFieldIsAvailable = VCardConfig.onlyOneNoteFieldIsAvailable(vcardType);
        this.mUsesAndroidProperty = VCardConfig.usesAndroidSpecificProperty(vcardType);
        this.mUsesDefactProperty = VCardConfig.usesDefactProperty(vcardType);
        this.mRefrainsQPToNameProperties = VCardConfig.shouldRefrainQPToNameProperties(vcardType);
        this.mAppendTypeParamName = VCardConfig.appendTypeParamName(vcardType);
        this.mNeedsToConvertPhoneticString = VCardConfig.needsToConvertPhoneticString(vcardType);
        boolean bl = this.mShouldAppendCharsetParam = !VCardConfig.isVersion30(vcardType) || !"UTF-8".equalsIgnoreCase(charset);
        if (VCardConfig.isDoCoMo(vcardType)) {
            if (!SHIFT_JIS.equalsIgnoreCase(charset)) {
                Log.w(LOG_TAG, "The charset \"" + charset + "\" is used while " + SHIFT_JIS + " is needed to be used.");
                if (TextUtils.isEmpty(charset)) {
                    this.mCharset = SHIFT_JIS;
                } else {
                    try {
                        charset = CharsetUtils.charsetForVendor(charset).name();
                    }
                    catch (UnsupportedCharsetException e) {
                        Log.i(LOG_TAG, "Career-specific \"" + charset + "\" was not found (as usual). " + "Use it as is.");
                    }
                    this.mCharset = charset;
                }
            } else {
                if (this.mIsDoCoMo) {
                    try {
                        charset = CharsetUtils.charsetForVendor(SHIFT_JIS, "docomo").name();
                    }
                    catch (UnsupportedCharsetException e) {
                        Log.e(LOG_TAG, "DoCoMo-specific SHIFT_JIS was not found. Use SHIFT_JIS as is.");
                        charset = SHIFT_JIS;
                    }
                } else {
                    try {
                        charset = CharsetUtils.charsetForVendor(SHIFT_JIS).name();
                    }
                    catch (UnsupportedCharsetException e) {
                        Log.e(LOG_TAG, "Career-specific SHIFT_JIS was not found. Use SHIFT_JIS as is.");
                        charset = SHIFT_JIS;
                    }
                }
                this.mCharset = charset;
            }
            this.mVCardCharsetParameter = "CHARSET=SHIFT_JIS";
        } else if (TextUtils.isEmpty(charset)) {
            Log.i(LOG_TAG, "Use the charset \"UTF-8\" for export.");
            this.mCharset = "UTF-8";
            this.mVCardCharsetParameter = "CHARSET=UTF-8";
        } else {
            try {
                charset = CharsetUtils.charsetForVendor(charset).name();
            }
            catch (UnsupportedCharsetException e) {
                Log.i(LOG_TAG, "Career-specific \"" + charset + "\" was not found (as usual). " + "Use it as is.");
            }
            this.mCharset = charset;
            this.mVCardCharsetParameter = "CHARSET=" + charset;
        }
        this.clear();
    }

    public void clear() {
        this.mBuilder = new StringBuilder();
        this.mEndAppended = false;
        this.appendLine("BEGIN", VCARD_DATA_VCARD);
        if (VCardConfig.isVersion40(this.mVCardType)) {
            this.appendLine("VERSION", "4.0");
        } else if (VCardConfig.isVersion30(this.mVCardType)) {
            this.appendLine("VERSION", "3.0");
        } else {
            if (!VCardConfig.isVersion21(this.mVCardType)) {
                Log.w(LOG_TAG, "Unknown vCard version detected.");
            }
            this.appendLine("VERSION", "2.1");
        }
    }

    private boolean containsNonEmptyName(ContentValues contentValues) {
        String familyName = contentValues.getAsString("data3");
        String middleName = contentValues.getAsString("data5");
        String givenName = contentValues.getAsString("data2");
        String prefix = contentValues.getAsString("data4");
        String suffix = contentValues.getAsString("data6");
        String phoneticFamilyName = contentValues.getAsString("data9");
        String phoneticMiddleName = contentValues.getAsString("data8");
        String phoneticGivenName = contentValues.getAsString("data7");
        String displayName = contentValues.getAsString("data1");
        return !TextUtils.isEmpty(familyName) || !TextUtils.isEmpty(middleName) || !TextUtils.isEmpty(givenName) || !TextUtils.isEmpty(prefix) || !TextUtils.isEmpty(suffix) || !TextUtils.isEmpty(phoneticFamilyName) || !TextUtils.isEmpty(phoneticMiddleName) || !TextUtils.isEmpty(phoneticGivenName) || !TextUtils.isEmpty(displayName);
    }

    private ContentValues getPrimaryContentValue(List<ContentValues> contentValuesList) {
        ContentValues primaryContentValues = null;
        ContentValues subprimaryContentValues = null;
        for (ContentValues contentValues : contentValuesList) {
            if (contentValues == null) continue;
            Integer isSuperPrimary = contentValues.getAsInteger("is_super_primary");
            if (isSuperPrimary != null && isSuperPrimary > 0) {
                primaryContentValues = contentValues;
                break;
            }
            if (primaryContentValues != null) continue;
            Integer isPrimary = contentValues.getAsInteger("is_primary");
            if (isPrimary != null && isPrimary > 0 && this.containsNonEmptyName(contentValues)) {
                primaryContentValues = contentValues;
                continue;
            }
            if (subprimaryContentValues != null || !this.containsNonEmptyName(contentValues)) continue;
            subprimaryContentValues = contentValues;
        }
        if (primaryContentValues == null) {
            if (subprimaryContentValues != null) {
                primaryContentValues = subprimaryContentValues;
            } else {
                Log.e(LOG_TAG, "All ContentValues given from database is empty.");
                primaryContentValues = new ContentValues();
            }
        }
        return primaryContentValues;
    }

    private VCardBuilder appendNamePropertiesV40(List<ContentValues> contentValuesList) {
        if (this.mIsDoCoMo || this.mNeedsToConvertPhoneticString) {
            Log.w(LOG_TAG, "Invalid flag is used in vCard 4.0 construction. Ignored.");
        }
        if (contentValuesList == null || contentValuesList.isEmpty()) {
            this.appendLine("FN", "");
            return this;
        }
        ContentValues contentValues = this.getPrimaryContentValue(contentValuesList);
        String familyName = contentValues.getAsString("data3");
        String middleName = contentValues.getAsString("data5");
        String givenName = contentValues.getAsString("data2");
        String prefix = contentValues.getAsString("data4");
        String suffix = contentValues.getAsString("data6");
        String formattedName = contentValues.getAsString("data1");
        if (TextUtils.isEmpty(familyName) && TextUtils.isEmpty(givenName) && TextUtils.isEmpty(middleName) && TextUtils.isEmpty(prefix) && TextUtils.isEmpty(suffix)) {
            if (TextUtils.isEmpty(formattedName)) {
                this.appendLine("FN", "");
                return this;
            }
            familyName = formattedName;
        }
        String phoneticFamilyName = contentValues.getAsString("data9");
        String phoneticMiddleName = contentValues.getAsString("data8");
        String phoneticGivenName = contentValues.getAsString("data7");
        String escapedFamily = this.escapeCharacters(familyName);
        String escapedGiven = this.escapeCharacters(givenName);
        String escapedMiddle = this.escapeCharacters(middleName);
        String escapedPrefix = this.escapeCharacters(prefix);
        String escapedSuffix = this.escapeCharacters(suffix);
        this.mBuilder.append("N");
        if (!(TextUtils.isEmpty(phoneticFamilyName) && TextUtils.isEmpty(phoneticMiddleName) && TextUtils.isEmpty(phoneticGivenName))) {
            this.mBuilder.append(";");
            String sortAs = this.escapeCharacters(phoneticFamilyName) + ';' + this.escapeCharacters(phoneticGivenName) + ';' + this.escapeCharacters(phoneticMiddleName);
            this.mBuilder.append("SORT-AS=").append(VCardUtils.toStringAsV40ParamValue(sortAs));
        }
        this.mBuilder.append(VCARD_DATA_SEPARATOR);
        this.mBuilder.append(escapedFamily);
        this.mBuilder.append(";");
        this.mBuilder.append(escapedGiven);
        this.mBuilder.append(";");
        this.mBuilder.append(escapedMiddle);
        this.mBuilder.append(";");
        this.mBuilder.append(escapedPrefix);
        this.mBuilder.append(";");
        this.mBuilder.append(escapedSuffix);
        this.mBuilder.append(VCARD_END_OF_LINE);
        if (TextUtils.isEmpty(formattedName)) {
            Log.w(LOG_TAG, "DISPLAY_NAME is empty.");
            String escaped = this.escapeCharacters(VCardUtils.constructNameFromElements(VCardConfig.getNameOrderType(this.mVCardType), familyName, middleName, givenName, prefix, suffix));
            this.appendLine("FN", escaped);
        } else {
            String escapedFormatted = this.escapeCharacters(formattedName);
            this.mBuilder.append("FN");
            this.mBuilder.append(VCARD_DATA_SEPARATOR);
            this.mBuilder.append(escapedFormatted);
            this.mBuilder.append(VCARD_END_OF_LINE);
        }
        this.appendPhoneticNameFields(contentValues);
        return this;
    }

    public VCardBuilder appendNameProperties(List<ContentValues> contentValuesList) {
        if (VCardConfig.isVersion40(this.mVCardType)) {
            return this.appendNamePropertiesV40(contentValuesList);
        }
        if (contentValuesList == null || contentValuesList.isEmpty()) {
            if (VCardConfig.isVersion30(this.mVCardType)) {
                this.appendLine("N", "");
                this.appendLine("FN", "");
            } else if (this.mIsDoCoMo) {
                this.appendLine("N", "");
            }
            return this;
        }
        ContentValues contentValues = this.getPrimaryContentValue(contentValuesList);
        String familyName = contentValues.getAsString("data3");
        String middleName = contentValues.getAsString("data5");
        String givenName = contentValues.getAsString("data2");
        String prefix = contentValues.getAsString("data4");
        String suffix = contentValues.getAsString("data6");
        String displayName = contentValues.getAsString("data1");
        if (!TextUtils.isEmpty(familyName) || !TextUtils.isEmpty(givenName)) {
            String encodedSuffix;
            String encodedPrefix;
            String encodedMiddle;
            String encodedGiven;
            String encodedFamily;
            boolean reallyUseQuotedPrintableToFN;
            boolean reallyAppendCharsetParameterToName = this.shouldAppendCharsetParam(familyName, givenName, middleName, prefix, suffix);
            boolean reallyUseQuotedPrintableToName = !this.mRefrainsQPToNameProperties && (!VCardUtils.containsOnlyNonCrLfPrintableAscii(familyName) || !VCardUtils.containsOnlyNonCrLfPrintableAscii(givenName) || !VCardUtils.containsOnlyNonCrLfPrintableAscii(middleName) || !VCardUtils.containsOnlyNonCrLfPrintableAscii(prefix) || !VCardUtils.containsOnlyNonCrLfPrintableAscii(suffix));
            String formattedName = !TextUtils.isEmpty(displayName) ? displayName : VCardUtils.constructNameFromElements(VCardConfig.getNameOrderType(this.mVCardType), familyName, middleName, givenName, prefix, suffix);
            boolean reallyAppendCharsetParameterToFN = this.shouldAppendCharsetParam(formattedName);
            boolean bl = reallyUseQuotedPrintableToFN = !this.mRefrainsQPToNameProperties && !VCardUtils.containsOnlyNonCrLfPrintableAscii(formattedName);
            if (reallyUseQuotedPrintableToName) {
                encodedFamily = this.encodeQuotedPrintable(familyName);
                encodedGiven = this.encodeQuotedPrintable(givenName);
                encodedMiddle = this.encodeQuotedPrintable(middleName);
                encodedPrefix = this.encodeQuotedPrintable(prefix);
                encodedSuffix = this.encodeQuotedPrintable(suffix);
            } else {
                encodedFamily = this.escapeCharacters(familyName);
                encodedGiven = this.escapeCharacters(givenName);
                encodedMiddle = this.escapeCharacters(middleName);
                encodedPrefix = this.escapeCharacters(prefix);
                encodedSuffix = this.escapeCharacters(suffix);
            }
            String encodedFormattedname = reallyUseQuotedPrintableToFN ? this.encodeQuotedPrintable(formattedName) : this.escapeCharacters(formattedName);
            this.mBuilder.append("N");
            if (this.mIsDoCoMo) {
                if (reallyAppendCharsetParameterToName) {
                    this.mBuilder.append(";");
                    this.mBuilder.append(this.mVCardCharsetParameter);
                }
                if (reallyUseQuotedPrintableToName) {
                    this.mBuilder.append(";");
                    this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
                }
                this.mBuilder.append(VCARD_DATA_SEPARATOR);
                this.mBuilder.append(formattedName);
                this.mBuilder.append(";");
                this.mBuilder.append(";");
                this.mBuilder.append(";");
                this.mBuilder.append(";");
            } else {
                if (reallyAppendCharsetParameterToName) {
                    this.mBuilder.append(";");
                    this.mBuilder.append(this.mVCardCharsetParameter);
                }
                if (reallyUseQuotedPrintableToName) {
                    this.mBuilder.append(";");
                    this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
                }
                this.mBuilder.append(VCARD_DATA_SEPARATOR);
                this.mBuilder.append(encodedFamily);
                this.mBuilder.append(";");
                this.mBuilder.append(encodedGiven);
                this.mBuilder.append(";");
                this.mBuilder.append(encodedMiddle);
                this.mBuilder.append(";");
                this.mBuilder.append(encodedPrefix);
                this.mBuilder.append(";");
                this.mBuilder.append(encodedSuffix);
            }
            this.mBuilder.append(VCARD_END_OF_LINE);
            this.mBuilder.append("FN");
            if (reallyAppendCharsetParameterToFN) {
                this.mBuilder.append(";");
                this.mBuilder.append(this.mVCardCharsetParameter);
            }
            if (reallyUseQuotedPrintableToFN) {
                this.mBuilder.append(";");
                this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
            }
            this.mBuilder.append(VCARD_DATA_SEPARATOR);
            this.mBuilder.append(encodedFormattedname);
            this.mBuilder.append(VCARD_END_OF_LINE);
        } else if (!TextUtils.isEmpty(displayName)) {
            boolean reallyUseQuotedPrintableToDisplayName = !this.mRefrainsQPToNameProperties && !VCardUtils.containsOnlyNonCrLfPrintableAscii(displayName);
            String encodedDisplayName = reallyUseQuotedPrintableToDisplayName ? this.encodeQuotedPrintable(displayName) : this.escapeCharacters(displayName);
            this.mBuilder.append("N");
            if (this.shouldAppendCharsetParam(displayName)) {
                this.mBuilder.append(";");
                this.mBuilder.append(this.mVCardCharsetParameter);
            }
            if (reallyUseQuotedPrintableToDisplayName) {
                this.mBuilder.append(";");
                this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
            }
            this.mBuilder.append(VCARD_DATA_SEPARATOR);
            this.mBuilder.append(encodedDisplayName);
            this.mBuilder.append(";");
            this.mBuilder.append(";");
            this.mBuilder.append(";");
            this.mBuilder.append(";");
            this.mBuilder.append(VCARD_END_OF_LINE);
            this.mBuilder.append("FN");
            if (this.shouldAppendCharsetParam(displayName)) {
                this.mBuilder.append(";");
                this.mBuilder.append(this.mVCardCharsetParameter);
            }
            this.mBuilder.append(VCARD_DATA_SEPARATOR);
            this.mBuilder.append(encodedDisplayName);
            this.mBuilder.append(VCARD_END_OF_LINE);
        } else if (VCardConfig.isVersion30(this.mVCardType)) {
            this.appendLine("N", "");
            this.appendLine("FN", "");
        } else if (this.mIsDoCoMo) {
            this.appendLine("N", "");
        }
        this.appendPhoneticNameFields(contentValues);
        return this;
    }

    private void appendPhoneticNameFields(ContentValues contentValues) {
        String encodedPhoneticFamilyName;
        String phoneticGivenName;
        String phoneticMiddleName;
        String phoneticFamilyName;
        String tmpPhoneticFamilyName = contentValues.getAsString("data9");
        String tmpPhoneticMiddleName = contentValues.getAsString("data8");
        String tmpPhoneticGivenName = contentValues.getAsString("data7");
        if (this.mNeedsToConvertPhoneticString) {
            phoneticFamilyName = VCardUtils.toHalfWidthString(tmpPhoneticFamilyName);
            phoneticMiddleName = VCardUtils.toHalfWidthString(tmpPhoneticMiddleName);
            phoneticGivenName = VCardUtils.toHalfWidthString(tmpPhoneticGivenName);
        } else {
            phoneticFamilyName = tmpPhoneticFamilyName;
            phoneticMiddleName = tmpPhoneticMiddleName;
            phoneticGivenName = tmpPhoneticGivenName;
        }
        if (TextUtils.isEmpty(phoneticFamilyName) && TextUtils.isEmpty(phoneticMiddleName) && TextUtils.isEmpty(phoneticGivenName)) {
            if (this.mIsDoCoMo) {
                this.mBuilder.append("SOUND");
                this.mBuilder.append(";");
                this.mBuilder.append("X-IRMC-N");
                this.mBuilder.append(VCARD_DATA_SEPARATOR);
                this.mBuilder.append(";");
                this.mBuilder.append(";");
                this.mBuilder.append(";");
                this.mBuilder.append(";");
                this.mBuilder.append(VCARD_END_OF_LINE);
            }
            return;
        }
        if (!VCardConfig.isVersion40(this.mVCardType)) {
            if (VCardConfig.isVersion30(this.mVCardType)) {
                String sortString = VCardUtils.constructNameFromElements(this.mVCardType, phoneticFamilyName, phoneticMiddleName, phoneticGivenName);
                this.mBuilder.append("SORT-STRING");
                if (VCardConfig.isVersion30(this.mVCardType) && this.shouldAppendCharsetParam(sortString)) {
                    this.mBuilder.append(";");
                    this.mBuilder.append(this.mVCardCharsetParameter);
                }
                this.mBuilder.append(VCARD_DATA_SEPARATOR);
                this.mBuilder.append(this.escapeCharacters(sortString));
                this.mBuilder.append(VCARD_END_OF_LINE);
            } else if (this.mIsJapaneseMobilePhone) {
                String encodedPhoneticGivenName;
                String encodedPhoneticMiddleName;
                boolean reallyUseQuotedPrintable;
                this.mBuilder.append("SOUND");
                this.mBuilder.append(";");
                this.mBuilder.append("X-IRMC-N");
                boolean bl = reallyUseQuotedPrintable = !this.mRefrainsQPToNameProperties && (!VCardUtils.containsOnlyNonCrLfPrintableAscii(phoneticFamilyName) || !VCardUtils.containsOnlyNonCrLfPrintableAscii(phoneticMiddleName) || !VCardUtils.containsOnlyNonCrLfPrintableAscii(phoneticGivenName));
                if (reallyUseQuotedPrintable) {
                    encodedPhoneticFamilyName = this.encodeQuotedPrintable(phoneticFamilyName);
                    encodedPhoneticMiddleName = this.encodeQuotedPrintable(phoneticMiddleName);
                    encodedPhoneticGivenName = this.encodeQuotedPrintable(phoneticGivenName);
                } else {
                    encodedPhoneticFamilyName = this.escapeCharacters(phoneticFamilyName);
                    encodedPhoneticMiddleName = this.escapeCharacters(phoneticMiddleName);
                    encodedPhoneticGivenName = this.escapeCharacters(phoneticGivenName);
                }
                if (this.shouldAppendCharsetParam(encodedPhoneticFamilyName, encodedPhoneticMiddleName, encodedPhoneticGivenName)) {
                    this.mBuilder.append(";");
                    this.mBuilder.append(this.mVCardCharsetParameter);
                }
                this.mBuilder.append(VCARD_DATA_SEPARATOR);
                boolean first = true;
                if (!TextUtils.isEmpty(encodedPhoneticFamilyName)) {
                    this.mBuilder.append(encodedPhoneticFamilyName);
                    first = false;
                }
                if (!TextUtils.isEmpty(encodedPhoneticMiddleName)) {
                    if (first) {
                        first = false;
                    } else {
                        this.mBuilder.append(' ');
                    }
                    this.mBuilder.append(encodedPhoneticMiddleName);
                }
                if (!TextUtils.isEmpty(encodedPhoneticGivenName)) {
                    if (!first) {
                        this.mBuilder.append(' ');
                    }
                    this.mBuilder.append(encodedPhoneticGivenName);
                }
                this.mBuilder.append(";");
                this.mBuilder.append(";");
                this.mBuilder.append(";");
                this.mBuilder.append(";");
                this.mBuilder.append(VCARD_END_OF_LINE);
            }
        }
        Log.d("@@@", "hoge");
        if (this.mUsesDefactProperty) {
            if (!TextUtils.isEmpty(phoneticGivenName)) {
                boolean reallyUseQuotedPrintable = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(phoneticGivenName);
                String encodedPhoneticGivenName = reallyUseQuotedPrintable ? this.encodeQuotedPrintable(phoneticGivenName) : this.escapeCharacters(phoneticGivenName);
                this.mBuilder.append("X-PHONETIC-FIRST-NAME");
                if (this.shouldAppendCharsetParam(phoneticGivenName)) {
                    this.mBuilder.append(";");
                    this.mBuilder.append(this.mVCardCharsetParameter);
                }
                if (reallyUseQuotedPrintable) {
                    this.mBuilder.append(";");
                    this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
                }
                this.mBuilder.append(VCARD_DATA_SEPARATOR);
                this.mBuilder.append(encodedPhoneticGivenName);
                this.mBuilder.append(VCARD_END_OF_LINE);
            }
            if (!TextUtils.isEmpty(phoneticMiddleName)) {
                boolean reallyUseQuotedPrintable = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(phoneticMiddleName);
                String encodedPhoneticMiddleName = reallyUseQuotedPrintable ? this.encodeQuotedPrintable(phoneticMiddleName) : this.escapeCharacters(phoneticMiddleName);
                this.mBuilder.append("X-PHONETIC-MIDDLE-NAME");
                if (this.shouldAppendCharsetParam(phoneticMiddleName)) {
                    this.mBuilder.append(";");
                    this.mBuilder.append(this.mVCardCharsetParameter);
                }
                if (reallyUseQuotedPrintable) {
                    this.mBuilder.append(";");
                    this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
                }
                this.mBuilder.append(VCARD_DATA_SEPARATOR);
                this.mBuilder.append(encodedPhoneticMiddleName);
                this.mBuilder.append(VCARD_END_OF_LINE);
            }
            if (!TextUtils.isEmpty(phoneticFamilyName)) {
                boolean reallyUseQuotedPrintable = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(phoneticFamilyName);
                encodedPhoneticFamilyName = reallyUseQuotedPrintable ? this.encodeQuotedPrintable(phoneticFamilyName) : this.escapeCharacters(phoneticFamilyName);
                this.mBuilder.append("X-PHONETIC-LAST-NAME");
                if (this.shouldAppendCharsetParam(phoneticFamilyName)) {
                    this.mBuilder.append(";");
                    this.mBuilder.append(this.mVCardCharsetParameter);
                }
                if (reallyUseQuotedPrintable) {
                    this.mBuilder.append(";");
                    this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
                }
                this.mBuilder.append(VCARD_DATA_SEPARATOR);
                this.mBuilder.append(encodedPhoneticFamilyName);
                this.mBuilder.append(VCARD_END_OF_LINE);
            }
        }
    }

    public VCardBuilder appendNickNames(List<ContentValues> contentValuesList) {
        boolean useAndroidProperty;
        if (this.mIsV30OrV40) {
            useAndroidProperty = false;
        } else if (this.mUsesAndroidProperty) {
            useAndroidProperty = true;
        } else {
            return this;
        }
        if (contentValuesList != null) {
            for (ContentValues contentValues : contentValuesList) {
                String nickname = contentValues.getAsString("data1");
                if (TextUtils.isEmpty(nickname)) continue;
                if (useAndroidProperty) {
                    this.appendAndroidSpecificProperty("vnd.android.cursor.item/nickname", contentValues);
                    continue;
                }
                this.appendLineWithCharsetAndQPDetection("NICKNAME", nickname);
            }
        }
        return this;
    }

    public VCardBuilder appendPhones(List<ContentValues> contentValuesList) {
        boolean phoneLineExists = false;
        if (contentValuesList != null) {
            HashSet<String> phoneSet = new HashSet<String>();
            for (ContentValues contentValues : contentValuesList) {
                int type;
                Integer typeAsObject = contentValues.getAsInteger("data2");
                String label = contentValues.getAsString("data3");
                Integer isPrimaryAsInteger = contentValues.getAsInteger("is_primary");
                boolean isPrimary = isPrimaryAsInteger != null ? isPrimaryAsInteger > 0 : false;
                String phoneNumber = contentValues.getAsString("data1");
                if (phoneNumber != null) {
                    phoneNumber = phoneNumber.trim();
                }
                if (TextUtils.isEmpty(phoneNumber)) continue;
                int n = type = typeAsObject != null ? typeAsObject : 1;
                if (type == 6 || VCardConfig.refrainPhoneNumberFormatting(this.mVCardType)) {
                    phoneLineExists = true;
                    if (phoneSet.contains(phoneNumber)) continue;
                    phoneSet.add(phoneNumber);
                    this.appendTelLine(type, label, phoneNumber, isPrimary);
                    continue;
                }
                List<String> phoneNumberList = this.splitAndTrimPhoneNumbers(phoneNumber);
                if (phoneNumberList.isEmpty()) continue;
                phoneLineExists = true;
                for (String actualPhoneNumber : phoneNumberList) {
                    if (phoneSet.contains(actualPhoneNumber)) continue;
                    int format = VCardUtils.getPhoneNumberFormat(this.mVCardType);
                    String formattedPhoneNumber = PhoneNumberUtils.formatNumber(actualPhoneNumber, format);
                    phoneSet.add(actualPhoneNumber);
                    this.appendTelLine(type, label, formattedPhoneNumber, isPrimary);
                }
            }
        }
        if (!phoneLineExists && this.mIsDoCoMo) {
            this.appendTelLine(1, "", "", false);
        }
        return this;
    }

    private List<String> splitAndTrimPhoneNumbers(String phoneNumber) {
        ArrayList<String> phoneList = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        int length = phoneNumber.length();
        for (int i = 0; i < length; ++i) {
            char ch = phoneNumber.charAt(i);
            if (Character.isDigit(ch) || ch == '+') {
                builder.append(ch);
                continue;
            }
            if (ch != ';' && ch != '\n' || builder.length() <= 0) continue;
            phoneList.add(builder.toString());
            builder = new StringBuilder();
        }
        if (builder.length() > 0) {
            phoneList.add(builder.toString());
        }
        return phoneList;
    }

    public VCardBuilder appendEmails(List<ContentValues> contentValuesList) {
        boolean emailAddressExists = false;
        if (contentValuesList != null) {
            HashSet<String> addressSet = new HashSet<String>();
            for (ContentValues contentValues : contentValuesList) {
                String emailAddress = contentValues.getAsString("data1");
                if (emailAddress != null) {
                    emailAddress = emailAddress.trim();
                }
                if (TextUtils.isEmpty(emailAddress)) continue;
                Integer typeAsObject = contentValues.getAsInteger("data2");
                int type = typeAsObject != null ? typeAsObject : 3;
                String label = contentValues.getAsString("data3");
                Integer isPrimaryAsInteger = contentValues.getAsInteger("is_primary");
                boolean isPrimary = isPrimaryAsInteger != null ? isPrimaryAsInteger > 0 : false;
                emailAddressExists = true;
                if (addressSet.contains(emailAddress)) continue;
                addressSet.add(emailAddress);
                this.appendEmailLine(type, label, emailAddress, isPrimary);
            }
        }
        if (!emailAddressExists && this.mIsDoCoMo) {
            this.appendEmailLine(1, "", "", false);
        }
        return this;
    }

    public VCardBuilder appendPostals(List<ContentValues> contentValuesList) {
        if (contentValuesList == null || contentValuesList.isEmpty()) {
            if (this.mIsDoCoMo) {
                this.mBuilder.append("ADR");
                this.mBuilder.append(";");
                this.mBuilder.append("HOME");
                this.mBuilder.append(VCARD_DATA_SEPARATOR);
                this.mBuilder.append(VCARD_END_OF_LINE);
            }
        } else if (this.mIsDoCoMo) {
            this.appendPostalsForDoCoMo(contentValuesList);
        } else {
            this.appendPostalsForGeneric(contentValuesList);
        }
        return this;
    }

    private void appendPostalsForDoCoMo(List<ContentValues> contentValuesList) {
        int currentPriority = Integer.MAX_VALUE;
        int currentType = Integer.MAX_VALUE;
        ContentValues currentContentValues = null;
        for (ContentValues contentValues : contentValuesList) {
            Integer typeAsInteger;
            Integer priorityAsInteger;
            int priority;
            if (contentValues == null || (priority = (priorityAsInteger = sPostalTypePriorityMap.get(typeAsInteger = contentValues.getAsInteger("data2"))) != null ? priorityAsInteger : Integer.MAX_VALUE) >= currentPriority) continue;
            currentPriority = priority;
            currentType = typeAsInteger;
            currentContentValues = contentValues;
            if (priority != 0) continue;
            break;
        }
        if (currentContentValues == null) {
            Log.w(LOG_TAG, "Should not come here. Must have at least one postal data.");
            return;
        }
        String label = currentContentValues.getAsString("data3");
        this.appendPostalLine(currentType, label, currentContentValues, false, true);
    }

    private void appendPostalsForGeneric(List<ContentValues> contentValuesList) {
        for (ContentValues contentValues : contentValuesList) {
            if (contentValues == null) continue;
            Integer typeAsInteger = contentValues.getAsInteger("data2");
            int type = typeAsInteger != null ? typeAsInteger : 1;
            String label = contentValues.getAsString("data3");
            Integer isPrimaryAsInteger = contentValues.getAsInteger("is_primary");
            boolean isPrimary = isPrimaryAsInteger != null ? isPrimaryAsInteger > 0 : false;
            this.appendPostalLine(type, label, contentValues, isPrimary, false);
        }
    }

    private PostalStruct tryConstructPostalStruct(ContentValues contentValues) {
        String rawCountry;
        String rawPostalCode;
        String rawRegion;
        String rawLocality;
        String rawStreet;
        String rawNeighborhood;
        String rawPoBox = contentValues.getAsString("data5");
        String[] rawAddressArray = new String[]{rawPoBox, rawNeighborhood = contentValues.getAsString("data6"), rawStreet = contentValues.getAsString("data4"), rawLocality = contentValues.getAsString("data7"), rawRegion = contentValues.getAsString("data8"), rawPostalCode = contentValues.getAsString("data9"), rawCountry = contentValues.getAsString("data10")};
        if (!VCardUtils.areAllEmpty(rawAddressArray)) {
            String encodedCountry;
            String encodedPostalCode;
            String encodedRegion;
            String encodedLocality;
            String encodedStreet;
            String encodedPoBox;
            boolean appendCharset;
            boolean reallyUseQuotedPrintable = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(rawAddressArray);
            boolean bl = appendCharset = !VCardUtils.containsOnlyPrintableAscii(rawAddressArray);
            String rawLocality2 = TextUtils.isEmpty(rawLocality) ? (TextUtils.isEmpty(rawNeighborhood) ? "" : rawNeighborhood) : (TextUtils.isEmpty(rawNeighborhood) ? rawLocality : rawLocality + VCARD_WS + rawNeighborhood);
            if (reallyUseQuotedPrintable) {
                encodedPoBox = this.encodeQuotedPrintable(rawPoBox);
                encodedStreet = this.encodeQuotedPrintable(rawStreet);
                encodedLocality = this.encodeQuotedPrintable(rawLocality2);
                encodedRegion = this.encodeQuotedPrintable(rawRegion);
                encodedPostalCode = this.encodeQuotedPrintable(rawPostalCode);
                encodedCountry = this.encodeQuotedPrintable(rawCountry);
            } else {
                encodedPoBox = this.escapeCharacters(rawPoBox);
                encodedStreet = this.escapeCharacters(rawStreet);
                encodedLocality = this.escapeCharacters(rawLocality2);
                encodedRegion = this.escapeCharacters(rawRegion);
                encodedPostalCode = this.escapeCharacters(rawPostalCode);
                encodedCountry = this.escapeCharacters(rawCountry);
                String string2 = this.escapeCharacters(rawNeighborhood);
            }
            StringBuilder addressBuilder = new StringBuilder();
            addressBuilder.append(encodedPoBox);
            addressBuilder.append(";");
            addressBuilder.append(";");
            addressBuilder.append(encodedStreet);
            addressBuilder.append(";");
            addressBuilder.append(encodedLocality);
            addressBuilder.append(";");
            addressBuilder.append(encodedRegion);
            addressBuilder.append(";");
            addressBuilder.append(encodedPostalCode);
            addressBuilder.append(";");
            addressBuilder.append(encodedCountry);
            return new PostalStruct(reallyUseQuotedPrintable, appendCharset, addressBuilder.toString());
        }
        String rawFormattedAddress = contentValues.getAsString("data1");
        if (TextUtils.isEmpty(rawFormattedAddress)) {
            return null;
        }
        boolean reallyUseQuotedPrintable = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(rawFormattedAddress);
        boolean appendCharset = !VCardUtils.containsOnlyPrintableAscii(rawFormattedAddress);
        String encodedFormattedAddress = reallyUseQuotedPrintable ? this.encodeQuotedPrintable(rawFormattedAddress) : this.escapeCharacters(rawFormattedAddress);
        StringBuilder addressBuilder = new StringBuilder();
        addressBuilder.append(";");
        addressBuilder.append(encodedFormattedAddress);
        addressBuilder.append(";");
        addressBuilder.append(";");
        addressBuilder.append(";");
        addressBuilder.append(";");
        addressBuilder.append(";");
        return new PostalStruct(reallyUseQuotedPrintable, appendCharset, addressBuilder.toString());
    }

    public VCardBuilder appendIms(List<ContentValues> contentValuesList) {
        if (contentValuesList != null) {
            for (ContentValues contentValues : contentValuesList) {
                boolean isPrimary;
                Integer isPrimaryAsInteger;
                String typeAsString;
                String propertyName;
                Integer protocolAsObject = contentValues.getAsInteger("data5");
                if (protocolAsObject == null || (propertyName = VCardUtils.getPropertyNameForIm(protocolAsObject)) == null) continue;
                String data = contentValues.getAsString("data1");
                if (data != null) {
                    data = data.trim();
                }
                if (TextUtils.isEmpty(data)) continue;
                Integer typeAsInteger = contentValues.getAsInteger("data2");
                switch (typeAsInteger != null ? typeAsInteger : 3) {
                    case 1: {
                        typeAsString = "HOME";
                        break;
                    }
                    case 2: {
                        typeAsString = "WORK";
                        break;
                    }
                    case 0: {
                        String label = contentValues.getAsString("data3");
                        typeAsString = label != null ? "X-" + label : null;
                        break;
                    }
                    default: {
                        typeAsString = null;
                    }
                }
                ArrayList<String> parameterList = new ArrayList<String>();
                if (!TextUtils.isEmpty(typeAsString)) {
                    parameterList.add(typeAsString);
                }
                boolean bl = (isPrimaryAsInteger = contentValues.getAsInteger("is_primary")) != null ? isPrimaryAsInteger > 0 : (isPrimary = false);
                if (isPrimary) {
                    parameterList.add("PREF");
                }
                this.appendLineWithCharsetAndQPDetection(propertyName, parameterList, data);
            }
        }
        return this;
    }

    public VCardBuilder appendWebsites(List<ContentValues> contentValuesList) {
        if (contentValuesList != null) {
            for (ContentValues contentValues : contentValuesList) {
                String website = contentValues.getAsString("data1");
                if (website != null) {
                    website = website.trim();
                }
                if (TextUtils.isEmpty(website)) continue;
                this.appendLineWithCharsetAndQPDetection("URL", website);
            }
        }
        return this;
    }

    public VCardBuilder appendOrganizations(List<ContentValues> contentValuesList) {
        if (contentValuesList != null) {
            for (ContentValues contentValues : contentValuesList) {
                String title;
                String department;
                String company = contentValues.getAsString("data1");
                if (company != null) {
                    company = company.trim();
                }
                if ((department = contentValues.getAsString("data5")) != null) {
                    department = department.trim();
                }
                if ((title = contentValues.getAsString("data4")) != null) {
                    title = title.trim();
                }
                StringBuilder orgBuilder = new StringBuilder();
                if (!TextUtils.isEmpty(company)) {
                    orgBuilder.append(company);
                }
                if (!TextUtils.isEmpty(department)) {
                    if (orgBuilder.length() > 0) {
                        orgBuilder.append(';');
                    }
                    orgBuilder.append(department);
                }
                String orgline = orgBuilder.toString();
                this.appendLine("ORG", orgline, !VCardUtils.containsOnlyPrintableAscii(orgline), this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(orgline));
                if (TextUtils.isEmpty(title)) continue;
                this.appendLine("TITLE", title, !VCardUtils.containsOnlyPrintableAscii(title), this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(title));
            }
        }
        return this;
    }

    public VCardBuilder appendPhotos(List<ContentValues> contentValuesList) {
        if (contentValuesList != null) {
            for (ContentValues contentValues : contentValuesList) {
                byte[] data;
                if (contentValues == null || (data = contentValues.getAsByteArray("data15")) == null) continue;
                String photoType = VCardUtils.guessImageType(data);
                if (photoType == null) {
                    Log.d(LOG_TAG, "Unknown photo type. Ignored.");
                    continue;
                }
                String photoString = new String(Base64.encode(data, 2));
                if (TextUtils.isEmpty(photoString)) continue;
                this.appendPhotoLine(photoString, photoType);
            }
        }
        return this;
    }

    public VCardBuilder appendNotes(List<ContentValues> contentValuesList) {
        if (contentValuesList != null) {
            if (this.mOnlyOneNoteFieldIsAvailable) {
                StringBuilder noteBuilder = new StringBuilder();
                boolean first = true;
                for (ContentValues contentValues : contentValuesList) {
                    String note = contentValues.getAsString("data1");
                    if (note == null) {
                        note = "";
                    }
                    if (note.length() <= 0) continue;
                    if (first) {
                        first = false;
                    } else {
                        noteBuilder.append('\n');
                    }
                    noteBuilder.append(note);
                }
                String noteStr = noteBuilder.toString();
                boolean shouldAppendCharsetInfo = !VCardUtils.containsOnlyPrintableAscii(noteStr);
                boolean reallyUseQuotedPrintable = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(noteStr);
                this.appendLine("NOTE", noteStr, shouldAppendCharsetInfo, reallyUseQuotedPrintable);
            } else {
                for (ContentValues contentValues : contentValuesList) {
                    String noteStr = contentValues.getAsString("data1");
                    if (TextUtils.isEmpty(noteStr)) continue;
                    boolean shouldAppendCharsetInfo = !VCardUtils.containsOnlyPrintableAscii(noteStr);
                    boolean reallyUseQuotedPrintable = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(noteStr);
                    this.appendLine("NOTE", noteStr, shouldAppendCharsetInfo, reallyUseQuotedPrintable);
                }
            }
        }
        return this;
    }

    public VCardBuilder appendEvents(List<ContentValues> contentValuesList) {
        if (contentValuesList != null) {
            String primaryBirthday = null;
            String secondaryBirthday = null;
            for (ContentValues contentValues : contentValuesList) {
                if (contentValues == null) continue;
                Integer eventTypeAsInteger = contentValues.getAsInteger("data2");
                int eventType = eventTypeAsInteger != null ? eventTypeAsInteger : 2;
                if (eventType == 3) {
                    boolean isPrimary;
                    boolean isSuperPrimary;
                    String birthdayCandidate = contentValues.getAsString("data1");
                    if (birthdayCandidate == null) continue;
                    Integer isSuperPrimaryAsInteger = contentValues.getAsInteger("is_super_primary");
                    boolean bl = isSuperPrimaryAsInteger != null ? isSuperPrimaryAsInteger > 0 : (isSuperPrimary = false);
                    if (isSuperPrimary) {
                        primaryBirthday = birthdayCandidate;
                        break;
                    }
                    Integer isPrimaryAsInteger = contentValues.getAsInteger("is_primary");
                    boolean bl2 = isPrimaryAsInteger != null ? isPrimaryAsInteger > 0 : (isPrimary = false);
                    if (isPrimary) {
                        primaryBirthday = birthdayCandidate;
                        continue;
                    }
                    if (secondaryBirthday != null) continue;
                    secondaryBirthday = birthdayCandidate;
                    continue;
                }
                if (!this.mUsesAndroidProperty) continue;
                this.appendAndroidSpecificProperty("vnd.android.cursor.item/contact_event", contentValues);
            }
            if (primaryBirthday != null) {
                this.appendLineWithCharsetAndQPDetection("BDAY", primaryBirthday.trim());
            } else if (secondaryBirthday != null) {
                this.appendLineWithCharsetAndQPDetection("BDAY", secondaryBirthday.trim());
            }
        }
        return this;
    }

    public VCardBuilder appendRelation(List<ContentValues> contentValuesList) {
        if (this.mUsesAndroidProperty && contentValuesList != null) {
            for (ContentValues contentValues : contentValuesList) {
                if (contentValues == null) continue;
                this.appendAndroidSpecificProperty("vnd.android.cursor.item/relation", contentValues);
            }
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void appendPostalLine(int type, String label, ContentValues contentValues, boolean isPrimary, boolean emitEveryTime) {
        String addressValue;
        boolean appendCharset;
        boolean reallyUseQuotedPrintable;
        PostalStruct postalStruct = this.tryConstructPostalStruct(contentValues);
        if (postalStruct == null) {
            if (!emitEveryTime) return;
            reallyUseQuotedPrintable = false;
            appendCharset = false;
            addressValue = "";
        } else {
            reallyUseQuotedPrintable = postalStruct.reallyUseQuotedPrintable;
            appendCharset = postalStruct.appendCharset;
            addressValue = postalStruct.addressData;
        }
        ArrayList<String> parameterList = new ArrayList<String>();
        if (isPrimary) {
            parameterList.add("PREF");
        }
        switch (type) {
            case 1: {
                parameterList.add("HOME");
                break;
            }
            case 2: {
                parameterList.add("WORK");
                break;
            }
            case 0: {
                if (TextUtils.isEmpty(label) || !VCardUtils.containsOnlyAlphaDigitHyphen(label)) break;
                parameterList.add("X-" + label);
                break;
            }
            case 3: {
                break;
            }
            default: {
                Log.e(LOG_TAG, "Unknown StructuredPostal type: " + type);
            }
        }
        this.mBuilder.append("ADR");
        if (!parameterList.isEmpty()) {
            this.mBuilder.append(";");
            this.appendTypeParameters(parameterList);
        }
        if (appendCharset) {
            this.mBuilder.append(";");
            this.mBuilder.append(this.mVCardCharsetParameter);
        }
        if (reallyUseQuotedPrintable) {
            this.mBuilder.append(";");
            this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
        }
        this.mBuilder.append(VCARD_DATA_SEPARATOR);
        this.mBuilder.append(addressValue);
        this.mBuilder.append(VCARD_END_OF_LINE);
    }

    public void appendEmailLine(int type, String label, String rawValue, boolean isPrimary) {
        String typeAsString;
        switch (type) {
            case 0: {
                if (VCardUtils.isMobilePhoneLabel(label)) {
                    typeAsString = "CELL";
                    break;
                }
                if (!TextUtils.isEmpty(label) && VCardUtils.containsOnlyAlphaDigitHyphen(label)) {
                    typeAsString = "X-" + label;
                    break;
                }
                typeAsString = null;
                break;
            }
            case 1: {
                typeAsString = "HOME";
                break;
            }
            case 2: {
                typeAsString = "WORK";
                break;
            }
            case 3: {
                typeAsString = null;
                break;
            }
            case 4: {
                typeAsString = "CELL";
                break;
            }
            default: {
                Log.e(LOG_TAG, "Unknown Email type: " + type);
                typeAsString = null;
            }
        }
        ArrayList<String> parameterList = new ArrayList<String>();
        if (isPrimary) {
            parameterList.add("PREF");
        }
        if (!TextUtils.isEmpty(typeAsString)) {
            parameterList.add(typeAsString);
        }
        this.appendLineWithCharsetAndQPDetection("EMAIL", parameterList, rawValue);
    }

    public void appendTelLine(Integer typeAsInteger, String label, String encodedValue, boolean isPrimary) {
        this.mBuilder.append("TEL");
        this.mBuilder.append(";");
        int type = typeAsInteger == null ? 7 : typeAsInteger;
        ArrayList<String> parameterList = new ArrayList<String>();
        switch (type) {
            case 1: {
                parameterList.addAll(Arrays.asList("HOME"));
                break;
            }
            case 3: {
                parameterList.addAll(Arrays.asList("WORK"));
                break;
            }
            case 5: {
                parameterList.addAll(Arrays.asList("HOME", "FAX"));
                break;
            }
            case 4: {
                parameterList.addAll(Arrays.asList("WORK", "FAX"));
                break;
            }
            case 2: {
                parameterList.add("CELL");
                break;
            }
            case 6: {
                if (this.mIsDoCoMo) {
                    parameterList.add("VOICE");
                    break;
                }
                parameterList.add("PAGER");
                break;
            }
            case 7: {
                parameterList.add("VOICE");
                break;
            }
            case 9: {
                parameterList.add("CAR");
                break;
            }
            case 10: {
                parameterList.add("WORK");
                isPrimary = true;
                break;
            }
            case 11: {
                parameterList.add("ISDN");
                break;
            }
            case 12: {
                isPrimary = true;
                break;
            }
            case 13: {
                parameterList.add("FAX");
                break;
            }
            case 15: {
                parameterList.add("TLX");
                break;
            }
            case 17: {
                parameterList.addAll(Arrays.asList("WORK", "CELL"));
                break;
            }
            case 18: {
                parameterList.add("WORK");
                if (this.mIsDoCoMo) {
                    parameterList.add("VOICE");
                    break;
                }
                parameterList.add("PAGER");
                break;
            }
            case 20: {
                parameterList.add("MSG");
                break;
            }
            case 0: {
                if (TextUtils.isEmpty(label)) {
                    parameterList.add("VOICE");
                    break;
                }
                if (VCardUtils.isMobilePhoneLabel(label)) {
                    parameterList.add("CELL");
                    break;
                }
                if (this.mIsV30OrV40) {
                    parameterList.add(label);
                    break;
                }
                String upperLabel = label.toUpperCase();
                if (VCardUtils.isValidInV21ButUnknownToContactsPhoteType(upperLabel)) {
                    parameterList.add(upperLabel);
                    break;
                }
                if (!VCardUtils.containsOnlyAlphaDigitHyphen(label)) break;
                parameterList.add("X-" + label);
                break;
            }
        }
        if (isPrimary) {
            parameterList.add("PREF");
        }
        if (parameterList.isEmpty()) {
            this.appendUncommonPhoneType(this.mBuilder, type);
        } else {
            this.appendTypeParameters(parameterList);
        }
        this.mBuilder.append(VCARD_DATA_SEPARATOR);
        this.mBuilder.append(encodedValue);
        this.mBuilder.append(VCARD_END_OF_LINE);
    }

    private void appendUncommonPhoneType(StringBuilder builder, Integer type) {
        if (this.mIsDoCoMo) {
            builder.append("VOICE");
        } else {
            String phoneType = VCardUtils.getPhoneTypeString(type);
            if (phoneType != null) {
                this.appendTypeParameter(phoneType);
            } else {
                Log.e(LOG_TAG, "Unknown or unsupported (by vCard) Phone type: " + type);
            }
        }
    }

    public void appendPhotoLine(String encodedValue, String photoType) {
        StringBuilder tmpBuilder = new StringBuilder();
        tmpBuilder.append("PHOTO");
        tmpBuilder.append(";");
        if (this.mIsV30OrV40) {
            tmpBuilder.append(VCARD_PARAM_ENCODING_BASE64_AS_B);
        } else {
            tmpBuilder.append(VCARD_PARAM_ENCODING_BASE64_V21);
        }
        tmpBuilder.append(";");
        this.appendTypeParameter(tmpBuilder, photoType);
        tmpBuilder.append(VCARD_DATA_SEPARATOR);
        tmpBuilder.append(encodedValue);
        String tmpStr = tmpBuilder.toString();
        tmpBuilder = new StringBuilder();
        int lineCount = 0;
        int length = tmpStr.length();
        int maxNumForFirstLine = 75 - VCARD_END_OF_LINE.length();
        int maxNumInGeneral = maxNumForFirstLine - VCARD_WS.length();
        int maxNum = maxNumForFirstLine;
        for (int i = 0; i < length; ++i) {
            tmpBuilder.append(tmpStr.charAt(i));
            if (++lineCount <= maxNum) continue;
            tmpBuilder.append(VCARD_END_OF_LINE);
            tmpBuilder.append(VCARD_WS);
            maxNum = maxNumInGeneral;
            lineCount = 0;
        }
        this.mBuilder.append(tmpBuilder.toString());
        this.mBuilder.append(VCARD_END_OF_LINE);
        this.mBuilder.append(VCARD_END_OF_LINE);
    }

    public void appendAndroidSpecificProperty(String mimeType, ContentValues contentValues) {
        if (!sAllowedAndroidPropertySet.contains(mimeType)) {
            return;
        }
        ArrayList<String> rawValueList = new ArrayList<String>();
        for (int i = 1; i <= 15; ++i) {
            String value = contentValues.getAsString("data" + i);
            if (value == null) {
                value = "";
            }
            rawValueList.add(value);
        }
        boolean needCharset = this.mShouldAppendCharsetParam && !VCardUtils.containsOnlyNonCrLfPrintableAscii(rawValueList);
        boolean reallyUseQuotedPrintable = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(rawValueList);
        this.mBuilder.append("X-ANDROID-CUSTOM");
        if (needCharset) {
            this.mBuilder.append(";");
            this.mBuilder.append(this.mVCardCharsetParameter);
        }
        if (reallyUseQuotedPrintable) {
            this.mBuilder.append(";");
            this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
        }
        this.mBuilder.append(VCARD_DATA_SEPARATOR);
        this.mBuilder.append(mimeType);
        for (String rawValue : rawValueList) {
            String encodedValue = reallyUseQuotedPrintable ? this.encodeQuotedPrintable(rawValue) : this.escapeCharacters(rawValue);
            this.mBuilder.append(";");
            this.mBuilder.append(encodedValue);
        }
        this.mBuilder.append(VCARD_END_OF_LINE);
    }

    public void appendLineWithCharsetAndQPDetection(String propertyName, String rawValue) {
        this.appendLineWithCharsetAndQPDetection(propertyName, null, rawValue);
    }

    public void appendLineWithCharsetAndQPDetection(String propertyName, List<String> rawValueList) {
        this.appendLineWithCharsetAndQPDetection(propertyName, null, rawValueList);
    }

    public void appendLineWithCharsetAndQPDetection(String propertyName, List<String> parameterList, String rawValue) {
        boolean needCharset = !VCardUtils.containsOnlyPrintableAscii(rawValue);
        boolean reallyUseQuotedPrintable = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(rawValue);
        this.appendLine(propertyName, parameterList, rawValue, needCharset, reallyUseQuotedPrintable);
    }

    public void appendLineWithCharsetAndQPDetection(String propertyName, List<String> parameterList, List<String> rawValueList) {
        boolean needCharset = this.mShouldAppendCharsetParam && !VCardUtils.containsOnlyNonCrLfPrintableAscii(rawValueList);
        boolean reallyUseQuotedPrintable = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(rawValueList);
        this.appendLine(propertyName, parameterList, rawValueList, needCharset, reallyUseQuotedPrintable);
    }

    public void appendLine(String propertyName, String rawValue) {
        this.appendLine(propertyName, rawValue, false, false);
    }

    public void appendLine(String propertyName, List<String> rawValueList) {
        this.appendLine(propertyName, rawValueList, false, false);
    }

    public void appendLine(String propertyName, String rawValue, boolean needCharset, boolean reallyUseQuotedPrintable) {
        this.appendLine(propertyName, null, rawValue, needCharset, reallyUseQuotedPrintable);
    }

    public void appendLine(String propertyName, List<String> parameterList, String rawValue) {
        this.appendLine(propertyName, parameterList, rawValue, false, false);
    }

    public void appendLine(String propertyName, List<String> parameterList, String rawValue, boolean needCharset, boolean reallyUseQuotedPrintable) {
        String encodedValue;
        this.mBuilder.append(propertyName);
        if (parameterList != null && parameterList.size() > 0) {
            this.mBuilder.append(";");
            this.appendTypeParameters(parameterList);
        }
        if (needCharset) {
            this.mBuilder.append(";");
            this.mBuilder.append(this.mVCardCharsetParameter);
        }
        if (reallyUseQuotedPrintable) {
            this.mBuilder.append(";");
            this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
            encodedValue = this.encodeQuotedPrintable(rawValue);
        } else {
            encodedValue = this.escapeCharacters(rawValue);
        }
        this.mBuilder.append(VCARD_DATA_SEPARATOR);
        this.mBuilder.append(encodedValue);
        this.mBuilder.append(VCARD_END_OF_LINE);
    }

    public void appendLine(String propertyName, List<String> rawValueList, boolean needCharset, boolean needQuotedPrintable) {
        this.appendLine(propertyName, null, rawValueList, needCharset, needQuotedPrintable);
    }

    public void appendLine(String propertyName, List<String> parameterList, List<String> rawValueList, boolean needCharset, boolean needQuotedPrintable) {
        this.mBuilder.append(propertyName);
        if (parameterList != null && parameterList.size() > 0) {
            this.mBuilder.append(";");
            this.appendTypeParameters(parameterList);
        }
        if (needCharset) {
            this.mBuilder.append(";");
            this.mBuilder.append(this.mVCardCharsetParameter);
        }
        if (needQuotedPrintable) {
            this.mBuilder.append(";");
            this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
        }
        this.mBuilder.append(VCARD_DATA_SEPARATOR);
        boolean first = true;
        for (String rawValue : rawValueList) {
            String encodedValue = needQuotedPrintable ? this.encodeQuotedPrintable(rawValue) : this.escapeCharacters(rawValue);
            if (first) {
                first = false;
            } else {
                this.mBuilder.append(";");
            }
            this.mBuilder.append(encodedValue);
        }
        this.mBuilder.append(VCARD_END_OF_LINE);
    }

    private void appendTypeParameters(List<String> types) {
        boolean first = true;
        for (String typeValue : types) {
            if (VCardConfig.isVersion30(this.mVCardType)) {
                String encoded = VCardUtils.toStringAsV30ParamValue(typeValue);
                if (TextUtils.isEmpty(encoded)) continue;
                if (first) {
                    first = false;
                } else {
                    this.mBuilder.append(";");
                }
                this.appendTypeParameter(encoded);
                continue;
            }
            if (!VCardUtils.isV21Word(typeValue)) continue;
            if (first) {
                first = false;
            } else {
                this.mBuilder.append(";");
            }
            this.appendTypeParameter(typeValue);
        }
    }

    private void appendTypeParameter(String type) {
        this.appendTypeParameter(this.mBuilder, type);
    }

    private void appendTypeParameter(StringBuilder builder, String type) {
        if (VCardConfig.isVersion40(this.mVCardType) || (VCardConfig.isVersion30(this.mVCardType) || this.mAppendTypeParamName) && !this.mIsDoCoMo) {
            builder.append("TYPE").append(VCARD_PARAM_EQUAL);
        }
        builder.append(type);
    }

    private boolean shouldAppendCharsetParam(String ... propertyValueList) {
        if (!this.mShouldAppendCharsetParam) {
            return false;
        }
        for (String propertyValue : propertyValueList) {
            if (VCardUtils.containsOnlyPrintableAscii(propertyValue)) continue;
            return true;
        }
        return false;
    }

    private String encodeQuotedPrintable(String str) {
        if (TextUtils.isEmpty(str)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int index = 0;
        int lineCount = 0;
        byte[] strArray = null;
        try {
            strArray = str.getBytes(this.mCharset);
        }
        catch (UnsupportedEncodingException e) {
            Log.e(LOG_TAG, "Charset " + this.mCharset + " cannot be used. " + "Try default charset");
            strArray = str.getBytes();
        }
        while (index < strArray.length) {
            builder.append(String.format("=%02X", strArray[index]));
            ++index;
            if ((lineCount += 3) < 67) continue;
            builder.append("=\r\n");
            lineCount = 0;
        }
        return builder.toString();
    }

    private String escapeCharacters(String unescaped) {
        if (TextUtils.isEmpty(unescaped)) {
            return "";
        }
        StringBuilder tmpBuilder = new StringBuilder();
        int length = unescaped.length();
        block8: for (int i = 0; i < length; ++i) {
            char ch = unescaped.charAt(i);
            switch (ch) {
                case ';': {
                    tmpBuilder.append('\\');
                    tmpBuilder.append(';');
                    continue block8;
                }
                case '\r': {
                    char nextChar;
                    if (i + 1 < length && (nextChar = unescaped.charAt(i)) == '\n') continue block8;
                }
                case '\n': {
                    tmpBuilder.append("\\n");
                    continue block8;
                }
                case '\\': {
                    if (this.mIsV30OrV40) {
                        tmpBuilder.append("\\\\");
                        continue block8;
                    }
                }
                case '<': 
                case '>': {
                    if (this.mIsDoCoMo) {
                        tmpBuilder.append('\\');
                        tmpBuilder.append(ch);
                        continue block8;
                    }
                    tmpBuilder.append(ch);
                    continue block8;
                }
                case ',': {
                    if (this.mIsV30OrV40) {
                        tmpBuilder.append("\\,");
                        continue block8;
                    }
                    tmpBuilder.append(ch);
                    continue block8;
                }
                default: {
                    tmpBuilder.append(ch);
                }
            }
        }
        return tmpBuilder.toString();
    }

    public String toString() {
        if (!this.mEndAppended) {
            if (this.mIsDoCoMo) {
                this.appendLine("X-CLASS", VCARD_DATA_PUBLIC);
                this.appendLine("X-REDUCTION", "");
                this.appendLine("X-NO", "");
                this.appendLine("X-DCM-HMN-MODE", "");
            }
            this.appendLine("END", VCARD_DATA_VCARD);
            this.mEndAppended = true;
        }
        return this.mBuilder.toString();
    }

    static {
        sPostalTypePriorityMap.put(1, 0);
        sPostalTypePriorityMap.put(2, 1);
        sPostalTypePriorityMap.put(3, 2);
        sPostalTypePriorityMap.put(0, 3);
    }

    private static class PostalStruct {
        final boolean reallyUseQuotedPrintable;
        final boolean appendCharset;
        final String addressData;

        public PostalStruct(boolean reallyUseQuotedPrintable, boolean appendCharset, String addressData) {
            this.reallyUseQuotedPrintable = reallyUseQuotedPrintable;
            this.appendCharset = appendCharset;
            this.addressData = addressData;
        }
    }
}

