/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.opengl.Object3D;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.khronos.opengles.GL10;

public class Material {
    private Object3D parent;
    private String name;
    private String map_kd;
    private float[] ka = new float[4];
    private float[] kd = new float[4];
    private float[] ks = new float[4];
    private float ns;
    private int illum;
    private float d;
    private static float[] black = new float[]{0.0f, 0.0f, 0.0f, 1.0f};

    public Material(Object3D parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public String getMap_Kd() {
        return this.map_kd;
    }

    public void setMaterialParameters(GL10 gl) {
        gl.glMaterialfv(1032, 4608, this.kd, 0);
        gl.glMaterialfv(1032, 4609, this.kd, 0);
        gl.glMaterialfv(1032, 4610, this.ks, 0);
        gl.glMaterialf(1032, 5633, Math.min(Math.max(this.ns, 0.0f), 128.0f));
    }

    public void load(DataInputStream dis) throws IOException {
        dis.readInt();
        this.name = dis.readUTF();
        dis.readInt();
        this.map_kd = dis.readUTF();
        if (this.parent.hasTexcoords() && this.map_kd.length() > 0) {
            this.parent.loadTexture(this.map_kd);
        }
        this.ka[0] = dis.readFloat();
        this.ka[1] = dis.readFloat();
        this.ka[2] = dis.readFloat();
        this.ka[3] = dis.readFloat();
        this.kd[0] = dis.readFloat();
        this.kd[1] = dis.readFloat();
        this.kd[2] = dis.readFloat();
        this.kd[3] = dis.readFloat();
        this.ks[0] = dis.readFloat();
        this.ks[1] = dis.readFloat();
        this.ks[2] = dis.readFloat();
        this.ks[3] = dis.readFloat();
        this.ns = dis.readFloat();
        this.illum = dis.readInt();
        this.d = dis.readFloat();
    }

    public String toString() {
        return "Material[name=\"" + this.name + "\"," + "ka={" + this.ka[0] + "," + this.ka[1] + "," + this.ka[2] + "}," + "kd={" + this.kd[0] + "," + this.kd[1] + "," + this.kd[2] + "}," + "ks={" + this.ks[0] + "," + this.ks[1] + "," + this.ks[2] + "}," + "ns=" + this.ns + "," + "map_kd=\"" + (this.map_kd == null ? "" : this.map_kd) + "\"," + "illum=" + this.illum + "," + "d=" + this.d + "]";
    }
}

