/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.opengl.GLWrapperBase;
import java.io.IOException;
import java.io.Writer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import javax.microedition.khronos.opengles.GL;

class GLLogWrapper
extends GLWrapperBase {
    private static final int FORMAT_INT = 0;
    private static final int FORMAT_FLOAT = 1;
    private static final int FORMAT_FIXED = 2;
    private Writer mLog;
    private boolean mLogArgumentNames;
    private int mArgCount;
    private PointerInfo mColorPointer = new PointerInfo();
    private PointerInfo mNormalPointer = new PointerInfo();
    private PointerInfo mTexCoordPointer = new PointerInfo();
    private PointerInfo mVertexPointer = new PointerInfo();
    boolean mColorArrayEnabled;
    boolean mNormalArrayEnabled;
    boolean mTextureCoordArrayEnabled;
    boolean mVertexArrayEnabled;
    StringBuilder mStringBuilder;

    public GLLogWrapper(GL gl, Writer log, boolean logArgumentNames) {
        super(gl);
        this.mLog = log;
        this.mLogArgumentNames = logArgumentNames;
    }

    private void checkError() {
        int glError = this.mgl.glGetError();
        if (glError != 0) {
            String errorMessage = "glError: " + Integer.toString(glError);
            this.logLine(errorMessage);
        }
    }

    private void logLine(String message) {
        this.log(message + '\n');
    }

    private void log(String message) {
        try {
            this.mLog.write(message);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void begin(String name) {
        this.log(name + '(');
        this.mArgCount = 0;
    }

    private void arg(String name, String value) {
        if (this.mArgCount++ > 0) {
            this.log(", ");
        }
        if (this.mLogArgumentNames) {
            this.log(name + "=");
        }
        this.log(value);
    }

    private void end() {
        this.log(");\n");
        this.flush();
    }

    private void flush() {
        try {
            this.mLog.flush();
        }
        catch (IOException e) {
            this.mLog = null;
        }
    }

    private void arg(String name, boolean value) {
        this.arg(name, Boolean.toString(value));
    }

    private void arg(String name, int value) {
        this.arg(name, Integer.toString(value));
    }

    private void arg(String name, float value) {
        this.arg(name, Float.toString(value));
    }

    private void returns(String result) {
        this.log(") returns " + result + ";\n");
        this.flush();
    }

    private void returns(int result) {
        this.returns(Integer.toString(result));
    }

    private void arg(String name, int n, int[] arr, int offset) {
        this.arg(name, this.toString(n, 0, arr, offset));
    }

    private void arg(String name, int n, short[] arr, int offset) {
        this.arg(name, this.toString(n, arr, offset));
    }

    private void arg(String name, int n, float[] arr, int offset) {
        this.arg(name, this.toString(n, arr, offset));
    }

    private void formattedAppend(StringBuilder buf, int value, int format) {
        switch (format) {
            case 0: {
                buf.append(value);
                break;
            }
            case 1: {
                buf.append(Float.intBitsToFloat(value));
                break;
            }
            case 2: {
                buf.append((float)value / 65536.0f);
            }
        }
    }

    private String toString(int n, int format, int[] arr, int offset) {
        StringBuilder buf = new StringBuilder();
        buf.append("{\n");
        int arrLen = arr.length;
        for (int i = 0; i < n; ++i) {
            int index = offset + i;
            buf.append(" [" + index + "] = ");
            if (index < 0 || index >= arrLen) {
                buf.append("out of bounds");
            } else {
                this.formattedAppend(buf, arr[index], format);
            }
            buf.append('\n');
        }
        buf.append("}");
        return buf.toString();
    }

    private String toString(int n, short[] arr, int offset) {
        StringBuilder buf = new StringBuilder();
        buf.append("{\n");
        int arrLen = arr.length;
        for (int i = 0; i < n; ++i) {
            int index = offset + i;
            buf.append(" [" + index + "] = ");
            if (index < 0 || index >= arrLen) {
                buf.append("out of bounds");
            } else {
                buf.append(arr[index]);
            }
            buf.append('\n');
        }
        buf.append("}");
        return buf.toString();
    }

    private String toString(int n, float[] arr, int offset) {
        StringBuilder buf = new StringBuilder();
        buf.append("{\n");
        int arrLen = arr.length;
        for (int i = 0; i < n; ++i) {
            int index = offset + i;
            buf.append("[" + index + "] = ");
            if (index < 0 || index >= arrLen) {
                buf.append("out of bounds");
            } else {
                buf.append(arr[index]);
            }
            buf.append('\n');
        }
        buf.append("}");
        return buf.toString();
    }

    private String toString(int n, FloatBuffer buf) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        for (int i = 0; i < n; ++i) {
            builder.append(" [" + i + "] = " + buf.get(i) + '\n');
        }
        builder.append("}");
        return builder.toString();
    }

    private String toString(int n, int format, IntBuffer buf) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        for (int i = 0; i < n; ++i) {
            builder.append(" [" + i + "] = ");
            this.formattedAppend(builder, buf.get(i), format);
            builder.append('\n');
        }
        builder.append("}");
        return builder.toString();
    }

    private String toString(int n, ShortBuffer buf) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        for (int i = 0; i < n; ++i) {
            builder.append(" [" + i + "] = " + buf.get(i) + '\n');
        }
        builder.append("}");
        return builder.toString();
    }

    private void arg(String name, int n, FloatBuffer buf) {
        this.arg(name, this.toString(n, buf));
    }

    private void arg(String name, int n, IntBuffer buf) {
        this.arg(name, this.toString(n, 0, buf));
    }

    private void arg(String name, int n, ShortBuffer buf) {
        this.arg(name, this.toString(n, buf));
    }

    private void argPointer(int size, int type, int stride, Buffer pointer) {
        this.arg("size", size);
        this.arg("type", this.getPointerTypeName(type));
        this.arg("stride", stride);
        this.arg("pointer", pointer.toString());
    }

    private static String getHex(int value) {
        return "0x" + Integer.toHexString(value);
    }

    public static String getErrorString(int error) {
        switch (error) {
            case 0: {
                return "GL_NO_ERROR";
            }
            case 1280: {
                return "GL_INVALID_ENUM";
            }
            case 1281: {
                return "GL_INVALID_VALUE";
            }
            case 1282: {
                return "GL_INVALID_OPERATION";
            }
            case 1283: {
                return "GL_STACK_OVERFLOW";
            }
            case 1284: {
                return "GL_STACK_UNDERFLOW";
            }
            case 1285: {
                return "GL_OUT_OF_MEMORY";
            }
        }
        return GLLogWrapper.getHex(error);
    }

    private String getClearBufferMask(int mask) {
        StringBuilder b = new StringBuilder();
        if ((mask & 0x100) != 0) {
            b.append("GL_DEPTH_BUFFER_BIT");
            mask &= 0xFFFFFEFF;
        }
        if ((mask & 0x400) != 0) {
            if (b.length() > 0) {
                b.append(" | ");
            }
            b.append("GL_STENCIL_BUFFER_BIT");
            mask &= 0xFFFFFBFF;
        }
        if ((mask & 0x4000) != 0) {
            if (b.length() > 0) {
                b.append(" | ");
            }
            b.append("GL_COLOR_BUFFER_BIT");
            mask &= 0xFFFFBFFF;
        }
        if (mask != 0) {
            if (b.length() > 0) {
                b.append(" | ");
            }
            b.append(GLLogWrapper.getHex(mask));
        }
        return b.toString();
    }

    private String getFactor(int factor) {
        switch (factor) {
            case 0: {
                return "GL_ZERO";
            }
            case 1: {
                return "GL_ONE";
            }
            case 768: {
                return "GL_SRC_COLOR";
            }
            case 769: {
                return "GL_ONE_MINUS_SRC_COLOR";
            }
            case 774: {
                return "GL_DST_COLOR";
            }
            case 775: {
                return "GL_ONE_MINUS_DST_COLOR";
            }
            case 770: {
                return "GL_SRC_ALPHA";
            }
            case 771: {
                return "GL_ONE_MINUS_SRC_ALPHA";
            }
            case 772: {
                return "GL_DST_ALPHA";
            }
            case 773: {
                return "GL_ONE_MINUS_DST_ALPHA";
            }
            case 776: {
                return "GL_SRC_ALPHA_SATURATE";
            }
        }
        return GLLogWrapper.getHex(factor);
    }

    private String getShadeModel(int model) {
        switch (model) {
            case 7424: {
                return "GL_FLAT";
            }
            case 7425: {
                return "GL_SMOOTH";
            }
        }
        return GLLogWrapper.getHex(model);
    }

    private String getTextureTarget(int target) {
        switch (target) {
            case 3553: {
                return "GL_TEXTURE_2D";
            }
        }
        return GLLogWrapper.getHex(target);
    }

    private String getTextureEnvTarget(int target) {
        switch (target) {
            case 8960: {
                return "GL_TEXTURE_ENV";
            }
        }
        return GLLogWrapper.getHex(target);
    }

    private String getTextureEnvPName(int pname) {
        switch (pname) {
            case 8704: {
                return "GL_TEXTURE_ENV_MODE";
            }
            case 8705: {
                return "GL_TEXTURE_ENV_COLOR";
            }
        }
        return GLLogWrapper.getHex(pname);
    }

    private int getTextureEnvParamCount(int pname) {
        switch (pname) {
            case 8704: {
                return 1;
            }
            case 8705: {
                return 4;
            }
        }
        return 0;
    }

    private String getTextureEnvParamName(float param) {
        int iparam = (int)param;
        if (param == (float)iparam) {
            switch (iparam) {
                case 7681: {
                    return "GL_REPLACE";
                }
                case 8448: {
                    return "GL_MODULATE";
                }
                case 8449: {
                    return "GL_DECAL";
                }
                case 3042: {
                    return "GL_BLEND";
                }
                case 260: {
                    return "GL_ADD";
                }
                case 34160: {
                    return "GL_COMBINE";
                }
            }
            return GLLogWrapper.getHex(iparam);
        }
        return Float.toString(param);
    }

    private String getMatrixMode(int matrixMode) {
        switch (matrixMode) {
            case 5888: {
                return "GL_MODELVIEW";
            }
            case 5889: {
                return "GL_PROJECTION";
            }
            case 5890: {
                return "GL_TEXTURE";
            }
        }
        return GLLogWrapper.getHex(matrixMode);
    }

    private String getClientState(int clientState) {
        switch (clientState) {
            case 32886: {
                return "GL_COLOR_ARRAY";
            }
            case 32884: {
                return "GL_VERTEX_ARRAY";
            }
            case 32885: {
                return "GL_NORMAL_ARRAY";
            }
            case 32888: {
                return "GL_TEXTURE_COORD_ARRAY";
            }
        }
        return GLLogWrapper.getHex(clientState);
    }

    private String getCap(int cap) {
        switch (cap) {
            case 2912: {
                return "GL_FOG";
            }
            case 2896: {
                return "GL_LIGHTING";
            }
            case 3553: {
                return "GL_TEXTURE_2D";
            }
            case 2884: {
                return "GL_CULL_FACE";
            }
            case 3008: {
                return "GL_ALPHA_TEST";
            }
            case 3042: {
                return "GL_BLEND";
            }
            case 3058: {
                return "GL_COLOR_LOGIC_OP";
            }
            case 3024: {
                return "GL_DITHER";
            }
            case 2960: {
                return "GL_STENCIL_TEST";
            }
            case 2929: {
                return "GL_DEPTH_TEST";
            }
            case 16384: {
                return "GL_LIGHT0";
            }
            case 16385: {
                return "GL_LIGHT1";
            }
            case 16386: {
                return "GL_LIGHT2";
            }
            case 16387: {
                return "GL_LIGHT3";
            }
            case 16388: {
                return "GL_LIGHT4";
            }
            case 16389: {
                return "GL_LIGHT5";
            }
            case 16390: {
                return "GL_LIGHT6";
            }
            case 16391: {
                return "GL_LIGHT7";
            }
            case 2832: {
                return "GL_POINT_SMOOTH";
            }
            case 2848: {
                return "GL_LINE_SMOOTH";
            }
            case 2903: {
                return "GL_COLOR_MATERIAL";
            }
            case 2977: {
                return "GL_NORMALIZE";
            }
            case 32826: {
                return "GL_RESCALE_NORMAL";
            }
            case 32884: {
                return "GL_VERTEX_ARRAY";
            }
            case 32885: {
                return "GL_NORMAL_ARRAY";
            }
            case 32886: {
                return "GL_COLOR_ARRAY";
            }
            case 32888: {
                return "GL_TEXTURE_COORD_ARRAY";
            }
            case 32925: {
                return "GL_MULTISAMPLE";
            }
            case 32926: {
                return "GL_SAMPLE_ALPHA_TO_COVERAGE";
            }
            case 32927: {
                return "GL_SAMPLE_ALPHA_TO_ONE";
            }
            case 32928: {
                return "GL_SAMPLE_COVERAGE";
            }
            case 3089: {
                return "GL_SCISSOR_TEST";
            }
        }
        return GLLogWrapper.getHex(cap);
    }

    private String getTexturePName(int pname) {
        switch (pname) {
            case 10240: {
                return "GL_TEXTURE_MAG_FILTER";
            }
            case 10241: {
                return "GL_TEXTURE_MIN_FILTER";
            }
            case 10242: {
                return "GL_TEXTURE_WRAP_S";
            }
            case 10243: {
                return "GL_TEXTURE_WRAP_T";
            }
            case 33169: {
                return "GL_GENERATE_MIPMAP";
            }
            case 35741: {
                return "GL_TEXTURE_CROP_RECT_OES";
            }
        }
        return GLLogWrapper.getHex(pname);
    }

    private String getTextureParamName(float param) {
        int iparam = (int)param;
        if (param == (float)iparam) {
            switch (iparam) {
                case 33071: {
                    return "GL_CLAMP_TO_EDGE";
                }
                case 10497: {
                    return "GL_REPEAT";
                }
                case 9728: {
                    return "GL_NEAREST";
                }
                case 9729: {
                    return "GL_LINEAR";
                }
                case 9984: {
                    return "GL_NEAREST_MIPMAP_NEAREST";
                }
                case 9985: {
                    return "GL_LINEAR_MIPMAP_NEAREST";
                }
                case 9986: {
                    return "GL_NEAREST_MIPMAP_LINEAR";
                }
                case 9987: {
                    return "GL_LINEAR_MIPMAP_LINEAR";
                }
            }
            return GLLogWrapper.getHex(iparam);
        }
        return Float.toString(param);
    }

    private String getFogPName(int pname) {
        switch (pname) {
            case 2914: {
                return "GL_FOG_DENSITY";
            }
            case 2915: {
                return "GL_FOG_START";
            }
            case 2916: {
                return "GL_FOG_END";
            }
            case 2917: {
                return "GL_FOG_MODE";
            }
            case 2918: {
                return "GL_FOG_COLOR";
            }
        }
        return GLLogWrapper.getHex(pname);
    }

    private int getFogParamCount(int pname) {
        switch (pname) {
            case 2914: {
                return 1;
            }
            case 2915: {
                return 1;
            }
            case 2916: {
                return 1;
            }
            case 2917: {
                return 1;
            }
            case 2918: {
                return 4;
            }
        }
        return 0;
    }

    private String getBeginMode(int mode) {
        switch (mode) {
            case 0: {
                return "GL_POINTS";
            }
            case 1: {
                return "GL_LINES";
            }
            case 2: {
                return "GL_LINE_LOOP";
            }
            case 3: {
                return "GL_LINE_STRIP";
            }
            case 4: {
                return "GL_TRIANGLES";
            }
            case 5: {
                return "GL_TRIANGLE_STRIP";
            }
            case 6: {
                return "GL_TRIANGLE_FAN";
            }
        }
        return GLLogWrapper.getHex(mode);
    }

    private String getIndexType(int type) {
        switch (type) {
            case 5123: {
                return "GL_UNSIGNED_SHORT";
            }
            case 5121: {
                return "GL_UNSIGNED_BYTE";
            }
        }
        return GLLogWrapper.getHex(type);
    }

    private String getIntegerStateName(int pname) {
        switch (pname) {
            case 3413: {
                return "GL_ALPHA_BITS";
            }
            case 33902: {
                return "GL_ALIASED_LINE_WIDTH_RANGE";
            }
            case 33901: {
                return "GL_ALIASED_POINT_SIZE_RANGE";
            }
            case 3412: {
                return "GL_BLUE_BITS";
            }
            case 34467: {
                return "GL_COMPRESSED_TEXTURE_FORMATS";
            }
            case 3414: {
                return "GL_DEPTH_BITS";
            }
            case 3411: {
                return "GL_GREEN_BITS";
            }
            case 33001: {
                return "GL_MAX_ELEMENTS_INDICES";
            }
            case 33000: {
                return "GL_MAX_ELEMENTS_VERTICES";
            }
            case 3377: {
                return "GL_MAX_LIGHTS";
            }
            case 3379: {
                return "GL_MAX_TEXTURE_SIZE";
            }
            case 3386: {
                return "GL_MAX_VIEWPORT_DIMS";
            }
            case 3382: {
                return "GL_MAX_MODELVIEW_STACK_DEPTH";
            }
            case 3384: {
                return "GL_MAX_PROJECTION_STACK_DEPTH";
            }
            case 3385: {
                return "GL_MAX_TEXTURE_STACK_DEPTH";
            }
            case 34018: {
                return "GL_MAX_TEXTURE_UNITS";
            }
            case 34466: {
                return "GL_NUM_COMPRESSED_TEXTURE_FORMATS";
            }
            case 3410: {
                return "GL_RED_BITS";
            }
            case 2850: {
                return "GL_SMOOTH_LINE_WIDTH_RANGE";
            }
            case 2834: {
                return "GL_SMOOTH_POINT_SIZE_RANGE";
            }
            case 3415: {
                return "GL_STENCIL_BITS";
            }
            case 3408: {
                return "GL_SUBPIXEL_BITS";
            }
            case 35213: {
                return "GL_MODELVIEW_MATRIX_FLOAT_AS_INT_BITS_OES";
            }
            case 35214: {
                return "GL_PROJECTION_MATRIX_FLOAT_AS_INT_BITS_OES";
            }
            case 35215: {
                return "GL_TEXTURE_MATRIX_FLOAT_AS_INT_BITS_OES";
            }
        }
        return GLLogWrapper.getHex(pname);
    }

    private int getIntegerStateSize(int pname) {
        switch (pname) {
            case 3413: {
                return 1;
            }
            case 33902: {
                return 2;
            }
            case 33901: {
                return 2;
            }
            case 3412: {
                return 1;
            }
            case 34467: {
                int[] buffer = new int[1];
                this.mgl.glGetIntegerv(34466, buffer, 0);
                return buffer[0];
            }
            case 3414: {
                return 1;
            }
            case 3411: {
                return 1;
            }
            case 33001: {
                return 1;
            }
            case 33000: {
                return 1;
            }
            case 3377: {
                return 1;
            }
            case 3379: {
                return 1;
            }
            case 3386: {
                return 2;
            }
            case 3382: {
                return 1;
            }
            case 3384: {
                return 1;
            }
            case 3385: {
                return 1;
            }
            case 34018: {
                return 1;
            }
            case 34466: {
                return 1;
            }
            case 3410: {
                return 1;
            }
            case 2850: {
                return 2;
            }
            case 2834: {
                return 2;
            }
            case 3415: {
                return 1;
            }
            case 3408: {
                return 1;
            }
            case 35213: 
            case 35214: 
            case 35215: {
                return 16;
            }
        }
        return 0;
    }

    private int getIntegerStateFormat(int pname) {
        switch (pname) {
            case 35213: 
            case 35214: 
            case 35215: {
                return 1;
            }
        }
        return 0;
    }

    private String getHintTarget(int target) {
        switch (target) {
            case 3156: {
                return "GL_FOG_HINT";
            }
            case 3154: {
                return "GL_LINE_SMOOTH_HINT";
            }
            case 3152: {
                return "GL_PERSPECTIVE_CORRECTION_HINT";
            }
            case 3153: {
                return "GL_POINT_SMOOTH_HINT";
            }
            case 3155: {
                return "GL_POLYGON_SMOOTH_HINT";
            }
            case 33170: {
                return "GL_GENERATE_MIPMAP_HINT";
            }
        }
        return GLLogWrapper.getHex(target);
    }

    private String getHintMode(int mode) {
        switch (mode) {
            case 4353: {
                return "GL_FASTEST";
            }
            case 4354: {
                return "GL_NICEST";
            }
            case 4352: {
                return "GL_DONT_CARE";
            }
        }
        return GLLogWrapper.getHex(mode);
    }

    private String getFaceName(int face) {
        switch (face) {
            case 1032: {
                return "GL_FRONT_AND_BACK";
            }
        }
        return GLLogWrapper.getHex(face);
    }

    private String getMaterialPName(int pname) {
        switch (pname) {
            case 4608: {
                return "GL_AMBIENT";
            }
            case 4609: {
                return "GL_DIFFUSE";
            }
            case 4610: {
                return "GL_SPECULAR";
            }
            case 5632: {
                return "GL_EMISSION";
            }
            case 5633: {
                return "GL_SHININESS";
            }
            case 5634: {
                return "GL_AMBIENT_AND_DIFFUSE";
            }
        }
        return GLLogWrapper.getHex(pname);
    }

    private int getMaterialParamCount(int pname) {
        switch (pname) {
            case 4608: {
                return 4;
            }
            case 4609: {
                return 4;
            }
            case 4610: {
                return 4;
            }
            case 5632: {
                return 4;
            }
            case 5633: {
                return 1;
            }
            case 5634: {
                return 4;
            }
        }
        return 0;
    }

    private String getLightName(int light) {
        if (light >= 16384 && light <= 16391) {
            return "GL_LIGHT" + Integer.toString(light);
        }
        return GLLogWrapper.getHex(light);
    }

    private String getLightPName(int pname) {
        switch (pname) {
            case 4608: {
                return "GL_AMBIENT";
            }
            case 4609: {
                return "GL_DIFFUSE";
            }
            case 4610: {
                return "GL_SPECULAR";
            }
            case 4611: {
                return "GL_POSITION";
            }
            case 4612: {
                return "GL_SPOT_DIRECTION";
            }
            case 4613: {
                return "GL_SPOT_EXPONENT";
            }
            case 4614: {
                return "GL_SPOT_CUTOFF";
            }
            case 4615: {
                return "GL_CONSTANT_ATTENUATION";
            }
            case 4616: {
                return "GL_LINEAR_ATTENUATION";
            }
            case 4617: {
                return "GL_QUADRATIC_ATTENUATION";
            }
        }
        return GLLogWrapper.getHex(pname);
    }

    private int getLightParamCount(int pname) {
        switch (pname) {
            case 4608: {
                return 4;
            }
            case 4609: {
                return 4;
            }
            case 4610: {
                return 4;
            }
            case 4611: {
                return 4;
            }
            case 4612: {
                return 3;
            }
            case 4613: {
                return 1;
            }
            case 4614: {
                return 1;
            }
            case 4615: {
                return 1;
            }
            case 4616: {
                return 1;
            }
            case 4617: {
                return 1;
            }
        }
        return 0;
    }

    private String getLightModelPName(int pname) {
        switch (pname) {
            case 2899: {
                return "GL_LIGHT_MODEL_AMBIENT";
            }
            case 2898: {
                return "GL_LIGHT_MODEL_TWO_SIDE";
            }
        }
        return GLLogWrapper.getHex(pname);
    }

    private int getLightModelParamCount(int pname) {
        switch (pname) {
            case 2899: {
                return 4;
            }
            case 2898: {
                return 1;
            }
        }
        return 0;
    }

    private String getPointerTypeName(int type) {
        switch (type) {
            case 5120: {
                return "GL_BYTE";
            }
            case 5121: {
                return "GL_UNSIGNED_BYTE";
            }
            case 5122: {
                return "GL_SHORT";
            }
            case 5132: {
                return "GL_FIXED";
            }
            case 5126: {
                return "GL_FLOAT";
            }
        }
        return GLLogWrapper.getHex(type);
    }

    private ByteBuffer toByteBuffer(int byteCount, Buffer input) {
        boolean convertWholeBuffer;
        ByteBuffer result = null;
        boolean bl = convertWholeBuffer = byteCount < 0;
        if (input instanceof ByteBuffer) {
            ByteBuffer input2 = (ByteBuffer)input;
            int position = input2.position();
            if (convertWholeBuffer) {
                byteCount = input2.limit() - position;
            }
            result = ByteBuffer.allocate(byteCount).order(input2.order());
            for (int i = 0; i < byteCount; ++i) {
                result.put(input2.get());
            }
            input2.position(position);
        } else if (input instanceof CharBuffer) {
            CharBuffer input2 = (CharBuffer)input;
            int position = input2.position();
            if (convertWholeBuffer) {
                byteCount = (input2.limit() - position) * 2;
            }
            result = ByteBuffer.allocate(byteCount).order(input2.order());
            CharBuffer result2 = result.asCharBuffer();
            for (int i = 0; i < byteCount / 2; ++i) {
                result2.put(input2.get());
            }
            input2.position(position);
        } else if (input instanceof ShortBuffer) {
            ShortBuffer input2 = (ShortBuffer)input;
            int position = input2.position();
            if (convertWholeBuffer) {
                byteCount = (input2.limit() - position) * 2;
            }
            result = ByteBuffer.allocate(byteCount).order(input2.order());
            ShortBuffer result2 = result.asShortBuffer();
            for (int i = 0; i < byteCount / 2; ++i) {
                result2.put(input2.get());
            }
            input2.position(position);
        } else if (input instanceof IntBuffer) {
            IntBuffer input2 = (IntBuffer)input;
            int position = input2.position();
            if (convertWholeBuffer) {
                byteCount = (input2.limit() - position) * 4;
            }
            result = ByteBuffer.allocate(byteCount).order(input2.order());
            IntBuffer result2 = result.asIntBuffer();
            for (int i = 0; i < byteCount / 4; ++i) {
                result2.put(input2.get());
            }
            input2.position(position);
        } else if (input instanceof FloatBuffer) {
            FloatBuffer input2 = (FloatBuffer)input;
            int position = input2.position();
            if (convertWholeBuffer) {
                byteCount = (input2.limit() - position) * 4;
            }
            result = ByteBuffer.allocate(byteCount).order(input2.order());
            FloatBuffer result2 = result.asFloatBuffer();
            for (int i = 0; i < byteCount / 4; ++i) {
                result2.put(input2.get());
            }
            input2.position(position);
        } else if (input instanceof DoubleBuffer) {
            DoubleBuffer input2 = (DoubleBuffer)input;
            int position = input2.position();
            if (convertWholeBuffer) {
                byteCount = (input2.limit() - position) * 8;
            }
            result = ByteBuffer.allocate(byteCount).order(input2.order());
            DoubleBuffer result2 = result.asDoubleBuffer();
            for (int i = 0; i < byteCount / 8; ++i) {
                result2.put(input2.get());
            }
            input2.position(position);
        } else if (input instanceof LongBuffer) {
            LongBuffer input2 = (LongBuffer)input;
            int position = input2.position();
            if (convertWholeBuffer) {
                byteCount = (input2.limit() - position) * 8;
            }
            result = ByteBuffer.allocate(byteCount).order(input2.order());
            LongBuffer result2 = result.asLongBuffer();
            for (int i = 0; i < byteCount / 8; ++i) {
                result2.put(input2.get());
            }
            input2.position(position);
        } else {
            throw new RuntimeException("Unimplemented Buffer subclass.");
        }
        result.rewind();
        result.order(ByteOrder.nativeOrder());
        return result;
    }

    private char[] toCharIndices(int count, int type, Buffer indices) {
        char[] result = new char[count];
        switch (type) {
            case 5121: {
                ByteBuffer byteBuffer = this.toByteBuffer(count, indices);
                byte[] array2 = byteBuffer.array();
                int offset = byteBuffer.arrayOffset();
                for (int i = 0; i < count; ++i) {
                    result[i] = (char)(0xFF & array2[offset + i]);
                }
                break;
            }
            case 5123: {
                CharBuffer charBuffer;
                if (indices instanceof CharBuffer) {
                    charBuffer = (CharBuffer)indices;
                } else {
                    ByteBuffer byteBuffer = this.toByteBuffer(count * 2, indices);
                    charBuffer = byteBuffer.asCharBuffer();
                }
                int oldPosition = charBuffer.position();
                charBuffer.position(0);
                charBuffer.get(result);
                charBuffer.position(oldPosition);
                break;
            }
        }
        return result;
    }

    private void doArrayElement(StringBuilder builder, boolean enabled, String name, PointerInfo pointer, int index) {
        if (!enabled) {
            return;
        }
        builder.append(" ");
        builder.append(name + ":{");
        if (pointer == null || pointer.mTempByteBuffer == null) {
            builder.append("undefined }");
            return;
        }
        if (pointer.mStride < 0) {
            builder.append("invalid stride");
            return;
        }
        int stride = pointer.getStride();
        ByteBuffer byteBuffer = pointer.mTempByteBuffer;
        int size = pointer.mSize;
        int type = pointer.mType;
        int sizeofType = pointer.sizeof(type);
        int byteOffset = stride * index;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            switch (type) {
                case 5120: {
                    byte d = byteBuffer.get(byteOffset);
                    builder.append(Integer.toString(d));
                    break;
                }
                case 5121: {
                    byte d = byteBuffer.get(byteOffset);
                    builder.append(Integer.toString(0xFF & d));
                    break;
                }
                case 5122: {
                    ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                    short d = shortBuffer.get(byteOffset / 2);
                    builder.append(Integer.toString(d));
                    break;
                }
                case 5132: {
                    IntBuffer intBuffer = byteBuffer.asIntBuffer();
                    int d = intBuffer.get(byteOffset / 4);
                    builder.append(Integer.toString(d));
                    break;
                }
                case 5126: {
                    FloatBuffer intBuffer = byteBuffer.asFloatBuffer();
                    float d = intBuffer.get(byteOffset / 4);
                    builder.append(Float.toString(d));
                    break;
                }
                default: {
                    builder.append("?");
                }
            }
            byteOffset += sizeofType;
        }
        builder.append("}");
    }

    private void doElement(StringBuilder builder, int ordinal, int vertexIndex) {
        builder.append(" [" + ordinal + " : " + vertexIndex + "] =");
        this.doArrayElement(builder, this.mVertexArrayEnabled, "v", this.mVertexPointer, vertexIndex);
        this.doArrayElement(builder, this.mNormalArrayEnabled, "n", this.mNormalPointer, vertexIndex);
        this.doArrayElement(builder, this.mColorArrayEnabled, "c", this.mColorPointer, vertexIndex);
        this.doArrayElement(builder, this.mTextureCoordArrayEnabled, "t", this.mTexCoordPointer, vertexIndex);
        builder.append("\n");
    }

    private void bindArrays() {
        if (this.mColorArrayEnabled) {
            this.mColorPointer.bindByteBuffer();
        }
        if (this.mNormalArrayEnabled) {
            this.mNormalPointer.bindByteBuffer();
        }
        if (this.mTextureCoordArrayEnabled) {
            this.mTexCoordPointer.bindByteBuffer();
        }
        if (this.mVertexArrayEnabled) {
            this.mVertexPointer.bindByteBuffer();
        }
    }

    private void unbindArrays() {
        if (this.mColorArrayEnabled) {
            this.mColorPointer.unbindByteBuffer();
        }
        if (this.mNormalArrayEnabled) {
            this.mNormalPointer.unbindByteBuffer();
        }
        if (this.mTextureCoordArrayEnabled) {
            this.mTexCoordPointer.unbindByteBuffer();
        }
        if (this.mVertexArrayEnabled) {
            this.mVertexPointer.unbindByteBuffer();
        }
    }

    private void startLogIndices() {
        this.mStringBuilder = new StringBuilder();
        this.mStringBuilder.append("\n");
        this.bindArrays();
    }

    private void endLogIndices() {
        this.log(this.mStringBuilder.toString());
        this.unbindArrays();
    }

    public void glActiveTexture(int texture) {
        this.begin("glActiveTexture");
        this.arg("texture", texture);
        this.end();
        this.mgl.glActiveTexture(texture);
        this.checkError();
    }

    public void glAlphaFunc(int func, float ref) {
        this.begin("glAlphaFunc");
        this.arg("func", func);
        this.arg("ref", ref);
        this.end();
        this.mgl.glAlphaFunc(func, ref);
        this.checkError();
    }

    public void glAlphaFuncx(int func, int ref) {
        this.begin("glAlphaFuncx");
        this.arg("func", func);
        this.arg("ref", ref);
        this.end();
        this.mgl.glAlphaFuncx(func, ref);
        this.checkError();
    }

    public void glBindTexture(int target, int texture) {
        this.begin("glBindTexture");
        this.arg("target", this.getTextureTarget(target));
        this.arg("texture", texture);
        this.end();
        this.mgl.glBindTexture(target, texture);
        this.checkError();
    }

    public void glBlendFunc(int sfactor, int dfactor) {
        this.begin("glBlendFunc");
        this.arg("sfactor", this.getFactor(sfactor));
        this.arg("dfactor", this.getFactor(dfactor));
        this.end();
        this.mgl.glBlendFunc(sfactor, dfactor);
        this.checkError();
    }

    public void glClear(int mask) {
        this.begin("glClear");
        this.arg("mask", this.getClearBufferMask(mask));
        this.end();
        this.mgl.glClear(mask);
        this.checkError();
    }

    public void glClearColor(float red, float green, float blue, float alpha) {
        this.begin("glClearColor");
        this.arg("red", red);
        this.arg("green", green);
        this.arg("blue", blue);
        this.arg("alpha", alpha);
        this.end();
        this.mgl.glClearColor(red, green, blue, alpha);
        this.checkError();
    }

    public void glClearColorx(int red, int green, int blue, int alpha) {
        this.begin("glClearColor");
        this.arg("red", red);
        this.arg("green", green);
        this.arg("blue", blue);
        this.arg("alpha", alpha);
        this.end();
        this.mgl.glClearColorx(red, green, blue, alpha);
        this.checkError();
    }

    public void glClearDepthf(float depth) {
        this.begin("glClearDepthf");
        this.arg("depth", depth);
        this.end();
        this.mgl.glClearDepthf(depth);
        this.checkError();
    }

    public void glClearDepthx(int depth) {
        this.begin("glClearDepthx");
        this.arg("depth", depth);
        this.end();
        this.mgl.glClearDepthx(depth);
        this.checkError();
    }

    public void glClearStencil(int s) {
        this.begin("glClearStencil");
        this.arg("s", s);
        this.end();
        this.mgl.glClearStencil(s);
        this.checkError();
    }

    public void glClientActiveTexture(int texture) {
        this.begin("glClientActiveTexture");
        this.arg("texture", texture);
        this.end();
        this.mgl.glClientActiveTexture(texture);
        this.checkError();
    }

    public void glColor4f(float red, float green, float blue, float alpha) {
        this.begin("glColor4f");
        this.arg("red", red);
        this.arg("green", green);
        this.arg("blue", blue);
        this.arg("alpha", alpha);
        this.end();
        this.mgl.glColor4f(red, green, blue, alpha);
        this.checkError();
    }

    public void glColor4x(int red, int green, int blue, int alpha) {
        this.begin("glColor4x");
        this.arg("red", red);
        this.arg("green", green);
        this.arg("blue", blue);
        this.arg("alpha", alpha);
        this.end();
        this.mgl.glColor4x(red, green, blue, alpha);
        this.checkError();
    }

    public void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        this.begin("glColorMask");
        this.arg("red", red);
        this.arg("green", green);
        this.arg("blue", blue);
        this.arg("alpha", alpha);
        this.end();
        this.mgl.glColorMask(red, green, blue, alpha);
        this.checkError();
    }

    public void glColorPointer(int size, int type, int stride, Buffer pointer) {
        this.begin("glColorPointer");
        this.argPointer(size, type, stride, pointer);
        this.end();
        this.mColorPointer = new PointerInfo(size, type, stride, pointer);
        this.mgl.glColorPointer(size, type, stride, pointer);
        this.checkError();
    }

    public void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, Buffer data) {
        this.begin("glCompressedTexImage2D");
        this.arg("target", this.getTextureTarget(target));
        this.arg("level", level);
        this.arg("internalformat", internalformat);
        this.arg("width", width);
        this.arg("height", height);
        this.arg("border", border);
        this.arg("imageSize", imageSize);
        this.arg("data", data.toString());
        this.end();
        this.mgl.glCompressedTexImage2D(target, level, internalformat, width, height, border, imageSize, data);
        this.checkError();
    }

    public void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, Buffer data) {
        this.begin("glCompressedTexSubImage2D");
        this.arg("target", this.getTextureTarget(target));
        this.arg("level", level);
        this.arg("xoffset", xoffset);
        this.arg("yoffset", yoffset);
        this.arg("width", width);
        this.arg("height", height);
        this.arg("format", format);
        this.arg("imageSize", imageSize);
        this.arg("data", data.toString());
        this.end();
        this.mgl.glCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, data);
        this.checkError();
    }

    public void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border) {
        this.begin("glCopyTexImage2D");
        this.arg("target", this.getTextureTarget(target));
        this.arg("level", level);
        this.arg("internalformat", internalformat);
        this.arg("x", x);
        this.arg("y", y);
        this.arg("width", width);
        this.arg("height", height);
        this.arg("border", border);
        this.end();
        this.mgl.glCopyTexImage2D(target, level, internalformat, x, y, width, height, border);
        this.checkError();
    }

    public void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        this.begin("glCopyTexSubImage2D");
        this.arg("target", this.getTextureTarget(target));
        this.arg("level", level);
        this.arg("xoffset", xoffset);
        this.arg("yoffset", yoffset);
        this.arg("x", x);
        this.arg("y", y);
        this.arg("width", width);
        this.arg("height", height);
        this.end();
        this.mgl.glCopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
        this.checkError();
    }

    public void glCullFace(int mode) {
        this.begin("glCullFace");
        this.arg("mode", mode);
        this.end();
        this.mgl.glCullFace(mode);
        this.checkError();
    }

    public void glDeleteTextures(int n, int[] textures, int offset) {
        this.begin("glDeleteTextures");
        this.arg("n", n);
        this.arg("textures", n, textures, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glDeleteTextures(n, textures, offset);
        this.checkError();
    }

    public void glDeleteTextures(int n, IntBuffer textures) {
        this.begin("glDeleteTextures");
        this.arg("n", n);
        this.arg("textures", n, textures);
        this.end();
        this.mgl.glDeleteTextures(n, textures);
        this.checkError();
    }

    public void glDepthFunc(int func) {
        this.begin("glDepthFunc");
        this.arg("func", func);
        this.end();
        this.mgl.glDepthFunc(func);
        this.checkError();
    }

    public void glDepthMask(boolean flag) {
        this.begin("glDepthMask");
        this.arg("flag", flag);
        this.end();
        this.mgl.glDepthMask(flag);
        this.checkError();
    }

    public void glDepthRangef(float near, float far) {
        this.begin("glDepthRangef");
        this.arg("near", near);
        this.arg("far", far);
        this.end();
        this.mgl.glDepthRangef(near, far);
        this.checkError();
    }

    public void glDepthRangex(int near, int far) {
        this.begin("glDepthRangex");
        this.arg("near", near);
        this.arg("far", far);
        this.end();
        this.mgl.glDepthRangex(near, far);
        this.checkError();
    }

    public void glDisable(int cap) {
        this.begin("glDisable");
        this.arg("cap", this.getCap(cap));
        this.end();
        this.mgl.glDisable(cap);
        this.checkError();
    }

    public void glDisableClientState(int array2) {
        this.begin("glDisableClientState");
        this.arg("array", this.getClientState(array2));
        this.end();
        switch (array2) {
            case 32886: {
                this.mColorArrayEnabled = false;
                break;
            }
            case 32885: {
                this.mNormalArrayEnabled = false;
                break;
            }
            case 32888: {
                this.mTextureCoordArrayEnabled = false;
                break;
            }
            case 32884: {
                this.mVertexArrayEnabled = false;
            }
        }
        this.mgl.glDisableClientState(array2);
        this.checkError();
    }

    public void glDrawArrays(int mode, int first, int count) {
        this.begin("glDrawArrays");
        this.arg("mode", mode);
        this.arg("first", first);
        this.arg("count", count);
        this.startLogIndices();
        for (int i = 0; i < count; ++i) {
            this.doElement(this.mStringBuilder, i, first + i);
        }
        this.endLogIndices();
        this.end();
        this.mgl.glDrawArrays(mode, first, count);
        this.checkError();
    }

    public void glDrawElements(int mode, int count, int type, Buffer indices) {
        this.begin("glDrawElements");
        this.arg("mode", this.getBeginMode(mode));
        this.arg("count", count);
        this.arg("type", this.getIndexType(type));
        char[] indexArray = this.toCharIndices(count, type, indices);
        int indexArrayLength = indexArray.length;
        this.startLogIndices();
        for (int i = 0; i < indexArrayLength; ++i) {
            this.doElement(this.mStringBuilder, i, indexArray[i]);
        }
        this.endLogIndices();
        this.end();
        this.mgl.glDrawElements(mode, count, type, indices);
        this.checkError();
    }

    public void glEnable(int cap) {
        this.begin("glEnable");
        this.arg("cap", this.getCap(cap));
        this.end();
        this.mgl.glEnable(cap);
        this.checkError();
    }

    public void glEnableClientState(int array2) {
        this.begin("glEnableClientState");
        this.arg("array", this.getClientState(array2));
        this.end();
        switch (array2) {
            case 32886: {
                this.mColorArrayEnabled = true;
                break;
            }
            case 32885: {
                this.mNormalArrayEnabled = true;
                break;
            }
            case 32888: {
                this.mTextureCoordArrayEnabled = true;
                break;
            }
            case 32884: {
                this.mVertexArrayEnabled = true;
            }
        }
        this.mgl.glEnableClientState(array2);
        this.checkError();
    }

    public void glFinish() {
        this.begin("glFinish");
        this.end();
        this.mgl.glFinish();
        this.checkError();
    }

    public void glFlush() {
        this.begin("glFlush");
        this.end();
        this.mgl.glFlush();
        this.checkError();
    }

    public void glFogf(int pname, float param) {
        this.begin("glFogf");
        this.arg("pname", pname);
        this.arg("param", param);
        this.end();
        this.mgl.glFogf(pname, param);
        this.checkError();
    }

    public void glFogfv(int pname, float[] params, int offset) {
        this.begin("glFogfv");
        this.arg("pname", this.getFogPName(pname));
        this.arg("params", this.getFogParamCount(pname), params, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glFogfv(pname, params, offset);
        this.checkError();
    }

    public void glFogfv(int pname, FloatBuffer params) {
        this.begin("glFogfv");
        this.arg("pname", this.getFogPName(pname));
        this.arg("params", this.getFogParamCount(pname), params);
        this.end();
        this.mgl.glFogfv(pname, params);
        this.checkError();
    }

    public void glFogx(int pname, int param) {
        this.begin("glFogx");
        this.arg("pname", this.getFogPName(pname));
        this.arg("param", param);
        this.end();
        this.mgl.glFogx(pname, param);
        this.checkError();
    }

    public void glFogxv(int pname, int[] params, int offset) {
        this.begin("glFogxv");
        this.arg("pname", this.getFogPName(pname));
        this.arg("params", this.getFogParamCount(pname), params, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glFogxv(pname, params, offset);
        this.checkError();
    }

    public void glFogxv(int pname, IntBuffer params) {
        this.begin("glFogxv");
        this.arg("pname", this.getFogPName(pname));
        this.arg("params", this.getFogParamCount(pname), params);
        this.end();
        this.mgl.glFogxv(pname, params);
        this.checkError();
    }

    public void glFrontFace(int mode) {
        this.begin("glFrontFace");
        this.arg("mode", mode);
        this.end();
        this.mgl.glFrontFace(mode);
        this.checkError();
    }

    public void glFrustumf(float left, float right, float bottom, float top, float near, float far) {
        this.begin("glFrustumf");
        this.arg("left", left);
        this.arg("right", right);
        this.arg("bottom", bottom);
        this.arg("top", top);
        this.arg("near", near);
        this.arg("far", far);
        this.end();
        this.mgl.glFrustumf(left, right, bottom, top, near, far);
        this.checkError();
    }

    public void glFrustumx(int left, int right, int bottom, int top, int near, int far) {
        this.begin("glFrustumx");
        this.arg("left", left);
        this.arg("right", right);
        this.arg("bottom", bottom);
        this.arg("top", top);
        this.arg("near", near);
        this.arg("far", far);
        this.end();
        this.mgl.glFrustumx(left, right, bottom, top, near, far);
        this.checkError();
    }

    public void glGenTextures(int n, int[] textures, int offset) {
        this.begin("glGenTextures");
        this.arg("n", n);
        this.arg("textures", Arrays.toString(textures));
        this.arg("offset", offset);
        this.mgl.glGenTextures(n, textures, offset);
        this.returns(this.toString(n, 0, textures, offset));
        this.checkError();
    }

    public void glGenTextures(int n, IntBuffer textures) {
        this.begin("glGenTextures");
        this.arg("n", n);
        this.arg("textures", textures.toString());
        this.mgl.glGenTextures(n, textures);
        this.returns(this.toString(n, 0, textures));
        this.checkError();
    }

    public int glGetError() {
        this.begin("glGetError");
        int result = this.mgl.glGetError();
        this.returns(result);
        return result;
    }

    public void glGetIntegerv(int pname, int[] params, int offset) {
        this.begin("glGetIntegerv");
        this.arg("pname", this.getIntegerStateName(pname));
        this.arg("params", Arrays.toString(params));
        this.arg("offset", offset);
        this.mgl.glGetIntegerv(pname, params, offset);
        this.returns(this.toString(this.getIntegerStateSize(pname), this.getIntegerStateFormat(pname), params, offset));
        this.checkError();
    }

    public void glGetIntegerv(int pname, IntBuffer params) {
        this.begin("glGetIntegerv");
        this.arg("pname", this.getIntegerStateName(pname));
        this.arg("params", params.toString());
        this.mgl.glGetIntegerv(pname, params);
        this.returns(this.toString(this.getIntegerStateSize(pname), this.getIntegerStateFormat(pname), params));
        this.checkError();
    }

    public String glGetString(int name) {
        this.begin("glGetString");
        this.arg("name", name);
        String result = this.mgl.glGetString(name);
        this.returns(result);
        this.checkError();
        return result;
    }

    public void glHint(int target, int mode) {
        this.begin("glHint");
        this.arg("target", this.getHintTarget(target));
        this.arg("mode", this.getHintMode(mode));
        this.end();
        this.mgl.glHint(target, mode);
        this.checkError();
    }

    public void glLightModelf(int pname, float param) {
        this.begin("glLightModelf");
        this.arg("pname", this.getLightModelPName(pname));
        this.arg("param", param);
        this.end();
        this.mgl.glLightModelf(pname, param);
        this.checkError();
    }

    public void glLightModelfv(int pname, float[] params, int offset) {
        this.begin("glLightModelfv");
        this.arg("pname", this.getLightModelPName(pname));
        this.arg("params", this.getLightModelParamCount(pname), params, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glLightModelfv(pname, params, offset);
        this.checkError();
    }

    public void glLightModelfv(int pname, FloatBuffer params) {
        this.begin("glLightModelfv");
        this.arg("pname", this.getLightModelPName(pname));
        this.arg("params", this.getLightModelParamCount(pname), params);
        this.end();
        this.mgl.glLightModelfv(pname, params);
        this.checkError();
    }

    public void glLightModelx(int pname, int param) {
        this.begin("glLightModelx");
        this.arg("pname", this.getLightModelPName(pname));
        this.arg("param", param);
        this.end();
        this.mgl.glLightModelx(pname, param);
        this.checkError();
    }

    public void glLightModelxv(int pname, int[] params, int offset) {
        this.begin("glLightModelxv");
        this.arg("pname", this.getLightModelPName(pname));
        this.arg("params", this.getLightModelParamCount(pname), params, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glLightModelxv(pname, params, offset);
        this.checkError();
    }

    public void glLightModelxv(int pname, IntBuffer params) {
        this.begin("glLightModelfv");
        this.arg("pname", this.getLightModelPName(pname));
        this.arg("params", this.getLightModelParamCount(pname), params);
        this.end();
        this.mgl.glLightModelxv(pname, params);
        this.checkError();
    }

    public void glLightf(int light, int pname, float param) {
        this.begin("glLightf");
        this.arg("light", this.getLightName(light));
        this.arg("pname", this.getLightPName(pname));
        this.arg("param", param);
        this.end();
        this.mgl.glLightf(light, pname, param);
        this.checkError();
    }

    public void glLightfv(int light, int pname, float[] params, int offset) {
        this.begin("glLightfv");
        this.arg("light", this.getLightName(light));
        this.arg("pname", this.getLightPName(pname));
        this.arg("params", this.getLightParamCount(pname), params, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glLightfv(light, pname, params, offset);
        this.checkError();
    }

    public void glLightfv(int light, int pname, FloatBuffer params) {
        this.begin("glLightfv");
        this.arg("light", this.getLightName(light));
        this.arg("pname", this.getLightPName(pname));
        this.arg("params", this.getLightParamCount(pname), params);
        this.end();
        this.mgl.glLightfv(light, pname, params);
        this.checkError();
    }

    public void glLightx(int light, int pname, int param) {
        this.begin("glLightx");
        this.arg("light", this.getLightName(light));
        this.arg("pname", this.getLightPName(pname));
        this.arg("param", param);
        this.end();
        this.mgl.glLightx(light, pname, param);
        this.checkError();
    }

    public void glLightxv(int light, int pname, int[] params, int offset) {
        this.begin("glLightxv");
        this.arg("light", this.getLightName(light));
        this.arg("pname", this.getLightPName(pname));
        this.arg("params", this.getLightParamCount(pname), params, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glLightxv(light, pname, params, offset);
        this.checkError();
    }

    public void glLightxv(int light, int pname, IntBuffer params) {
        this.begin("glLightxv");
        this.arg("light", this.getLightName(light));
        this.arg("pname", this.getLightPName(pname));
        this.arg("params", this.getLightParamCount(pname), params);
        this.end();
        this.mgl.glLightxv(light, pname, params);
        this.checkError();
    }

    public void glLineWidth(float width) {
        this.begin("glLineWidth");
        this.arg("width", width);
        this.end();
        this.mgl.glLineWidth(width);
        this.checkError();
    }

    public void glLineWidthx(int width) {
        this.begin("glLineWidthx");
        this.arg("width", width);
        this.end();
        this.mgl.glLineWidthx(width);
        this.checkError();
    }

    public void glLoadIdentity() {
        this.begin("glLoadIdentity");
        this.end();
        this.mgl.glLoadIdentity();
        this.checkError();
    }

    public void glLoadMatrixf(float[] m, int offset) {
        this.begin("glLoadMatrixf");
        this.arg("m", 16, m, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glLoadMatrixf(m, offset);
        this.checkError();
    }

    public void glLoadMatrixf(FloatBuffer m) {
        this.begin("glLoadMatrixf");
        this.arg("m", 16, m);
        this.end();
        this.mgl.glLoadMatrixf(m);
        this.checkError();
    }

    public void glLoadMatrixx(int[] m, int offset) {
        this.begin("glLoadMatrixx");
        this.arg("m", 16, m, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glLoadMatrixx(m, offset);
        this.checkError();
    }

    public void glLoadMatrixx(IntBuffer m) {
        this.begin("glLoadMatrixx");
        this.arg("m", 16, m);
        this.end();
        this.mgl.glLoadMatrixx(m);
        this.checkError();
    }

    public void glLogicOp(int opcode) {
        this.begin("glLogicOp");
        this.arg("opcode", opcode);
        this.end();
        this.mgl.glLogicOp(opcode);
        this.checkError();
    }

    public void glMaterialf(int face, int pname, float param) {
        this.begin("glMaterialf");
        this.arg("face", this.getFaceName(face));
        this.arg("pname", this.getMaterialPName(pname));
        this.arg("param", param);
        this.end();
        this.mgl.glMaterialf(face, pname, param);
        this.checkError();
    }

    public void glMaterialfv(int face, int pname, float[] params, int offset) {
        this.begin("glMaterialfv");
        this.arg("face", this.getFaceName(face));
        this.arg("pname", this.getMaterialPName(pname));
        this.arg("params", this.getMaterialParamCount(pname), params, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glMaterialfv(face, pname, params, offset);
        this.checkError();
    }

    public void glMaterialfv(int face, int pname, FloatBuffer params) {
        this.begin("glMaterialfv");
        this.arg("face", this.getFaceName(face));
        this.arg("pname", this.getMaterialPName(pname));
        this.arg("params", this.getMaterialParamCount(pname), params);
        this.end();
        this.mgl.glMaterialfv(face, pname, params);
        this.checkError();
    }

    public void glMaterialx(int face, int pname, int param) {
        this.begin("glMaterialx");
        this.arg("face", this.getFaceName(face));
        this.arg("pname", this.getMaterialPName(pname));
        this.arg("param", param);
        this.end();
        this.mgl.glMaterialx(face, pname, param);
        this.checkError();
    }

    public void glMaterialxv(int face, int pname, int[] params, int offset) {
        this.begin("glMaterialxv");
        this.arg("face", this.getFaceName(face));
        this.arg("pname", this.getMaterialPName(pname));
        this.arg("params", this.getMaterialParamCount(pname), params, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glMaterialxv(face, pname, params, offset);
        this.checkError();
    }

    public void glMaterialxv(int face, int pname, IntBuffer params) {
        this.begin("glMaterialxv");
        this.arg("face", this.getFaceName(face));
        this.arg("pname", this.getMaterialPName(pname));
        this.arg("params", this.getMaterialParamCount(pname), params);
        this.end();
        this.mgl.glMaterialxv(face, pname, params);
        this.checkError();
    }

    public void glMatrixMode(int mode) {
        this.begin("glMatrixMode");
        this.arg("mode", this.getMatrixMode(mode));
        this.end();
        this.mgl.glMatrixMode(mode);
        this.checkError();
    }

    public void glMultMatrixf(float[] m, int offset) {
        this.begin("glMultMatrixf");
        this.arg("m", 16, m, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glMultMatrixf(m, offset);
        this.checkError();
    }

    public void glMultMatrixf(FloatBuffer m) {
        this.begin("glMultMatrixf");
        this.arg("m", 16, m);
        this.end();
        this.mgl.glMultMatrixf(m);
        this.checkError();
    }

    public void glMultMatrixx(int[] m, int offset) {
        this.begin("glMultMatrixx");
        this.arg("m", 16, m, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glMultMatrixx(m, offset);
        this.checkError();
    }

    public void glMultMatrixx(IntBuffer m) {
        this.begin("glMultMatrixx");
        this.arg("m", 16, m);
        this.end();
        this.mgl.glMultMatrixx(m);
        this.checkError();
    }

    public void glMultiTexCoord4f(int target, float s, float t, float r, float q) {
        this.begin("glMultiTexCoord4f");
        this.arg("target", target);
        this.arg("s", s);
        this.arg("t", t);
        this.arg("r", r);
        this.arg("q", q);
        this.end();
        this.mgl.glMultiTexCoord4f(target, s, t, r, q);
        this.checkError();
    }

    public void glMultiTexCoord4x(int target, int s, int t, int r, int q) {
        this.begin("glMultiTexCoord4x");
        this.arg("target", target);
        this.arg("s", s);
        this.arg("t", t);
        this.arg("r", r);
        this.arg("q", q);
        this.end();
        this.mgl.glMultiTexCoord4x(target, s, t, r, q);
        this.checkError();
    }

    public void glNormal3f(float nx, float ny, float nz) {
        this.begin("glNormal3f");
        this.arg("nx", nx);
        this.arg("ny", ny);
        this.arg("nz", nz);
        this.end();
        this.mgl.glNormal3f(nx, ny, nz);
        this.checkError();
    }

    public void glNormal3x(int nx, int ny, int nz) {
        this.begin("glNormal3x");
        this.arg("nx", nx);
        this.arg("ny", ny);
        this.arg("nz", nz);
        this.end();
        this.mgl.glNormal3x(nx, ny, nz);
        this.checkError();
    }

    public void glNormalPointer(int type, int stride, Buffer pointer) {
        this.begin("glNormalPointer");
        this.arg("type", type);
        this.arg("stride", stride);
        this.arg("pointer", pointer.toString());
        this.end();
        this.mNormalPointer = new PointerInfo(3, type, stride, pointer);
        this.mgl.glNormalPointer(type, stride, pointer);
        this.checkError();
    }

    public void glOrthof(float left, float right, float bottom, float top, float near, float far) {
        this.begin("glOrthof");
        this.arg("left", left);
        this.arg("right", right);
        this.arg("bottom", bottom);
        this.arg("top", top);
        this.arg("near", near);
        this.arg("far", far);
        this.end();
        this.mgl.glOrthof(left, right, bottom, top, near, far);
        this.checkError();
    }

    public void glOrthox(int left, int right, int bottom, int top, int near, int far) {
        this.begin("glOrthox");
        this.arg("left", left);
        this.arg("right", right);
        this.arg("bottom", bottom);
        this.arg("top", top);
        this.arg("near", near);
        this.arg("far", far);
        this.end();
        this.mgl.glOrthox(left, right, bottom, top, near, far);
        this.checkError();
    }

    public void glPixelStorei(int pname, int param) {
        this.begin("glPixelStorei");
        this.arg("pname", pname);
        this.arg("param", param);
        this.end();
        this.mgl.glPixelStorei(pname, param);
        this.checkError();
    }

    public void glPointSize(float size) {
        this.begin("glPointSize");
        this.arg("size", size);
        this.end();
        this.mgl.glPointSize(size);
        this.checkError();
    }

    public void glPointSizex(int size) {
        this.begin("glPointSizex");
        this.arg("size", size);
        this.end();
        this.mgl.glPointSizex(size);
        this.checkError();
    }

    public void glPolygonOffset(float factor, float units) {
        this.begin("glPolygonOffset");
        this.arg("factor", factor);
        this.arg("units", units);
        this.end();
        this.mgl.glPolygonOffset(factor, units);
        this.checkError();
    }

    public void glPolygonOffsetx(int factor, int units) {
        this.begin("glPolygonOffsetx");
        this.arg("factor", factor);
        this.arg("units", units);
        this.end();
        this.mgl.glPolygonOffsetx(factor, units);
        this.checkError();
    }

    public void glPopMatrix() {
        this.begin("glPopMatrix");
        this.end();
        this.mgl.glPopMatrix();
        this.checkError();
    }

    public void glPushMatrix() {
        this.begin("glPushMatrix");
        this.end();
        this.mgl.glPushMatrix();
        this.checkError();
    }

    public void glReadPixels(int x, int y, int width, int height, int format, int type, Buffer pixels) {
        this.begin("glReadPixels");
        this.arg("x", x);
        this.arg("y", y);
        this.arg("width", width);
        this.arg("height", height);
        this.arg("format", format);
        this.arg("type", type);
        this.arg("pixels", pixels.toString());
        this.end();
        this.mgl.glReadPixels(x, y, width, height, format, type, pixels);
        this.checkError();
    }

    public void glRotatef(float angle, float x, float y, float z) {
        this.begin("glRotatef");
        this.arg("angle", angle);
        this.arg("x", x);
        this.arg("y", y);
        this.arg("z", z);
        this.end();
        this.mgl.glRotatef(angle, x, y, z);
        this.checkError();
    }

    public void glRotatex(int angle, int x, int y, int z) {
        this.begin("glRotatex");
        this.arg("angle", angle);
        this.arg("x", x);
        this.arg("y", y);
        this.arg("z", z);
        this.end();
        this.mgl.glRotatex(angle, x, y, z);
        this.checkError();
    }

    public void glSampleCoverage(float value, boolean invert) {
        this.begin("glSampleCoveragex");
        this.arg("value", value);
        this.arg("invert", invert);
        this.end();
        this.mgl.glSampleCoverage(value, invert);
        this.checkError();
    }

    public void glSampleCoveragex(int value, boolean invert) {
        this.begin("glSampleCoveragex");
        this.arg("value", value);
        this.arg("invert", invert);
        this.end();
        this.mgl.glSampleCoveragex(value, invert);
        this.checkError();
    }

    public void glScalef(float x, float y, float z) {
        this.begin("glScalef");
        this.arg("x", x);
        this.arg("y", y);
        this.arg("z", z);
        this.end();
        this.mgl.glScalef(x, y, z);
        this.checkError();
    }

    public void glScalex(int x, int y, int z) {
        this.begin("glScalex");
        this.arg("x", x);
        this.arg("y", y);
        this.arg("z", z);
        this.end();
        this.mgl.glScalex(x, y, z);
        this.checkError();
    }

    public void glScissor(int x, int y, int width, int height) {
        this.begin("glScissor");
        this.arg("x", x);
        this.arg("y", y);
        this.arg("width", width);
        this.arg("height", height);
        this.end();
        this.mgl.glScissor(x, y, width, height);
        this.checkError();
    }

    public void glShadeModel(int mode) {
        this.begin("glShadeModel");
        this.arg("mode", this.getShadeModel(mode));
        this.end();
        this.mgl.glShadeModel(mode);
        this.checkError();
    }

    public void glStencilFunc(int func, int ref, int mask) {
        this.begin("glStencilFunc");
        this.arg("func", func);
        this.arg("ref", ref);
        this.arg("mask", mask);
        this.end();
        this.mgl.glStencilFunc(func, ref, mask);
        this.checkError();
    }

    public void glStencilMask(int mask) {
        this.begin("glStencilMask");
        this.arg("mask", mask);
        this.end();
        this.mgl.glStencilMask(mask);
        this.checkError();
    }

    public void glStencilOp(int fail, int zfail, int zpass) {
        this.begin("glStencilOp");
        this.arg("fail", fail);
        this.arg("zfail", zfail);
        this.arg("zpass", zpass);
        this.end();
        this.mgl.glStencilOp(fail, zfail, zpass);
        this.checkError();
    }

    public void glTexCoordPointer(int size, int type, int stride, Buffer pointer) {
        this.begin("glTexCoordPointer");
        this.argPointer(size, type, stride, pointer);
        this.end();
        this.mTexCoordPointer = new PointerInfo(size, type, stride, pointer);
        this.mgl.glTexCoordPointer(size, type, stride, pointer);
        this.checkError();
    }

    public void glTexEnvf(int target, int pname, float param) {
        this.begin("glTexEnvf");
        this.arg("target", this.getTextureEnvTarget(target));
        this.arg("pname", this.getTextureEnvPName(pname));
        this.arg("param", this.getTextureEnvParamName(param));
        this.end();
        this.mgl.glTexEnvf(target, pname, param);
        this.checkError();
    }

    public void glTexEnvfv(int target, int pname, float[] params, int offset) {
        this.begin("glTexEnvfv");
        this.arg("target", this.getTextureEnvTarget(target));
        this.arg("pname", this.getTextureEnvPName(pname));
        this.arg("params", this.getTextureEnvParamCount(pname), params, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glTexEnvfv(target, pname, params, offset);
        this.checkError();
    }

    public void glTexEnvfv(int target, int pname, FloatBuffer params) {
        this.begin("glTexEnvfv");
        this.arg("target", this.getTextureEnvTarget(target));
        this.arg("pname", this.getTextureEnvPName(pname));
        this.arg("params", this.getTextureEnvParamCount(pname), params);
        this.end();
        this.mgl.glTexEnvfv(target, pname, params);
        this.checkError();
    }

    public void glTexEnvx(int target, int pname, int param) {
        this.begin("glTexEnvx");
        this.arg("target", this.getTextureEnvTarget(target));
        this.arg("pname", this.getTextureEnvPName(pname));
        this.arg("param", param);
        this.end();
        this.mgl.glTexEnvx(target, pname, param);
        this.checkError();
    }

    public void glTexEnvxv(int target, int pname, int[] params, int offset) {
        this.begin("glTexEnvxv");
        this.arg("target", this.getTextureEnvTarget(target));
        this.arg("pname", this.getTextureEnvPName(pname));
        this.arg("params", this.getTextureEnvParamCount(pname), params, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl.glTexEnvxv(target, pname, params, offset);
        this.checkError();
    }

    public void glTexEnvxv(int target, int pname, IntBuffer params) {
        this.begin("glTexEnvxv");
        this.arg("target", this.getTextureEnvTarget(target));
        this.arg("pname", this.getTextureEnvPName(pname));
        this.arg("params", this.getTextureEnvParamCount(pname), params);
        this.end();
        this.mgl.glTexEnvxv(target, pname, params);
        this.checkError();
    }

    public void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, Buffer pixels) {
        this.begin("glTexImage2D");
        this.arg("target", target);
        this.arg("level", level);
        this.arg("internalformat", internalformat);
        this.arg("width", width);
        this.arg("height", height);
        this.arg("border", border);
        this.arg("format", format);
        this.arg("type", type);
        this.arg("pixels", pixels.toString());
        this.end();
        this.mgl.glTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
        this.checkError();
    }

    public void glTexParameterf(int target, int pname, float param) {
        this.begin("glTexParameterf");
        this.arg("target", this.getTextureTarget(target));
        this.arg("pname", this.getTexturePName(pname));
        this.arg("param", this.getTextureParamName(param));
        this.end();
        this.mgl.glTexParameterf(target, pname, param);
        this.checkError();
    }

    public void glTexParameterx(int target, int pname, int param) {
        this.begin("glTexParameterx");
        this.arg("target", this.getTextureTarget(target));
        this.arg("pname", this.getTexturePName(pname));
        this.arg("param", param);
        this.end();
        this.mgl.glTexParameterx(target, pname, param);
        this.checkError();
    }

    public void glTexParameteriv(int target, int pname, int[] params, int offset) {
        this.begin("glTexParameteriv");
        this.arg("target", this.getTextureTarget(target));
        this.arg("pname", this.getTexturePName(pname));
        this.arg("params", 4, params, offset);
        this.end();
        this.mgl11.glTexParameteriv(target, pname, params, offset);
        this.checkError();
    }

    public void glTexParameteriv(int target, int pname, IntBuffer params) {
        this.begin("glTexParameteriv");
        this.arg("target", this.getTextureTarget(target));
        this.arg("pname", this.getTexturePName(pname));
        this.arg("params", 4, params);
        this.end();
        this.mgl11.glTexParameteriv(target, pname, params);
        this.checkError();
    }

    public void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, Buffer pixels) {
        this.begin("glTexSubImage2D");
        this.arg("target", this.getTextureTarget(target));
        this.arg("level", level);
        this.arg("xoffset", xoffset);
        this.arg("yoffset", yoffset);
        this.arg("width", width);
        this.arg("height", height);
        this.arg("format", format);
        this.arg("type", type);
        this.arg("pixels", pixels.toString());
        this.end();
        this.mgl.glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
        this.checkError();
    }

    public void glTranslatef(float x, float y, float z) {
        this.begin("glTranslatef");
        this.arg("x", x);
        this.arg("y", y);
        this.arg("z", z);
        this.end();
        this.mgl.glTranslatef(x, y, z);
        this.checkError();
    }

    public void glTranslatex(int x, int y, int z) {
        this.begin("glTranslatex");
        this.arg("x", x);
        this.arg("y", y);
        this.arg("z", z);
        this.end();
        this.mgl.glTranslatex(x, y, z);
        this.checkError();
    }

    public void glVertexPointer(int size, int type, int stride, Buffer pointer) {
        this.begin("glVertexPointer");
        this.argPointer(size, type, stride, pointer);
        this.end();
        this.mVertexPointer = new PointerInfo(size, type, stride, pointer);
        this.mgl.glVertexPointer(size, type, stride, pointer);
        this.checkError();
    }

    public void glViewport(int x, int y, int width, int height) {
        this.begin("glViewport");
        this.arg("x", x);
        this.arg("y", y);
        this.arg("width", width);
        this.arg("height", height);
        this.end();
        this.mgl.glViewport(x, y, width, height);
        this.checkError();
    }

    public void glClipPlanef(int plane, float[] equation, int offset) {
        this.begin("glClipPlanef");
        this.arg("plane", plane);
        this.arg("equation", 4, equation, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl11.glClipPlanef(plane, equation, offset);
        this.checkError();
    }

    public void glClipPlanef(int plane, FloatBuffer equation) {
        this.begin("glClipPlanef");
        this.arg("plane", plane);
        this.arg("equation", 4, equation);
        this.end();
        this.mgl11.glClipPlanef(plane, equation);
        this.checkError();
    }

    public void glClipPlanex(int plane, int[] equation, int offset) {
        this.begin("glClipPlanex");
        this.arg("plane", plane);
        this.arg("equation", 4, equation, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl11.glClipPlanex(plane, equation, offset);
        this.checkError();
    }

    public void glClipPlanex(int plane, IntBuffer equation) {
        this.begin("glClipPlanef");
        this.arg("plane", plane);
        this.arg("equation", 4, equation);
        this.end();
        this.mgl11.glClipPlanex(plane, equation);
        this.checkError();
    }

    public void glDrawTexfOES(float x, float y, float z, float width, float height) {
        this.begin("glDrawTexfOES");
        this.arg("x", x);
        this.arg("y", y);
        this.arg("z", z);
        this.arg("width", width);
        this.arg("height", height);
        this.end();
        this.mgl11Ext.glDrawTexfOES(x, y, z, width, height);
        this.checkError();
    }

    public void glDrawTexfvOES(float[] coords, int offset) {
        this.begin("glDrawTexfvOES");
        this.arg("coords", 5, coords, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl11Ext.glDrawTexfvOES(coords, offset);
        this.checkError();
    }

    public void glDrawTexfvOES(FloatBuffer coords) {
        this.begin("glDrawTexfvOES");
        this.arg("coords", 5, coords);
        this.end();
        this.mgl11Ext.glDrawTexfvOES(coords);
        this.checkError();
    }

    public void glDrawTexiOES(int x, int y, int z, int width, int height) {
        this.begin("glDrawTexiOES");
        this.arg("x", x);
        this.arg("y", y);
        this.arg("z", z);
        this.arg("width", width);
        this.arg("height", height);
        this.end();
        this.mgl11Ext.glDrawTexiOES(x, y, z, width, height);
        this.checkError();
    }

    public void glDrawTexivOES(int[] coords, int offset) {
        this.begin("glDrawTexivOES");
        this.arg("coords", 5, coords, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl11Ext.glDrawTexivOES(coords, offset);
        this.checkError();
    }

    public void glDrawTexivOES(IntBuffer coords) {
        this.begin("glDrawTexivOES");
        this.arg("coords", 5, coords);
        this.end();
        this.mgl11Ext.glDrawTexivOES(coords);
        this.checkError();
    }

    public void glDrawTexsOES(short x, short y, short z, short width, short height) {
        this.begin("glDrawTexsOES");
        this.arg("x", x);
        this.arg("y", y);
        this.arg("z", z);
        this.arg("width", width);
        this.arg("height", height);
        this.end();
        this.mgl11Ext.glDrawTexsOES(x, y, z, width, height);
        this.checkError();
    }

    public void glDrawTexsvOES(short[] coords, int offset) {
        this.begin("glDrawTexsvOES");
        this.arg("coords", 5, coords, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl11Ext.glDrawTexsvOES(coords, offset);
        this.checkError();
    }

    public void glDrawTexsvOES(ShortBuffer coords) {
        this.begin("glDrawTexsvOES");
        this.arg("coords", 5, coords);
        this.end();
        this.mgl11Ext.glDrawTexsvOES(coords);
        this.checkError();
    }

    public void glDrawTexxOES(int x, int y, int z, int width, int height) {
        this.begin("glDrawTexxOES");
        this.arg("x", x);
        this.arg("y", y);
        this.arg("z", z);
        this.arg("width", width);
        this.arg("height", height);
        this.end();
        this.mgl11Ext.glDrawTexxOES(x, y, z, width, height);
        this.checkError();
    }

    public void glDrawTexxvOES(int[] coords, int offset) {
        this.begin("glDrawTexxvOES");
        this.arg("coords", 5, coords, offset);
        this.arg("offset", offset);
        this.end();
        this.mgl11Ext.glDrawTexxvOES(coords, offset);
        this.checkError();
    }

    public void glDrawTexxvOES(IntBuffer coords) {
        this.begin("glDrawTexxvOES");
        this.arg("coords", 5, coords);
        this.end();
        this.mgl11Ext.glDrawTexxvOES(coords);
        this.checkError();
    }

    public int glQueryMatrixxOES(int[] mantissa, int mantissaOffset, int[] exponent, int exponentOffset) {
        this.begin("glQueryMatrixxOES");
        this.arg("mantissa", Arrays.toString(mantissa));
        this.arg("exponent", Arrays.toString(exponent));
        this.end();
        int valid = this.mgl10Ext.glQueryMatrixxOES(mantissa, mantissaOffset, exponent, exponentOffset);
        this.returns(this.toString(16, 2, mantissa, mantissaOffset));
        this.returns(this.toString(16, 0, exponent, exponentOffset));
        this.checkError();
        return valid;
    }

    public int glQueryMatrixxOES(IntBuffer mantissa, IntBuffer exponent) {
        this.begin("glQueryMatrixxOES");
        this.arg("mantissa", mantissa.toString());
        this.arg("exponent", exponent.toString());
        this.end();
        int valid = this.mgl10Ext.glQueryMatrixxOES(mantissa, exponent);
        this.returns(this.toString(16, 2, mantissa));
        this.returns(this.toString(16, 0, exponent));
        this.checkError();
        return valid;
    }

    public void glBindBuffer(int target, int buffer) {
        this.begin("glBindBuffer");
        this.arg("target", target);
        this.arg("buffer", buffer);
        this.end();
        this.mgl11.glBindBuffer(target, buffer);
        this.checkError();
    }

    public void glBufferData(int target, int size, Buffer data, int usage) {
        this.begin("glBufferData");
        this.arg("target", target);
        this.arg("size", size);
        this.arg("data", data.toString());
        this.arg("usage", usage);
        this.end();
        this.mgl11.glBufferData(target, size, data, usage);
        this.checkError();
    }

    public void glBufferSubData(int target, int offset, int size, Buffer data) {
        this.begin("glBufferSubData");
        this.arg("target", target);
        this.arg("offset", offset);
        this.arg("size", size);
        this.arg("data", data.toString());
        this.end();
        this.mgl11.glBufferSubData(target, offset, size, data);
        this.checkError();
    }

    public void glColor4ub(byte red, byte green, byte blue, byte alpha) {
        this.begin("glColor4ub");
        this.arg("red", red);
        this.arg("green", green);
        this.arg("blue", blue);
        this.arg("alpha", alpha);
        this.end();
        this.mgl11.glColor4ub(red, green, blue, alpha);
        this.checkError();
    }

    public void glDeleteBuffers(int n, int[] buffers, int offset) {
        this.begin("glDeleteBuffers");
        this.arg("n", n);
        this.arg("buffers", buffers.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glDeleteBuffers(n, buffers, offset);
        this.checkError();
    }

    public void glDeleteBuffers(int n, IntBuffer buffers) {
        this.begin("glDeleteBuffers");
        this.arg("n", n);
        this.arg("buffers", buffers.toString());
        this.end();
        this.mgl11.glDeleteBuffers(n, buffers);
        this.checkError();
    }

    public void glGenBuffers(int n, int[] buffers, int offset) {
        this.begin("glGenBuffers");
        this.arg("n", n);
        this.arg("buffers", buffers.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGenBuffers(n, buffers, offset);
        this.checkError();
    }

    public void glGenBuffers(int n, IntBuffer buffers) {
        this.begin("glGenBuffers");
        this.arg("n", n);
        this.arg("buffers", buffers.toString());
        this.end();
        this.mgl11.glGenBuffers(n, buffers);
        this.checkError();
    }

    public void glGetBooleanv(int pname, boolean[] params, int offset) {
        this.begin("glGetBooleanv");
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetBooleanv(pname, params, offset);
        this.checkError();
    }

    public void glGetBooleanv(int pname, IntBuffer params) {
        this.begin("glGetBooleanv");
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetBooleanv(pname, params);
        this.checkError();
    }

    public void glGetBufferParameteriv(int target, int pname, int[] params, int offset) {
        this.begin("glGetBufferParameteriv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetBufferParameteriv(target, pname, params, offset);
        this.checkError();
    }

    public void glGetBufferParameteriv(int target, int pname, IntBuffer params) {
        this.begin("glGetBufferParameteriv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetBufferParameteriv(target, pname, params);
        this.checkError();
    }

    public void glGetClipPlanef(int pname, float[] eqn, int offset) {
        this.begin("glGetClipPlanef");
        this.arg("pname", pname);
        this.arg("eqn", eqn.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetClipPlanef(pname, eqn, offset);
        this.checkError();
    }

    public void glGetClipPlanef(int pname, FloatBuffer eqn) {
        this.begin("glGetClipPlanef");
        this.arg("pname", pname);
        this.arg("eqn", eqn.toString());
        this.end();
        this.mgl11.glGetClipPlanef(pname, eqn);
        this.checkError();
    }

    public void glGetClipPlanex(int pname, int[] eqn, int offset) {
        this.begin("glGetClipPlanex");
        this.arg("pname", pname);
        this.arg("eqn", eqn.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetClipPlanex(pname, eqn, offset);
    }

    public void glGetClipPlanex(int pname, IntBuffer eqn) {
        this.begin("glGetClipPlanex");
        this.arg("pname", pname);
        this.arg("eqn", eqn.toString());
        this.end();
        this.mgl11.glGetClipPlanex(pname, eqn);
        this.checkError();
    }

    public void glGetFixedv(int pname, int[] params, int offset) {
        this.begin("glGetFixedv");
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetFixedv(pname, params, offset);
    }

    public void glGetFixedv(int pname, IntBuffer params) {
        this.begin("glGetFixedv");
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetFixedv(pname, params);
        this.checkError();
    }

    public void glGetFloatv(int pname, float[] params, int offset) {
        this.begin("glGetFloatv");
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetFloatv(pname, params, offset);
    }

    public void glGetFloatv(int pname, FloatBuffer params) {
        this.begin("glGetFloatv");
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetFloatv(pname, params);
        this.checkError();
    }

    public void glGetLightfv(int light, int pname, float[] params, int offset) {
        this.begin("glGetLightfv");
        this.arg("light", light);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetLightfv(light, pname, params, offset);
        this.checkError();
    }

    public void glGetLightfv(int light, int pname, FloatBuffer params) {
        this.begin("glGetLightfv");
        this.arg("light", light);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetLightfv(light, pname, params);
        this.checkError();
    }

    public void glGetLightxv(int light, int pname, int[] params, int offset) {
        this.begin("glGetLightxv");
        this.arg("light", light);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetLightxv(light, pname, params, offset);
        this.checkError();
    }

    public void glGetLightxv(int light, int pname, IntBuffer params) {
        this.begin("glGetLightxv");
        this.arg("light", light);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetLightxv(light, pname, params);
        this.checkError();
    }

    public void glGetMaterialfv(int face, int pname, float[] params, int offset) {
        this.begin("glGetMaterialfv");
        this.arg("face", face);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetMaterialfv(face, pname, params, offset);
        this.checkError();
    }

    public void glGetMaterialfv(int face, int pname, FloatBuffer params) {
        this.begin("glGetMaterialfv");
        this.arg("face", face);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetMaterialfv(face, pname, params);
        this.checkError();
    }

    public void glGetMaterialxv(int face, int pname, int[] params, int offset) {
        this.begin("glGetMaterialxv");
        this.arg("face", face);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetMaterialxv(face, pname, params, offset);
        this.checkError();
    }

    public void glGetMaterialxv(int face, int pname, IntBuffer params) {
        this.begin("glGetMaterialxv");
        this.arg("face", face);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetMaterialxv(face, pname, params);
        this.checkError();
    }

    public void glGetTexEnviv(int env, int pname, int[] params, int offset) {
        this.begin("glGetTexEnviv");
        this.arg("env", env);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetTexEnviv(env, pname, params, offset);
        this.checkError();
    }

    public void glGetTexEnviv(int env, int pname, IntBuffer params) {
        this.begin("glGetTexEnviv");
        this.arg("env", env);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetTexEnviv(env, pname, params);
        this.checkError();
    }

    public void glGetTexEnvxv(int env, int pname, int[] params, int offset) {
        this.begin("glGetTexEnviv");
        this.arg("env", env);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetTexEnviv(env, pname, params, offset);
        this.checkError();
    }

    public void glGetTexEnvxv(int env, int pname, IntBuffer params) {
        this.begin("glGetTexEnviv");
        this.arg("env", env);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetTexEnvxv(env, pname, params);
        this.checkError();
    }

    public void glGetTexParameterfv(int target, int pname, float[] params, int offset) {
        this.begin("glGetTexParameterfv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetTexParameterfv(target, pname, params, offset);
        this.checkError();
    }

    public void glGetTexParameterfv(int target, int pname, FloatBuffer params) {
        this.begin("glGetTexParameterfv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetTexParameterfv(target, pname, params);
        this.checkError();
    }

    public void glGetTexParameteriv(int target, int pname, int[] params, int offset) {
        this.begin("glGetTexParameteriv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetTexEnviv(target, pname, params, offset);
        this.checkError();
    }

    public void glGetTexParameteriv(int target, int pname, IntBuffer params) {
        this.begin("glGetTexParameteriv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetTexParameteriv(target, pname, params);
        this.checkError();
    }

    public void glGetTexParameterxv(int target, int pname, int[] params, int offset) {
        this.begin("glGetTexParameterxv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glGetTexParameterxv(target, pname, params, offset);
        this.checkError();
    }

    public void glGetTexParameterxv(int target, int pname, IntBuffer params) {
        this.begin("glGetTexParameterxv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetTexParameterxv(target, pname, params);
        this.checkError();
    }

    public boolean glIsBuffer(int buffer) {
        this.begin("glIsBuffer");
        this.arg("buffer", buffer);
        this.end();
        boolean result = this.mgl11.glIsBuffer(buffer);
        this.checkError();
        return result;
    }

    public boolean glIsEnabled(int cap) {
        this.begin("glIsEnabled");
        this.arg("cap", cap);
        this.end();
        boolean result = this.mgl11.glIsEnabled(cap);
        this.checkError();
        return result;
    }

    public boolean glIsTexture(int texture) {
        this.begin("glIsTexture");
        this.arg("texture", texture);
        this.end();
        boolean result = this.mgl11.glIsTexture(texture);
        this.checkError();
        return result;
    }

    public void glPointParameterf(int pname, float param) {
        this.begin("glPointParameterf");
        this.arg("pname", pname);
        this.arg("param", param);
        this.end();
        this.mgl11.glPointParameterf(pname, param);
        this.checkError();
    }

    public void glPointParameterfv(int pname, float[] params, int offset) {
        this.begin("glPointParameterfv");
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glPointParameterfv(pname, params, offset);
        this.checkError();
    }

    public void glPointParameterfv(int pname, FloatBuffer params) {
        this.begin("glPointParameterfv");
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glPointParameterfv(pname, params);
        this.checkError();
    }

    public void glPointParameterx(int pname, int param) {
        this.begin("glPointParameterfv");
        this.arg("pname", pname);
        this.arg("param", param);
        this.end();
        this.mgl11.glPointParameterx(pname, param);
        this.checkError();
    }

    public void glPointParameterxv(int pname, int[] params, int offset) {
        this.begin("glPointParameterxv");
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glPointParameterxv(pname, params, offset);
        this.checkError();
    }

    public void glPointParameterxv(int pname, IntBuffer params) {
        this.begin("glPointParameterxv");
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glPointParameterxv(pname, params);
        this.checkError();
    }

    public void glPointSizePointerOES(int type, int stride, Buffer pointer) {
        this.begin("glPointSizePointerOES");
        this.arg("type", type);
        this.arg("stride", stride);
        this.arg("params", pointer.toString());
        this.end();
        this.mgl11.glPointSizePointerOES(type, stride, pointer);
        this.checkError();
    }

    public void glTexEnvi(int target, int pname, int param) {
        this.begin("glTexEnvi");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("param", param);
        this.end();
        this.mgl11.glTexEnvi(target, pname, param);
        this.checkError();
    }

    public void glTexEnviv(int target, int pname, int[] params, int offset) {
        this.begin("glTexEnviv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glTexEnviv(target, pname, params, offset);
        this.checkError();
    }

    public void glTexEnviv(int target, int pname, IntBuffer params) {
        this.begin("glTexEnviv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glTexEnviv(target, pname, params);
        this.checkError();
    }

    public void glTexParameterfv(int target, int pname, float[] params, int offset) {
        this.begin("glTexParameterfv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glTexParameterfv(target, pname, params, offset);
        this.checkError();
    }

    public void glTexParameterfv(int target, int pname, FloatBuffer params) {
        this.begin("glTexParameterfv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glTexParameterfv(target, pname, params);
        this.checkError();
    }

    public void glTexParameteri(int target, int pname, int param) {
        this.begin("glTexParameterxv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("param", param);
        this.end();
        this.mgl11.glTexParameteri(target, pname, param);
        this.checkError();
    }

    public void glTexParameterxv(int target, int pname, int[] params, int offset) {
        this.begin("glTexParameterxv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.arg("offset", offset);
        this.end();
        this.mgl11.glTexParameterxv(target, pname, params, offset);
        this.checkError();
    }

    public void glTexParameterxv(int target, int pname, IntBuffer params) {
        this.begin("glTexParameterxv");
        this.arg("target", target);
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glTexParameterxv(target, pname, params);
        this.checkError();
    }

    public void glColorPointer(int size, int type, int stride, int offset) {
        this.begin("glColorPointer");
        this.arg("size", size);
        this.arg("type", type);
        this.arg("stride", stride);
        this.arg("offset", offset);
        this.end();
        this.mgl11.glColorPointer(size, type, stride, offset);
        this.checkError();
    }

    public void glDrawElements(int mode, int count, int type, int offset) {
        this.begin("glDrawElements");
        this.arg("mode", mode);
        this.arg("count", count);
        this.arg("type", type);
        this.arg("offset", offset);
        this.end();
        this.mgl11.glDrawElements(mode, count, type, offset);
        this.checkError();
    }

    public void glGetPointerv(int pname, Buffer[] params) {
        this.begin("glGetPointerv");
        this.arg("pname", pname);
        this.arg("params", params.toString());
        this.end();
        this.mgl11.glGetPointerv(pname, params);
        this.checkError();
    }

    public void glNormalPointer(int type, int stride, int offset) {
        this.begin("glNormalPointer");
        this.arg("type", type);
        this.arg("stride", stride);
        this.arg("offset", offset);
        this.end();
        this.mgl11.glNormalPointer(type, stride, offset);
    }

    public void glTexCoordPointer(int size, int type, int stride, int offset) {
        this.begin("glTexCoordPointer");
        this.arg("size", size);
        this.arg("type", type);
        this.arg("stride", stride);
        this.arg("offset", offset);
        this.end();
        this.mgl11.glTexCoordPointer(size, type, stride, offset);
    }

    public void glVertexPointer(int size, int type, int stride, int offset) {
        this.begin("glVertexPointer");
        this.arg("size", size);
        this.arg("type", type);
        this.arg("stride", stride);
        this.arg("offset", offset);
        this.end();
        this.mgl11.glVertexPointer(size, type, stride, offset);
    }

    public void glCurrentPaletteMatrixOES(int matrixpaletteindex) {
        this.begin("glCurrentPaletteMatrixOES");
        this.arg("matrixpaletteindex", matrixpaletteindex);
        this.end();
        this.mgl11Ext.glCurrentPaletteMatrixOES(matrixpaletteindex);
        this.checkError();
    }

    public void glLoadPaletteFromModelViewMatrixOES() {
        this.begin("glLoadPaletteFromModelViewMatrixOES");
        this.end();
        this.mgl11Ext.glLoadPaletteFromModelViewMatrixOES();
        this.checkError();
    }

    public void glMatrixIndexPointerOES(int size, int type, int stride, Buffer pointer) {
        this.begin("glMatrixIndexPointerOES");
        this.argPointer(size, type, stride, pointer);
        this.end();
        this.mgl11Ext.glMatrixIndexPointerOES(size, type, stride, pointer);
        this.checkError();
    }

    public void glMatrixIndexPointerOES(int size, int type, int stride, int offset) {
        this.begin("glMatrixIndexPointerOES");
        this.arg("size", size);
        this.arg("type", type);
        this.arg("stride", stride);
        this.arg("offset", offset);
        this.end();
        this.mgl11Ext.glMatrixIndexPointerOES(size, type, stride, offset);
        this.checkError();
    }

    public void glWeightPointerOES(int size, int type, int stride, Buffer pointer) {
        this.begin("glWeightPointerOES");
        this.argPointer(size, type, stride, pointer);
        this.end();
        this.mgl11Ext.glWeightPointerOES(size, type, stride, pointer);
        this.checkError();
    }

    public void glWeightPointerOES(int size, int type, int stride, int offset) {
        this.begin("glWeightPointerOES");
        this.arg("size", size);
        this.arg("type", type);
        this.arg("stride", stride);
        this.arg("offset", offset);
        this.end();
        this.mgl11Ext.glWeightPointerOES(size, type, stride, offset);
        this.checkError();
    }

    private class PointerInfo {
        public int mSize;
        public int mType;
        public int mStride;
        public Buffer mPointer;
        public ByteBuffer mTempByteBuffer;

        public PointerInfo() {
        }

        public PointerInfo(int size, int type, int stride, Buffer pointer) {
            this.mSize = size;
            this.mType = type;
            this.mStride = stride;
            this.mPointer = pointer;
        }

        public int sizeof(int type) {
            switch (type) {
                case 5121: {
                    return 1;
                }
                case 5120: {
                    return 1;
                }
                case 5122: {
                    return 2;
                }
                case 5132: {
                    return 4;
                }
                case 5126: {
                    return 4;
                }
            }
            return 0;
        }

        public int getStride() {
            return this.mStride > 0 ? this.mStride : this.sizeof(this.mType) * this.mSize;
        }

        public void bindByteBuffer() {
            this.mTempByteBuffer = this.mPointer == null ? null : GLLogWrapper.this.toByteBuffer(-1, this.mPointer);
        }

        public void unbindByteBuffer() {
            this.mTempByteBuffer = null;
        }
    }
}

