/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.opengl.ETC1;
import android.opengl.GLES10;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ETC1Util {
    public static void loadTexture(int target, int level, int border, int fallbackFormat, int fallbackType, InputStream input) throws IOException {
        ETC1Util.loadTexture(target, level, border, fallbackFormat, fallbackType, ETC1Util.createTexture(input));
    }

    public static void loadTexture(int target, int level, int border, int fallbackFormat, int fallbackType, ETC1Texture texture) {
        if (fallbackFormat != 6407) {
            throw new IllegalArgumentException("fallbackFormat must be GL_RGB");
        }
        if (fallbackType != 33635 && fallbackType != 5121) {
            throw new IllegalArgumentException("Unsupported fallbackType");
        }
        int width = texture.getWidth();
        int height = texture.getHeight();
        ByteBuffer data = texture.getData();
        if (ETC1Util.isETC1Supported()) {
            int imageSize = data.remaining();
            GLES10.glCompressedTexImage2D(target, level, 36196, width, height, border, imageSize, data);
        } else {
            boolean useShorts = fallbackType != 5121;
            int pixelSize = useShorts ? 2 : 3;
            int stride = pixelSize * width;
            ByteBuffer decodedData = ByteBuffer.allocateDirect(stride * height).order(ByteOrder.nativeOrder());
            ETC1.decodeImage(data, decodedData, width, height, pixelSize, stride);
            GLES10.glTexImage2D(target, level, fallbackFormat, width, height, border, fallbackFormat, fallbackType, decodedData);
        }
    }

    public static boolean isETC1Supported() {
        int[] results = new int[20];
        GLES10.glGetIntegerv(34466, results, 0);
        int numFormats = results[0];
        if (numFormats > results.length) {
            results = new int[numFormats];
        }
        GLES10.glGetIntegerv(34467, results, 0);
        for (int i = 0; i < numFormats; ++i) {
            if (results[i] != 36196) continue;
            return true;
        }
        return false;
    }

    public static ETC1Texture createTexture(InputStream input) throws IOException {
        int chunkSize;
        int width = 0;
        int height = 0;
        byte[] ioBuffer = new byte[4096];
        if (input.read(ioBuffer, 0, 16) != 16) {
            throw new IOException("Unable to read PKM file header.");
        }
        ByteBuffer headerBuffer = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder());
        headerBuffer.put(ioBuffer, 0, 16).position(0);
        if (!ETC1.isValid(headerBuffer)) {
            throw new IOException("Not a PKM file.");
        }
        width = ETC1.getWidth(headerBuffer);
        height = ETC1.getHeight(headerBuffer);
        int encodedSize = ETC1.getEncodedDataSize(width, height);
        ByteBuffer dataBuffer = ByteBuffer.allocateDirect(encodedSize).order(ByteOrder.nativeOrder());
        for (int i = 0; i < encodedSize; i += chunkSize) {
            chunkSize = Math.min(ioBuffer.length, encodedSize - i);
            if (input.read(ioBuffer, 0, chunkSize) != chunkSize) {
                throw new IOException("Unable to read PKM file data.");
            }
            dataBuffer.put(ioBuffer, 0, chunkSize);
        }
        dataBuffer.position(0);
        return new ETC1Texture(width, height, dataBuffer);
    }

    public static ETC1Texture compressTexture(Buffer input, int width, int height, int pixelSize, int stride) {
        int encodedImageSize = ETC1.getEncodedDataSize(width, height);
        ByteBuffer compressedImage = ByteBuffer.allocateDirect(encodedImageSize).order(ByteOrder.nativeOrder());
        ETC1.encodeImage(input, width, height, 3, stride, compressedImage);
        return new ETC1Texture(width, height, compressedImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTexture(ETC1Texture texture, OutputStream output) throws IOException {
        ByteBuffer dataBuffer = texture.getData();
        int originalPosition = dataBuffer.position();
        try {
            int chunkSize;
            int width = texture.getWidth();
            int height = texture.getHeight();
            ByteBuffer header = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder());
            ETC1.formatHeader(header, width, height);
            byte[] ioBuffer = new byte[4096];
            header.get(ioBuffer, 0, 16);
            output.write(ioBuffer, 0, 16);
            int encodedSize = ETC1.getEncodedDataSize(width, height);
            for (int i = 0; i < encodedSize; i += chunkSize) {
                chunkSize = Math.min(ioBuffer.length, encodedSize - i);
                dataBuffer.get(ioBuffer, 0, chunkSize);
                output.write(ioBuffer, 0, chunkSize);
            }
        }
        finally {
            dataBuffer.position(originalPosition);
        }
    }

    public static class ETC1Texture {
        private int mWidth;
        private int mHeight;
        private ByteBuffer mData;

        public ETC1Texture(int width, int height, ByteBuffer data) {
            this.mWidth = width;
            this.mHeight = height;
            this.mData = data;
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public ByteBuffer getData() {
            return this.mData;
        }
    }
}

