/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.os.Parcel;
import android.os.Parcelable;

public final class TransceiveResult
implements Parcelable {
    private final boolean mTagLost;
    private final boolean mSuccess;
    private final byte[] mResponseData;
    public static final Parcelable.Creator<TransceiveResult> CREATOR = new Parcelable.Creator<TransceiveResult>(){

        @Override
        public TransceiveResult createFromParcel(Parcel in) {
            byte[] responseData;
            boolean tagLost;
            boolean success = in.readInt() == 1;
            boolean bl = tagLost = in.readInt() == 1;
            if (success) {
                int responseLength = in.readInt();
                responseData = new byte[responseLength];
                in.readByteArray(responseData);
            } else {
                responseData = null;
            }
            return new TransceiveResult(success, tagLost, responseData);
        }

        public TransceiveResult[] newArray(int size) {
            return new TransceiveResult[size];
        }
    };

    public TransceiveResult(boolean success, boolean tagIsLost, byte[] data) {
        this.mSuccess = success;
        this.mTagLost = tagIsLost;
        this.mResponseData = data;
    }

    public boolean isSuccessful() {
        return this.mSuccess;
    }

    public boolean isTagLost() {
        return this.mTagLost;
    }

    public byte[] getResponseData() {
        return this.mResponseData;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mSuccess ? 1 : 0);
        dest.writeInt(this.mTagLost ? 1 : 0);
        if (this.mSuccess) {
            dest.writeInt(this.mResponseData.length);
            dest.writeByteArray(this.mResponseData);
        }
    }
}

