/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.app.Activity;
import android.app.ActivityThread;
import android.app.OnActivityPausedListener;
import android.app.PendingIntent;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.IPackageManager;
import android.nfc.INfcAdapter;
import android.nfc.INfcAdapterExtras;
import android.nfc.INfcTag;
import android.nfc.NdefMessage;
import android.nfc.NfcManager;
import android.nfc.TechListParcel;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;

public final class NfcAdapter {
    private static final String TAG = "NFC";
    public static final String ACTION_NDEF_DISCOVERED = "android.nfc.action.NDEF_DISCOVERED";
    public static final String ACTION_TECH_DISCOVERED = "android.nfc.action.TECH_DISCOVERED";
    public static final String ACTION_TAG_DISCOVERED = "android.nfc.action.TAG_DISCOVERED";
    public static final String ACTION_TAG_LEFT_FIELD = "android.nfc.action.TAG_LOST";
    public static final String EXTRA_TAG = "android.nfc.extra.TAG";
    public static final String EXTRA_NDEF_MESSAGES = "android.nfc.extra.NDEF_MESSAGES";
    public static final String EXTRA_ID = "android.nfc.extra.ID";
    public static final String ACTION_ADAPTER_STATE_CHANGE = "android.nfc.action.ADAPTER_STATE_CHANGE";
    public static final String EXTRA_NEW_BOOLEAN_STATE = "android.nfc.isEnabled";
    public static final int LLCP_LINK_STATE_ACTIVATED = 0;
    public static final int LLCP_LINK_STATE_DEACTIVATED = 1;
    public static final String ACTION_LLCP_LINK_STATE_CHANGED = "android.nfc.action.LLCP_LINK_STATE_CHANGED";
    public static final String EXTRA_LLCP_LINK_STATE_CHANGED = "android.nfc.extra.LLCP_LINK_STATE";
    private static final int DISCOVERY_MODE_TAG_READER = 0;
    private static final int DISCOVERY_MODE_NFCIP1 = 1;
    private static final int DISCOVERY_MODE_CARD_EMULATION = 2;
    private static boolean sIsInitialized = false;
    private static INfcAdapter sService;
    private static INfcTag sTagService;
    OnActivityPausedListener mForegroundDispatchListener = new OnActivityPausedListener(){

        public void onPaused(Activity activity) {
            NfcAdapter.this.disableForegroundDispatchInternal(activity, true);
        }
    };
    OnActivityPausedListener mForegroundNdefPushListener = new OnActivityPausedListener(){

        public void onPaused(Activity activity) {
            NfcAdapter.this.disableForegroundNdefPushInternal(activity, true);
        }
    };

    private static boolean hasNfcFeature() {
        IPackageManager pm = ActivityThread.getPackageManager();
        if (pm == null) {
            Log.e(TAG, "Cannot get package manager, assuming no NFC feature");
            return false;
        }
        try {
            return pm.hasSystemFeature("android.hardware.nfc");
        }
        catch (RemoteException e) {
            Log.e(TAG, "Package manager query failed, assuming no NFC feature", e);
            return false;
        }
    }

    private static synchronized INfcAdapter setupService() {
        if (!sIsInitialized) {
            sIsInitialized = true;
            if (!NfcAdapter.hasNfcFeature()) {
                Log.v(TAG, "this device does not have NFC support");
                return null;
            }
            sService = NfcAdapter.getServiceInterface();
            if (sService == null) {
                Log.e(TAG, "could not retrieve NFC service");
                return null;
            }
            try {
                sTagService = sService.getNfcTagInterface();
            }
            catch (RemoteException e) {
                Log.e(TAG, "could not retrieve NFC Tag service");
                return null;
            }
        }
        return sService;
    }

    private static INfcAdapter getServiceInterface() {
        IBinder b = ServiceManager.getService("nfc");
        if (b == null) {
            return null;
        }
        return INfcAdapter.Stub.asInterface(b);
    }

    public static NfcAdapter getDefaultAdapter(Context context) {
        NfcManager manager = (NfcManager)context.getSystemService("nfc");
        return manager.getDefaultAdapter();
    }

    @Deprecated
    public static NfcAdapter getDefaultAdapter() {
        Log.w(TAG, "WARNING: NfcAdapter.getDefaultAdapter() is deprecated, use NfcAdapter.getDefaultAdapter(Context) instead", new Exception());
        return new NfcAdapter(null);
    }

    NfcAdapter(Context context) {
        if (NfcAdapter.setupService() == null) {
            throw new UnsupportedOperationException();
        }
    }

    public INfcAdapter getService() {
        this.isEnabled();
        return sService;
    }

    public INfcTag getTagService() {
        this.isEnabled();
        return sTagService;
    }

    public void attemptDeadServiceRecovery(Exception e) {
        Log.e(TAG, "NFC service dead - attempting to recover", e);
        INfcAdapter service = NfcAdapter.getServiceInterface();
        if (service == null) {
            Log.e(TAG, "could not retrieve NFC service during service recovery");
            return;
        }
        sService = service;
        try {
            sTagService = service.getNfcTagInterface();
        }
        catch (RemoteException ee) {
            Log.e(TAG, "could not retrieve NFC tag service during service recovery");
        }
    }

    public boolean isEnabled() {
        try {
            return sService.isEnabled();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            return false;
        }
    }

    public boolean enable() {
        try {
            return sService.enable();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            return false;
        }
    }

    public boolean disable() {
        try {
            return sService.disable();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            return false;
        }
    }

    public void enableForegroundDispatch(Activity activity, PendingIntent intent, IntentFilter[] filters, String[][] techLists) {
        if (activity == null || intent == null) {
            throw new NullPointerException();
        }
        if (!activity.isResumed()) {
            throw new IllegalStateException("Foregorund dispatching can only be enabled when your activity is resumed");
        }
        try {
            TechListParcel parcel = null;
            if (techLists != null && techLists.length > 0) {
                parcel = new TechListParcel(techLists);
            }
            ActivityThread.currentActivityThread().registerOnActivityPausedListener(activity, this.mForegroundDispatchListener);
            sService.enableForegroundDispatch(activity.getComponentName(), intent, filters, parcel);
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
        }
    }

    public void disableForegroundDispatch(Activity activity) {
        ActivityThread.currentActivityThread().unregisterOnActivityPausedListener(activity, this.mForegroundDispatchListener);
        this.disableForegroundDispatchInternal(activity, false);
    }

    void disableForegroundDispatchInternal(Activity activity, boolean force) {
        try {
            sService.disableForegroundDispatch(activity.getComponentName());
            if (!force && !activity.isResumed()) {
                throw new IllegalStateException("You must disable forgeground dispatching while your activity is still resumed");
            }
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
        }
    }

    public void enableForegroundNdefPush(Activity activity, NdefMessage msg) {
        if (activity == null || msg == null) {
            throw new NullPointerException();
        }
        if (!activity.isResumed()) {
            throw new IllegalStateException("Foregorund NDEF push can only be enabled when your activity is resumed");
        }
        try {
            ActivityThread.currentActivityThread().registerOnActivityPausedListener(activity, this.mForegroundNdefPushListener);
            sService.enableForegroundNdefPush(activity.getComponentName(), msg);
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
        }
    }

    public void disableForegroundNdefPush(Activity activity) {
        ActivityThread.currentActivityThread().unregisterOnActivityPausedListener(activity, this.mForegroundNdefPushListener);
        this.disableForegroundNdefPushInternal(activity, false);
    }

    void disableForegroundNdefPushInternal(Activity activity, boolean force) {
        try {
            sService.disableForegroundNdefPush(activity.getComponentName());
            if (!force && !activity.isResumed()) {
                throw new IllegalStateException("You must disable forgeground NDEF push while your activity is still resumed");
            }
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
        }
    }

    public void setLocalNdefMessage(NdefMessage message) {
        try {
            sService.localSet(message);
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
        }
    }

    public NdefMessage getLocalNdefMessage() {
        try {
            return sService.localGet();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            return null;
        }
    }

    public INfcAdapterExtras getNfcAdapterExtrasInterface() {
        try {
            return sService.getNfcAdapterExtrasInterface();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            return null;
        }
    }
}

