/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.nfc.FormatException;
import android.os.Parcel;
import android.os.Parcelable;

public final class NdefRecord
implements Parcelable {
    public static final short TNF_EMPTY = 0;
    public static final short TNF_WELL_KNOWN = 1;
    public static final short TNF_MIME_MEDIA = 2;
    public static final short TNF_ABSOLUTE_URI = 3;
    public static final short TNF_EXTERNAL_TYPE = 4;
    public static final short TNF_UNKNOWN = 5;
    public static final short TNF_UNCHANGED = 6;
    public static final short TNF_RESERVED = 7;
    public static final byte[] RTD_TEXT = new byte[]{84};
    public static final byte[] RTD_URI = new byte[]{85};
    public static final byte[] RTD_SMART_POSTER = new byte[]{83, 112};
    public static final byte[] RTD_ALTERNATIVE_CARRIER = new byte[]{97, 99};
    public static final byte[] RTD_HANDOVER_CARRIER = new byte[]{72, 99};
    public static final byte[] RTD_HANDOVER_REQUEST = new byte[]{72, 114};
    public static final byte[] RTD_HANDOVER_SELECT = new byte[]{72, 115};
    private static final byte FLAG_MB = -128;
    private static final byte FLAG_ME = 64;
    private static final byte FLAG_CF = 32;
    private static final byte FLAG_SR = 16;
    private static final byte FLAG_IL = 8;
    private final byte mFlags;
    private final short mTnf;
    private final byte[] mType;
    private final byte[] mId;
    private final byte[] mPayload;
    public static final Parcelable.Creator<NdefRecord> CREATOR = new Parcelable.Creator<NdefRecord>(){

        @Override
        public NdefRecord createFromParcel(Parcel in) {
            short tnf = (short)in.readInt();
            int typeLength = in.readInt();
            byte[] type = new byte[typeLength];
            in.readByteArray(type);
            int idLength = in.readInt();
            byte[] id2 = new byte[idLength];
            in.readByteArray(id2);
            int payloadLength = in.readInt();
            byte[] payload = new byte[payloadLength];
            in.readByteArray(payload);
            return new NdefRecord(tnf, type, id2, payload);
        }

        public NdefRecord[] newArray(int size) {
            return new NdefRecord[size];
        }
    };

    public NdefRecord(short tnf, byte[] type, byte[] id2, byte[] payload) {
        if (type == null || id2 == null || payload == null) {
            throw new IllegalArgumentException("Illegal null argument");
        }
        if (tnf < 0 || tnf > 7) {
            throw new IllegalArgumentException("TNF out of range " + tnf);
        }
        int flags = -64;
        if (payload.length < 255) {
            flags = (byte)(flags | 0x10);
        }
        if (id2.length != 0) {
            flags = (byte)(flags | 8);
        }
        this.mFlags = (byte)flags;
        this.mTnf = tnf;
        this.mType = (byte[])type.clone();
        this.mId = (byte[])id2.clone();
        this.mPayload = (byte[])payload.clone();
    }

    public NdefRecord(byte[] data) throws FormatException {
        this.mFlags = 0;
        this.mTnf = 0;
        this.mType = null;
        this.mId = null;
        this.mPayload = null;
        if (this.parseNdefRecord(data) == -1) {
            throw new FormatException("Error while parsing NDEF record");
        }
    }

    public short getTnf() {
        return this.mTnf;
    }

    public byte[] getType() {
        return (byte[])this.mType.clone();
    }

    public byte[] getId() {
        return (byte[])this.mId.clone();
    }

    public byte[] getPayload() {
        return (byte[])this.mPayload.clone();
    }

    public byte[] toByteArray() {
        return this.generate(this.mFlags, this.mTnf, this.mType, this.mId, this.mPayload);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mTnf);
        dest.writeInt(this.mType.length);
        dest.writeByteArray(this.mType);
        dest.writeInt(this.mId.length);
        dest.writeByteArray(this.mId);
        dest.writeInt(this.mPayload.length);
        dest.writeByteArray(this.mPayload);
    }

    private native int parseNdefRecord(byte[] var1);

    private native byte[] generate(short var1, short var2, byte[] var3, byte[] var4, byte[] var5);
}

