/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.app.ActivityManagerNative;
import android.app.AlarmManager;
import android.app.Notification;
import android.app.PendingIntent;
import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.DhcpInfo;
import android.net.NetworkInfo;
import android.net.NetworkStateTracker;
import android.net.NetworkUtils;
import android.net.wifi.ScanResult;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiMonitor;
import android.net.wifi.WifiNative;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.WorkSource;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.app.IBatteryStats;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WifiStateTracker
extends NetworkStateTracker {
    private static final boolean LOCAL_LOGD = true;
    private static final String TAG = "WifiStateTracker";
    private static final int EVENTLOG_NETWORK_STATE_CHANGED = 50021;
    private static final int EVENTLOG_SUPPLICANT_STATE_CHANGED = 50022;
    private static final int EVENTLOG_DRIVER_STATE_CHANGED = 50023;
    private static final int EVENTLOG_INTERFACE_CONFIGURATION_STATE_CHANGED = 50024;
    private static final int EVENTLOG_SUPPLICANT_CONNECTION_STATE_CHANGED = 50025;
    private static final int EVENT_SUPPLICANT_CONNECTION = 1;
    private static final int EVENT_SUPPLICANT_DISCONNECT = 2;
    private static final int EVENT_SUPPLICANT_STATE_CHANGED = 3;
    private static final int EVENT_NETWORK_STATE_CHANGED = 4;
    private static final int EVENT_SCAN_RESULTS_AVAILABLE = 5;
    private static final int EVENT_INTERFACE_CONFIGURATION_SUCCEEDED = 6;
    private static final int EVENT_INTERFACE_CONFIGURATION_FAILED = 7;
    private static final int EVENT_POLL_INTERVAL = 8;
    private static final int EVENT_DHCP_START = 9;
    private static final int EVENT_DHCP_RENEW = 10;
    private static final int EVENT_DEFERRED_DISCONNECT = 11;
    private static final int EVENT_DEFERRED_RECONNECT = 12;
    private static final int EVENT_DRIVER_STATE_CHANGED = 13;
    private static final int EVENT_PASSWORD_KEY_MAY_BE_INCORRECT = 14;
    private static final int EVENT_MAYBE_START_SCAN_POST_DISCONNECT = 15;
    private static final int DRIVER_STARTED = 0;
    private static final int DRIVER_STOPPED = 1;
    private static final int DRIVER_HUNG = 2;
    private static final int POLL_STATUS_INTERVAL_MSECS = 3000;
    private static final int MAX_SUPPLICANT_LOOP_ITERATIONS = 4;
    private static final int DISCONNECT_DELAY_MSECS = 5000;
    private static final int RECONNECT_DELAY_MSECS = 2000;
    private static final int KICKSTART_SCANNING_DELAY_MSECS = 15000;
    private static final int DEFAULT_MAX_DHCP_RETRIES = 9;
    private static final int MIN_RENEWAL_TIME_SECS = 300;
    private static final int DRIVER_POWER_MODE_AUTO = 0;
    private static final int DRIVER_POWER_MODE_ACTIVE = 1;
    private SupplicantState mSupplicantLoopState = SupplicantState.DISCONNECTED;
    private int mNumSupplicantLoopIterations = 0;
    private int mNumSupplicantStateChanges = 0;
    private boolean mPasswordKeyMayBeIncorrect = false;
    public static final int SUPPL_SCAN_HANDLING_NORMAL = 1;
    public static final int SUPPL_SCAN_HANDLING_LIST_ONLY = 2;
    private WifiMonitor mWifiMonitor;
    private WifiInfo mWifiInfo;
    private List<ScanResult> mScanResults;
    private WifiManager mWM;
    private boolean mHaveIpAddress = false;
    private boolean mObtainingIpAddress = false;
    private boolean mTornDownByConnMgr;
    private boolean mDisconnectPending;
    private boolean mDisconnectExpected;
    private DhcpHandler mDhcpTarget;
    private DhcpInfo mDhcpInfo;
    private int mLastSignalLevel = -1;
    private String mLastBssid;
    private String mLastSsid;
    private int mLastNetworkId = -1;
    private boolean mUseStaticIp = false;
    private int mReconnectCount;
    private AlarmManager mAlarmManager;
    private PendingIntent mDhcpRenewalIntent;
    private PowerManager.WakeLock mDhcpRenewWakeLock;
    private static final String WAKELOCK_TAG = "*wifi*";
    private static final int DHCP_RENEW = 0;
    private static final String ACTION_DHCP_RENEW = "android.net.wifi.DHCP_RENEW";
    private AtomicBoolean mIsAnyNetworkDisabled = new AtomicBoolean(false);
    private int mNumAllowedChannels = 0;
    private static final int ICON_NETWORKS_AVAILABLE = 17302164;
    private final long NOTIFICATION_REPEAT_DELAY_MS;
    private boolean mNotificationEnabled;
    private NotificationEnabledSettingObserver mNotificationEnabledSettingObserver;
    private long mNotificationRepeatTime;
    private Notification mNotification;
    private boolean mNotificationShown;
    private static final int NUM_SCANS_BEFORE_ACTUALLY_SCANNING = 3;
    private int mNumScansSinceNetworkStateChange;
    private SettingsObserver mSettingsObserver;
    private boolean mIsScanModeActive;
    private boolean mEnableRssiPolling;
    private boolean mIsHighPerfEnabled;
    private int mPowerModeRefCount = 0;
    private int mOptimizationsDisabledRefCount = 0;
    private final AtomicInteger mWifiState = new AtomicInteger(4);
    private static final int RUN_STATE_STARTING = 1;
    private static final int RUN_STATE_RUNNING = 2;
    private static final int RUN_STATE_STOPPING = 3;
    private static final int RUN_STATE_STOPPED = 4;
    private static final String[] mRunStateNames = new String[]{"Starting", "Running", "Stopping", "Stopped"};
    private int mRunState;
    private final IBatteryStats mBatteryStats;
    private boolean mIsScanOnly;
    private BluetoothA2dp mBluetoothA2dp;
    private String mInterfaceName;
    private static String LS = System.getProperty("line.separator");
    private static String[] sDnsPropNames;
    private boolean mReportedRunning = false;
    private final WorkSource mRunningWifiUids = new WorkSource();
    private final WorkSource mLastRunningWifiUids = new WorkSource();

    public WifiStateTracker(Context context, Handler target) {
        super(context, target, 1, 0, "WIFI", "");
        this.mWifiInfo = new WifiInfo();
        this.mWifiMonitor = new WifiMonitor(this);
        this.setTornDownByConnMgr(false);
        this.mDisconnectPending = false;
        this.mScanResults = new ArrayList<ScanResult>();
        this.mDhcpInfo = new DhcpInfo();
        this.mRunState = 1;
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        Intent dhcpRenewalIntent = new Intent(ACTION_DHCP_RENEW, null);
        this.mDhcpRenewalIntent = PendingIntent.getBroadcast(this.mContext, 0, dhcpRenewalIntent, 0);
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (WifiStateTracker.this.mDhcpTarget != null) {
                    Log.d(WifiStateTracker.TAG, "Sending a DHCP renewal");
                    WifiStateTracker.this.mDhcpRenewWakeLock.acquire(40000L);
                    WifiStateTracker.this.mDhcpTarget.sendEmptyMessage(10);
                }
            }
        }, new IntentFilter(ACTION_DHCP_RENEW));
        PowerManager powerManager = (PowerManager)this.mContext.getSystemService("power");
        this.mDhcpRenewWakeLock = powerManager.newWakeLock(1, WAKELOCK_TAG);
        this.NOTIFICATION_REPEAT_DELAY_MS = (long)Settings.Secure.getInt(context.getContentResolver(), "wifi_networks_available_repeat_delay", 900) * 1000L;
        this.mNotificationEnabledSettingObserver = new NotificationEnabledSettingObserver(new Handler());
        this.mNotificationEnabledSettingObserver.register();
        this.mSettingsObserver = new SettingsObserver(new Handler());
        this.mInterfaceName = SystemProperties.get("wifi.interface", "tiwlan0");
        sDnsPropNames = new String[]{"dhcp." + this.mInterfaceName + ".dns1", "dhcp." + this.mInterfaceName + ".dns2"};
        this.mBatteryStats = IBatteryStats.Stub.asInterface(ServiceManager.getService("batteryinfo"));
    }

    private void setSupplicantState(SupplicantState state) {
        this.mWifiInfo.setSupplicantState(state);
        this.updateNetworkInfo();
        this.checkPollTimer();
    }

    public SupplicantState getSupplicantState() {
        return this.mWifiInfo.getSupplicantState();
    }

    private void setSupplicantState(String stateName) {
        this.mWifiInfo.setSupplicantState(stateName);
        this.updateNetworkInfo();
        this.checkPollTimer();
    }

    private void setTornDownByConnMgr(boolean flag) {
        this.mTornDownByConnMgr = flag;
        this.updateNetworkInfo();
    }

    @Override
    public String[] getNameServers() {
        return WifiStateTracker.getNameServerList(sDnsPropNames);
    }

    @Override
    public String getInterfaceName() {
        return this.mInterfaceName;
    }

    @Override
    public String getTcpBufferSizesPropName() {
        return "net.tcp.buffersize.wifi";
    }

    @Override
    public void startMonitoring() {
        this.mWM = (WifiManager)this.mContext.getSystemService("wifi");
    }

    public void startEventLoop() {
        this.mWifiMonitor.startMonitoring();
    }

    @Override
    public synchronized boolean isAvailable() {
        SupplicantState suppState = this.mWifiInfo.getSupplicantState();
        return suppState != SupplicantState.UNINITIALIZED && suppState != SupplicantState.INACTIVE && (this.mTornDownByConnMgr || !this.isDriverStopped());
    }

    public int getNetworkSubtype() {
        return 0;
    }

    private void updateNetworkInfo() {
        this.mNetworkInfo.setIsAvailable(this.isAvailable());
    }

    public boolean isConnectionCompleted() {
        return this.mWifiInfo.getSupplicantState() == SupplicantState.COMPLETED;
    }

    public boolean hasIpAddress() {
        return this.mHaveIpAddress;
    }

    void notifyPasswordKeyMayBeIncorrect() {
        this.sendEmptyMessage(14);
    }

    void notifySupplicantConnection() {
        this.sendEmptyMessage(1);
    }

    void notifyStateChange(int networkId, String BSSID, SupplicantState newState) {
        Message msg = Message.obtain(this, 3, new SupplicantStateChangeResult(networkId, BSSID, newState));
        msg.sendToTarget();
    }

    void notifyStateChange(NetworkInfo.DetailedState newState, String BSSID, int networkId) {
        Message msg = Message.obtain(this, 4, new NetworkStateChangeResult(newState, BSSID, networkId));
        msg.sendToTarget();
    }

    void notifyScanResultsAvailable() {
        this.setScanResultHandling(1);
        this.sendEmptyMessage(5);
    }

    void notifySupplicantLost() {
        this.sendEmptyMessage(2);
    }

    void notifyDriverStopped() {
        Message.obtain(this, 13, 1, 0).sendToTarget();
    }

    void notifyDriverStarted() {
        Message.obtain(this, 13, 0, 0).sendToTarget();
    }

    void notifyDriverHung() {
        Message.obtain(this, 13, 2, 0).sendToTarget();
    }

    private synchronized void checkPollTimer() {
        if (this.mEnableRssiPolling && this.mWifiInfo.getSupplicantState() == SupplicantState.COMPLETED && !this.hasMessages(8)) {
            this.sendEmptyMessageDelayed(8, 3000L);
        }
    }

    public synchronized boolean isDriverStopped() {
        return this.mRunState == 4 || this.mRunState == 3;
    }

    public void updateBatteryWorkSourceLocked(WorkSource newSource) {
        try {
            if (newSource != null) {
                this.mRunningWifiUids.set(newSource);
            }
            if (this.mRunState == 2) {
                if (this.mReportedRunning) {
                    if (this.mLastRunningWifiUids.diff(this.mRunningWifiUids)) {
                        this.mBatteryStats.noteWifiRunningChanged(this.mLastRunningWifiUids, this.mRunningWifiUids);
                        this.mLastRunningWifiUids.set(this.mRunningWifiUids);
                    }
                } else {
                    this.mBatteryStats.noteWifiRunning(this.mRunningWifiUids);
                    this.mLastRunningWifiUids.set(this.mRunningWifiUids);
                    this.mReportedRunning = true;
                }
            } else if (this.mRunState == 4 && this.mReportedRunning) {
                this.mBatteryStats.noteWifiStopped(this.mLastRunningWifiUids);
                this.mLastRunningWifiUids.clear();
                this.mReportedRunning = false;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public synchronized void setScanOnlyMode(boolean scanOnlyMode) {
        if (this.mIsScanOnly != scanOnlyMode) {
            int scanType = scanOnlyMode ? 2 : 1;
            Log.v(TAG, "Scan-only mode changing to " + scanOnlyMode + " scanType=" + scanType);
            if (this.setScanResultHandling(scanType)) {
                this.mIsScanOnly = scanOnlyMode;
                if (!this.isDriverStopped()) {
                    if (scanOnlyMode) {
                        this.disconnect();
                    } else {
                        this.reconnectCommand();
                    }
                }
            }
        }
    }

    public synchronized void setSuspendModeOptimizations(boolean enabled) {
        if (!enabled) {
            ++this.mOptimizationsDisabledRefCount;
        } else {
            --this.mOptimizationsDisabledRefCount;
            if (this.mOptimizationsDisabledRefCount > 0) {
                return;
            }
            this.mOptimizationsDisabledRefCount = 0;
        }
        if (this.mWifiState.get() != 3 || this.isDriverStopped()) {
            return;
        }
        WifiNative.setSuspendOptimizationsCommand(enabled);
    }

    public synchronized void setHighPerfMode(boolean enabled) {
        if (this.mIsHighPerfEnabled != enabled) {
            if (enabled) {
                this.setPowerMode(1);
                this.setSuspendModeOptimizations(false);
            } else {
                this.setPowerMode(0);
                this.setSuspendModeOptimizations(true);
            }
            this.mIsHighPerfEnabled = enabled;
            Log.d(TAG, "high performance mode: " + enabled);
        }
    }

    private void checkIsBluetoothPlaying() {
        boolean isBluetoothPlaying = false;
        Set<BluetoothDevice> connected = this.mBluetoothA2dp.getConnectedSinks();
        for (BluetoothDevice device : connected) {
            if (this.mBluetoothA2dp.getSinkState(device) != 4) continue;
            isBluetoothPlaying = true;
            break;
        }
        this.setBluetoothScanMode(isBluetoothPlaying);
    }

    public void enableRssiPolling(boolean enable) {
        if (this.mEnableRssiPolling != enable) {
            this.mEnableRssiPolling = enable;
            this.checkPollTimer();
        }
    }

    @Override
    public void releaseWakeLock() {
    }

    private boolean isSupplicantLooping(SupplicantState newSupplicantState) {
        if (SupplicantState.ASSOCIATING.ordinal() <= newSupplicantState.ordinal() && newSupplicantState.ordinal() < SupplicantState.COMPLETED.ordinal()) {
            if (this.mSupplicantLoopState != newSupplicantState) {
                if (newSupplicantState.ordinal() < this.mSupplicantLoopState.ordinal()) {
                    ++this.mNumSupplicantLoopIterations;
                }
                this.mSupplicantLoopState = newSupplicantState;
            }
        } else if (newSupplicantState == SupplicantState.COMPLETED) {
            this.resetSupplicantLoopState();
        }
        return this.mNumSupplicantLoopIterations >= 4;
    }

    private void resetSupplicantLoopState() {
        this.mNumSupplicantLoopIterations = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                String macaddr;
                this.mRunState = 2;
                WifiStateTracker wifiStateTracker = this;
                synchronized (wifiStateTracker) {
                    this.updateBatteryWorkSourceLocked(null);
                    macaddr = WifiNative.getMacAddressCommand();
                }
                if (macaddr != null) {
                    this.mWifiInfo.setMacAddress(macaddr);
                }
                this.checkUseStaticIp();
                this.resetNotificationTimer();
                HandlerThread dhcpThread = new HandlerThread("DHCP Handler Thread");
                dhcpThread.start();
                this.mDhcpTarget = new DhcpHandler(dhcpThread.getLooper(), this);
                this.mIsScanModeActive = true;
                this.mIsHighPerfEnabled = false;
                this.mOptimizationsDisabledRefCount = 0;
                this.mPowerModeRefCount = 0;
                this.mTornDownByConnMgr = false;
                this.mLastBssid = null;
                this.mLastSsid = null;
                this.mIsAnyNetworkDisabled.set(false);
                this.requestConnectionInfo();
                SupplicantState supplState = this.mWifiInfo.getSupplicantState();
                Log.v(TAG, "Connection to supplicant established, state=" + supplState);
                EventLog.writeEvent(50025, 1);
                if (supplState == SupplicantState.COMPLETED) {
                    this.mLastBssid = this.mWifiInfo.getBSSID();
                    this.mLastSsid = this.mWifiInfo.getSSID();
                    this.configureInterface();
                }
                if (ActivityManagerNative.isSystemReady()) {
                    Intent intent = new Intent("android.net.wifi.supplicant.CONNECTION_CHANGE");
                    intent.putExtra("connected", true);
                    this.mContext.sendBroadcast(intent);
                }
                if (supplState == SupplicantState.COMPLETED && this.mHaveIpAddress) {
                    this.setDetailedState(NetworkInfo.DetailedState.CONNECTED);
                } else {
                    this.setDetailedState(WifiInfo.getDetailedStateOf(supplState));
                }
                this.mWM.initializeMulticastFiltering();
                if (this.mBluetoothA2dp == null) {
                    this.mBluetoothA2dp = new BluetoothA2dp(this.mContext);
                }
                this.checkIsBluetoothPlaying();
                this.setNumAllowedChannels();
                break;
            }
            case 2: {
                boolean died;
                this.mRunState = 4;
                WifiStateTracker wifiStateTracker = this;
                synchronized (wifiStateTracker) {
                    this.updateBatteryWorkSourceLocked(null);
                }
                boolean bl = died = this.mWifiState.get() != 1 && this.mWifiState.get() != 0;
                if (died) {
                    Log.v(TAG, "Supplicant died unexpectedly");
                } else {
                    Log.v(TAG, "Connection to supplicant lost");
                }
                EventLog.writeEvent(50025, died ? 2 : 0);
                this.closeSupplicantConnection();
                if (died) {
                    this.resetConnections(true);
                }
                this.mDhcpTarget.getLooper().quit();
                this.mContext.removeStickyBroadcast(new Intent("android.net.wifi.STATE_CHANGE"));
                if (ActivityManagerNative.isSystemReady()) {
                    Intent intent = new Intent("android.net.wifi.supplicant.CONNECTION_CHANGE");
                    intent.putExtra("connected", false);
                    this.mContext.sendBroadcast(intent);
                }
                this.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED);
                this.setSupplicantState(SupplicantState.UNINITIALIZED);
                this.mHaveIpAddress = false;
                this.mObtainingIpAddress = false;
                if (!died) break;
                this.mWM.setWifiEnabled(false);
                break;
            }
            case 15: {
                if (this.mNumSupplicantStateChanges != msg.arg1) break;
                this.scan(false);
                break;
            }
            case 3: {
                ++this.mNumSupplicantStateChanges;
                SupplicantStateChangeResult supplicantStateResult = (SupplicantStateChangeResult)msg.obj;
                SupplicantState newState = supplicantStateResult.state;
                SupplicantState currentState = this.mWifiInfo.getSupplicantState();
                int eventLogParam = newState.ordinal() & 0x3F;
                EventLog.writeEvent(50022, eventLogParam);
                Log.v(TAG, "Changing supplicant state: " + currentState + " ==> " + newState);
                int networkId = supplicantStateResult.networkId;
                if (supplicantStateResult.state == SupplicantState.ASSOCIATING) {
                    this.mLastBssid = supplicantStateResult.BSSID;
                }
                if (newState == SupplicantState.DISCONNECTED || newState == SupplicantState.INACTIVE) {
                    this.sendMessageDelayed(this.obtainMessage(15, this.mNumSupplicantStateChanges, 0), 15000L);
                }
                boolean failedToAuthenticate = false;
                if (newState == SupplicantState.DISCONNECTED) {
                    failedToAuthenticate = this.mPasswordKeyMayBeIncorrect;
                }
                this.mPasswordKeyMayBeIncorrect = false;
                boolean disabledNetwork = false;
                if (this.isSupplicantLooping(newState)) {
                    Log.v(TAG, "Stop WPA supplicant loop and disable network");
                    disabledNetwork = this.wifiManagerDisableNetwork(networkId);
                }
                if (disabledNetwork) {
                    this.resetSupplicantLoopState();
                    break;
                }
                if (newState == currentState && (newState != SupplicantState.DISCONNECTED || !this.isDriverStopped())) break;
                this.setSupplicantState(newState);
                if (newState == SupplicantState.DORMANT) {
                    Message reconnectMsg = this.obtainMessage(12, this.mLastBssid);
                    NetworkInfo.DetailedState newDetailedState = this.mIsScanOnly || this.mRunState == 3 ? NetworkInfo.DetailedState.IDLE : NetworkInfo.DetailedState.FAILED;
                    this.handleDisconnectedState(newDetailedState, true);
                    if (this.mRunState == 2 && !this.mIsScanOnly) {
                        this.sendMessageDelayed(reconnectMsg, 2000L);
                    } else if (this.mRunState == 3) {
                        this.stopDriver();
                    } else if (this.mRunState == 1 && !this.mIsScanOnly) {
                        this.reconnectCommand();
                    }
                } else if (newState == SupplicantState.DISCONNECTED) {
                    this.mHaveIpAddress = false;
                    if (this.isDriverStopped() || this.mDisconnectExpected) {
                        this.handleDisconnectedState(NetworkInfo.DetailedState.DISCONNECTED, true);
                    } else {
                        this.scheduleDisconnect();
                    }
                } else if (newState != SupplicantState.COMPLETED && !this.mDisconnectPending && (currentState != SupplicantState.COMPLETED || newState != SupplicantState.ASSOCIATING && newState != SupplicantState.ASSOCIATED && newState != SupplicantState.FOUR_WAY_HANDSHAKE && newState != SupplicantState.GROUP_HANDSHAKE)) {
                    this.setDetailedState(WifiInfo.getDetailedStateOf(newState));
                }
                this.mDisconnectExpected = false;
                Intent intent = new Intent("android.net.wifi.supplicant.STATE_CHANGE");
                intent.addFlags(0x30000000);
                intent.putExtra("newState", newState);
                if (failedToAuthenticate) {
                    Log.d(TAG, "Failed to authenticate, disabling network " + networkId);
                    this.wifiManagerDisableNetwork(networkId);
                    intent.putExtra("supplicantError", 1);
                }
                this.mContext.sendStickyBroadcast(intent);
                break;
            }
            case 4: {
                NetworkStateChangeResult result = (NetworkStateChangeResult)msg.obj;
                int eventLogParam = result.state.ordinal() & 0x3F;
                EventLog.writeEvent(50021, eventLogParam);
                Log.v(TAG, "New network state is " + (Object)((Object)result.state));
                if (this.mIsScanOnly) {
                    Log.v(TAG, "Dropping event in scan-only mode");
                    break;
                }
                if (result.state != NetworkInfo.DetailedState.SCANNING) {
                    this.mNumScansSinceNetworkStateChange = 0;
                }
                if (result.state == NetworkInfo.DetailedState.DISCONNECTED) {
                    if (this.mWifiInfo.getSupplicantState() == SupplicantState.DORMANT) break;
                    this.scheduleDisconnect();
                    break;
                }
                this.requestConnectionStatus(this.mWifiInfo);
                if (result.state != NetworkInfo.DetailedState.CONNECTED || this.mHaveIpAddress && !this.mDisconnectPending) {
                    this.setDetailedState(result.state);
                }
                if (result.state == NetworkInfo.DetailedState.CONNECTED) {
                    this.setNotificationVisible(false, 0, false, 0);
                    boolean wasDisconnectPending = this.mDisconnectPending;
                    this.cancelDisconnect();
                    if (wasDisconnectPending) {
                        NetworkInfo.DetailedState saveState = this.getNetworkInfo().getDetailedState();
                        this.handleDisconnectedState(NetworkInfo.DetailedState.DISCONNECTED, false);
                        this.setDetailedStateInternal(saveState);
                    }
                    this.configureInterface();
                    this.mLastBssid = result.BSSID;
                    this.mLastSsid = this.mWifiInfo.getSSID();
                    this.mLastNetworkId = result.networkId;
                    if (this.mHaveIpAddress) {
                        this.setDetailedState(NetworkInfo.DetailedState.CONNECTED);
                    } else {
                        this.setDetailedState(NetworkInfo.DetailedState.OBTAINING_IPADDR);
                    }
                }
                this.sendNetworkStateChangeBroadcast(this.mWifiInfo.getBSSID());
                break;
            }
            case 5: {
                if (ActivityManagerNative.isSystemReady()) {
                    this.mContext.sendBroadcast(new Intent("android.net.wifi.SCAN_RESULTS"));
                }
                this.sendScanResultsAvailable();
                this.setScanMode(false);
                break;
            }
            case 8: {
                if (this.mWifiInfo.getSupplicantState() == SupplicantState.UNINITIALIZED) break;
                this.requestPolledInfo(this.mWifiInfo, true);
                this.checkPollTimer();
                break;
            }
            case 11: {
                if (this.mWifiInfo.getSupplicantState() == SupplicantState.UNINITIALIZED) break;
                this.handleDisconnectedState(NetworkInfo.DetailedState.DISCONNECTED, true);
                break;
            }
            case 12: {
                String BSSID;
                String string2 = BSSID = msg.obj != null ? msg.obj.toString() : null;
                if (this.mWifiInfo.getSupplicantState() == SupplicantState.UNINITIALIZED) break;
                if (++this.mReconnectCount > this.getMaxDhcpRetries()) {
                    Log.d(TAG, "Failed reconnect count: " + this.mReconnectCount + " Disabling " + BSSID);
                    this.mWM.disableNetwork(this.mLastNetworkId);
                }
                this.reconnectCommand();
                break;
            }
            case 6: {
                if (this.mWifiInfo.getSupplicantState() == SupplicantState.UNINITIALIZED) break;
                this.mReconnectCount = 0;
                this.mHaveIpAddress = true;
                this.mObtainingIpAddress = false;
                this.mWifiInfo.setIpAddress(this.mDhcpInfo.ipAddress);
                this.mLastSignalLevel = -1;
                if (this.mNetworkInfo.getDetailedState() != NetworkInfo.DetailedState.CONNECTED) {
                    this.setDetailedState(NetworkInfo.DetailedState.CONNECTED);
                    this.sendNetworkStateChangeBroadcast(this.mWifiInfo.getBSSID());
                } else {
                    msg = this.mTarget.obtainMessage(4, this.mNetworkInfo);
                    msg.sendToTarget();
                }
                Log.v(TAG, "IP configuration: " + this.mDhcpInfo);
                EventLog.writeEvent(50024, 1);
                this.resetNotificationTimer();
                break;
            }
            case 7: {
                if (this.mWifiInfo.getSupplicantState() == SupplicantState.UNINITIALIZED) break;
                EventLog.writeEvent(50024, 0);
                this.mHaveIpAddress = false;
                this.mWifiInfo.setIpAddress(0);
                this.mObtainingIpAddress = false;
                this.disconnect();
                break;
            }
            case 13: {
                WifiStateTracker wifiStateTracker;
                EventLog.writeEvent(50023, msg.arg1);
                switch (msg.arg1) {
                    case 0: {
                        this.setNumAllowedChannels();
                        wifiStateTracker = this;
                        synchronized (wifiStateTracker) {
                            String macaddr = WifiNative.getMacAddressCommand();
                            if (macaddr != null) {
                                this.mWifiInfo.setMacAddress(macaddr);
                            }
                            this.mRunState = 2;
                            if (!this.mIsScanOnly) {
                                this.reconnectCommand();
                            } else {
                                this.scan(true);
                            }
                            break;
                        }
                    }
                    case 1: {
                        this.mRunState = 4;
                        break;
                    }
                    case 2: {
                        Log.e(TAG, "Wifi Driver reports HUNG - reloading.");
                        this.mWM.setWifiEnabled(false);
                        this.mWM.setWifiEnabled(true);
                    }
                }
                wifiStateTracker = this;
                synchronized (wifiStateTracker) {
                    this.updateBatteryWorkSourceLocked(null);
                    break;
                }
            }
            case 14: {
                this.mPasswordKeyMayBeIncorrect = true;
            }
        }
    }

    private boolean wifiManagerDisableNetwork(int networkId) {
        boolean disabledNetwork = false;
        if (0 <= networkId && (disabledNetwork = this.mWM.disableNetwork(networkId))) {
            Log.v(TAG, "Disabled network: " + networkId);
        }
        if (!disabledNetwork) {
            Log.e(TAG, "Failed to disable network: invalid network id: " + networkId);
        }
        return disabledNetwork;
    }

    private void configureInterface() {
        this.checkPollTimer();
        this.mLastSignalLevel = -1;
        if (!this.mUseStaticIp) {
            if (!this.mHaveIpAddress && !this.mObtainingIpAddress) {
                this.mObtainingIpAddress = true;
                this.mDhcpTarget.sendEmptyMessage(9);
            }
        } else {
            int event;
            if (NetworkUtils.configureInterface(this.mInterfaceName, this.mDhcpInfo)) {
                this.mHaveIpAddress = true;
                event = 6;
                Log.v(TAG, "Static IP configuration succeeded");
            } else {
                this.mHaveIpAddress = false;
                event = 7;
                Log.v(TAG, "Static IP configuration failed");
            }
            this.sendEmptyMessage(event);
        }
    }

    private void handleDisconnectedState(NetworkInfo.DetailedState newState, boolean disableInterface) {
        if (this.mDisconnectPending) {
            this.cancelDisconnect();
        }
        this.mDisconnectExpected = false;
        this.resetConnections(disableInterface);
        this.setDetailedState(newState);
        this.sendNetworkStateChangeBroadcast(this.mLastBssid);
        this.mWifiInfo.setBSSID(null);
        this.mLastBssid = null;
        this.mLastSsid = null;
        this.mDisconnectPending = false;
    }

    public void resetConnections(boolean disableInterface) {
        Log.d(TAG, "Reset connections and stopping DHCP");
        this.mHaveIpAddress = false;
        this.mObtainingIpAddress = false;
        this.mWifiInfo.setIpAddress(0);
        NetworkUtils.resetConnections(this.mInterfaceName);
        this.mDhcpTarget.setCancelCallback(true);
        this.mDhcpTarget.removeMessages(9);
        if (!NetworkUtils.stopDhcp(this.mInterfaceName)) {
            Log.e(TAG, "Could not stop DHCP");
        }
        if (disableInterface) {
            Log.d(TAG, "Disabling interface");
            NetworkUtils.disableInterface(this.mInterfaceName);
        }
    }

    private void scheduleDisconnect() {
        this.mDisconnectPending = true;
        if (!this.hasMessages(11)) {
            this.sendEmptyMessageDelayed(11, 5000L);
        }
    }

    private void cancelDisconnect() {
        this.mDisconnectPending = false;
        this.removeMessages(11);
    }

    public DhcpInfo getDhcpInfo() {
        return this.mDhcpInfo;
    }

    public synchronized List<ScanResult> getScanResultsList() {
        return this.mScanResults;
    }

    public synchronized void setScanResultsList(List<ScanResult> scanList) {
        this.mScanResults = scanList;
    }

    public WifiInfo requestConnectionInfo() {
        this.requestConnectionStatus(this.mWifiInfo);
        this.requestPolledInfo(this.mWifiInfo, false);
        return this.mWifiInfo;
    }

    private void requestConnectionStatus(WifiInfo info) {
        String SSID = null;
        String BSSID = null;
        String suppState = null;
        int netId = -1;
        String reply = this.status();
        if (reply != null) {
            String[] lines;
            for (String line : lines = reply.split("\n")) {
                String[] prop = line.split(" *= *");
                if (prop.length < 2) continue;
                String name = prop[0];
                String value = prop[1];
                if (name.equalsIgnoreCase("id")) {
                    netId = Integer.parseInt(value);
                    continue;
                }
                if (name.equalsIgnoreCase("ssid")) {
                    SSID = value;
                    continue;
                }
                if (name.equalsIgnoreCase("bssid")) {
                    BSSID = value;
                    continue;
                }
                if (!name.equalsIgnoreCase("wpa_state")) continue;
                suppState = value;
            }
        }
        info.setNetworkId(netId);
        info.setSSID(SSID);
        info.setBSSID(BSSID);
        if (this.mWifiInfo.getSupplicantState() == SupplicantState.UNINITIALIZED && suppState != null) {
            this.setSupplicantState(suppState);
        }
    }

    private synchronized void requestPolledInfo(WifiInfo info, boolean polling) {
        int newRssi;
        int n = newRssi = polling ? this.getRssiApprox() : this.getRssi();
        if (newRssi != -1 && -200 < newRssi && newRssi < 256) {
            if (newRssi > 0) {
                newRssi -= 256;
            }
            info.setRssi(newRssi);
            int newSignalLevel = WifiManager.calculateSignalLevel(newRssi, 4);
            if (newSignalLevel != this.mLastSignalLevel) {
                this.sendRssiChangeBroadcast(newRssi);
            }
            this.mLastSignalLevel = newSignalLevel;
        } else {
            info.setRssi(-200);
        }
        int newLinkSpeed = this.getLinkSpeed();
        if (newLinkSpeed != -1) {
            info.setLinkSpeed(newLinkSpeed);
        }
    }

    private void sendRssiChangeBroadcast(int newRssi) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent intent = new Intent("android.net.wifi.RSSI_CHANGED");
            intent.putExtra("newRssi", newRssi);
            this.mContext.sendBroadcast(intent);
        }
    }

    private void sendNetworkStateChangeBroadcast(String bssid) {
        Intent intent = new Intent("android.net.wifi.STATE_CHANGE");
        intent.addFlags(0x30000000);
        intent.putExtra("networkInfo", this.mNetworkInfo);
        if (bssid != null) {
            intent.putExtra("bssid", bssid);
        }
        this.mContext.sendStickyBroadcast(intent);
    }

    @Override
    public boolean teardown() {
        if (!this.mTornDownByConnMgr) {
            if (this.disconnectAndStop()) {
                this.setTornDownByConnMgr(true);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean reconnect() {
        if (this.mTornDownByConnMgr) {
            if (this.restart()) {
                this.setTornDownByConnMgr(false);
                return true;
            }
            return false;
        }
        return true;
    }

    public synchronized boolean disconnectAndStop() {
        boolean ret = true;
        if (this.mRunState != 3 && this.mRunState != 4) {
            this.setNotificationVisible(false, 0, false, 0);
            ret = this.mWifiInfo.getSupplicantState() == SupplicantState.DORMANT ? this.stopDriver() : this.disconnect();
            this.mRunState = 3;
        }
        return ret;
    }

    public synchronized boolean restart() {
        if (this.isDriverStopped()) {
            this.mRunState = 1;
            this.resetConnections(true);
            return this.startDriver();
        }
        return true;
    }

    public int getWifiState() {
        return this.mWifiState.get();
    }

    public void setWifiState(int wifiState) {
        this.mWifiState.set(wifiState);
    }

    public boolean isAnyNetworkDisabled() {
        return this.mIsAnyNetworkDisabled.get();
    }

    public synchronized boolean loadDriver() {
        return WifiNative.loadDriver();
    }

    public synchronized boolean unloadDriver() {
        return WifiNative.unloadDriver();
    }

    public synchronized boolean startSupplicant() {
        return WifiNative.startSupplicant();
    }

    public synchronized boolean stopSupplicant() {
        return WifiNative.stopSupplicant();
    }

    public synchronized boolean connectToSupplicant() {
        return WifiNative.connectToSupplicant();
    }

    public synchronized void closeSupplicantConnection() {
        WifiNative.closeSupplicantConnection();
    }

    public synchronized boolean ping() {
        if (this.mWifiState.get() != 3) {
            return false;
        }
        return WifiNative.pingCommand();
    }

    public synchronized boolean scan(boolean forceActive) {
        if (this.mWifiState.get() != 3 || this.isDriverStopped()) {
            return false;
        }
        return WifiNative.scanCommand(forceActive);
    }

    public synchronized boolean setScanResultHandling(int mode) {
        if (this.mWifiState.get() != 3) {
            return false;
        }
        return WifiNative.setScanResultHandlingCommand(mode);
    }

    public synchronized String scanResults() {
        if (this.mWifiState.get() != 3 || this.isDriverStopped()) {
            return null;
        }
        return WifiNative.scanResultsCommand();
    }

    public synchronized boolean setScanMode(boolean isScanModeActive) {
        if (this.mWifiState.get() != 3 || this.isDriverStopped()) {
            return false;
        }
        if (this.mIsScanModeActive != isScanModeActive) {
            this.mIsScanModeActive = isScanModeActive;
            return WifiNative.setScanModeCommand(this.mIsScanModeActive);
        }
        return true;
    }

    public synchronized boolean disconnect() {
        if (this.mWifiState.get() != 3 || this.isDriverStopped()) {
            return false;
        }
        return WifiNative.disconnectCommand();
    }

    public synchronized boolean reconnectCommand() {
        if (this.mWifiState.get() != 3 || this.isDriverStopped()) {
            return false;
        }
        return WifiNative.reconnectCommand();
    }

    public synchronized int addNetwork() {
        if (this.mWifiState.get() != 3) {
            return -1;
        }
        return WifiNative.addNetworkCommand();
    }

    public synchronized boolean removeNetwork(int networkId) {
        if (this.mWifiState.get() != 3) {
            return false;
        }
        this.mDisconnectExpected = WifiNative.removeNetworkCommand(networkId);
        return this.mDisconnectExpected;
    }

    public synchronized boolean enableNetwork(int netId, boolean disableOthers) {
        if (this.mWifiState.get() != 3) {
            return false;
        }
        if (disableOthers) {
            this.mIsAnyNetworkDisabled.set(true);
        }
        return WifiNative.enableNetworkCommand(netId, disableOthers);
    }

    public synchronized void enableAllNetworks(List<WifiConfiguration> networks) {
        if (this.mWifiState.get() != 3) {
            return;
        }
        this.mIsAnyNetworkDisabled.set(false);
        for (WifiConfiguration config : networks) {
            if (config.status != 1) continue;
            WifiNative.enableNetworkCommand(config.networkId, false);
        }
    }

    public synchronized boolean disableNetwork(int netId) {
        if (this.mWifiState.get() != 3) {
            return false;
        }
        this.mIsAnyNetworkDisabled.set(true);
        return WifiNative.disableNetworkCommand(netId);
    }

    public synchronized boolean reassociate() {
        if (this.mWifiState.get() != 3 || this.isDriverStopped()) {
            return false;
        }
        return WifiNative.reassociateCommand();
    }

    public synchronized boolean addToBlacklist(String bssid) {
        if (this.mWifiState.get() != 3) {
            return false;
        }
        return WifiNative.addToBlacklistCommand(bssid);
    }

    public synchronized boolean clearBlacklist() {
        if (this.mWifiState.get() != 3) {
            return false;
        }
        return WifiNative.clearBlacklistCommand();
    }

    public synchronized String listNetworks() {
        if (this.mWifiState.get() != 3) {
            return null;
        }
        return WifiNative.listNetworksCommand();
    }

    public synchronized String getNetworkVariable(int netId, String name) {
        if (this.mWifiState.get() != 3) {
            return null;
        }
        return WifiNative.getNetworkVariableCommand(netId, name);
    }

    public synchronized boolean setNetworkVariable(int netId, String name, String value) {
        if (this.mWifiState.get() != 3) {
            return false;
        }
        return WifiNative.setNetworkVariableCommand(netId, name, value);
    }

    public synchronized String status() {
        if (this.mWifiState.get() != 3) {
            return null;
        }
        return WifiNative.statusCommand();
    }

    public synchronized int getRssi() {
        if (this.mWifiState.get() != 3 || this.isDriverStopped()) {
            return -1;
        }
        return WifiNative.getRssiApproxCommand();
    }

    public synchronized int getRssiApprox() {
        if (this.mWifiState.get() != 3 || this.isDriverStopped()) {
            return -1;
        }
        return WifiNative.getRssiApproxCommand();
    }

    public synchronized int getLinkSpeed() {
        if (this.mWifiState.get() != 3 || this.isDriverStopped()) {
            return -1;
        }
        return WifiNative.getLinkSpeedCommand();
    }

    public synchronized boolean startDriver() {
        if (this.mWifiState.get() != 3) {
            return false;
        }
        return WifiNative.startDriverCommand();
    }

    public synchronized boolean stopDriver() {
        if (this.mWifiState.get() != 3 || this.mRunState == 4) {
            return false;
        }
        return WifiNative.stopDriverCommand();
    }

    public synchronized boolean startPacketFiltering() {
        if (this.mWifiState.get() != 3 || this.isDriverStopped()) {
            return false;
        }
        return WifiNative.startPacketFiltering();
    }

    public synchronized boolean stopPacketFiltering() {
        if (this.mWifiState.get() != 3 || this.isDriverStopped()) {
            return false;
        }
        return WifiNative.stopPacketFiltering();
    }

    public synchronized int getPowerMode() {
        if (this.mWifiState.get() != 3 && !this.isDriverStopped()) {
            return -1;
        }
        return WifiNative.getPowerModeCommand();
    }

    private synchronized void setPowerMode(int mode) {
        switch (mode) {
            case 1: {
                ++this.mPowerModeRefCount;
                break;
            }
            case 0: {
                --this.mPowerModeRefCount;
                if (this.mPowerModeRefCount > 0) {
                    return;
                }
                this.mPowerModeRefCount = 0;
            }
        }
        if (this.mWifiState.get() != 3 || this.isDriverStopped()) {
            return;
        }
        WifiNative.setPowerModeCommand(mode);
    }

    public synchronized boolean setNumAllowedChannels() {
        if (this.mWifiState.get() != 3 || this.isDriverStopped()) {
            return false;
        }
        try {
            return this.setNumAllowedChannels(Settings.Secure.getInt(this.mContext.getContentResolver(), "wifi_num_allowed_channels"));
        }
        catch (Settings.SettingNotFoundException e) {
            if (this.mNumAllowedChannels != 0) {
                WifiNative.setNumAllowedChannelsCommand(this.mNumAllowedChannels);
            }
            return true;
        }
    }

    public synchronized boolean setNumAllowedChannels(int numChannels) {
        if (this.mWifiState.get() != 3 || this.isDriverStopped()) {
            return false;
        }
        this.mNumAllowedChannels = numChannels;
        return WifiNative.setNumAllowedChannelsCommand(numChannels);
    }

    public synchronized int getNumAllowedChannels() {
        if (this.mWifiState.get() != 3 || this.isDriverStopped()) {
            return -1;
        }
        return WifiNative.getNumAllowedChannelsCommand();
    }

    public synchronized boolean setBluetoothCoexistenceMode(int mode) {
        if (this.mWifiState.get() != 3 || this.isDriverStopped()) {
            return false;
        }
        return WifiNative.setBluetoothCoexistenceModeCommand(mode);
    }

    public synchronized void setBluetoothScanMode(boolean isBluetoothPlaying) {
        if (this.mWifiState.get() != 3 || this.isDriverStopped()) {
            return;
        }
        WifiNative.setBluetoothCoexistenceScanModeCommand(isBluetoothPlaying);
    }

    public synchronized boolean saveConfig() {
        if (this.mWifiState.get() != 3) {
            return false;
        }
        return WifiNative.saveConfigCommand();
    }

    public synchronized boolean reloadConfig() {
        if (this.mWifiState.get() != 3) {
            return false;
        }
        return WifiNative.reloadConfigCommand();
    }

    @Override
    public boolean setRadio(boolean turnOn) {
        return this.mWM.setWifiEnabled(turnOn);
    }

    @Override
    public int startUsingNetworkFeature(String feature, int callingPid, int callingUid) {
        return -1;
    }

    @Override
    public int stopUsingNetworkFeature(String feature, int callingPid, int callingUid) {
        return -1;
    }

    @Override
    public void interpretScanResultsAvailable() {
        List<ScanResult> scanResults;
        if (!this.mNotificationEnabled) {
            return;
        }
        NetworkInfo networkInfo = this.getNetworkInfo();
        NetworkInfo.State state = networkInfo.getState();
        if ((state == NetworkInfo.State.DISCONNECTED || state == NetworkInfo.State.UNKNOWN) && (scanResults = this.getScanResultsList()) != null) {
            int numOpenNetworks = 0;
            for (int i = scanResults.size() - 1; i >= 0; --i) {
                ScanResult scanResult = scanResults.get(i);
                if (!TextUtils.isEmpty(scanResult.capabilities)) continue;
                ++numOpenNetworks;
            }
            if (numOpenNetworks > 0) {
                if (++this.mNumScansSinceNetworkStateChange >= 3) {
                    this.setNotificationVisible(true, numOpenNetworks, false, 0);
                }
                return;
            }
        }
        this.setNotificationVisible(false, 0, false, 0);
    }

    public void setNotificationVisible(boolean visible, int numNetworks, boolean force, int delay) {
        Message message;
        if (!(visible || this.mNotificationShown || force)) {
            return;
        }
        if (visible) {
            if (System.currentTimeMillis() < this.mNotificationRepeatTime) {
                return;
            }
            if (this.mNotification == null) {
                this.mNotification = new Notification();
                this.mNotification.when = 0L;
                this.mNotification.icon = 17302164;
                this.mNotification.flags = 16;
                this.mNotification.contentIntent = PendingIntent.getActivity(this.mContext, 0, new Intent("android.net.wifi.PICK_WIFI_NETWORK"), 0);
            }
            CharSequence title = this.mContext.getResources().getQuantityText(0x10F0011, numNetworks);
            CharSequence details = this.mContext.getResources().getQuantityText(17760274, numNetworks);
            this.mNotification.tickerText = title;
            this.mNotification.setLatestEventInfo(this.mContext, title, details, this.mNotification.contentIntent);
            this.mNotificationRepeatTime = System.currentTimeMillis() + this.NOTIFICATION_REPEAT_DELAY_MS;
            message = this.mTarget.obtainMessage(3, 1, 17302164, this.mNotification);
        } else {
            this.mTarget.removeMessages(3, this.mNotification);
            message = this.mTarget.obtainMessage(3, 0, 17302164);
        }
        this.mTarget.sendMessageDelayed(message, delay);
        this.mNotificationShown = visible;
    }

    private void resetNotificationTimer() {
        this.mNotificationRepeatTime = 0L;
        this.mNumScansSinceNetworkStateChange = 0;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("interface ").append(this.mInterfaceName);
        sb.append(" runState=");
        if (this.mRunState >= 1 && this.mRunState <= mRunStateNames.length) {
            sb.append(mRunStateNames[this.mRunState - 1]);
        } else {
            sb.append(this.mRunState);
        }
        sb.append(LS).append(this.mWifiInfo).append(LS);
        sb.append(this.mDhcpInfo).append(LS);
        sb.append("haveIpAddress=").append(this.mHaveIpAddress).append(", obtainingIpAddress=").append(this.mObtainingIpAddress).append(", scanModeActive=").append(this.mIsScanModeActive).append(LS).append("lastSignalLevel=").append(this.mLastSignalLevel).append(", explicitlyDisabled=").append(this.mTornDownByConnMgr);
        return sb.toString();
    }

    private void checkUseStaticIp() {
        this.mUseStaticIp = false;
        ContentResolver cr = this.mContext.getContentResolver();
        try {
            if (Settings.System.getInt(cr, "wifi_use_static_ip") == 0) {
                return;
            }
        }
        catch (Settings.SettingNotFoundException e) {
            return;
        }
        try {
            String addr = Settings.System.getString(cr, "wifi_static_ip");
            if (addr == null) {
                return;
            }
            this.mDhcpInfo.ipAddress = WifiStateTracker.stringToIpAddr(addr);
            addr = Settings.System.getString(cr, "wifi_static_gateway");
            if (addr == null) {
                return;
            }
            this.mDhcpInfo.gateway = WifiStateTracker.stringToIpAddr(addr);
            addr = Settings.System.getString(cr, "wifi_static_netmask");
            if (addr == null) {
                return;
            }
            this.mDhcpInfo.netmask = WifiStateTracker.stringToIpAddr(addr);
            addr = Settings.System.getString(cr, "wifi_static_dns1");
            if (addr == null) {
                return;
            }
            this.mDhcpInfo.dns1 = WifiStateTracker.stringToIpAddr(addr);
            addr = Settings.System.getString(cr, "wifi_static_dns2");
            this.mDhcpInfo.dns2 = addr != null ? WifiStateTracker.stringToIpAddr(addr) : 0;
        }
        catch (UnknownHostException e) {
            return;
        }
        this.mUseStaticIp = true;
    }

    private static int stringToIpAddr(String addrString) throws UnknownHostException {
        try {
            String[] parts = addrString.split("\\.");
            if (parts.length != 4) {
                throw new UnknownHostException(addrString);
            }
            int a = Integer.parseInt(parts[0]);
            int b = Integer.parseInt(parts[1]) << 8;
            int c = Integer.parseInt(parts[2]) << 16;
            int d = Integer.parseInt(parts[3]) << 24;
            return a | b | c | d;
        }
        catch (NumberFormatException ex) {
            throw new UnknownHostException(addrString);
        }
    }

    private int getMaxDhcpRetries() {
        return Settings.Secure.getInt(this.mContext.getContentResolver(), "wifi_max_dhcp_retry_count", 9);
    }

    private class NotificationEnabledSettingObserver
    extends ContentObserver {
        public NotificationEnabledSettingObserver(Handler handler) {
            super(handler);
        }

        public void register() {
            ContentResolver cr = WifiStateTracker.this.mContext.getContentResolver();
            cr.registerContentObserver(Settings.Secure.getUriFor("wifi_networks_available_notification_on"), true, this);
            WifiStateTracker.this.mNotificationEnabled = this.getValue();
        }

        public void onChange(boolean selfChange) {
            super.onChange(selfChange);
            WifiStateTracker.this.mNotificationEnabled = this.getValue();
            if (!WifiStateTracker.this.mNotificationEnabled) {
                WifiStateTracker.this.setNotificationVisible(false, 0, true, 0);
            }
            WifiStateTracker.this.resetNotificationTimer();
        }

        private boolean getValue() {
            return Settings.Secure.getInt(WifiStateTracker.this.mContext.getContentResolver(), "wifi_networks_available_notification_on", 1) == 1;
        }
    }

    private class SettingsObserver
    extends ContentObserver {
        public SettingsObserver(Handler handler) {
            super(handler);
            ContentResolver cr = WifiStateTracker.this.mContext.getContentResolver();
            cr.registerContentObserver(Settings.System.getUriFor("wifi_use_static_ip"), false, this);
            cr.registerContentObserver(Settings.System.getUriFor("wifi_static_ip"), false, this);
            cr.registerContentObserver(Settings.System.getUriFor("wifi_static_gateway"), false, this);
            cr.registerContentObserver(Settings.System.getUriFor("wifi_static_netmask"), false, this);
            cr.registerContentObserver(Settings.System.getUriFor("wifi_static_dns1"), false, this);
            cr.registerContentObserver(Settings.System.getUriFor("wifi_static_dns2"), false, this);
        }

        public void onChange(boolean selfChange) {
            boolean changed;
            super.onChange(selfChange);
            boolean wasStaticIp = WifiStateTracker.this.mUseStaticIp;
            int oDns2 = 0;
            int oDns1 = 0;
            int oMsk = 0;
            int oGw = 0;
            int oIp = 0;
            if (wasStaticIp) {
                oIp = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.ipAddress;
                oGw = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.gateway;
                oMsk = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.netmask;
                oDns1 = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.dns1;
                oDns2 = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.dns2;
            }
            WifiStateTracker.this.checkUseStaticIp();
            if (WifiStateTracker.this.mWifiInfo.getSupplicantState() == SupplicantState.UNINITIALIZED) {
                return;
            }
            boolean bl = changed = wasStaticIp != WifiStateTracker.this.mUseStaticIp || wasStaticIp && (oIp != ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.ipAddress || oGw != ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.gateway || oMsk != ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.netmask || oDns1 != ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.dns1 || oDns2 != ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.dns2);
            if (changed) {
                WifiStateTracker.this.resetConnections(true);
                WifiStateTracker.this.configureInterface();
                if (WifiStateTracker.this.mUseStaticIp) {
                    Message msg = WifiStateTracker.this.mTarget.obtainMessage(4, WifiStateTracker.this.mNetworkInfo);
                    msg.sendToTarget();
                }
            }
        }
    }

    private class DhcpHandler
    extends Handler {
        private Handler mWifiStateTrackerHandler;
        private boolean mCancelCallback;
        private BluetoothHeadset mBluetoothHeadset;

        public DhcpHandler(Looper looper, Handler target) {
            super(looper);
            this.mWifiStateTrackerHandler = target;
            this.mBluetoothHeadset = new BluetoothHeadset(WifiStateTracker.this.mContext, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 9: 
                case 10: {
                    boolean modifiedBluetoothCoexistenceMode = false;
                    int powerMode = 0;
                    if (this.shouldDisableCoexistenceMode()) {
                        modifiedBluetoothCoexistenceMode = true;
                        WifiStateTracker.this.setBluetoothCoexistenceMode(1);
                    }
                    if ((powerMode = WifiStateTracker.this.getPowerMode()) < 0) {
                        powerMode = 0;
                    }
                    if (powerMode != 1) {
                        WifiStateTracker.this.setPowerMode(1);
                    }
                    DhcpHandler dhcpHandler = this;
                    synchronized (dhcpHandler) {
                        this.mCancelCallback = false;
                    }
                    if (msg.what == 9) {
                        int event;
                        Log.d(WifiStateTracker.TAG, "DHCP request started");
                        if (NetworkUtils.runDhcp(WifiStateTracker.this.mInterfaceName, WifiStateTracker.this.mDhcpInfo)) {
                            event = 6;
                            Log.d(WifiStateTracker.TAG, "DHCP succeeded with lease: " + ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.leaseDuration);
                            this.setDhcpRenewalAlarm(((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.leaseDuration);
                        } else {
                            event = 7;
                            Log.e(WifiStateTracker.TAG, "DHCP request failed: " + NetworkUtils.getDhcpError());
                        }
                        dhcpHandler = this;
                        synchronized (dhcpHandler) {
                            if (!this.mCancelCallback) {
                                this.mWifiStateTrackerHandler.sendEmptyMessage(event);
                            }
                        }
                    }
                    if (msg.what == 10) {
                        Log.d(WifiStateTracker.TAG, "DHCP renewal started");
                        int oIp = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.ipAddress;
                        int oGw = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.gateway;
                        int oMsk = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.netmask;
                        int oDns1 = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.dns1;
                        int oDns2 = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.dns2;
                        if (NetworkUtils.runDhcpRenew(WifiStateTracker.this.mInterfaceName, WifiStateTracker.this.mDhcpInfo)) {
                            boolean changed;
                            Log.d(WifiStateTracker.TAG, "DHCP renewal with lease: " + ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.leaseDuration);
                            boolean bl = changed = oIp != ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.ipAddress || oGw != ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.gateway || oMsk != ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.netmask || oDns1 != ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.dns1 || oDns2 != ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.dns2;
                            if (changed) {
                                Log.d(WifiStateTracker.TAG, "IP config change on renewal");
                                WifiStateTracker.this.mWifiInfo.setIpAddress(((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.ipAddress);
                                NetworkUtils.resetConnections(WifiStateTracker.this.mInterfaceName);
                                msg = WifiStateTracker.this.mTarget.obtainMessage(4, WifiStateTracker.this.mNetworkInfo);
                                msg.sendToTarget();
                            }
                            this.setDhcpRenewalAlarm(((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.leaseDuration);
                        } else {
                            int event = 7;
                            Log.d(WifiStateTracker.TAG, "DHCP renewal failed: " + NetworkUtils.getDhcpError());
                            DhcpHandler dhcpHandler2 = this;
                            synchronized (dhcpHandler2) {
                                if (!this.mCancelCallback) {
                                    this.mWifiStateTrackerHandler.sendEmptyMessage(event);
                                }
                            }
                        }
                    }
                    if (powerMode != 1) {
                        WifiStateTracker.this.setPowerMode(powerMode);
                    }
                    if (!modifiedBluetoothCoexistenceMode) break;
                    WifiStateTracker.this.setBluetoothCoexistenceMode(2);
                }
            }
        }

        public synchronized void setCancelCallback(boolean cancelCallback) {
            this.mCancelCallback = cancelCallback;
            if (cancelCallback) {
                WifiStateTracker.this.mAlarmManager.cancel(WifiStateTracker.this.mDhcpRenewalIntent);
            }
        }

        private boolean shouldDisableCoexistenceMode() {
            int state = this.mBluetoothHeadset.getState(this.mBluetoothHeadset.getCurrentHeadset());
            return state == 0;
        }

        private void setDhcpRenewalAlarm(long leaseDuration) {
            if (leaseDuration < 300L) {
                leaseDuration = 300L;
            }
            WifiStateTracker.this.mAlarmManager.set(2, SystemClock.elapsedRealtime() + leaseDuration * 480L, WifiStateTracker.this.mDhcpRenewalIntent);
        }
    }

    private static class NetworkStateChangeResult {
        NetworkInfo.DetailedState state;
        String BSSID;
        int networkId;

        NetworkStateChangeResult(NetworkInfo.DetailedState state, String BSSID, int networkId) {
            this.state = state;
            this.BSSID = BSSID;
            this.networkId = networkId;
        }
    }

    private static class SupplicantStateChangeResult {
        int networkId;
        String BSSID;
        SupplicantState state;

        SupplicantStateChangeResult(int networkId, String BSSID, SupplicantState state) {
            this.state = state;
            this.BSSID = BSSID;
            this.networkId = networkId;
        }
    }
}

