/*
 * Decompiled with CFR 0.152.
 */
package android.net.rtp;

import android.net.rtp.AudioCodec;
import android.net.rtp.AudioStream;
import java.util.HashMap;
import java.util.Map;

public class AudioGroup {
    public static final int MODE_ON_HOLD = 0;
    public static final int MODE_MUTED = 1;
    public static final int MODE_NORMAL = 2;
    public static final int MODE_ECHO_SUPPRESSION = 3;
    private final Map<AudioStream, Integer> mStreams = new HashMap<AudioStream, Integer>();
    private int mMode = 0;
    private int mNative;

    public int getMode() {
        return this.mMode;
    }

    public synchronized native void setMode(int var1);

    private native void add(int var1, int var2, String var3, int var4, String var5, int var6);

    synchronized void add(AudioStream stream, AudioCodec codec, int dtmfType) {
        if (!this.mStreams.containsKey(stream)) {
            try {
                int socket = stream.dup();
                String codecSpec = String.format("%d %s %s", codec.type, codec.rtpmap, codec.fmtp);
                this.add(stream.getMode(), socket, stream.getRemoteAddress().getHostAddress(), stream.getRemotePort(), codecSpec, dtmfType);
                this.mStreams.put(stream, socket);
            }
            catch (NullPointerException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private native void remove(int var1);

    synchronized void remove(AudioStream stream) {
        Integer socket = this.mStreams.remove(stream);
        if (socket != null) {
            this.remove(socket);
        }
    }

    public synchronized native void sendDtmf(int var1);

    public synchronized void clear() {
        this.remove(-1);
    }

    protected void finalize() throws Throwable {
        this.clear();
        super.finalize();
    }

    static {
        System.loadLibrary("rtp_jni");
    }
}

