/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.ConnectivityManager;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.EnumMap;

public class NetworkInfo
implements Parcelable {
    private static final EnumMap<DetailedState, State> stateMap = new EnumMap(DetailedState.class);
    private int mNetworkType;
    private int mSubtype;
    private String mTypeName;
    private String mSubtypeName;
    private State mState;
    private DetailedState mDetailedState;
    private String mReason;
    private String mExtraInfo;
    private boolean mIsFailover;
    private boolean mIsRoaming;
    private boolean mIsAvailable;
    public static final Parcelable.Creator<NetworkInfo> CREATOR;

    public NetworkInfo(int type) {
    }

    NetworkInfo(int type, int subtype, String typeName, String subtypeName) {
        if (!ConnectivityManager.isNetworkTypeValid(type)) {
            throw new IllegalArgumentException("Invalid network type: " + type);
        }
        this.mNetworkType = type;
        this.mSubtype = subtype;
        this.mTypeName = typeName;
        this.mSubtypeName = subtypeName;
        this.setDetailedState(DetailedState.IDLE, null, null);
        this.mState = State.UNKNOWN;
        this.mIsAvailable = false;
        this.mIsRoaming = false;
    }

    public int getType() {
        return this.mNetworkType;
    }

    public int getSubtype() {
        return this.mSubtype;
    }

    void setSubtype(int subtype, String subtypeName) {
        this.mSubtype = subtype;
        this.mSubtypeName = subtypeName;
    }

    public String getTypeName() {
        return this.mTypeName;
    }

    public String getSubtypeName() {
        return this.mSubtypeName;
    }

    public boolean isConnectedOrConnecting() {
        return this.mState == State.CONNECTED || this.mState == State.CONNECTING;
    }

    public boolean isConnected() {
        return this.mState == State.CONNECTED;
    }

    public boolean isAvailable() {
        return this.mIsAvailable;
    }

    public void setIsAvailable(boolean isAvailable) {
        this.mIsAvailable = isAvailable;
    }

    public boolean isFailover() {
        return this.mIsFailover;
    }

    public void setFailover(boolean isFailover) {
        this.mIsFailover = isFailover;
    }

    public boolean isRoaming() {
        return this.mIsRoaming;
    }

    void setRoaming(boolean isRoaming) {
        this.mIsRoaming = isRoaming;
    }

    public State getState() {
        return this.mState;
    }

    public DetailedState getDetailedState() {
        return this.mDetailedState;
    }

    void setDetailedState(DetailedState detailedState, String reason, String extraInfo) {
        this.mDetailedState = detailedState;
        this.mState = stateMap.get((Object)detailedState);
        this.mReason = reason;
        this.mExtraInfo = extraInfo;
    }

    public String getReason() {
        return this.mReason;
    }

    public String getExtraInfo() {
        return this.mExtraInfo;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("NetworkInfo: ");
        builder.append("type: ").append(this.getTypeName()).append("[").append(this.getSubtypeName()).append("], state: ").append((Object)this.mState).append("/").append((Object)this.mDetailedState).append(", reason: ").append(this.mReason == null ? "(unspecified)" : this.mReason).append(", extra: ").append(this.mExtraInfo == null ? "(none)" : this.mExtraInfo).append(", roaming: ").append(this.mIsRoaming).append(", failover: ").append(this.mIsFailover).append(", isAvailable: ").append(this.mIsAvailable);
        return builder.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mNetworkType);
        dest.writeInt(this.mSubtype);
        dest.writeString(this.mTypeName);
        dest.writeString(this.mSubtypeName);
        dest.writeString(this.mState.name());
        dest.writeString(this.mDetailedState.name());
        dest.writeInt(this.mIsFailover ? 1 : 0);
        dest.writeInt(this.mIsAvailable ? 1 : 0);
        dest.writeInt(this.mIsRoaming ? 1 : 0);
        dest.writeString(this.mReason);
        dest.writeString(this.mExtraInfo);
    }

    static {
        stateMap.put(DetailedState.IDLE, State.DISCONNECTED);
        stateMap.put(DetailedState.SCANNING, State.DISCONNECTED);
        stateMap.put(DetailedState.CONNECTING, State.CONNECTING);
        stateMap.put(DetailedState.AUTHENTICATING, State.CONNECTING);
        stateMap.put(DetailedState.OBTAINING_IPADDR, State.CONNECTING);
        stateMap.put(DetailedState.CONNECTED, State.CONNECTED);
        stateMap.put(DetailedState.SUSPENDED, State.SUSPENDED);
        stateMap.put(DetailedState.DISCONNECTING, State.DISCONNECTING);
        stateMap.put(DetailedState.DISCONNECTED, State.DISCONNECTED);
        stateMap.put(DetailedState.FAILED, State.DISCONNECTED);
        CREATOR = new Parcelable.Creator<NetworkInfo>(){

            @Override
            public NetworkInfo createFromParcel(Parcel in) {
                int netType = in.readInt();
                int subtype = in.readInt();
                String typeName = in.readString();
                String subtypeName = in.readString();
                NetworkInfo netInfo = new NetworkInfo(netType, subtype, typeName, subtypeName);
                netInfo.mState = State.valueOf(in.readString());
                netInfo.mDetailedState = DetailedState.valueOf(in.readString());
                netInfo.mIsFailover = in.readInt() != 0;
                netInfo.mIsAvailable = in.readInt() != 0;
                netInfo.mIsRoaming = in.readInt() != 0;
                netInfo.mReason = in.readString();
                netInfo.mExtraInfo = in.readString();
                return netInfo;
            }

            public NetworkInfo[] newArray(int size) {
                return new NetworkInfo[size];
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DetailedState {
        IDLE,
        SCANNING,
        CONNECTING,
        AUTHENTICATING,
        OBTAINING_IPADDR,
        CONNECTED,
        SUSPENDED,
        DISCONNECTING,
        DISCONNECTED,
        FAILED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        CONNECTING,
        CONNECTED,
        SUSPENDED,
        DISCONNECTING,
        DISCONNECTED,
        UNKNOWN;

    }
}

