/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.NetworkStateTracker;
import android.net.NetworkUtils;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.Phone;

public class MobileDataStateTracker
extends NetworkStateTracker {
    private static final String TAG = "MobileDataStateTracker";
    private static final boolean DBG = false;
    private Phone.DataState mMobileDataState;
    private ITelephony mPhoneService;
    private String mApnType;
    private String mApnTypeToWatchFor;
    private String mApnName;
    private boolean mEnabled;
    private BroadcastReceiver mStateReceiver;
    private boolean mIsDefaultOrHipri = false;

    public MobileDataStateTracker(Context context, Handler target, int netType, String tag) {
        super(context, target, netType, TelephonyManager.getDefault().getNetworkType(), tag, TelephonyManager.getDefault().getNetworkTypeName());
        this.mApnType = MobileDataStateTracker.networkTypeToApnType(netType);
        this.mApnTypeToWatchFor = TextUtils.equals(this.mApnType, "hipri") ? "default" : this.mApnType;
        if (netType == 0 || netType == 5) {
            this.mIsDefaultOrHipri = true;
        }
        this.mPhoneService = null;
        this.mEnabled = netType == 0;
        this.mDnsPropNames = new String[]{"net.rmnet0.dns1", "net.rmnet0.dns2", "net.eth0.dns1", "net.eth0.dns2", "net.eth0.dns3", "net.eth0.dns4", "net.gprs.dns1", "net.gprs.dns2", "net.ppp0.dns1", "net.ppp0.dns2"};
    }

    public void startMonitoring() {
        IntentFilter filter = new IntentFilter("android.intent.action.ANY_DATA_STATE");
        filter.addAction("android.intent.action.DATA_CONNECTION_FAILED");
        filter.addAction("android.intent.action.SERVICE_STATE");
        this.mStateReceiver = new MobileDataStateReceiver();
        Intent intent = this.mContext.registerReceiver(this.mStateReceiver, filter);
        this.mMobileDataState = intent != null ? this.getMobileDataState(intent) : Phone.DataState.DISCONNECTED;
    }

    private Phone.DataState getMobileDataState(Intent intent) {
        String apnTypeList;
        String str = intent.getStringExtra("state");
        if (str != null && this.isApnTypeIncluded(apnTypeList = intent.getStringExtra("apnType"))) {
            return Enum.valueOf(Phone.DataState.class, str);
        }
        return Phone.DataState.DISCONNECTED;
    }

    private boolean isApnTypeIncluded(String typeList) {
        if (typeList == null) {
            return false;
        }
        String[] list = typeList.split(",");
        for (int i = 0; i < list.length; ++i) {
            if (!TextUtils.equals(list[i], this.mApnTypeToWatchFor) && !TextUtils.equals(list[i], "*")) continue;
            return true;
        }
        return false;
    }

    private void getPhoneService(boolean forceRefresh) {
        if (this.mPhoneService == null || forceRefresh) {
            this.mPhoneService = ITelephony.Stub.asInterface(ServiceManager.getService("phone"));
        }
    }

    public boolean isAvailable() {
        this.getPhoneService(false);
        for (int retry = 0; retry < 2 && this.mPhoneService != null; ++retry) {
            try {
                return this.mPhoneService.isDataConnectivityPossible();
            }
            catch (RemoteException e) {
                if (retry != 0) continue;
                this.getPhoneService(true);
                continue;
            }
        }
        return false;
    }

    public int getNetworkSubtype() {
        return TelephonyManager.getDefault().getNetworkType();
    }

    public String getTcpBufferSizesPropName() {
        String networkTypeStr = "unknown";
        TelephonyManager tm = new TelephonyManager(this.mContext);
        switch (tm.getNetworkType()) {
            case 1: {
                networkTypeStr = "gprs";
                break;
            }
            case 2: {
                networkTypeStr = "edge";
                break;
            }
            case 3: {
                networkTypeStr = "umts";
                break;
            }
            case 8: {
                networkTypeStr = "hsdpa";
                break;
            }
            case 9: {
                networkTypeStr = "hsupa";
                break;
            }
            case 10: {
                networkTypeStr = "hspa";
                break;
            }
            case 4: {
                networkTypeStr = "cdma";
                break;
            }
            case 7: {
                networkTypeStr = "1xrtt";
                break;
            }
            case 5: {
                networkTypeStr = "evdo";
                break;
            }
            case 6: {
                networkTypeStr = "evdo";
                break;
            }
            case 12: {
                networkTypeStr = "evdo";
            }
        }
        return "net.tcp.buffersize." + networkTypeStr;
    }

    public boolean teardown() {
        this.setTeardownRequested(true);
        return this.setEnableApn(this.mApnType, false) != 3;
    }

    public boolean reconnect() {
        this.setTeardownRequested(false);
        switch (this.setEnableApn(this.mApnType, true)) {
            case 0: {
                this.mEnabled = true;
                this.mMobileDataState = Phone.DataState.CONNECTING;
                this.setDetailedState(NetworkInfo.DetailedState.CONNECTING, "apnChanged", null);
                Intent intent = new Intent("android.intent.action.ANY_DATA_STATE");
                intent.putExtra("state", Phone.DataState.CONNECTED.toString());
                intent.putExtra("reason", "apnChanged");
                intent.putExtra("apnType", this.mApnTypeToWatchFor);
                intent.putExtra("apn", this.mApnName);
                intent.putExtra("iface", this.mInterfaceName);
                intent.putExtra("networkUnvailable", false);
                intent.putExtra("gateway", this.mDefaultGatewayAddr);
                if (this.mStateReceiver == null) break;
                this.mStateReceiver.onReceive(this.mContext, intent);
                break;
            }
            case 1: {
                this.mEnabled = true;
                break;
            }
            case 3: {
                if (this.mPhoneService == null && this.mApnType == "default") {
                    this.mEnabled = true;
                    return false;
                }
            }
            case 2: {
                if (this.mApnType == "default") break;
                this.mEnabled = false;
                break;
            }
            default: {
                Log.e(TAG, "Error in reconnect - unexpected response.");
                this.mEnabled = false;
            }
        }
        return this.mEnabled;
    }

    public boolean setRadio(boolean turnOn) {
        this.getPhoneService(false);
        for (int retry = 0; retry < 2; ++retry) {
            if (this.mPhoneService == null) {
                Log.w(TAG, "Ignoring mobile radio request because could not acquire PhoneService");
                break;
            }
            try {
                return this.mPhoneService.setRadio(turnOn);
            }
            catch (RemoteException e) {
                if (retry != 0) continue;
                this.getPhoneService(true);
                continue;
            }
        }
        Log.w(TAG, "Could not set radio power to " + (turnOn ? "on" : "off"));
        return false;
    }

    public int startUsingNetworkFeature(String feature, int callingPid, int callingUid) {
        return -1;
    }

    public int stopUsingNetworkFeature(String feature, int callingPid, int callingUid) {
        return -1;
    }

    public boolean requestRouteToHost(int hostAddress) {
        if (this.mInterfaceName != null && hostAddress != -1) {
            return NetworkUtils.addHostRoute(this.mInterfaceName, hostAddress) == 0;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Mobile data state: ");
        sb.append((Object)this.mMobileDataState);
        return sb.toString();
    }

    private int setEnableApn(String apnType, boolean enable) {
        this.getPhoneService(false);
        for (int retry = 0; retry < 2; ++retry) {
            if (this.mPhoneService == null) {
                Log.w(TAG, "Ignoring feature request because could not acquire PhoneService");
                break;
            }
            try {
                if (enable) {
                    return this.mPhoneService.enableApnType(apnType);
                }
                return this.mPhoneService.disableApnType(apnType);
            }
            catch (RemoteException e) {
                if (retry != 0) continue;
                this.getPhoneService(true);
                continue;
            }
        }
        Log.w(TAG, "Could not " + (enable ? "enable" : "disable") + " APN type \"" + apnType + "\"");
        return 3;
    }

    public static String networkTypeToApnType(int netType) {
        switch (netType) {
            case 0: {
                return "default";
            }
            case 2: {
                return "mms";
            }
            case 3: {
                return "supl";
            }
            case 4: {
                return "dun";
            }
            case 5: {
                return "hipri";
            }
        }
        Log.e(TAG, "Error mapping networkType " + netType + " to apnType.");
        return null;
    }

    private class MobileDataStateReceiver
    extends BroadcastReceiver {
        ConnectivityManager mConnectivityManager;

        private MobileDataStateReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            MobileDataStateReceiver mobileDataStateReceiver = this;
            synchronized (mobileDataStateReceiver) {
                TelephonyManager tm = TelephonyManager.getDefault();
                MobileDataStateTracker.this.setRoamingStatus(tm.isNetworkRoaming());
                MobileDataStateTracker.this.setSubtype(tm.getNetworkType(), tm.getNetworkTypeName());
                if (intent.getAction().equals("android.intent.action.ANY_DATA_STATE")) {
                    Phone.DataState state = MobileDataStateTracker.this.getMobileDataState(intent);
                    String reason = intent.getStringExtra("reason");
                    String apnName = intent.getStringExtra("apn");
                    String apnTypeList = intent.getStringExtra("apnType");
                    MobileDataStateTracker.this.mApnName = apnName;
                    boolean unavailable = intent.getBooleanExtra("networkUnvailable", false);
                    MobileDataStateTracker.this.mNetworkInfo.setIsAvailable(!unavailable);
                    if (MobileDataStateTracker.this.isApnTypeIncluded(apnTypeList)) {
                        if (!MobileDataStateTracker.this.mEnabled) {
                            if (state == Phone.DataState.CONNECTED) {
                                MobileDataStateTracker.this.mInterfaceName = intent.getStringExtra("iface");
                            }
                            return;
                        }
                    } else {
                        return;
                    }
                    if (MobileDataStateTracker.this.mMobileDataState != state) {
                        MobileDataStateTracker.this.mMobileDataState = state;
                        switch (state) {
                            case DISCONNECTED: {
                                if (MobileDataStateTracker.this.isTeardownRequested()) {
                                    MobileDataStateTracker.this.mEnabled = false;
                                    MobileDataStateTracker.this.setTeardownRequested(false);
                                }
                                MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, reason, apnName);
                                boolean doReset = true;
                                if (MobileDataStateTracker.this.mIsDefaultOrHipri) {
                                    NetworkInfo info;
                                    int typeToCheck;
                                    int n = typeToCheck = "default".equals(MobileDataStateTracker.this.mApnType) ? 5 : 0;
                                    if (this.mConnectivityManager == null) {
                                        this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                                    }
                                    if (this.mConnectivityManager != null && (info = this.mConnectivityManager.getNetworkInfo(typeToCheck)) != null && info.isConnected()) {
                                        doReset = false;
                                    }
                                }
                                if (!doReset || MobileDataStateTracker.this.mInterfaceName == null) break;
                                NetworkUtils.resetConnections(MobileDataStateTracker.this.mInterfaceName);
                                break;
                            }
                            case CONNECTING: {
                                MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.CONNECTING, reason, apnName);
                                break;
                            }
                            case SUSPENDED: {
                                MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.SUSPENDED, reason, apnName);
                                break;
                            }
                            case CONNECTED: {
                                MobileDataStateTracker.this.mInterfaceName = intent.getStringExtra("iface");
                                if (MobileDataStateTracker.this.mInterfaceName == null) {
                                    Log.d(MobileDataStateTracker.TAG, "CONNECTED event did not supply interface name.");
                                }
                                MobileDataStateTracker.this.mDefaultGatewayAddr = intent.getIntExtra("gateway", 0);
                                if (MobileDataStateTracker.this.mDefaultGatewayAddr == 0) {
                                    Log.d(MobileDataStateTracker.TAG, "CONNECTED event did not supply a default gateway.");
                                }
                                MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.CONNECTED, reason, apnName);
                            }
                        }
                    }
                } else if (intent.getAction().equals("android.intent.action.DATA_CONNECTION_FAILED")) {
                    MobileDataStateTracker.this.mEnabled = false;
                    String reason = intent.getStringExtra("reason");
                    String apnName = intent.getStringExtra("apn");
                    MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.FAILED, reason, apnName);
                }
            }
        }
    }
}

