/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.util.AndroidRuntimeException;
import android.util.Log;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.WeakReference;

public class SoundPool {
    private static final String TAG = "SoundPool";
    private static final boolean DEBUG = false;
    private int mNativeContext;
    private EventHandler mEventHandler;
    private OnLoadCompleteListener mOnLoadCompleteListener;
    private final Object mLock;
    private static final int SAMPLE_LOADED = 1;

    public SoundPool(int maxStreams, int streamType, int srcQuality) {
        if (this.native_setup(new WeakReference<SoundPool>(this), maxStreams, streamType, srcQuality) != 0) {
            throw new RuntimeException("Native setup failed");
        }
        this.mLock = new Object();
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
    }

    public int load(String path, int priority) {
        if (path.startsWith("http:")) {
            return this._load(path, priority);
        }
        int id2 = 0;
        try {
            ParcelFileDescriptor fd;
            File f = new File(path);
            if (f != null && (fd = ParcelFileDescriptor.open(f, 0x10000000)) != null) {
                id2 = this._load(fd.getFileDescriptor(), 0L, f.length(), priority);
                fd.close();
            }
        }
        catch (IOException e) {
            Log.e(TAG, "error loading " + path);
        }
        return id2;
    }

    public int load(Context context, int resId, int priority) {
        AssetFileDescriptor afd = context.getResources().openRawResourceFd(resId);
        int id2 = 0;
        if (afd != null) {
            id2 = this._load(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength(), priority);
            try {
                afd.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return id2;
    }

    public int load(AssetFileDescriptor afd, int priority) {
        if (afd != null) {
            long len = afd.getLength();
            if (len < 0L) {
                throw new AndroidRuntimeException("no length for fd");
            }
            return this._load(afd.getFileDescriptor(), afd.getStartOffset(), len, priority);
        }
        return 0;
    }

    public int load(FileDescriptor fd, long offset, long length, int priority) {
        return this._load(fd, offset, length, priority);
    }

    private final native int _load(String var1, int var2);

    private final native int _load(FileDescriptor var1, long var2, long var4, int var6);

    public final native boolean unload(int var1);

    public final native int play(int var1, float var2, float var3, int var4, int var5, float var6);

    public final native void pause(int var1);

    public final native void resume(int var1);

    public final native void autoPause();

    public final native void autoResume();

    public final native void stop(int var1);

    public final native void setVolume(int var1, float var2, float var3);

    public final native void setPriority(int var1, int var2);

    public final native void setLoop(int var1, int var2);

    public final native void setRate(int var1, float var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnLoadCompleteListener(OnLoadCompleteListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mOnLoadCompleteListener = listener;
        }
    }

    private static void postEventFromNative(Object weakRef, int msg, int arg1, int arg2, Object obj) {
        SoundPool soundPool = (SoundPool)((WeakReference)weakRef).get();
        if (soundPool == null) {
            return;
        }
        if (soundPool.mEventHandler != null) {
            Message m = soundPool.mEventHandler.obtainMessage(msg, arg1, arg2, obj);
            soundPool.mEventHandler.sendMessage(m);
        }
    }

    public final native void release();

    private final native int native_setup(Object var1, int var2, int var3, int var4);

    protected void finalize() {
        this.release();
    }

    static {
        System.loadLibrary("soundpool");
    }

    private class EventHandler
    extends Handler {
        private SoundPool mSoundPool;

        public EventHandler(SoundPool soundPool2, Looper looper) {
            super(looper);
            this.mSoundPool = soundPool2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Object object = SoundPool.this.mLock;
                    synchronized (object) {
                        if (SoundPool.this.mOnLoadCompleteListener != null) {
                            SoundPool.this.mOnLoadCompleteListener.onLoadComplete(this.mSoundPool, msg.arg1, msg.arg2);
                        }
                        break;
                    }
                }
                default: {
                    Log.e(SoundPool.TAG, "Unknown message type " + msg.what);
                    return;
                }
            }
        }
    }

    public static interface OnLoadCompleteListener {
        public void onLoadComplete(SoundPool var1, int var2, int var3);
    }
}

