/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.content.Context;
import android.inputmethodservice.InputMethodService;
import android.util.AttributeSet;
import android.view.inputmethod.ExtractedText;
import android.widget.EditText;

public class ExtractEditText
extends EditText {
    private InputMethodService mIME;
    private int mSettingExtractedText;

    public ExtractEditText(Context context) {
        super(context, null);
    }

    public ExtractEditText(Context context, AttributeSet attrs) {
        super(context, attrs, 16842862);
    }

    public ExtractEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    void setIME(InputMethodService ime) {
        this.mIME = ime;
    }

    public void startInternalChanges() {
        ++this.mSettingExtractedText;
    }

    public void finishInternalChanges() {
        --this.mSettingExtractedText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExtractedText(ExtractedText text) {
        try {
            ++this.mSettingExtractedText;
            super.setExtractedText(text);
            Object var3_2 = null;
            --this.mSettingExtractedText;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            --this.mSettingExtractedText;
            throw throwable;
        }
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        if (this.mSettingExtractedText == 0 && this.mIME != null && selStart >= 0 && selEnd >= 0) {
            this.mIME.onExtractedSelectionChanged(selStart, selEnd);
        }
    }

    public boolean performClick() {
        if (!super.performClick() && this.mIME != null) {
            this.mIME.onExtractedTextClicked();
            return true;
        }
        return false;
    }

    public boolean onTextContextMenuItem(int id2) {
        if (this.mIME != null && id2 != 16908328 && this.mIME.onExtractTextContextMenuItem(id2)) {
            return true;
        }
        return super.onTextContextMenuItem(id2);
    }

    public boolean isInputMethodTarget() {
        return true;
    }

    public boolean hasVerticalScrollBar() {
        return this.computeVerticalScrollRange() > this.computeVerticalScrollExtent();
    }

    public boolean hasWindowFocus() {
        return this.isEnabled();
    }

    public boolean isFocused() {
        return this.isEnabled();
    }

    public boolean hasFocus() {
        return this.isEnabled();
    }
}

