/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorListener;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.view.IRotationWatcher;
import android.view.IWindowManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SensorManager {
    private static final String TAG = "SensorManager";
    private static final float[] mTempMatrix = new float[16];
    @Deprecated
    public static final int SENSOR_ORIENTATION = 1;
    @Deprecated
    public static final int SENSOR_ACCELEROMETER = 2;
    @Deprecated
    public static final int SENSOR_TEMPERATURE = 4;
    @Deprecated
    public static final int SENSOR_MAGNETIC_FIELD = 8;
    @Deprecated
    public static final int SENSOR_LIGHT = 16;
    @Deprecated
    public static final int SENSOR_PROXIMITY = 32;
    @Deprecated
    public static final int SENSOR_TRICORDER = 64;
    @Deprecated
    public static final int SENSOR_ORIENTATION_RAW = 128;
    @Deprecated
    public static final int SENSOR_ALL = 127;
    @Deprecated
    public static final int SENSOR_MIN = 1;
    @Deprecated
    public static final int SENSOR_MAX = 64;
    @Deprecated
    public static final int DATA_X = 0;
    @Deprecated
    public static final int DATA_Y = 1;
    @Deprecated
    public static final int DATA_Z = 2;
    @Deprecated
    public static final int RAW_DATA_INDEX = 3;
    @Deprecated
    public static final int RAW_DATA_X = 3;
    @Deprecated
    public static final int RAW_DATA_Y = 4;
    @Deprecated
    public static final int RAW_DATA_Z = 5;
    public static final float STANDARD_GRAVITY = 9.80665f;
    public static final float GRAVITY_SUN = 275.0f;
    public static final float GRAVITY_MERCURY = 3.7f;
    public static final float GRAVITY_VENUS = 8.87f;
    public static final float GRAVITY_EARTH = 9.80665f;
    public static final float GRAVITY_MOON = 1.6f;
    public static final float GRAVITY_MARS = 3.71f;
    public static final float GRAVITY_JUPITER = 23.12f;
    public static final float GRAVITY_SATURN = 8.96f;
    public static final float GRAVITY_URANUS = 8.69f;
    public static final float GRAVITY_NEPTUNE = 11.0f;
    public static final float GRAVITY_PLUTO = 0.6f;
    public static final float GRAVITY_DEATH_STAR_I = 3.5303614E-7f;
    public static final float GRAVITY_THE_ISLAND = 4.815162f;
    public static final float MAGNETIC_FIELD_EARTH_MAX = 60.0f;
    public static final float MAGNETIC_FIELD_EARTH_MIN = 30.0f;
    public static final float PRESSURE_STANDARD_ATMOSPHERE = 1013.25f;
    public static final float LIGHT_SUNLIGHT_MAX = 120000.0f;
    public static final float LIGHT_SUNLIGHT = 110000.0f;
    public static final float LIGHT_SHADE = 20000.0f;
    public static final float LIGHT_OVERCAST = 10000.0f;
    public static final float LIGHT_SUNRISE = 400.0f;
    public static final float LIGHT_CLOUDY = 100.0f;
    public static final float LIGHT_FULLMOON = 0.25f;
    public static final float LIGHT_NO_MOON = 0.001f;
    public static final int SENSOR_DELAY_FASTEST = 0;
    public static final int SENSOR_DELAY_GAME = 1;
    public static final int SENSOR_DELAY_UI = 2;
    public static final int SENSOR_DELAY_NORMAL = 3;
    public static final int SENSOR_STATUS_UNRELIABLE = 0;
    public static final int SENSOR_STATUS_ACCURACY_LOW = 1;
    public static final int SENSOR_STATUS_ACCURACY_MEDIUM = 2;
    public static final int SENSOR_STATUS_ACCURACY_HIGH = 3;
    public static final int AXIS_X = 1;
    public static final int AXIS_Y = 2;
    public static final int AXIS_Z = 3;
    public static final int AXIS_MINUS_X = 129;
    public static final int AXIS_MINUS_Y = 130;
    public static final int AXIS_MINUS_Z = 131;
    Looper mMainLooper;
    private HashMap<SensorListener, LegacyListener> mLegacyListenersMap = new HashMap();
    private static final int SENSOR_DISABLE = -1;
    private static boolean sSensorModuleInitialized = false;
    private static ArrayList<Sensor> sFullSensorsList = new ArrayList();
    private static SparseArray<List<Sensor>> sSensorListByType = new SparseArray();
    private static IWindowManager sWindowManager;
    private static int sRotation;
    private static SensorThread sSensorThread;
    private static int sQueue;
    static SparseArray<Sensor> sHandleToSensor;
    static final ArrayList<ListenerDelegate> sListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SensorManager(Looper mainLooper) {
        this.mMainLooper = mainLooper;
        ArrayList<ListenerDelegate> arrayList = sListeners;
        synchronized (arrayList) {
            if (!sSensorModuleInitialized) {
                sSensorModuleInitialized = true;
                SensorManager.nativeClassInit();
                sWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
                if (sWindowManager != null) {
                    try {
                        sRotation = sWindowManager.watchRotation(new IRotationWatcher.Stub(){

                            public void onRotationChanged(int rotation) {
                                SensorManager.this.onRotationChanged(rotation);
                            }
                        });
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
                SensorManager.sensors_module_init();
                ArrayList<Sensor> fullList = sFullSensorsList;
                int i = 0;
                do {
                    Sensor sensor;
                    if ((i = SensorManager.sensors_module_get_next_sensor(sensor = new Sensor(), i)) < 0) continue;
                    sensor.setLegacyType(this.getLegacySensorType(sensor.getType()));
                    fullList.add(sensor);
                    sHandleToSensor.append(sensor.getHandle(), sensor);
                } while (i > 0);
                sSensorThread = new SensorThread();
            }
        }
    }

    private int getLegacySensorType(int type) {
        switch (type) {
            case 1: {
                return 2;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 128;
            }
            case 7: {
                return 4;
            }
        }
        return 0;
    }

    @Deprecated
    public int getSensors() {
        int result = 0;
        ArrayList<Sensor> fullList = sFullSensorsList;
        for (Sensor i : fullList) {
            switch (i.getType()) {
                case 1: {
                    result |= 2;
                    break;
                }
                case 2: {
                    result |= 8;
                    break;
                }
                case 3: {
                    result |= 0x81;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Sensor> getSensorList(int type) {
        List<Sensor> list;
        ArrayList<Sensor> fullList;
        ArrayList<Sensor> arrayList = fullList = sFullSensorsList;
        synchronized (arrayList) {
            list = sSensorListByType.get(type);
            if (list == null) {
                if (type == -1) {
                    list = fullList;
                } else {
                    list = new ArrayList<Sensor>();
                    for (Sensor i : fullList) {
                        if (i.getType() != type) continue;
                        list.add(i);
                    }
                }
                list = Collections.unmodifiableList(list);
                sSensorListByType.append(type, list);
            }
        }
        return list;
    }

    public Sensor getDefaultSensor(int type) {
        List<Sensor> l = this.getSensorList(type);
        return l.isEmpty() ? null : l.get(0);
    }

    @Deprecated
    public boolean registerListener(SensorListener listener, int sensors) {
        return this.registerListener(listener, sensors, 3);
    }

    @Deprecated
    public boolean registerListener(SensorListener listener, int sensors, int rate) {
        if (listener == null) {
            return false;
        }
        boolean result = false;
        result = this.registerLegacyListener(2, 1, listener, sensors, rate) || result;
        result = this.registerLegacyListener(8, 2, listener, sensors, rate) || result;
        result = this.registerLegacyListener(128, 3, listener, sensors, rate) || result;
        result = this.registerLegacyListener(1, 3, listener, sensors, rate) || result;
        result = this.registerLegacyListener(4, 7, listener, sensors, rate) || result;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerLegacyListener(int legacyType, int type, SensorListener listener, int sensors, int rate) {
        Sensor sensor;
        if (listener == null) {
            return false;
        }
        boolean result = false;
        if ((sensors & legacyType) != 0 && (sensor = this.getDefaultSensor(type)) != null) {
            LegacyListener legacyListener = null;
            HashMap<SensorListener, LegacyListener> hashMap = this.mLegacyListenersMap;
            synchronized (hashMap) {
                legacyListener = this.mLegacyListenersMap.get(listener);
                if (legacyListener == null) {
                    legacyListener = new LegacyListener(listener);
                    this.mLegacyListenersMap.put(listener, legacyListener);
                }
            }
            legacyListener.registerSensor(legacyType);
            result = this.registerListener(legacyListener, sensor, rate);
        }
        return result;
    }

    @Deprecated
    public void unregisterListener(SensorListener listener, int sensors) {
        this.unregisterLegacyListener(2, 1, listener, sensors);
        this.unregisterLegacyListener(8, 2, listener, sensors);
        this.unregisterLegacyListener(128, 3, listener, sensors);
        this.unregisterLegacyListener(1, 3, listener, sensors);
        this.unregisterLegacyListener(4, 7, listener, sensors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterLegacyListener(int legacyType, int type, SensorListener listener, int sensors) {
        Sensor sensor;
        if (listener == null) {
            return;
        }
        LegacyListener legacyListener = null;
        HashMap<SensorListener, LegacyListener> hashMap = this.mLegacyListenersMap;
        synchronized (hashMap) {
            legacyListener = this.mLegacyListenersMap.get(listener);
        }
        if (legacyListener != null && (sensors & legacyType) != 0 && (sensor = this.getDefaultSensor(type)) != null && legacyListener.unregisterSensor(legacyType)) {
            this.unregisterListener(legacyListener, sensor);
            ArrayList<ListenerDelegate> arrayList = sListeners;
            synchronized (arrayList) {
                boolean found = false;
                for (ListenerDelegate i : sListeners) {
                    if (i.getListener() != legacyListener) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    HashMap<SensorListener, LegacyListener> hashMap2 = this.mLegacyListenersMap;
                    synchronized (hashMap2) {
                        this.mLegacyListenersMap.remove(listener);
                    }
                }
            }
        }
    }

    @Deprecated
    public void unregisterListener(SensorListener listener) {
        this.unregisterListener(listener, 255);
    }

    public void unregisterListener(SensorEventListener listener, Sensor sensor) {
        this.unregisterListener((Object)listener, sensor);
    }

    public void unregisterListener(SensorEventListener listener) {
        this.unregisterListener((Object)listener);
    }

    public boolean registerListener(SensorEventListener listener, Sensor sensor, int rate) {
        return this.registerListener(listener, sensor, rate, null);
    }

    private boolean enableSensorLocked(Sensor sensor, int delay) {
        boolean result = false;
        for (ListenerDelegate i : sListeners) {
            if (!i.hasSensor(sensor)) continue;
            String name = sensor.getName();
            int handle = sensor.getHandle();
            result = SensorManager.sensors_enable_sensor(sQueue, name, handle, delay);
            break;
        }
        return result;
    }

    private boolean disableSensorLocked(Sensor sensor) {
        for (ListenerDelegate i : sListeners) {
            if (!i.hasSensor(sensor)) continue;
            return true;
        }
        String name = sensor.getName();
        int handle = sensor.getHandle();
        return SensorManager.sensors_enable_sensor(sQueue, name, handle, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerListener(SensorEventListener listener, Sensor sensor, int rate, Handler handler) {
        if (listener == null || sensor == null) {
            return false;
        }
        boolean result = true;
        int delay = -1;
        switch (rate) {
            case 0: {
                delay = 0;
                break;
            }
            case 1: {
                delay = 20000;
                break;
            }
            case 2: {
                delay = 60000;
                break;
            }
            case 3: {
                delay = 200000;
                break;
            }
            default: {
                delay = rate;
            }
        }
        ArrayList<ListenerDelegate> arrayList = sListeners;
        synchronized (arrayList) {
            ListenerDelegate l = null;
            for (ListenerDelegate i : sListeners) {
                if (i.getListener() != listener) continue;
                l = i;
                break;
            }
            if (l == null) {
                l = new ListenerDelegate(listener, sensor, handler);
                sListeners.add(l);
                if (!sListeners.isEmpty()) {
                    if (sSensorThread.startLocked()) {
                        if (!this.enableSensorLocked(sensor, delay)) {
                            sListeners.remove(l);
                            result = false;
                        }
                    } else {
                        sListeners.remove(l);
                        result = false;
                    }
                } else {
                    result = false;
                }
            } else {
                l.addSensor(sensor);
                if (!this.enableSensorLocked(sensor, delay)) {
                    l.removeSensor(sensor);
                    result = false;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterListener(Object listener, Sensor sensor) {
        if (listener == null || sensor == null) {
            return;
        }
        ArrayList<ListenerDelegate> arrayList = sListeners;
        synchronized (arrayList) {
            int size = sListeners.size();
            for (int i = 0; i < size; ++i) {
                ListenerDelegate l = sListeners.get(i);
                if (l.getListener() != listener) continue;
                if (l.removeSensor(sensor) != 0) break;
                sListeners.remove(i);
                break;
            }
            this.disableSensorLocked(sensor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterListener(Object listener) {
        if (listener == null) {
            return;
        }
        ArrayList<ListenerDelegate> arrayList = sListeners;
        synchronized (arrayList) {
            int size = sListeners.size();
            for (int i = 0; i < size; ++i) {
                ListenerDelegate l = sListeners.get(i);
                if (l.getListener() != listener) continue;
                sListeners.remove(i);
                for (Sensor sensor : l.getSensors()) {
                    this.disableSensorLocked(sensor);
                }
                break;
            }
        }
    }

    public static boolean getRotationMatrix(float[] R2, float[] I, float[] gravity, float[] geomagnetic) {
        float Ey = geomagnetic[1];
        float Az = gravity[2];
        float Ez = geomagnetic[2];
        float Ay = gravity[1];
        float Hx = Ey * Az - Ez * Ay;
        float Ax = gravity[0];
        float Ex = geomagnetic[0];
        float Hy = Ez * Ax - Ex * Az;
        float Hz = Ex * Ay - Ey * Ax;
        float normH = (float)Math.sqrt(Hx * Hx + Hy * Hy + Hz * Hz);
        if (normH < 0.1f) {
            return false;
        }
        float invH = 1.0f / normH;
        float invA = 1.0f / (float)Math.sqrt(Ax * Ax + Ay * Ay + Az * Az);
        float Mx = (Ay *= invA) * (Hz *= invH) - (Az *= invA) * (Hy *= invH);
        float My = Az * (Hx *= invH) - (Ax *= invA) * Hz;
        float Mz = Ax * Hy - Ay * Hx;
        if (R2 != null) {
            if (R2.length == 9) {
                R2[0] = Hx;
                R2[1] = Hy;
                R2[2] = Hz;
                R2[3] = Mx;
                R2[4] = My;
                R2[5] = Mz;
                R2[6] = Ax;
                R2[7] = Ay;
                R2[8] = Az;
            } else if (R2.length == 16) {
                R2[0] = Hx;
                R2[1] = Hy;
                R2[2] = Hz;
                R2[3] = 0.0f;
                R2[4] = Mx;
                R2[5] = My;
                R2[6] = Mz;
                R2[7] = 0.0f;
                R2[8] = Ax;
                R2[9] = Ay;
                R2[10] = Az;
                R2[11] = 0.0f;
                R2[12] = 0.0f;
                R2[13] = 0.0f;
                R2[14] = 0.0f;
                R2[15] = 1.0f;
            }
        }
        if (I != null) {
            float invE = 1.0f / (float)Math.sqrt(Ex * Ex + Ey * Ey + Ez * Ez);
            float c = (Ex * Mx + Ey * My + Ez * Mz) * invE;
            float s = (Ex * Ax + Ey * Ay + Ez * Az) * invE;
            if (I.length == 9) {
                I[0] = 1.0f;
                I[1] = 0.0f;
                I[2] = 0.0f;
                I[3] = 0.0f;
                I[4] = c;
                I[5] = s;
                I[6] = 0.0f;
                I[7] = -s;
                I[8] = c;
            } else if (I.length == 16) {
                I[0] = 1.0f;
                I[1] = 0.0f;
                I[2] = 0.0f;
                I[4] = 0.0f;
                I[5] = c;
                I[6] = s;
                I[8] = 0.0f;
                I[9] = -s;
                I[10] = c;
                I[14] = 0.0f;
                I[13] = 0.0f;
                I[12] = 0.0f;
                I[11] = 0.0f;
                I[7] = 0.0f;
                I[3] = 0.0f;
                I[15] = 1.0f;
            }
        }
        return true;
    }

    public static float getInclination(float[] I) {
        if (I.length == 9) {
            return (float)Math.atan2(I[5], I[4]);
        }
        return (float)Math.atan2(I[6], I[5]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean remapCoordinateSystem(float[] inR, int X, int Y, float[] outR) {
        float[] temp;
        if (inR != outR) return SensorManager.remapCoordinateSystemImpl(inR, X, Y, outR);
        float[] fArray = temp = mTempMatrix;
        synchronized (temp) {
            if (!SensorManager.remapCoordinateSystemImpl(inR, X, Y, temp)) return SensorManager.remapCoordinateSystemImpl(inR, X, Y, outR);
            int size = outR.length;
            for (int i = 0; i < size; ++i) {
                outR[i] = temp[i];
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return true;
        }
    }

    private static boolean remapCoordinateSystemImpl(float[] inR, int X, int Y, float[] outR) {
        int length = outR.length;
        if (inR.length != length) {
            return false;
        }
        if ((X & 0x7C) != 0 || (Y & 0x7C) != 0) {
            return false;
        }
        if ((X & 3) == 0 || (Y & 3) == 0) {
            return false;
        }
        if ((X & 3) == (Y & 3)) {
            return false;
        }
        int x = (X & 3) - 1;
        int Z = X ^ Y;
        int z = (Z & 3) - 1;
        int axis_y = (z + 1) % 3;
        int y = (Y & 3) - 1;
        int axis_z = (z + 2) % 3;
        if ((x ^ axis_y | y ^ axis_z) != 0) {
            Z ^= 0x80;
        }
        boolean sx = X >= 128;
        boolean sy = Y >= 128;
        boolean sz = Z >= 128;
        int rowLength = length == 16 ? 4 : 3;
        for (int j = 0; j < 3; ++j) {
            int offset = j * rowLength;
            for (int i = 0; i < 3; ++i) {
                if (x == i) {
                    float f = outR[offset + i] = sx ? -inR[offset + 0] : inR[offset + 0];
                }
                if (y == i) {
                    float f = outR[offset + i] = sy ? -inR[offset + 1] : inR[offset + 1];
                }
                if (z != i) continue;
                outR[offset + i] = sz ? -inR[offset + 2] : inR[offset + 2];
            }
        }
        if (length == 16) {
            outR[14] = 0.0f;
            outR[13] = 0.0f;
            outR[12] = 0.0f;
            outR[11] = 0.0f;
            outR[7] = 0.0f;
            outR[3] = 0.0f;
            outR[15] = 1.0f;
        }
        return true;
    }

    public static float[] getOrientation(float[] R2, float[] values) {
        if (R2.length == 9) {
            values[0] = (float)Math.atan2(R2[1], R2[4]);
            values[1] = (float)Math.asin(-R2[7]);
            values[2] = (float)Math.atan2(-R2[6], R2[8]);
        } else {
            values[0] = (float)Math.atan2(R2[1], R2[5]);
            values[1] = (float)Math.asin(-R2[9]);
            values[2] = (float)Math.atan2(-R2[8], R2[10]);
        }
        return values;
    }

    public static float getAltitude(float p0, float p) {
        float coef = 0.19029495f;
        return 44330.0f * (1.0f - (float)Math.pow(p / p0, 0.19029495120048523));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRotationChanged(int rotation) {
        ArrayList<ListenerDelegate> arrayList = sListeners;
        synchronized (arrayList) {
            sRotation = rotation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getRotation() {
        ArrayList<ListenerDelegate> arrayList = sListeners;
        synchronized (arrayList) {
            return sRotation;
        }
    }

    public static void getAngleChange(float[] angleChange, float[] R2, float[] prevR) {
        float rd1 = 0.0f;
        float rd4 = 0.0f;
        float rd6 = 0.0f;
        float rd7 = 0.0f;
        float rd8 = 0.0f;
        float ri0 = 0.0f;
        float ri1 = 0.0f;
        float ri2 = 0.0f;
        float ri3 = 0.0f;
        float ri4 = 0.0f;
        float ri5 = 0.0f;
        float ri6 = 0.0f;
        float ri7 = 0.0f;
        float ri8 = 0.0f;
        float pri0 = 0.0f;
        float pri1 = 0.0f;
        float pri2 = 0.0f;
        float pri3 = 0.0f;
        float pri4 = 0.0f;
        float pri5 = 0.0f;
        float pri6 = 0.0f;
        float pri7 = 0.0f;
        float pri8 = 0.0f;
        if (R2.length == 9) {
            ri0 = R2[0];
            ri1 = R2[1];
            ri2 = R2[2];
            ri3 = R2[3];
            ri4 = R2[4];
            ri5 = R2[5];
            ri6 = R2[6];
            ri7 = R2[7];
            ri8 = R2[8];
        } else if (R2.length == 16) {
            ri0 = R2[0];
            ri1 = R2[1];
            ri2 = R2[2];
            ri3 = R2[4];
            ri4 = R2[5];
            ri5 = R2[6];
            ri6 = R2[8];
            ri7 = R2[9];
            ri8 = R2[10];
        }
        if (prevR.length == 9) {
            pri0 = prevR[0];
            pri1 = prevR[1];
            pri2 = prevR[2];
            pri3 = prevR[3];
            pri4 = prevR[4];
            pri5 = prevR[5];
            pri6 = prevR[6];
            pri7 = prevR[7];
            pri8 = prevR[8];
        } else if (prevR.length == 16) {
            pri0 = prevR[0];
            pri1 = prevR[1];
            pri2 = prevR[2];
            pri3 = prevR[4];
            pri4 = prevR[5];
            pri5 = prevR[6];
            pri6 = prevR[8];
            pri7 = prevR[9];
            pri8 = prevR[10];
        }
        rd1 = pri0 * ri1 + pri3 * ri4 + pri6 * ri7;
        rd4 = pri1 * ri1 + pri4 * ri4 + pri7 * ri7;
        rd6 = pri2 * ri0 + pri5 * ri3 + pri8 * ri6;
        rd7 = pri2 * ri1 + pri5 * ri4 + pri8 * ri7;
        rd8 = pri2 * ri2 + pri5 * ri5 + pri8 * ri8;
        angleChange[0] = (float)Math.atan2(rd1, rd4);
        angleChange[1] = (float)Math.asin(-rd7);
        angleChange[2] = (float)Math.atan2(-rd6, rd8);
    }

    public static void getRotationMatrixFromVector(float[] R2, float[] rotationVector) {
        float q0;
        float q1 = rotationVector[0];
        float q2 = rotationVector[1];
        float q3 = rotationVector[2];
        q0 = rotationVector.length == 4 ? rotationVector[3] : ((q0 = 1.0f - q1 * q1 - q2 * q2 - q3 * q3) > 0.0f ? (float)Math.sqrt(q0) : 0.0f);
        float sq_q1 = 2.0f * q1 * q1;
        float sq_q2 = 2.0f * q2 * q2;
        float sq_q3 = 2.0f * q3 * q3;
        float q1_q2 = 2.0f * q1 * q2;
        float q3_q0 = 2.0f * q3 * q0;
        float q1_q3 = 2.0f * q1 * q3;
        float q2_q0 = 2.0f * q2 * q0;
        float q2_q3 = 2.0f * q2 * q3;
        float q1_q0 = 2.0f * q1 * q0;
        if (R2.length == 9) {
            R2[0] = 1.0f - sq_q2 - sq_q3;
            R2[1] = q1_q2 - q3_q0;
            R2[2] = q1_q3 + q2_q0;
            R2[3] = q1_q2 + q3_q0;
            R2[4] = 1.0f - sq_q1 - sq_q3;
            R2[5] = q2_q3 - q1_q0;
            R2[6] = q1_q3 - q2_q0;
            R2[7] = q2_q3 + q1_q0;
            R2[8] = 1.0f - sq_q1 - sq_q2;
        } else if (R2.length == 16) {
            R2[0] = 1.0f - sq_q2 - sq_q3;
            R2[1] = q1_q2 - q3_q0;
            R2[2] = q1_q3 + q2_q0;
            R2[3] = 0.0f;
            R2[4] = q1_q2 + q3_q0;
            R2[5] = 1.0f - sq_q1 - sq_q3;
            R2[6] = q2_q3 - q1_q0;
            R2[7] = 0.0f;
            R2[8] = q1_q3 - q2_q0;
            R2[9] = q2_q3 + q1_q0;
            R2[10] = 1.0f - sq_q1 - sq_q2;
            R2[11] = 0.0f;
            R2[14] = 0.0f;
            R2[13] = 0.0f;
            R2[12] = 0.0f;
            R2[15] = 1.0f;
        }
    }

    public static void getQuaternionFromVector(float[] Q, float[] rv) {
        if (rv.length == 4) {
            Q[0] = rv[3];
        } else {
            Q[0] = 1.0f - rv[0] * rv[0] - rv[1] * rv[1] - rv[2] * rv[2];
            Q[0] = Q[0] > 0.0f ? (float)Math.sqrt(Q[0]) : 0.0f;
        }
        Q[1] = rv[0];
        Q[2] = rv[1];
        Q[3] = rv[2];
    }

    private static native void nativeClassInit();

    private static native int sensors_module_init();

    private static native int sensors_module_get_next_sensor(Sensor var0, int var1);

    static native int sensors_create_queue();

    static native void sensors_destroy_queue(int var0);

    static native boolean sensors_enable_sensor(int var0, String var1, int var2, int var3);

    static native int sensors_data_poll(int var0, float[] var1, int[] var2, long[] var3);

    static {
        sRotation = 0;
        sHandleToSensor = new SparseArray();
        sListeners = new ArrayList();
    }

    class LmsFilter {
        private static final int SENSORS_RATE_MS = 20;
        private static final int COUNT = 12;
        private static final float PREDICTION_RATIO = 0.33333334f;
        private static final float PREDICTION_TIME = 0.08f;
        private float[] mV = new float[24];
        private float[] mT = new float[24];
        private int mIndex = 12;

        public float filter(long time, float in) {
            float v = in;
            float ns = 1.0E-9f;
            float t = (float)time * 1.0E-9f;
            float v1 = this.mV[this.mIndex];
            if (v - v1 > 180.0f) {
                v -= 360.0f;
            } else if (v1 - v > 180.0f) {
                v += 360.0f;
            }
            ++this.mIndex;
            if (this.mIndex >= 24) {
                this.mIndex = 12;
            }
            this.mV[this.mIndex] = v;
            this.mT[this.mIndex] = t;
            this.mV[this.mIndex - 12] = v;
            this.mT[this.mIndex - 12] = t;
            float E = 0.0f;
            float D = 0.0f;
            float C = 0.0f;
            float B = 0.0f;
            float A = 0.0f;
            for (int i = 0; i < 11; ++i) {
                int j = this.mIndex - 1 - i;
                float Z = this.mV[j];
                float T2 = 0.5f * (this.mT[j] + this.mT[j + 1]) - t;
                float dT = this.mT[j] - this.mT[j + 1];
                dT *= dT;
                A += Z * dT;
                B += T2 * (T2 * dT);
                C += T2 * dT;
                D += Z * (T2 * dT);
                E += dT;
            }
            float b = (A * B + C * D) / (E * B + C * C);
            float a = (E * b - A) / C;
            float f = b + 0.08f * a;
            float f2 = (f *= 0.0027777778f) >= 0.0f ? f : -f;
            if (f2 >= 0.5f) {
                f = f - (float)Math.ceil(f + 0.5f) + 1.0f;
            }
            if (f < 0.0f) {
                f += 1.0f;
            }
            return f *= 360.0f;
        }
    }

    private class LegacyListener
    implements SensorEventListener {
        private float[] mValues = new float[6];
        private SensorListener mTarget;
        private int mSensors;
        private final LmsFilter mYawfilter = new LmsFilter();

        LegacyListener(SensorListener target) {
            this.mTarget = target;
            this.mSensors = 0;
        }

        void registerSensor(int legacyType) {
            this.mSensors |= legacyType;
        }

        boolean unregisterSensor(int legacyType) {
            this.mSensors &= ~legacyType;
            int mask = 129;
            return (legacyType & mask) == 0 || (this.mSensors & mask) == 0;
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
            try {
                this.mTarget.onAccuracyChanged(sensor.getLegacyType(), accuracy);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }

        public void onSensorChanged(SensorEvent event) {
            float[] v = this.mValues;
            v[0] = event.values[0];
            v[1] = event.values[1];
            v[2] = event.values[2];
            int legacyType = event.sensor.getLegacyType();
            this.mapSensorDataToWindow(legacyType, v, SensorManager.getRotation());
            if (event.sensor.getType() == 3) {
                if ((this.mSensors & 0x80) != 0) {
                    this.mTarget.onSensorChanged(128, v);
                }
                if ((this.mSensors & 1) != 0) {
                    v[0] = this.mYawfilter.filter(event.timestamp, v[0]);
                    this.mTarget.onSensorChanged(1, v);
                }
            } else {
                this.mTarget.onSensorChanged(legacyType, v);
            }
        }

        private void mapSensorDataToWindow(int sensor, float[] values, int orientation) {
            float x = values[0];
            float y = values[1];
            float z = values[2];
            switch (sensor) {
                case 1: 
                case 128: {
                    z = -z;
                    break;
                }
                case 2: {
                    x = -x;
                    y = -y;
                    z = -z;
                    break;
                }
                case 8: {
                    x = -x;
                    y = -y;
                }
            }
            values[0] = x;
            values[1] = y;
            values[2] = z;
            values[3] = x;
            values[4] = y;
            values[5] = z;
            if ((orientation & 1) != 0) {
                switch (sensor) {
                    case 2: 
                    case 8: {
                        values[0] = -y;
                        values[1] = x;
                        values[2] = z;
                        break;
                    }
                    case 1: 
                    case 128: {
                        values[0] = x + (float)(x < 270.0f ? 90 : -270);
                        values[1] = z;
                        values[2] = y;
                    }
                }
            }
            if ((orientation & 2) != 0) {
                x = values[0];
                y = values[1];
                z = values[2];
                switch (sensor) {
                    case 2: 
                    case 8: {
                        values[0] = -x;
                        values[1] = -y;
                        values[2] = z;
                        break;
                    }
                    case 1: 
                    case 128: {
                        values[0] = x >= 180.0f ? x - 180.0f : x + 180.0f;
                        values[1] = -y;
                        values[2] = -z;
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListenerDelegate {
        final SensorEventListener mSensorEventListener;
        private final ArrayList<Sensor> mSensorList = new ArrayList();
        private final Handler mHandler;
        private SensorEvent mValuesPool;
        public SparseBooleanArray mSensors = new SparseBooleanArray();
        public SparseBooleanArray mFirstEvent = new SparseBooleanArray();
        public SparseIntArray mSensorAccuracies = new SparseIntArray();

        ListenerDelegate(SensorEventListener listener, Sensor sensor, Handler handler) {
            this.mSensorEventListener = listener;
            Looper looper = handler != null ? handler.getLooper() : SensorManager.this.mMainLooper;
            this.mHandler = new Handler(looper){

                public void handleMessage(Message msg) {
                    SensorEvent t = (SensorEvent)msg.obj;
                    int handle = t.sensor.getHandle();
                    switch (t.sensor.getType()) {
                        case 2: 
                        case 3: {
                            int accuracy = ListenerDelegate.this.mSensorAccuracies.get(handle);
                            if (t.accuracy < 0 || accuracy == t.accuracy) break;
                            ListenerDelegate.this.mSensorAccuracies.put(handle, t.accuracy);
                            ListenerDelegate.this.mSensorEventListener.onAccuracyChanged(t.sensor, t.accuracy);
                            break;
                        }
                        default: {
                            if (ListenerDelegate.this.mFirstEvent.get(handle)) break;
                            ListenerDelegate.this.mFirstEvent.put(handle, true);
                            ListenerDelegate.this.mSensorEventListener.onAccuracyChanged(t.sensor, 3);
                        }
                    }
                    ListenerDelegate.this.mSensorEventListener.onSensorChanged(t);
                    ListenerDelegate.this.returnToPool(t);
                }
            };
            this.addSensor(sensor);
        }

        protected SensorEvent createSensorEvent() {
            return new SensorEvent(3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SensorEvent getFromPool() {
            SensorEvent t = null;
            ListenerDelegate listenerDelegate = this;
            synchronized (listenerDelegate) {
                t = this.mValuesPool;
                this.mValuesPool = null;
            }
            if (t == null) {
                t = this.createSensorEvent();
            }
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void returnToPool(SensorEvent t) {
            ListenerDelegate listenerDelegate = this;
            synchronized (listenerDelegate) {
                if (this.mValuesPool == null) {
                    this.mValuesPool = t;
                }
            }
        }

        Object getListener() {
            return this.mSensorEventListener;
        }

        void addSensor(Sensor sensor) {
            this.mSensors.put(sensor.getHandle(), true);
            this.mSensorList.add(sensor);
        }

        int removeSensor(Sensor sensor) {
            this.mSensors.delete(sensor.getHandle());
            this.mSensorList.remove(sensor);
            return this.mSensors.size();
        }

        boolean hasSensor(Sensor sensor) {
            return this.mSensors.get(sensor.getHandle());
        }

        List<Sensor> getSensors() {
            return this.mSensorList;
        }

        void onSensorChangedLocked(Sensor sensor, float[] values, long[] timestamp, int accuracy) {
            SensorEvent t = this.getFromPool();
            float[] v = t.values;
            v[0] = values[0];
            v[1] = values[1];
            v[2] = values[2];
            t.timestamp = timestamp[0];
            t.accuracy = accuracy;
            t.sensor = sensor;
            Message msg = Message.obtain();
            msg.what = 0;
            msg.obj = t;
            this.mHandler.sendMessage(msg);
        }
    }

    private static class SensorThread {
        Thread mThread;
        boolean mSensorsReady;

        SensorThread() {
        }

        protected void finalize() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean startLocked() {
            block6: {
                try {
                    if (this.mThread != null) break block6;
                    this.mSensorsReady = false;
                    SensorThreadRunnable runnable = new SensorThreadRunnable();
                    Thread thread = new Thread((Runnable)runnable, SensorThread.class.getName());
                    thread.start();
                    SensorThreadRunnable sensorThreadRunnable = runnable;
                    synchronized (sensorThreadRunnable) {
                        while (!this.mSensorsReady) {
                            runnable.wait();
                        }
                    }
                    this.mThread = thread;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.mThread != null;
        }

        private class SensorThreadRunnable
        implements Runnable {
            SensorThreadRunnable() {
            }

            private boolean open() {
                sQueue = SensorManager.sensors_create_queue();
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                float[] values = new float[3];
                int[] status = new int[1];
                long[] timestamp = new long[1];
                Process.setThreadPriority(-8);
                if (!this.open()) {
                    return;
                }
                SensorThreadRunnable sensorThreadRunnable = this;
                synchronized (sensorThreadRunnable) {
                    SensorThread.this.mSensorsReady = true;
                    this.notify();
                }
                while (true) {
                    int sensor = SensorManager.sensors_data_poll(sQueue, values, status, timestamp);
                    int accuracy = status[0];
                    ArrayList<ListenerDelegate> arrayList = sListeners;
                    synchronized (arrayList) {
                        if (sensor == -1 || sListeners.isEmpty()) {
                            if (sensor == -1 && !sListeners.isEmpty()) {
                                Log.e(SensorManager.TAG, "_sensors_data_poll() failed, we bail out: sensors=" + sensor);
                            }
                            SensorManager.sensors_destroy_queue(sQueue);
                            sQueue = 0;
                            SensorThread.this.mThread = null;
                            break;
                        }
                        Sensor sensorObject = sHandleToSensor.get(sensor);
                        if (sensorObject != null) {
                            int size = sListeners.size();
                            for (int i = 0; i < size; ++i) {
                                ListenerDelegate listener = sListeners.get(i);
                                if (!listener.hasSensor(sensorObject)) continue;
                                listener.onSensorChangedLocked(sensorObject, values, timestamp, accuracy);
                            }
                        }
                    }
                }
            }
        }
    }
}

