/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ColorDrawable
extends Drawable {
    private ColorState mState;

    public ColorDrawable() {
        this(null);
    }

    public ColorDrawable(int color2) {
        this(null);
        this.mState.mBaseColor = this.mState.mUseColor = color2;
    }

    private ColorDrawable(ColorState state) {
        this.mState = new ColorState(state);
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mState.mChangingConfigurations;
    }

    public void draw(Canvas canvas) {
        canvas.drawColor(this.mState.mUseColor);
    }

    public int getAlpha() {
        return this.mState.mUseColor >>> 24;
    }

    public void setAlpha(int alpha) {
        alpha += alpha >> 7;
        int baseAlpha = this.mState.mBaseColor >>> 24;
        int useAlpha = baseAlpha * alpha >> 8;
        this.mState.mUseColor = this.mState.mBaseColor << 8 >>> 8 | useAlpha << 24;
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public int getOpacity() {
        switch (this.mState.mUseColor >>> 24) {
            case 255: {
                return -1;
            }
            case 0: {
                return -2;
            }
        }
        return -3;
    }

    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs);
        TypedArray a = r.obtainAttributes(attrs, R.styleable.ColorDrawable);
        int color2 = this.mState.mBaseColor;
        this.mState.mBaseColor = this.mState.mUseColor = (color2 = a.getColor(0, color2));
        a.recycle();
    }

    public Drawable.ConstantState getConstantState() {
        this.mState.mChangingConfigurations = super.getChangingConfigurations();
        return this.mState;
    }

    static final class ColorState
    extends Drawable.ConstantState {
        int mBaseColor;
        int mUseColor;
        int mChangingConfigurations;

        ColorState(ColorState state) {
            if (state != null) {
                this.mBaseColor = state.mBaseColor;
                this.mUseColor = state.mUseColor;
            }
        }

        public Drawable newDrawable() {
            return new ColorDrawable(this);
        }

        public Drawable newDrawable(Resources res) {
            return new ColorDrawable(this);
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }
    }
}

