/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Shader;

public class RadialGradient
extends Shader {
    public RadialGradient(float x, float y, float radius, int[] colors, float[] positions, Shader.TileMode tile) {
        if (radius <= 0.0f) {
            throw new IllegalArgumentException("radius must be > 0");
        }
        if (colors.length < 2) {
            throw new IllegalArgumentException("needs >= 2 number of colors");
        }
        if (positions != null && colors.length != positions.length) {
            throw new IllegalArgumentException("color and position arrays must be of equal length");
        }
        this.native_instance = RadialGradient.nativeCreate1(x, y, radius, colors, positions, tile.nativeInt);
    }

    public RadialGradient(float x, float y, float radius, int color0, int color1, Shader.TileMode tile) {
        if (radius <= 0.0f) {
            throw new IllegalArgumentException("radius must be > 0");
        }
        this.native_instance = RadialGradient.nativeCreate2(x, y, radius, color0, color1, tile.nativeInt);
    }

    private static native int nativeCreate1(float var0, float var1, float var2, int[] var3, float[] var4, int var5);

    private static native int nativeCreate2(float var0, float var1, float var2, int var3, int var4, int var5);
}

