/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;

public class NinePatch {
    private final Bitmap mBitmap;
    private final byte[] mChunk;
    private Paint mPaint;
    private String mSrcName;

    public NinePatch(Bitmap bitmap, byte[] chunk, String srcName) {
        this.mBitmap = bitmap;
        this.mChunk = chunk;
        this.mSrcName = srcName;
        NinePatch.validateNinePatchChunk(this.mBitmap.ni(), chunk);
    }

    public NinePatch(NinePatch patch) {
        this.mBitmap = patch.mBitmap;
        this.mChunk = patch.mChunk;
        this.mSrcName = patch.mSrcName;
        if (patch.mPaint != null) {
            this.mPaint = new Paint(patch.mPaint);
        }
        NinePatch.validateNinePatchChunk(this.mBitmap.ni(), this.mChunk);
    }

    public void setPaint(Paint p) {
        this.mPaint = p;
    }

    public void draw(Canvas canvas, RectF location) {
        NinePatch.nativeDraw(canvas.mNativeCanvas, location, this.mBitmap.ni(), this.mChunk, this.mPaint != null ? this.mPaint.mNativePaint : 0, canvas.mDensity, this.mBitmap.mDensity);
    }

    public void draw(Canvas canvas, Rect location) {
        NinePatch.nativeDraw(canvas.mNativeCanvas, location, this.mBitmap.ni(), this.mChunk, this.mPaint != null ? this.mPaint.mNativePaint : 0, canvas.mDensity, this.mBitmap.mDensity);
    }

    public void draw(Canvas canvas, Rect location, Paint paint) {
        NinePatch.nativeDraw(canvas.mNativeCanvas, location, this.mBitmap.ni(), this.mChunk, paint != null ? paint.mNativePaint : 0, canvas.mDensity, this.mBitmap.mDensity);
    }

    public int getDensity() {
        return this.mBitmap.mDensity;
    }

    public int getWidth() {
        return this.mBitmap.getWidth();
    }

    public int getHeight() {
        return this.mBitmap.getHeight();
    }

    public final boolean hasAlpha() {
        return this.mBitmap.hasAlpha();
    }

    public final Region getTransparentRegion(Rect location) {
        int r = NinePatch.nativeGetTransparentRegion(this.mBitmap.ni(), this.mChunk, location);
        return r != 0 ? new Region(r) : null;
    }

    public static native boolean isNinePatchChunk(byte[] var0);

    private static native void validateNinePatchChunk(int var0, byte[] var1);

    private static native void nativeDraw(int var0, RectF var1, int var2, byte[] var3, int var4, int var5, int var6);

    private static native void nativeDraw(int var0, Rect var1, int var2, byte[] var3, int var4, int var5, int var6);

    private static native int nativeGetTransparentRegion(int var0, byte[] var1, Rect var2);
}

