/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.os.Parcel;
import android.os.Parcelable;
import java.lang.ref.SoftReference;
import java.util.Arrays;

public class Signature
implements Parcelable {
    private final byte[] mSignature;
    private int mHashCode;
    private boolean mHaveHashCode;
    private SoftReference<String> mStringRef;
    public static final Parcelable.Creator<Signature> CREATOR = new Parcelable.Creator<Signature>(){

        @Override
        public Signature createFromParcel(Parcel source) {
            return new Signature(source);
        }

        public Signature[] newArray(int size) {
            return new Signature[size];
        }
    };

    public Signature(byte[] signature) {
        this.mSignature = (byte[])signature.clone();
    }

    public Signature(String text) {
        int N = text.length() / 2;
        byte[] sig = new byte[N];
        for (int i = 0; i < N; ++i) {
            char c = text.charAt(i * 2);
            byte b = (byte)((c >= 'a' ? c - 97 + 10 : c - 48) << 4);
            c = text.charAt(i * 2 + 1);
            sig[i] = b = (byte)(b | (byte)(c >= 'a' ? c - 97 + 10 : c - 48));
        }
        this.mSignature = sig;
    }

    public char[] toChars() {
        return this.toChars(null, null);
    }

    public char[] toChars(char[] existingArray, int[] outLen) {
        byte[] sig = this.mSignature;
        int N = sig.length;
        int N2 = N * 2;
        char[] text = existingArray == null || N2 > existingArray.length ? new char[N2] : existingArray;
        for (int j = 0; j < N; ++j) {
            byte v = sig[j];
            int d = v >> 4 & 0xF;
            text[j * 2] = (char)(d >= 10 ? 97 + d - 10 : 48 + d);
            d = v & 0xF;
            text[j * 2 + 1] = (char)(d >= 10 ? 97 + d - 10 : 48 + d);
        }
        if (outLen != null) {
            outLen[0] = N;
        }
        return text;
    }

    public String toCharsString() {
        String str;
        String string2 = str = this.mStringRef == null ? null : this.mStringRef.get();
        if (str != null) {
            return str;
        }
        str = new String(this.toChars());
        this.mStringRef = new SoftReference<String>(str);
        return str;
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[this.mSignature.length];
        System.arraycopy(this.mSignature, 0, bytes, 0, this.mSignature.length);
        return bytes;
    }

    public boolean equals(Object obj) {
        try {
            if (obj != null) {
                Signature other = (Signature)obj;
                return Arrays.equals(this.mSignature, other.mSignature);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public int hashCode() {
        if (this.mHaveHashCode) {
            return this.mHashCode;
        }
        this.mHashCode = Arrays.hashCode(this.mSignature);
        this.mHaveHashCode = true;
        return this.mHashCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int parcelableFlags) {
        dest.writeByteArray(this.mSignature);
    }

    private Signature(Parcel source) {
        this.mSignature = source.createByteArray();
    }
}

