/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentValues;
import android.content.IContentProvider;
import android.content.OperationApplicationException;
import android.content.res.AssetFileDescriptor;
import android.database.BulkCursorNative;
import android.database.BulkCursorToCursorAdaptor;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.DatabaseUtils;
import android.database.IBulkCursor;
import android.database.IContentObserver;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import java.io.FileNotFoundException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ContentProviderProxy
implements IContentProvider {
    private IBinder mRemote;

    public ContentProviderProxy(IBinder remote) {
        this.mRemote = remote;
    }

    @Override
    public IBinder asBinder() {
        return this.mRemote;
    }

    private IBulkCursor bulkQueryInternal(Uri url, String[] projection, String selection, String[] selectionArgs, String sortOrder, IContentObserver observer, CursorWindow window, BulkCursorToCursorAdaptor adaptor) throws RemoteException {
        int i;
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IContentProvider");
        url.writeToParcel(data, 0);
        int length = 0;
        if (projection != null) {
            length = projection.length;
        }
        data.writeInt(length);
        for (i = 0; i < length; ++i) {
            data.writeString(projection[i]);
        }
        data.writeString(selection);
        length = selectionArgs != null ? selectionArgs.length : 0;
        data.writeInt(length);
        for (i = 0; i < length; ++i) {
            data.writeString(selectionArgs[i]);
        }
        data.writeString(sortOrder);
        data.writeStrongBinder(observer.asBinder());
        window.writeToParcel(data, 0);
        boolean wantsCursorMetadata = adaptor != null;
        data.writeInt(wantsCursorMetadata ? 1 : 0);
        this.mRemote.transact(1, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        IBulkCursor bulkCursor = null;
        IBinder bulkCursorBinder = reply.readStrongBinder();
        if (bulkCursorBinder != null) {
            bulkCursor = BulkCursorNative.asInterface(bulkCursorBinder);
            if (wantsCursorMetadata) {
                int rowCount = reply.readInt();
                int idColumnPosition = reply.readInt();
                if (bulkCursor != null) {
                    adaptor.set(bulkCursor, rowCount, idColumnPosition);
                }
            }
        }
        data.recycle();
        reply.recycle();
        return bulkCursor;
    }

    @Override
    public IBulkCursor bulkQuery(Uri url, String[] projection, String selection, String[] selectionArgs, String sortOrder, IContentObserver observer, CursorWindow window) throws RemoteException {
        return this.bulkQueryInternal(url, projection, selection, selectionArgs, sortOrder, observer, window, null);
    }

    @Override
    public Cursor query(Uri url, String[] projection, String selection, String[] selectionArgs, String sortOrder) throws RemoteException {
        CursorWindow window = new CursorWindow(false);
        BulkCursorToCursorAdaptor adaptor = new BulkCursorToCursorAdaptor();
        IBulkCursor bulkCursor = this.bulkQueryInternal(url, projection, selection, selectionArgs, sortOrder, adaptor.getObserver(), window, adaptor);
        if (bulkCursor == null) {
            return null;
        }
        return adaptor;
    }

    @Override
    public String getType(Uri url) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IContentProvider");
        url.writeToParcel(data, 0);
        this.mRemote.transact(2, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        String out = reply.readString();
        data.recycle();
        reply.recycle();
        return out;
    }

    @Override
    public Uri insert(Uri url, ContentValues values) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IContentProvider");
        url.writeToParcel(data, 0);
        values.writeToParcel(data, 0);
        this.mRemote.transact(3, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        Uri out = Uri.CREATOR.createFromParcel(reply);
        data.recycle();
        reply.recycle();
        return out;
    }

    @Override
    public int bulkInsert(Uri url, ContentValues[] values) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IContentProvider");
        url.writeToParcel(data, 0);
        data.writeTypedArray(values, 0);
        this.mRemote.transact(13, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        int count = reply.readInt();
        data.recycle();
        reply.recycle();
        return count;
    }

    @Override
    public ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> operations) throws RemoteException, OperationApplicationException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IContentProvider");
        data.writeInt(operations.size());
        for (ContentProviderOperation operation : operations) {
            operation.writeToParcel(data, 0);
        }
        this.mRemote.transact(20, data, reply, 0);
        DatabaseUtils.readExceptionWithOperationApplicationExceptionFromParcel(reply);
        ContentProviderResult[] results = reply.createTypedArray(ContentProviderResult.CREATOR);
        data.recycle();
        reply.recycle();
        return results;
    }

    @Override
    public int delete(Uri url, String selection, String[] selectionArgs) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IContentProvider");
        url.writeToParcel(data, 0);
        data.writeString(selection);
        data.writeStringArray(selectionArgs);
        this.mRemote.transact(4, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        int count = reply.readInt();
        data.recycle();
        reply.recycle();
        return count;
    }

    @Override
    public int update(Uri url, ContentValues values, String selection, String[] selectionArgs) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IContentProvider");
        url.writeToParcel(data, 0);
        values.writeToParcel(data, 0);
        data.writeString(selection);
        data.writeStringArray(selectionArgs);
        this.mRemote.transact(10, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        int count = reply.readInt();
        data.recycle();
        reply.recycle();
        return count;
    }

    @Override
    public ParcelFileDescriptor openFile(Uri url, String mode) throws RemoteException, FileNotFoundException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IContentProvider");
        url.writeToParcel(data, 0);
        data.writeString(mode);
        this.mRemote.transact(14, data, reply, 0);
        DatabaseUtils.readExceptionWithFileNotFoundExceptionFromParcel(reply);
        int has = reply.readInt();
        ParcelFileDescriptor fd = has != 0 ? reply.readFileDescriptor() : null;
        data.recycle();
        reply.recycle();
        return fd;
    }

    @Override
    public AssetFileDescriptor openAssetFile(Uri url, String mode) throws RemoteException, FileNotFoundException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IContentProvider");
        url.writeToParcel(data, 0);
        data.writeString(mode);
        this.mRemote.transact(15, data, reply, 0);
        DatabaseUtils.readExceptionWithFileNotFoundExceptionFromParcel(reply);
        int has = reply.readInt();
        AssetFileDescriptor fd = has != 0 ? AssetFileDescriptor.CREATOR.createFromParcel(reply) : null;
        data.recycle();
        reply.recycle();
        return fd;
    }

    @Override
    public Bundle call(String method, String request, Bundle args) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IContentProvider");
        data.writeString(method);
        data.writeString(request);
        data.writeBundle(args);
        this.mRemote.transact(21, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        Bundle bundle = reply.readBundle();
        data.recycle();
        reply.recycle();
        return bundle;
    }
}

