/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManager;
import android.app.ApplicationErrorReport;
import android.app.IActivityController;
import android.app.IActivityWatcher;
import android.app.IApplicationThread;
import android.app.IInstrumentationWatcher;
import android.app.IServiceConnection;
import android.app.IThumbnailReceiver;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.ContentProviderNative;
import android.content.IContentProvider;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.ProviderInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Debug;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.StrictMode;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IActivityManager
extends IInterface {
    public static final int START_SWITCHES_CANCELED = 4;
    public static final int START_DELIVERED_TO_TOP = 3;
    public static final int START_TASK_TO_FRONT = 2;
    public static final int START_RETURN_INTENT_TO_CALLER = 1;
    public static final int START_SUCCESS = 0;
    public static final int START_INTENT_NOT_RESOLVED = -1;
    public static final int START_CLASS_NOT_FOUND = -2;
    public static final int START_FORWARD_AND_REQUEST_CONFLICT = -3;
    public static final int START_PERMISSION_DENIED = -4;
    public static final int START_NOT_ACTIVITY = -5;
    public static final int START_CANCELED = -6;
    public static final int BROADCAST_SUCCESS = 0;
    public static final int BROADCAST_STICKY_CANT_HAVE_PERMISSION = -1;
    public static final int INTENT_SENDER_BROADCAST = 1;
    public static final int INTENT_SENDER_ACTIVITY = 2;
    public static final int INTENT_SENDER_ACTIVITY_RESULT = 3;
    public static final int INTENT_SENDER_SERVICE = 4;
    public static final String descriptor = "android.app.IActivityManager";
    public static final int START_RUNNING_TRANSACTION = 1;
    public static final int HANDLE_APPLICATION_CRASH_TRANSACTION = 2;
    public static final int START_ACTIVITY_TRANSACTION = 3;
    public static final int UNHANDLED_BACK_TRANSACTION = 4;
    public static final int OPEN_CONTENT_URI_TRANSACTION = 5;
    public static final int FINISH_ACTIVITY_TRANSACTION = 11;
    public static final int REGISTER_RECEIVER_TRANSACTION = 12;
    public static final int UNREGISTER_RECEIVER_TRANSACTION = 13;
    public static final int BROADCAST_INTENT_TRANSACTION = 14;
    public static final int UNBROADCAST_INTENT_TRANSACTION = 15;
    public static final int FINISH_RECEIVER_TRANSACTION = 16;
    public static final int ATTACH_APPLICATION_TRANSACTION = 17;
    public static final int ACTIVITY_IDLE_TRANSACTION = 18;
    public static final int ACTIVITY_PAUSED_TRANSACTION = 19;
    public static final int ACTIVITY_STOPPED_TRANSACTION = 20;
    public static final int GET_CALLING_PACKAGE_TRANSACTION = 21;
    public static final int GET_CALLING_ACTIVITY_TRANSACTION = 22;
    public static final int GET_TASKS_TRANSACTION = 23;
    public static final int MOVE_TASK_TO_FRONT_TRANSACTION = 24;
    public static final int MOVE_TASK_TO_BACK_TRANSACTION = 25;
    public static final int MOVE_TASK_BACKWARDS_TRANSACTION = 26;
    public static final int GET_TASK_FOR_ACTIVITY_TRANSACTION = 27;
    public static final int REPORT_THUMBNAIL_TRANSACTION = 28;
    public static final int GET_CONTENT_PROVIDER_TRANSACTION = 29;
    public static final int PUBLISH_CONTENT_PROVIDERS_TRANSACTION = 30;
    public static final int FINISH_SUB_ACTIVITY_TRANSACTION = 32;
    public static final int GET_RUNNING_SERVICE_CONTROL_PANEL_TRANSACTION = 33;
    public static final int START_SERVICE_TRANSACTION = 34;
    public static final int STOP_SERVICE_TRANSACTION = 35;
    public static final int BIND_SERVICE_TRANSACTION = 36;
    public static final int UNBIND_SERVICE_TRANSACTION = 37;
    public static final int PUBLISH_SERVICE_TRANSACTION = 38;
    public static final int FINISH_OTHER_INSTANCES_TRANSACTION = 39;
    public static final int GOING_TO_SLEEP_TRANSACTION = 40;
    public static final int WAKING_UP_TRANSACTION = 41;
    public static final int SET_DEBUG_APP_TRANSACTION = 42;
    public static final int SET_ALWAYS_FINISH_TRANSACTION = 43;
    public static final int START_INSTRUMENTATION_TRANSACTION = 44;
    public static final int FINISH_INSTRUMENTATION_TRANSACTION = 45;
    public static final int GET_CONFIGURATION_TRANSACTION = 46;
    public static final int UPDATE_CONFIGURATION_TRANSACTION = 47;
    public static final int STOP_SERVICE_TOKEN_TRANSACTION = 48;
    public static final int GET_ACTIVITY_CLASS_FOR_TOKEN_TRANSACTION = 49;
    public static final int GET_PACKAGE_FOR_TOKEN_TRANSACTION = 50;
    public static final int SET_PROCESS_LIMIT_TRANSACTION = 51;
    public static final int GET_PROCESS_LIMIT_TRANSACTION = 52;
    public static final int CHECK_PERMISSION_TRANSACTION = 53;
    public static final int CHECK_URI_PERMISSION_TRANSACTION = 54;
    public static final int GRANT_URI_PERMISSION_TRANSACTION = 55;
    public static final int REVOKE_URI_PERMISSION_TRANSACTION = 56;
    public static final int SET_ACTIVITY_CONTROLLER_TRANSACTION = 57;
    public static final int SHOW_WAITING_FOR_DEBUGGER_TRANSACTION = 58;
    public static final int SIGNAL_PERSISTENT_PROCESSES_TRANSACTION = 59;
    public static final int GET_RECENT_TASKS_TRANSACTION = 60;
    public static final int SERVICE_DONE_EXECUTING_TRANSACTION = 61;
    public static final int ACTIVITY_DESTROYED_TRANSACTION = 62;
    public static final int GET_INTENT_SENDER_TRANSACTION = 63;
    public static final int CANCEL_INTENT_SENDER_TRANSACTION = 64;
    public static final int GET_PACKAGE_FOR_INTENT_SENDER_TRANSACTION = 65;
    public static final int ENTER_SAFE_MODE_TRANSACTION = 66;
    public static final int START_NEXT_MATCHING_ACTIVITY_TRANSACTION = 67;
    public static final int NOTE_WAKEUP_ALARM_TRANSACTION = 68;
    public static final int REMOVE_CONTENT_PROVIDER_TRANSACTION = 69;
    public static final int SET_REQUESTED_ORIENTATION_TRANSACTION = 70;
    public static final int GET_REQUESTED_ORIENTATION_TRANSACTION = 71;
    public static final int UNBIND_FINISHED_TRANSACTION = 72;
    public static final int SET_PROCESS_FOREGROUND_TRANSACTION = 73;
    public static final int SET_SERVICE_FOREGROUND_TRANSACTION = 74;
    public static final int MOVE_ACTIVITY_TASK_TO_BACK_TRANSACTION = 75;
    public static final int GET_MEMORY_INFO_TRANSACTION = 76;
    public static final int GET_PROCESSES_IN_ERROR_STATE_TRANSACTION = 77;
    public static final int CLEAR_APP_DATA_TRANSACTION = 78;
    public static final int FORCE_STOP_PACKAGE_TRANSACTION = 79;
    public static final int KILL_PIDS_TRANSACTION = 80;
    public static final int GET_SERVICES_TRANSACTION = 81;
    public static final int GET_RUNNING_APP_PROCESSES_TRANSACTION = 83;
    public static final int GET_DEVICE_CONFIGURATION_TRANSACTION = 84;
    public static final int PEEK_SERVICE_TRANSACTION = 85;
    public static final int PROFILE_CONTROL_TRANSACTION = 86;
    public static final int SHUTDOWN_TRANSACTION = 87;
    public static final int STOP_APP_SWITCHES_TRANSACTION = 88;
    public static final int RESUME_APP_SWITCHES_TRANSACTION = 89;
    public static final int START_BACKUP_AGENT_TRANSACTION = 90;
    public static final int BACKUP_AGENT_CREATED_TRANSACTION = 91;
    public static final int UNBIND_BACKUP_AGENT_TRANSACTION = 92;
    public static final int REGISTER_ACTIVITY_WATCHER_TRANSACTION = 93;
    public static final int UNREGISTER_ACTIVITY_WATCHER_TRANSACTION = 94;
    public static final int START_ACTIVITY_IN_PACKAGE_TRANSACTION = 95;
    public static final int KILL_APPLICATION_WITH_UID_TRANSACTION = 96;
    public static final int CLOSE_SYSTEM_DIALOGS_TRANSACTION = 97;
    public static final int GET_PROCESS_MEMORY_INFO_TRANSACTION = 98;
    public static final int KILL_APPLICATION_PROCESS_TRANSACTION = 99;
    public static final int START_ACTIVITY_INTENT_SENDER_TRANSACTION = 100;
    public static final int OVERRIDE_PENDING_TRANSITION_TRANSACTION = 101;
    public static final int HANDLE_APPLICATION_WTF_TRANSACTION = 102;
    public static final int KILL_BACKGROUND_PROCESSES_TRANSACTION = 103;
    public static final int IS_USER_A_MONKEY_TRANSACTION = 104;
    public static final int START_ACTIVITY_AND_WAIT_TRANSACTION = 105;
    public static final int WILL_ACTIVITY_BE_VISIBLE_TRANSACTION = 106;
    public static final int START_ACTIVITY_WITH_CONFIG_TRANSACTION = 107;
    public static final int GET_RUNNING_EXTERNAL_APPLICATIONS_TRANSACTION = 108;
    public static final int FINISH_HEAVY_WEIGHT_APP_TRANSACTION = 109;
    public static final int HANDLE_APPLICATION_STRICT_MODE_VIOLATION_TRANSACTION = 110;
    public static final int IS_IMMERSIVE_TRANSACTION = 111;
    public static final int SET_IMMERSIVE_TRANSACTION = 112;
    public static final int IS_TOP_ACTIVITY_IMMERSIVE_TRANSACTION = 113;
    public static final int CRASH_APPLICATION_TRANSACTION = 114;
    public static final int GET_PROVIDER_MIME_TYPE_TRANSACTION = 115;
    public static final int NEW_URI_PERMISSION_OWNER_TRANSACTION = 116;
    public static final int GRANT_URI_PERMISSION_FROM_OWNER_TRANSACTION = 117;
    public static final int REVOKE_URI_PERMISSION_FROM_OWNER_TRANSACTION = 118;

    public int startActivity(IApplicationThread var1, Intent var2, String var3, Uri[] var4, int var5, IBinder var6, String var7, int var8, boolean var9, boolean var10) throws RemoteException;

    public WaitResult startActivityAndWait(IApplicationThread var1, Intent var2, String var3, Uri[] var4, int var5, IBinder var6, String var7, int var8, boolean var9, boolean var10) throws RemoteException;

    public int startActivityWithConfig(IApplicationThread var1, Intent var2, String var3, Uri[] var4, int var5, IBinder var6, String var7, int var8, boolean var9, boolean var10, Configuration var11) throws RemoteException;

    public int startActivityIntentSender(IApplicationThread var1, IntentSender var2, Intent var3, String var4, IBinder var5, String var6, int var7, int var8, int var9) throws RemoteException;

    public boolean startNextMatchingActivity(IBinder var1, Intent var2) throws RemoteException;

    public boolean finishActivity(IBinder var1, int var2, Intent var3) throws RemoteException;

    public void finishSubActivity(IBinder var1, String var2, int var3) throws RemoteException;

    public boolean willActivityBeVisible(IBinder var1) throws RemoteException;

    public Intent registerReceiver(IApplicationThread var1, IIntentReceiver var2, IntentFilter var3, String var4) throws RemoteException;

    public void unregisterReceiver(IIntentReceiver var1) throws RemoteException;

    public int broadcastIntent(IApplicationThread var1, Intent var2, String var3, IIntentReceiver var4, int var5, String var6, Bundle var7, String var8, boolean var9, boolean var10) throws RemoteException;

    public void unbroadcastIntent(IApplicationThread var1, Intent var2) throws RemoteException;

    public void finishReceiver(IBinder var1, int var2, String var3, Bundle var4, boolean var5) throws RemoteException;

    public void attachApplication(IApplicationThread var1) throws RemoteException;

    public void activityIdle(IBinder var1, Configuration var2) throws RemoteException;

    public void activityPaused(IBinder var1, Bundle var2) throws RemoteException;

    public void activityStopped(IBinder var1, Bitmap var2, CharSequence var3) throws RemoteException;

    public void activityDestroyed(IBinder var1) throws RemoteException;

    public String getCallingPackage(IBinder var1) throws RemoteException;

    public ComponentName getCallingActivity(IBinder var1) throws RemoteException;

    public List getTasks(int var1, int var2, IThumbnailReceiver var3) throws RemoteException;

    public List<ActivityManager.RecentTaskInfo> getRecentTasks(int var1, int var2) throws RemoteException;

    public List getServices(int var1, int var2) throws RemoteException;

    public List<ActivityManager.ProcessErrorStateInfo> getProcessesInErrorState() throws RemoteException;

    public void moveTaskToFront(int var1) throws RemoteException;

    public void moveTaskToBack(int var1) throws RemoteException;

    public boolean moveActivityTaskToBack(IBinder var1, boolean var2) throws RemoteException;

    public void moveTaskBackwards(int var1) throws RemoteException;

    public int getTaskForActivity(IBinder var1, boolean var2) throws RemoteException;

    public void finishOtherInstances(IBinder var1, ComponentName var2) throws RemoteException;

    public void reportThumbnail(IBinder var1, Bitmap var2, CharSequence var3) throws RemoteException;

    public ContentProviderHolder getContentProvider(IApplicationThread var1, String var2) throws RemoteException;

    public void removeContentProvider(IApplicationThread var1, String var2) throws RemoteException;

    public void publishContentProviders(IApplicationThread var1, List<ContentProviderHolder> var2) throws RemoteException;

    public PendingIntent getRunningServiceControlPanel(ComponentName var1) throws RemoteException;

    public ComponentName startService(IApplicationThread var1, Intent var2, String var3) throws RemoteException;

    public int stopService(IApplicationThread var1, Intent var2, String var3) throws RemoteException;

    public boolean stopServiceToken(ComponentName var1, IBinder var2, int var3) throws RemoteException;

    public void setServiceForeground(ComponentName var1, IBinder var2, int var3, Notification var4, boolean var5) throws RemoteException;

    public int bindService(IApplicationThread var1, IBinder var2, Intent var3, String var4, IServiceConnection var5, int var6) throws RemoteException;

    public boolean unbindService(IServiceConnection var1) throws RemoteException;

    public void publishService(IBinder var1, Intent var2, IBinder var3) throws RemoteException;

    public void unbindFinished(IBinder var1, Intent var2, boolean var3) throws RemoteException;

    public void serviceDoneExecuting(IBinder var1, int var2, int var3, int var4) throws RemoteException;

    public IBinder peekService(Intent var1, String var2) throws RemoteException;

    public boolean bindBackupAgent(ApplicationInfo var1, int var2) throws RemoteException;

    public void backupAgentCreated(String var1, IBinder var2) throws RemoteException;

    public void unbindBackupAgent(ApplicationInfo var1) throws RemoteException;

    public void killApplicationProcess(String var1, int var2) throws RemoteException;

    public boolean startInstrumentation(ComponentName var1, String var2, int var3, Bundle var4, IInstrumentationWatcher var5) throws RemoteException;

    public void finishInstrumentation(IApplicationThread var1, int var2, Bundle var3) throws RemoteException;

    public Configuration getConfiguration() throws RemoteException;

    public void updateConfiguration(Configuration var1) throws RemoteException;

    public void setRequestedOrientation(IBinder var1, int var2) throws RemoteException;

    public int getRequestedOrientation(IBinder var1) throws RemoteException;

    public ComponentName getActivityClassForToken(IBinder var1) throws RemoteException;

    public String getPackageForToken(IBinder var1) throws RemoteException;

    public IIntentSender getIntentSender(int var1, String var2, IBinder var3, String var4, int var5, Intent var6, String var7, int var8) throws RemoteException;

    public void cancelIntentSender(IIntentSender var1) throws RemoteException;

    public boolean clearApplicationUserData(String var1, IPackageDataObserver var2) throws RemoteException;

    public String getPackageForIntentSender(IIntentSender var1) throws RemoteException;

    public void setProcessLimit(int var1) throws RemoteException;

    public int getProcessLimit() throws RemoteException;

    public void setProcessForeground(IBinder var1, int var2, boolean var3) throws RemoteException;

    public int checkPermission(String var1, int var2, int var3) throws RemoteException;

    public int checkUriPermission(Uri var1, int var2, int var3, int var4) throws RemoteException;

    public void grantUriPermission(IApplicationThread var1, String var2, Uri var3, int var4) throws RemoteException;

    public void revokeUriPermission(IApplicationThread var1, Uri var2, int var3) throws RemoteException;

    public void showWaitingForDebugger(IApplicationThread var1, boolean var2) throws RemoteException;

    public void getMemoryInfo(ActivityManager.MemoryInfo var1) throws RemoteException;

    public void killBackgroundProcesses(String var1) throws RemoteException;

    public void forceStopPackage(String var1) throws RemoteException;

    public void goingToSleep() throws RemoteException;

    public void wakingUp() throws RemoteException;

    public void unhandledBack() throws RemoteException;

    public ParcelFileDescriptor openContentUri(Uri var1) throws RemoteException;

    public void setDebugApp(String var1, boolean var2, boolean var3) throws RemoteException;

    public void setAlwaysFinish(boolean var1) throws RemoteException;

    public void setActivityController(IActivityController var1) throws RemoteException;

    public void enterSafeMode() throws RemoteException;

    public void noteWakeupAlarm(IIntentSender var1) throws RemoteException;

    public boolean killPids(int[] var1, String var2) throws RemoteException;

    public void startRunning(String var1, String var2, String var3, String var4) throws RemoteException;

    public void handleApplicationCrash(IBinder var1, ApplicationErrorReport.CrashInfo var2) throws RemoteException;

    public boolean handleApplicationWtf(IBinder var1, String var2, ApplicationErrorReport.CrashInfo var3) throws RemoteException;

    public void handleApplicationStrictModeViolation(IBinder var1, int var2, StrictMode.ViolationInfo var3) throws RemoteException;

    public void signalPersistentProcesses(int var1) throws RemoteException;

    public List<ActivityManager.RunningAppProcessInfo> getRunningAppProcesses() throws RemoteException;

    public List<ApplicationInfo> getRunningExternalApplications() throws RemoteException;

    public ConfigurationInfo getDeviceConfigurationInfo() throws RemoteException;

    public boolean profileControl(String var1, boolean var2, String var3, ParcelFileDescriptor var4) throws RemoteException;

    public boolean shutdown(int var1) throws RemoteException;

    public void stopAppSwitches() throws RemoteException;

    public void resumeAppSwitches() throws RemoteException;

    public void registerActivityWatcher(IActivityWatcher var1) throws RemoteException;

    public void unregisterActivityWatcher(IActivityWatcher var1) throws RemoteException;

    public int startActivityInPackage(int var1, Intent var2, String var3, IBinder var4, String var5, int var6, boolean var7) throws RemoteException;

    public void killApplicationWithUid(String var1, int var2) throws RemoteException;

    public void closeSystemDialogs(String var1) throws RemoteException;

    public Debug.MemoryInfo[] getProcessMemoryInfo(int[] var1) throws RemoteException;

    public void overridePendingTransition(IBinder var1, String var2, int var3, int var4) throws RemoteException;

    public boolean isUserAMonkey() throws RemoteException;

    public void finishHeavyWeightApp() throws RemoteException;

    public void crashApplication(int var1, int var2, String var3, String var4) throws RemoteException;

    public String getProviderMimeType(Uri var1) throws RemoteException;

    public IBinder newUriPermissionOwner(String var1) throws RemoteException;

    public void grantUriPermissionFromOwner(IBinder var1, int var2, String var3, Uri var4, int var5) throws RemoteException;

    public void revokeUriPermissionFromOwner(IBinder var1, Uri var2, int var3) throws RemoteException;

    public boolean testIsSystemReady();

    public static class WaitResult
    implements Parcelable {
        public int result;
        public boolean timeout;
        public ComponentName who;
        public long thisTime;
        public long totalTime;
        public static final Parcelable.Creator<WaitResult> CREATOR = new Parcelable.Creator<WaitResult>(){

            @Override
            public WaitResult createFromParcel(Parcel source) {
                return new WaitResult(source);
            }

            public WaitResult[] newArray(int size) {
                return new WaitResult[size];
            }
        };

        public WaitResult() {
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.result);
            dest.writeInt(this.timeout ? 1 : 0);
            ComponentName.writeToParcel(this.who, dest);
            dest.writeLong(this.thisTime);
            dest.writeLong(this.totalTime);
        }

        private WaitResult(Parcel source) {
            this.result = source.readInt();
            this.timeout = source.readInt() != 0;
            this.who = ComponentName.readFromParcel(source);
            this.thisTime = source.readLong();
            this.totalTime = source.readLong();
        }
    }

    public static class ContentProviderHolder
    implements Parcelable {
        public final ProviderInfo info;
        public IContentProvider provider;
        public boolean noReleaseNeeded;
        public static final Parcelable.Creator<ContentProviderHolder> CREATOR = new Parcelable.Creator<ContentProviderHolder>(){

            @Override
            public ContentProviderHolder createFromParcel(Parcel source) {
                return new ContentProviderHolder(source);
            }

            public ContentProviderHolder[] newArray(int size) {
                return new ContentProviderHolder[size];
            }
        };

        public ContentProviderHolder(ProviderInfo _info) {
            this.info = _info;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            this.info.writeToParcel(dest, 0);
            if (this.provider != null) {
                dest.writeStrongBinder(this.provider.asBinder());
            } else {
                dest.writeStrongBinder(null);
            }
            dest.writeInt(this.noReleaseNeeded ? 1 : 0);
        }

        private ContentProviderHolder(Parcel source) {
            this.info = ProviderInfo.CREATOR.createFromParcel(source);
            this.provider = ContentProviderNative.asInterface(source.readStrongBinder());
            this.noReleaseNeeded = source.readInt() != 0;
        }
    }
}

