/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.backup.BackupAgent;
import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataOutput;
import android.app.backup.FileBackupHelper;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;

public class FullBackupAgent
extends BackupAgent {
    private static final String TAG = "FullBackupAgent";
    private static final boolean DEBUG = true;

    public void onBackup(ParcelFileDescriptor oldState, BackupDataOutput data, ParcelFileDescriptor newState) {
        LinkedList<File> dirsToScan = new LinkedList<File>();
        ArrayList<String> allFiles = new ArrayList<String>();
        dirsToScan.add(this.getFilesDir());
        Log.v(TAG, "Backing up dir tree @ " + this.getFilesDir().getAbsolutePath() + " :");
        while (dirsToScan.size() > 0) {
            File dir = (File)dirsToScan.removeFirst();
            File[] contents = dir.listFiles();
            if (contents == null) continue;
            for (File f : contents) {
                if (f.isDirectory()) {
                    dirsToScan.add(f);
                    continue;
                }
                if (!f.isFile()) continue;
                Log.v(TAG, "    " + f.getAbsolutePath());
                allFiles.add(f.getAbsolutePath());
            }
        }
        FileBackupHelper helper = new FileBackupHelper(this, allFiles.toArray(new String[allFiles.size()]));
        helper.performBackup(oldState, data, newState);
    }

    public void onRestore(BackupDataInput data, int appVersionCode, ParcelFileDescriptor newState) {
    }
}

