/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWrapper;
import android.net.Uri;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.Downloads;
import android.util.Pair;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DownloadManager {
    private static final String TAG = "DownloadManager";
    public static final String COLUMN_ID = "_id";
    public static final String COLUMN_TITLE = "title";
    public static final String COLUMN_DESCRIPTION = "description";
    public static final String COLUMN_URI = "uri";
    public static final String COLUMN_MEDIA_TYPE = "media_type";
    public static final String COLUMN_TOTAL_SIZE_BYTES = "total_size";
    public static final String COLUMN_LOCAL_URI = "local_uri";
    public static final String COLUMN_STATUS = "status";
    public static final String COLUMN_REASON = "reason";
    public static final String COLUMN_BYTES_DOWNLOADED_SO_FAR = "bytes_so_far";
    public static final String COLUMN_LAST_MODIFIED_TIMESTAMP = "last_modified_timestamp";
    public static final String COLUMN_MEDIAPROVIDER_URI = "mediaprovider_uri";
    public static final int STATUS_PENDING = 1;
    public static final int STATUS_RUNNING = 2;
    public static final int STATUS_PAUSED = 4;
    public static final int STATUS_SUCCESSFUL = 8;
    public static final int STATUS_FAILED = 16;
    public static final int ERROR_UNKNOWN = 1000;
    public static final int ERROR_FILE_ERROR = 1001;
    public static final int ERROR_UNHANDLED_HTTP_CODE = 1002;
    public static final int ERROR_HTTP_DATA_ERROR = 1004;
    public static final int ERROR_TOO_MANY_REDIRECTS = 1005;
    public static final int ERROR_INSUFFICIENT_SPACE = 1006;
    public static final int ERROR_DEVICE_NOT_FOUND = 1007;
    public static final int ERROR_CANNOT_RESUME = 1008;
    public static final int ERROR_FILE_ALREADY_EXISTS = 1009;
    public static final int PAUSED_WAITING_TO_RETRY = 1;
    public static final int PAUSED_WAITING_FOR_NETWORK = 2;
    public static final int PAUSED_QUEUED_FOR_WIFI = 3;
    public static final int PAUSED_UNKNOWN = 4;
    public static final String ACTION_DOWNLOAD_COMPLETE = "android.intent.action.DOWNLOAD_COMPLETE";
    public static final String ACTION_NOTIFICATION_CLICKED = "android.intent.action.DOWNLOAD_NOTIFICATION_CLICKED";
    public static final String ACTION_VIEW_DOWNLOADS = "android.intent.action.VIEW_DOWNLOADS";
    public static final String EXTRA_DOWNLOAD_ID = "extra_download_id";
    private static final String[] COLUMNS = new String[]{"_id", "mediaprovider_uri", "title", "description", "uri", "media_type", "total_size", "local_uri", "status", "reason", "bytes_so_far", "last_modified_timestamp"};
    private static final String[] UNDERLYING_COLUMNS = new String[]{"_id", "mediaprovider_uri", "title", "description", "uri", "mimetype", "total_bytes", "status", "current_bytes", "lastmod", "destination", "hint", "_data"};
    private static final Set<String> LONG_COLUMNS = new HashSet<String>(Arrays.asList("_id", "total_size", "status", "reason", "bytes_so_far", "last_modified_timestamp"));
    private ContentResolver mResolver;
    private String mPackageName;
    private Uri mBaseUri = Downloads.Impl.CONTENT_URI;

    public DownloadManager(ContentResolver resolver, String packageName) {
        this.mResolver = resolver;
        this.mPackageName = packageName;
    }

    public void setAccessAllDownloads(boolean accessAllDownloads) {
        this.mBaseUri = accessAllDownloads ? Downloads.Impl.ALL_DOWNLOADS_CONTENT_URI : Downloads.Impl.CONTENT_URI;
    }

    public long enqueue(Request request) {
        ContentValues values = request.toContentValues(this.mPackageName);
        Uri downloadUri = this.mResolver.insert(Downloads.CONTENT_URI, values);
        long id2 = Long.parseLong(downloadUri.getLastPathSegment());
        return id2;
    }

    public int markRowDeleted(long ... ids) {
        if (ids == null || ids.length == 0) {
            throw new IllegalArgumentException("input param 'ids' can't be null");
        }
        ContentValues values = new ContentValues();
        values.put("deleted", 1);
        return this.mResolver.update(this.mBaseUri, values, DownloadManager.getWhereClauseForIds(ids), DownloadManager.getWhereArgsForIds(ids));
    }

    public int remove(long ... ids) {
        if (ids == null || ids.length == 0) {
            throw new IllegalArgumentException("input param 'ids' can't be null");
        }
        return this.mResolver.delete(this.mBaseUri, DownloadManager.getWhereClauseForIds(ids), DownloadManager.getWhereArgsForIds(ids));
    }

    public Cursor query(Query query) {
        Cursor underlyingCursor = query.runQuery(this.mResolver, UNDERLYING_COLUMNS, this.mBaseUri);
        if (underlyingCursor == null) {
            return null;
        }
        return new CursorTranslator(underlyingCursor, this.mBaseUri);
    }

    public ParcelFileDescriptor openDownloadedFile(long id2) throws FileNotFoundException {
        return this.mResolver.openFileDescriptor(this.getDownloadUri(id2), "r");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartDownload(long ... ids) {
        Cursor cursor = this.query(new Query().setFilterById(ids));
        try {
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                int status = cursor.getInt(cursor.getColumnIndex(COLUMN_STATUS));
                if (status != 8 && status != 16) {
                    throw new IllegalArgumentException("Cannot restart incomplete download: " + cursor.getLong(cursor.getColumnIndex(COLUMN_ID)));
                }
                cursor.moveToNext();
            }
            Object var5_5 = null;
            cursor.close();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            cursor.close();
            throw throwable;
        }
        ContentValues values = new ContentValues();
        values.put("current_bytes", 0);
        values.put("total_bytes", -1);
        values.putNull("_data");
        values.put(COLUMN_STATUS, 190);
        this.mResolver.update(this.mBaseUri, values, DownloadManager.getWhereClauseForIds(ids), DownloadManager.getWhereArgsForIds(ids));
    }

    Uri getDownloadUri(long id2) {
        return ContentUris.withAppendedId(this.mBaseUri, id2);
    }

    static String getWhereClauseForIds(long[] ids) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("(");
        for (int i = 0; i < ids.length; ++i) {
            if (i > 0) {
                whereClause.append("OR ");
            }
            whereClause.append(COLUMN_ID);
            whereClause.append(" = ? ");
        }
        whereClause.append(")");
        return whereClause.toString();
    }

    static String[] getWhereArgsForIds(long[] ids) {
        String[] whereArgs = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            whereArgs[i] = Long.toString(ids[i]);
        }
        return whereArgs;
    }

    private static class CursorTranslator
    extends CursorWrapper {
        private Uri mBaseUri;

        public CursorTranslator(Cursor cursor, Uri baseUri) {
            super(cursor);
            this.mBaseUri = baseUri;
        }

        public int getColumnIndex(String columnName) {
            return Arrays.asList(COLUMNS).indexOf(columnName);
        }

        public int getColumnIndexOrThrow(String columnName) throws IllegalArgumentException {
            int index = this.getColumnIndex(columnName);
            if (index == -1) {
                throw new IllegalArgumentException("No such column: " + columnName);
            }
            return index;
        }

        public String getColumnName(int columnIndex) {
            int numColumns = COLUMNS.length;
            if (columnIndex < 0 || columnIndex >= numColumns) {
                throw new IllegalArgumentException("Invalid column index " + columnIndex + ", " + numColumns + " columns exist");
            }
            return COLUMNS[columnIndex];
        }

        public String[] getColumnNames() {
            String[] returnColumns = new String[COLUMNS.length];
            System.arraycopy(COLUMNS, 0, returnColumns, 0, COLUMNS.length);
            return returnColumns;
        }

        public int getColumnCount() {
            return COLUMNS.length;
        }

        public byte[] getBlob(int columnIndex) {
            throw new UnsupportedOperationException();
        }

        public double getDouble(int columnIndex) {
            return this.getLong(columnIndex);
        }

        private boolean isLongColumn(String column) {
            return LONG_COLUMNS.contains(column);
        }

        public float getFloat(int columnIndex) {
            return (float)this.getDouble(columnIndex);
        }

        public int getInt(int columnIndex) {
            return (int)this.getLong(columnIndex);
        }

        public long getLong(int columnIndex) {
            return this.translateLong(this.getColumnName(columnIndex));
        }

        public short getShort(int columnIndex) {
            return (short)this.getLong(columnIndex);
        }

        public String getString(int columnIndex) {
            return this.translateString(this.getColumnName(columnIndex));
        }

        private String translateString(String column) {
            if (this.isLongColumn(column)) {
                return Long.toString(this.translateLong(column));
            }
            if (column.equals(DownloadManager.COLUMN_TITLE)) {
                return this.getUnderlyingString(DownloadManager.COLUMN_TITLE);
            }
            if (column.equals(DownloadManager.COLUMN_DESCRIPTION)) {
                return this.getUnderlyingString(DownloadManager.COLUMN_DESCRIPTION);
            }
            if (column.equals(DownloadManager.COLUMN_URI)) {
                return this.getUnderlyingString(DownloadManager.COLUMN_URI);
            }
            if (column.equals(DownloadManager.COLUMN_MEDIA_TYPE)) {
                return this.getUnderlyingString("mimetype");
            }
            if (column.equals(DownloadManager.COLUMN_MEDIAPROVIDER_URI)) {
                return this.getUnderlyingString(DownloadManager.COLUMN_MEDIAPROVIDER_URI);
            }
            assert (column.equals(DownloadManager.COLUMN_LOCAL_URI));
            return this.getLocalUri();
        }

        private String getLocalUri() {
            long destinationType = this.getUnderlyingLong("destination");
            if (destinationType == 4L) {
                return this.getUnderlyingString("hint");
            }
            if (destinationType == 0L) {
                String localPath = this.getUnderlyingString("_data");
                if (localPath == null) {
                    return null;
                }
                return Uri.fromFile(new File(localPath)).toString();
            }
            long downloadId = this.getUnderlyingLong(DownloadManager.COLUMN_ID);
            return ContentUris.withAppendedId(this.mBaseUri, downloadId).toString();
        }

        private long translateLong(String column) {
            if (!this.isLongColumn(column)) {
                return Long.valueOf(this.translateString(column));
            }
            if (column.equals(DownloadManager.COLUMN_ID)) {
                return this.getUnderlyingLong(DownloadManager.COLUMN_ID);
            }
            if (column.equals(DownloadManager.COLUMN_TOTAL_SIZE_BYTES)) {
                return this.getUnderlyingLong("total_bytes");
            }
            if (column.equals(DownloadManager.COLUMN_STATUS)) {
                return this.translateStatus((int)this.getUnderlyingLong(DownloadManager.COLUMN_STATUS));
            }
            if (column.equals(DownloadManager.COLUMN_REASON)) {
                return this.getReason((int)this.getUnderlyingLong(DownloadManager.COLUMN_STATUS));
            }
            if (column.equals(DownloadManager.COLUMN_BYTES_DOWNLOADED_SO_FAR)) {
                return this.getUnderlyingLong("current_bytes");
            }
            assert (column.equals(DownloadManager.COLUMN_LAST_MODIFIED_TIMESTAMP));
            return this.getUnderlyingLong("lastmod");
        }

        private long getReason(int status) {
            switch (this.translateStatus(status)) {
                case 16: {
                    return this.getErrorCode(status);
                }
                case 4: {
                    return this.getPausedReason(status);
                }
            }
            return 0L;
        }

        private long getPausedReason(int status) {
            switch (status) {
                case 194: {
                    return 1L;
                }
                case 195: {
                    return 2L;
                }
                case 196: {
                    return 3L;
                }
            }
            return 4L;
        }

        private long getErrorCode(int status) {
            if (400 <= status && status < 488 || 500 <= status && status < 600) {
                return status;
            }
            switch (status) {
                case 492: {
                    return 1001L;
                }
                case 493: 
                case 494: {
                    return 1002L;
                }
                case 495: {
                    return 1004L;
                }
                case 497: {
                    return 1005L;
                }
                case 498: {
                    return 1006L;
                }
                case 499: {
                    return 1007L;
                }
                case 489: {
                    return 1008L;
                }
                case 488: {
                    return 1009L;
                }
            }
            return 1000L;
        }

        private long getUnderlyingLong(String column) {
            return super.getLong(super.getColumnIndex(column));
        }

        private String getUnderlyingString(String column) {
            return super.getString(super.getColumnIndex(column));
        }

        private int translateStatus(int status) {
            switch (status) {
                case 190: {
                    return 1;
                }
                case 192: {
                    return 2;
                }
                case 193: 
                case 194: 
                case 195: 
                case 196: {
                    return 4;
                }
                case 200: {
                    return 8;
                }
            }
            assert (Downloads.isStatusError(status));
            return 16;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Query {
        public static final int ORDER_ASCENDING = 1;
        public static final int ORDER_DESCENDING = 2;
        private long[] mIds = null;
        private Integer mStatusFlags = null;
        private String mOrderByColumn = "lastmod";
        private int mOrderDirection = 2;
        private boolean mOnlyIncludeVisibleInDownloadsUi = false;

        public Query setFilterById(long ... ids) {
            this.mIds = ids;
            return this;
        }

        public Query setFilterByStatus(int flags) {
            this.mStatusFlags = flags;
            return this;
        }

        public Query setOnlyIncludeVisibleInDownloadsUi(boolean value) {
            this.mOnlyIncludeVisibleInDownloadsUi = value;
            return this;
        }

        public Query orderBy(String column, int direction) {
            if (direction != 1 && direction != 2) {
                throw new IllegalArgumentException("Invalid direction: " + direction);
            }
            if (column.equals(DownloadManager.COLUMN_LAST_MODIFIED_TIMESTAMP)) {
                this.mOrderByColumn = "lastmod";
            } else if (column.equals(DownloadManager.COLUMN_TOTAL_SIZE_BYTES)) {
                this.mOrderByColumn = "total_bytes";
            } else {
                throw new IllegalArgumentException("Cannot order by " + column);
            }
            this.mOrderDirection = direction;
            return this;
        }

        Cursor runQuery(ContentResolver resolver, String[] projection, Uri baseUri) {
            Uri uri = baseUri;
            ArrayList<String> selectionParts = new ArrayList<String>();
            String[] selectionArgs = null;
            if (this.mIds != null) {
                selectionParts.add(DownloadManager.getWhereClauseForIds(this.mIds));
                selectionArgs = DownloadManager.getWhereArgsForIds(this.mIds);
            }
            if (this.mStatusFlags != null) {
                ArrayList<String> parts = new ArrayList<String>();
                if ((this.mStatusFlags & 1) != 0) {
                    parts.add(this.statusClause("=", 190));
                }
                if ((this.mStatusFlags & 2) != 0) {
                    parts.add(this.statusClause("=", 192));
                }
                if ((this.mStatusFlags & 4) != 0) {
                    parts.add(this.statusClause("=", 193));
                    parts.add(this.statusClause("=", 194));
                    parts.add(this.statusClause("=", 195));
                    parts.add(this.statusClause("=", 196));
                }
                if ((this.mStatusFlags & 8) != 0) {
                    parts.add(this.statusClause("=", 200));
                }
                if ((this.mStatusFlags & 0x10) != 0) {
                    parts.add("(" + this.statusClause(">=", 400) + " AND " + this.statusClause("<", 600) + ")");
                }
                selectionParts.add(this.joinStrings(" OR ", parts));
            }
            if (this.mOnlyIncludeVisibleInDownloadsUi) {
                selectionParts.add("is_visible_in_downloads_ui != '0'");
            }
            selectionParts.add("deleted != '1'");
            String selection = this.joinStrings(" AND ", selectionParts);
            String orderDirection = this.mOrderDirection == 1 ? "ASC" : "DESC";
            String orderBy = this.mOrderByColumn + " " + orderDirection;
            return resolver.query(uri, projection, selection, selectionArgs, orderBy);
        }

        private String joinStrings(String joiner, Iterable<String> parts) {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String part : parts) {
                if (!first) {
                    builder.append(joiner);
                }
                builder.append(part);
                first = false;
            }
            return builder.toString();
        }

        private String statusClause(String operator, int value) {
            return DownloadManager.COLUMN_STATUS + operator + "'" + value + "'";
        }
    }

    public static class Request {
        public static final int NETWORK_MOBILE = 1;
        public static final int NETWORK_WIFI = 2;
        private Uri mUri;
        private Uri mDestinationUri;
        private List<Pair<String, String>> mRequestHeaders = new ArrayList<Pair<String, String>>();
        private CharSequence mTitle;
        private CharSequence mDescription;
        private boolean mShowNotification = true;
        private String mMimeType;
        private boolean mRoamingAllowed = true;
        private int mAllowedNetworkTypes = -1;
        private boolean mIsVisibleInDownloadsUi = true;

        public Request(Uri uri) {
            if (uri == null) {
                throw new NullPointerException();
            }
            String scheme = uri.getScheme();
            if (scheme == null || !scheme.equals("http")) {
                throw new IllegalArgumentException("Can only download HTTP URIs: " + uri);
            }
            this.mUri = uri;
        }

        public Request setDestinationUri(Uri uri) {
            this.mDestinationUri = uri;
            return this;
        }

        public Request setDestinationInExternalFilesDir(Context context, String dirType, String subPath) {
            this.setDestinationFromBase(context.getExternalFilesDir(dirType), subPath);
            return this;
        }

        public Request setDestinationInExternalPublicDir(String dirType, String subPath) {
            this.setDestinationFromBase(Environment.getExternalStoragePublicDirectory(dirType), subPath);
            return this;
        }

        private void setDestinationFromBase(File base, String subPath) {
            if (subPath == null) {
                throw new NullPointerException("subPath cannot be null");
            }
            this.mDestinationUri = Uri.withAppendedPath(Uri.fromFile(base), subPath);
        }

        public Request addRequestHeader(String header, String value) {
            if (header == null) {
                throw new NullPointerException("header cannot be null");
            }
            if (header.contains(":")) {
                throw new IllegalArgumentException("header may not contain ':'");
            }
            if (value == null) {
                value = "";
            }
            this.mRequestHeaders.add(Pair.create(header, value));
            return this;
        }

        public Request setTitle(CharSequence title) {
            this.mTitle = title;
            return this;
        }

        public Request setDescription(CharSequence description) {
            this.mDescription = description;
            return this;
        }

        public Request setMimeType(String mimeType) {
            this.mMimeType = mimeType;
            return this;
        }

        public Request setShowRunningNotification(boolean show) {
            this.mShowNotification = show;
            return this;
        }

        public Request setAllowedNetworkTypes(int flags) {
            this.mAllowedNetworkTypes = flags;
            return this;
        }

        public Request setAllowedOverRoaming(boolean allowed) {
            this.mRoamingAllowed = allowed;
            return this;
        }

        public Request setVisibleInDownloadsUi(boolean isVisible) {
            this.mIsVisibleInDownloadsUi = isVisible;
            return this;
        }

        ContentValues toContentValues(String packageName) {
            ContentValues values = new ContentValues();
            assert (this.mUri != null);
            values.put(DownloadManager.COLUMN_URI, this.mUri.toString());
            values.put("is_public_api", true);
            values.put("notificationpackage", packageName);
            if (this.mDestinationUri != null) {
                values.put("destination", 4);
                values.put("hint", this.mDestinationUri.toString());
            } else {
                values.put("destination", 2);
            }
            if (!this.mRequestHeaders.isEmpty()) {
                this.encodeHttpHeaders(values);
            }
            this.putIfNonNull(values, DownloadManager.COLUMN_TITLE, this.mTitle);
            this.putIfNonNull(values, DownloadManager.COLUMN_DESCRIPTION, this.mDescription);
            this.putIfNonNull(values, "mimetype", this.mMimeType);
            values.put("visibility", this.mShowNotification ? 0 : 2);
            values.put("allowed_network_types", this.mAllowedNetworkTypes);
            values.put("allow_roaming", this.mRoamingAllowed);
            values.put("is_visible_in_downloads_ui", this.mIsVisibleInDownloadsUi);
            return values;
        }

        private void encodeHttpHeaders(ContentValues values) {
            int index = 0;
            for (Pair<String, String> header : this.mRequestHeaders) {
                String headerString = (String)header.first + ": " + (String)header.second;
                values.put("http_header_" + index, headerString);
                ++index;
            }
        }

        private void putIfNonNull(ContentValues contentValues, String key, Object value) {
            if (value != null) {
                contentValues.put(key, value.toString());
            }
        }
    }
}

