/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AccountAuthenticatorCache;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AuthenticatorDescription;
import android.accounts.GrantCredentialsPermissionActivity;
import android.accounts.IAccountAuthenticator;
import android.accounts.IAccountAuthenticatorResponse;
import android.accounts.IAccountManager;
import android.accounts.IAccountManagerResponse;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.RegisteredServicesCache;
import android.content.pm.RegisteredServicesCacheListener;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountManagerService
extends IAccountManager.Stub
implements RegisteredServicesCacheListener<AuthenticatorDescription> {
    private static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    private static final String NO_BROADCAST_FLAG = "nobroadcast";
    private static final String TAG = "AccountManagerService";
    private static final int TIMEOUT_DELAY_MS = 60000;
    private static final String DATABASE_NAME = "accounts.db";
    private static final int DATABASE_VERSION = 4;
    private final Context mContext;
    private final PackageManager mPackageManager;
    private HandlerThread mMessageThread;
    private final MessageHandler mMessageHandler;
    private static final int MESSAGE_TIMED_OUT = 3;
    private final AccountAuthenticatorCache mAuthenticatorCache;
    private final DatabaseHelper mOpenHelper;
    private static final String TABLE_ACCOUNTS = "accounts";
    private static final String ACCOUNTS_ID = "_id";
    private static final String ACCOUNTS_NAME = "name";
    private static final String ACCOUNTS_TYPE = "type";
    private static final String ACCOUNTS_TYPE_COUNT = "count(type)";
    private static final String ACCOUNTS_PASSWORD = "password";
    private static final String TABLE_AUTHTOKENS = "authtokens";
    private static final String AUTHTOKENS_ID = "_id";
    private static final String AUTHTOKENS_ACCOUNTS_ID = "accounts_id";
    private static final String AUTHTOKENS_TYPE = "type";
    private static final String AUTHTOKENS_AUTHTOKEN = "authtoken";
    private static final String TABLE_GRANTS = "grants";
    private static final String GRANTS_ACCOUNTS_ID = "accounts_id";
    private static final String GRANTS_AUTH_TOKEN_TYPE = "auth_token_type";
    private static final String GRANTS_GRANTEE_UID = "uid";
    private static final String TABLE_EXTRAS = "extras";
    private static final String EXTRAS_ID = "_id";
    private static final String EXTRAS_ACCOUNTS_ID = "accounts_id";
    private static final String EXTRAS_KEY = "key";
    private static final String EXTRAS_VALUE = "value";
    private static final String TABLE_META = "meta";
    private static final String META_KEY = "key";
    private static final String META_VALUE = "value";
    private static final String[] ACCOUNT_NAME_TYPE_PROJECTION = new String[]{"_id", "name", "type"};
    private static final String[] ACCOUNT_TYPE_COUNT_PROJECTION = new String[]{"type", "count(type)"};
    private static final Intent ACCOUNTS_CHANGED_INTENT;
    private static final String COUNT_OF_MATCHING_GRANTS = "SELECT COUNT(*) FROM grants, accounts WHERE accounts_id=_id AND uid=? AND auth_token_type=? AND name=? AND type=?";
    private final LinkedHashMap<String, Session> mSessions = new LinkedHashMap();
    private final AtomicInteger mNotificationIds = new AtomicInteger(1);
    private final HashMap<Pair<Pair<Account, String>, Integer>, Integer> mCredentialsPermissionNotificationIds = new HashMap();
    private final HashMap<Account, Integer> mSigninRequiredNotificationIds = new HashMap();
    private static AtomicReference<AccountManagerService> sThis;
    private static final boolean isDebuggableMonkeyBuild;
    private static final Account[] EMPTY_ACCOUNT_ARRAY;

    public static AccountManagerService getSingleton() {
        return sThis.get();
    }

    public AccountManagerService(Context context) {
        this.mContext = context;
        this.mPackageManager = context.getPackageManager();
        this.mOpenHelper = new DatabaseHelper(this.mContext);
        this.mMessageThread = new HandlerThread(TAG);
        this.mMessageThread.start();
        this.mMessageHandler = new MessageHandler(this.mMessageThread.getLooper());
        this.mAuthenticatorCache = new AccountAuthenticatorCache(this.mContext);
        this.mAuthenticatorCache.setListener(this, null);
        sThis.set(this);
        this.validateAccounts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateAccounts() {
        boolean accountDeleted = false;
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        Cursor cursor = db.query(TABLE_ACCOUNTS, new String[]{"_id", "type", ACCOUNTS_NAME}, null, null, null, null, null);
        try {
            while (cursor.moveToNext()) {
                long accountId = cursor.getLong(0);
                String accountType = cursor.getString(1);
                String accountName = cursor.getString(2);
                if (this.mAuthenticatorCache.getServiceInfo(AuthenticatorDescription.newKey(accountType)) != null) continue;
                Log.d(TAG, "deleting account " + accountName + " because type " + accountType + " no longer has a registered authenticator");
                db.delete(TABLE_ACCOUNTS, "_id=" + accountId, null);
                accountDeleted = true;
            }
            Object var9_7 = null;
            cursor.close();
            if (accountDeleted) {
                this.sendAccountsChangedBroadcast();
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            cursor.close();
            if (accountDeleted) {
                this.sendAccountsChangedBroadcast();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceChanged(AuthenticatorDescription desc, boolean removed) {
        boolean accountDeleted = false;
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        Cursor cursor = db.query(TABLE_ACCOUNTS, new String[]{"_id", "type", ACCOUNTS_NAME}, "type=?", new String[]{desc.type}, null, null, null);
        try {
            while (cursor.moveToNext()) {
                long accountId = cursor.getLong(0);
                String accountType = cursor.getString(1);
                String accountName = cursor.getString(2);
                Log.d(TAG, "deleting account " + accountName + " because type " + accountType + " no longer has a registered authenticator");
                db.delete(TABLE_ACCOUNTS, "_id=" + accountId, null);
                accountDeleted = true;
            }
            Object var11_9 = null;
            cursor.close();
            if (accountDeleted) {
                this.sendAccountsChangedBroadcast();
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            cursor.close();
            if (accountDeleted) {
                this.sendAccountsChangedBroadcast();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPassword(Account account) {
        String string2;
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        this.checkAuthenticateAccountsPermission(account);
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            string2 = this.readPasswordFromDatabase(account);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            AccountManagerService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(identityToken);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readPasswordFromDatabase(Account account) {
        Cursor cursor;
        block4: {
            if (account == null) {
                return null;
            }
            SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
            cursor = db.query(TABLE_ACCOUNTS, new String[]{ACCOUNTS_PASSWORD}, "name=? AND type=?", new String[]{account.name, account.type}, null, null, null);
            try {
                if (!cursor.moveToNext()) break block4;
                String string2 = cursor.getString(0);
                Object var6_6 = null;
                cursor.close();
                return string2;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                cursor.close();
                throw throwable;
            }
        }
        String string3 = null;
        Object var6_7 = null;
        cursor.close();
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUserData(Account account, String key) {
        String string2;
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        this.checkAuthenticateAccountsPermission(account);
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            string2 = this.readUserDataFromDatabase(account, key);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            AccountManagerService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(identityToken);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readUserDataFromDatabase(Account account, String key) {
        Cursor cursor;
        block4: {
            if (account == null) {
                return null;
            }
            SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
            cursor = db.query(TABLE_EXTRAS, new String[]{"value"}, "accounts_id=(select _id FROM accounts WHERE name=? AND type=?) AND key=?", new String[]{account.name, account.type, key}, null, null, null);
            try {
                if (!cursor.moveToNext()) break block4;
                String string2 = cursor.getString(0);
                Object var7_7 = null;
                cursor.close();
                return string2;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                cursor.close();
                throw throwable;
            }
        }
        String string3 = null;
        Object var7_8 = null;
        cursor.close();
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthenticatorDescription[] getAuthenticatorTypes() {
        AuthenticatorDescription[] authenticatorDescriptionArray;
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            Collection authenticatorCollection = this.mAuthenticatorCache.getAllServices();
            AuthenticatorDescription[] types = new AuthenticatorDescription[authenticatorCollection.size()];
            int i = 0;
            for (RegisteredServicesCache.ServiceInfo authenticator : authenticatorCollection) {
                types[i] = (AuthenticatorDescription)authenticator.type;
                ++i;
            }
            authenticatorDescriptionArray = types;
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            AccountManagerService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(identityToken);
        return authenticatorDescriptionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account[] getAccountsByType(String accountType) {
        String[] stringArray;
        String selection;
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        String string2 = selection = accountType == null ? null : "type=?";
        if (accountType == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = accountType;
        }
        String[] selectionArgs = stringArray;
        Cursor cursor = db.query(TABLE_ACCOUNTS, ACCOUNT_NAME_TYPE_PROJECTION, selection, selectionArgs, null, null, null);
        try {
            int i = 0;
            Account[] accounts = new Account[cursor.getCount()];
            while (cursor.moveToNext()) {
                accounts[i] = new Account(cursor.getString(1), cursor.getString(2));
                ++i;
            }
            Account[] accountArray = accounts;
            Object var10_9 = null;
            cursor.close();
            return accountArray;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            cursor.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAccount(Account account, String password, Bundle extras) {
        boolean bl;
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        this.checkAuthenticateAccountsPermission(account);
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            bl = this.insertAccountIntoDatabase(account, password, extras);
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            AccountManagerService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(identityToken);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean insertAccountIntoDatabase(Account account, String password, Bundle extras) {
        boolean bl;
        SQLiteDatabase db;
        block12: {
            boolean bl2;
            block11: {
                boolean bl3;
                block10: {
                    boolean bl4;
                    block9: {
                        db = this.mOpenHelper.getWritableDatabase();
                        db.beginTransaction();
                        try {
                            long numMatches;
                            if (account == null) {
                                boolean bl5 = false;
                                Object var16_7 = null;
                                db.endTransaction();
                                return bl5;
                            }
                            boolean noBroadcast = false;
                            if (account.type.equals(GOOGLE_ACCOUNT_TYPE)) {
                                noBroadcast = extras.getBoolean(NO_BROADCAST_FLAG, false);
                                extras.remove(NO_BROADCAST_FLAG);
                            }
                            if ((numMatches = DatabaseUtils.longForQuery(db, "select count(*) from accounts WHERE name=? AND type=?", new String[]{account.name, account.type})) > 0L) {
                                bl4 = false;
                                break block9;
                            }
                            ContentValues values = new ContentValues();
                            values.put(ACCOUNTS_NAME, account.name);
                            values.put("type", account.type);
                            values.put(ACCOUNTS_PASSWORD, password);
                            long accountId = db.insert(TABLE_ACCOUNTS, ACCOUNTS_NAME, values);
                            if (accountId < 0L) {
                                bl3 = false;
                                break block10;
                            }
                            if (extras != null) {
                                for (String key : extras.keySet()) {
                                    String value;
                                    if (this.insertExtra(db, accountId, key, value = extras.getString(key)) >= 0L) continue;
                                    bl2 = false;
                                    break block11;
                                }
                            }
                            db.setTransactionSuccessful();
                            if (!noBroadcast) {
                                this.sendAccountsChangedBroadcast();
                            }
                            bl = true;
                            break block12;
                        }
                        catch (Throwable throwable) {
                            Object var16_12 = null;
                            db.endTransaction();
                            throw throwable;
                        }
                    }
                    Object var16_8 = null;
                    db.endTransaction();
                    return bl4;
                }
                Object var16_9 = null;
                db.endTransaction();
                return bl3;
            }
            Object var16_10 = null;
            db.endTransaction();
            return bl2;
        }
        Object var16_11 = null;
        db.endTransaction();
        return bl;
    }

    private long insertExtra(SQLiteDatabase db, long accountId, String key, String value) {
        ContentValues values = new ContentValues();
        values.put("key", key);
        values.put("accounts_id", accountId);
        values.put("value", value);
        return db.insert(TABLE_EXTRAS, "key", values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hasFeatures(IAccountManagerResponse response, Account account, String[] features) {
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (features == null) {
            throw new IllegalArgumentException("features is null");
        }
        this.checkReadAccountsPermission();
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            new TestFeaturesSession(response, account, features).bind();
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            AccountManagerService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(identityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAccount(IAccountManagerResponse response, Account account) {
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        this.checkManageAccountsPermission();
        long identityToken = AccountManagerService.clearCallingIdentity();
        this.cancelNotification(this.getSigninRequiredNotificationId(account));
        HashMap<Pair<Pair<Account, String>, Integer>, Integer> hashMap = this.mCredentialsPermissionNotificationIds;
        synchronized (hashMap) {
            for (Pair<Pair<Account, String>, Integer> pair : this.mCredentialsPermissionNotificationIds.keySet()) {
                if (!account.equals(((Pair)pair.first).first)) continue;
                int id2 = this.mCredentialsPermissionNotificationIds.get(pair);
                this.cancelNotification(id2);
            }
        }
        try {
            new RemoveAccountSession(response, account).bind();
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            AccountManagerService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(identityToken);
    }

    private void removeAccount(Account account) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        db.delete(TABLE_ACCOUNTS, "name=? AND type=?", new String[]{account.name, account.type});
        this.sendAccountsChangedBroadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateAuthToken(String accountType, String authToken) {
        if (accountType == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        if (authToken == null) {
            throw new IllegalArgumentException("authToken is null");
        }
        this.checkManageAccountsOrUseCredentialsPermissions();
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
            db.beginTransaction();
            try {
                this.invalidateAuthToken(db, accountType, authToken);
                db.setTransactionSuccessful();
                Object var7_5 = null;
                db.endTransaction();
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                db.endTransaction();
                throw throwable;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            AccountManagerService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(identityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateAuthToken(SQLiteDatabase db, String accountType, String authToken) {
        if (authToken == null || accountType == null) {
            return;
        }
        Cursor cursor = db.rawQuery("SELECT authtokens._id, accounts.name, authtokens.type FROM accounts JOIN authtokens ON accounts._id = accounts_id WHERE authtoken = ? AND accounts.type = ?", new String[]{authToken, accountType});
        try {
            while (cursor.moveToNext()) {
                long authTokenId = cursor.getLong(0);
                String accountName = cursor.getString(1);
                String authTokenType = cursor.getString(2);
                db.delete(TABLE_AUTHTOKENS, "_id=" + authTokenId, null);
            }
            Object var10_8 = null;
            cursor.close();
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            cursor.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveAuthTokenToDatabase(Account account, String type, String authToken) {
        SQLiteDatabase db;
        block6: {
            long accountId;
            block5: {
                if (account == null || type == null) {
                    return false;
                }
                this.cancelNotification(this.getSigninRequiredNotificationId(account));
                db = this.mOpenHelper.getWritableDatabase();
                db.beginTransaction();
                try {
                    accountId = this.getAccountId(db, account);
                    if (accountId >= 0L) break block5;
                    boolean bl = false;
                    Object var10_8 = null;
                    db.endTransaction();
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    db.endTransaction();
                    throw throwable;
                }
            }
            db.delete(TABLE_AUTHTOKENS, "accounts_id=" + accountId + " AND " + "type" + "=?", new String[]{type});
            ContentValues values = new ContentValues();
            values.put("accounts_id", accountId);
            values.put("type", type);
            values.put(AUTHTOKENS_AUTHTOKEN, authToken);
            if (db.insert(TABLE_AUTHTOKENS, AUTHTOKENS_AUTHTOKEN, values) < 0L) break block6;
            db.setTransactionSuccessful();
            boolean bl = true;
            Object var10_9 = null;
            db.endTransaction();
            return bl;
        }
        boolean bl = false;
        Object var10_10 = null;
        db.endTransaction();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readAuthTokenFromDatabase(Account account, String authTokenType) {
        Cursor cursor;
        block4: {
            if (account == null || authTokenType == null) {
                return null;
            }
            SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
            cursor = db.query(TABLE_AUTHTOKENS, new String[]{AUTHTOKENS_AUTHTOKEN}, "accounts_id=(select _id FROM accounts WHERE name=? AND type=?) AND type=?", new String[]{account.name, account.type, authTokenType}, null, null, null);
            try {
                if (!cursor.moveToNext()) break block4;
                String string2 = cursor.getString(0);
                Object var7_7 = null;
                cursor.close();
                return string2;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                cursor.close();
                throw throwable;
            }
        }
        String string3 = null;
        Object var7_8 = null;
        cursor.close();
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String peekAuthToken(Account account, String authTokenType) {
        String string2;
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (authTokenType == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        this.checkAuthenticateAccountsPermission(account);
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            string2 = this.readAuthTokenFromDatabase(account, authTokenType);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            AccountManagerService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(identityToken);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAuthToken(Account account, String authTokenType, String authToken) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (authTokenType == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        this.checkAuthenticateAccountsPermission(account);
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            this.saveAuthTokenToDatabase(account, authTokenType, authToken);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            AccountManagerService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(identityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPassword(Account account, String password) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        this.checkAuthenticateAccountsPermission(account);
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            this.setPasswordInDB(account, password);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            AccountManagerService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(identityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPasswordInDB(Account account, String password) {
        if (account == null) {
            return;
        }
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        db.beginTransaction();
        try {
            ContentValues values = new ContentValues();
            values.put(ACCOUNTS_PASSWORD, password);
            long accountId = this.getAccountId(db, account);
            if (accountId >= 0L) {
                String[] argsAccountId = new String[]{String.valueOf(accountId)};
                db.update(TABLE_ACCOUNTS, values, "_id=?", argsAccountId);
                db.delete(TABLE_AUTHTOKENS, "accounts_id=?", argsAccountId);
                db.setTransactionSuccessful();
            }
            Object var9_7 = null;
            db.endTransaction();
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            db.endTransaction();
            throw throwable;
        }
        this.sendAccountsChangedBroadcast();
    }

    private void sendAccountsChangedBroadcast() {
        this.mContext.sendBroadcast(ACCOUNTS_CHANGED_INTENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPassword(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        this.checkManageAccountsPermission();
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            this.setPasswordInDB(account, null);
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            AccountManagerService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(identityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserData(Account account, String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        this.checkAuthenticateAccountsPermission(account);
        long identityToken = AccountManagerService.clearCallingIdentity();
        if (account == null) {
            return;
        }
        if (account.type.equals(GOOGLE_ACCOUNT_TYPE) && key.equals("broadcast")) {
            this.sendAccountsChangedBroadcast();
            return;
        }
        try {
            this.writeUserdataIntoDatabase(account, key, value);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            AccountManagerService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(identityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeUserdataIntoDatabase(Account account, String key, String value) {
        SQLiteDatabase db;
        block10: {
            block9: {
                block8: {
                    if (account == null) return;
                    if (key == null) {
                        return;
                    }
                    db = this.mOpenHelper.getWritableDatabase();
                    db.beginTransaction();
                    try {
                        long accountId = this.getAccountId(db, account);
                        if (accountId < 0L) {
                            Object var11_6 = null;
                            db.endTransaction();
                            return;
                        }
                        long extrasId = this.getExtrasId(db, accountId, key);
                        if (extrasId < 0L) {
                            extrasId = this.insertExtra(db, accountId, key, value);
                            if (extrasId < 0L) {
                                break block8;
                            }
                        } else {
                            ContentValues values = new ContentValues();
                            values.put("value", value);
                            if (1 != db.update(TABLE_EXTRAS, values, "_id=" + extrasId, null)) {
                                break block9;
                            }
                        }
                        db.setTransactionSuccessful();
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var11_10 = null;
                        db.endTransaction();
                        throw throwable;
                    }
                }
                Object var11_7 = null;
                db.endTransaction();
                return;
            }
            Object var11_8 = null;
            db.endTransaction();
            return;
        }
        Object var11_9 = null;
        db.endTransaction();
    }

    private void onResult(IAccountManagerResponse response, Bundle result) {
        block2: {
            try {
                response.onResult(result);
            }
            catch (RemoteException e) {
                if (!Log.isLoggable(TAG, 2)) break block2;
                Log.v(TAG, "failure while notifying response", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getAuthTokenLabel(IAccountManagerResponse response, final Account account, final String authTokenType) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (authTokenType == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        this.checkBinderPermission("android.permission.USE_CREDENTIALS");
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            new Session(response, account.type, false, false){

                protected String toDebugString(long now) {
                    return super.toDebugString(now) + ", getAuthTokenLabel" + ", " + account + ", authTokenType " + authTokenType;
                }

                public void run() throws RemoteException {
                    this.mAuthenticator.getAuthTokenLabel(this, authTokenType);
                }

                public void onResult(Bundle result) {
                    if (result != null) {
                        String label = result.getString("authTokenLabelKey");
                        Bundle bundle = new Bundle();
                        bundle.putString("authTokenLabelKey", label);
                        super.onResult(bundle);
                        return;
                    }
                    super.onResult(result);
                }
            }.bind();
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            AccountManagerService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(identityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void getAuthToken(IAccountManagerResponse response, final Account account, final String authTokenType, final boolean notifyOnAuthFailure, boolean expectActivityLaunch, Bundle loginOptionsIn) {
        long identityToken;
        block10: {
            block9: {
                Bundle loginOptions;
                if (Log.isLoggable(TAG, 2)) {
                    Log.v(TAG, "getAuthToken: " + account + ", response " + response + ", authTokenType " + authTokenType + ", notifyOnAuthFailure " + notifyOnAuthFailure + ", expectActivityLaunch " + expectActivityLaunch + ", caller's uid " + Binder.getCallingUid() + ", pid " + Binder.getCallingPid());
                }
                if (response == null) {
                    throw new IllegalArgumentException("response is null");
                }
                if (account == null) {
                    throw new IllegalArgumentException("account is null");
                }
                if (authTokenType == null) {
                    throw new IllegalArgumentException("authTokenType is null");
                }
                this.checkBinderPermission("android.permission.USE_CREDENTIALS");
                final int callerUid = Binder.getCallingUid();
                int callerPid = Binder.getCallingPid();
                RegisteredServicesCache.ServiceInfo<AuthenticatorDescription> authenticatorInfo = this.mAuthenticatorCache.getServiceInfo(AuthenticatorDescription.newKey(account.type));
                final boolean customTokens = authenticatorInfo != null && ((AuthenticatorDescription)authenticatorInfo.type).customTokens;
                final boolean permissionGranted = customTokens || this.permissionIsGranted(account, authTokenType, callerUid);
                Bundle bundle = loginOptions = loginOptionsIn == null ? new Bundle() : loginOptionsIn;
                if (customTokens) {
                    loginOptions.putInt("callerUid", callerUid);
                    loginOptions.putInt("callerPid", callerPid);
                    if (notifyOnAuthFailure) {
                        loginOptions.putBoolean("notifyOnAuthFailure", true);
                    }
                }
                identityToken = AccountManagerService.clearCallingIdentity();
                try {
                    String authToken;
                    if (!customTokens && permissionGranted && (authToken = this.readAuthTokenFromDatabase(account, authTokenType)) != null) {
                        Bundle result = new Bundle();
                        result.putString(AUTHTOKENS_AUTHTOKEN, authToken);
                        result.putString("authAccount", account.name);
                        result.putString("accountType", account.type);
                        this.onResult(response, result);
                        Object var18_16 = null;
                        break block9;
                    }
                    new Session(response, account.type, expectActivityLaunch, false){

                        protected String toDebugString(long now) {
                            if (loginOptions != null) {
                                loginOptions.keySet();
                            }
                            return super.toDebugString(now) + ", getAuthToken" + ", " + account + ", authTokenType " + authTokenType + ", loginOptions " + loginOptions + ", notifyOnAuthFailure " + notifyOnAuthFailure;
                        }

                        public void run() throws RemoteException {
                            if (!permissionGranted) {
                                this.mAuthenticator.getAuthTokenLabel(this, authTokenType);
                            } else {
                                this.mAuthenticator.getAuthToken(this, account, authTokenType, loginOptions);
                            }
                        }

                        public void onResult(Bundle result) {
                            if (result != null) {
                                Intent intent;
                                if (result.containsKey("authTokenLabelKey")) {
                                    Intent intent2 = AccountManagerService.this.newGrantCredentialsPermissionIntent(account, callerUid, new AccountAuthenticatorResponse(this), authTokenType, result.getString("authTokenLabelKey"));
                                    Bundle bundle = new Bundle();
                                    bundle.putParcelable("intent", intent2);
                                    this.onResult(bundle);
                                    return;
                                }
                                String authToken = result.getString(AccountManagerService.AUTHTOKENS_AUTHTOKEN);
                                if (authToken != null) {
                                    String name = result.getString("authAccount");
                                    String type = result.getString("accountType");
                                    if (TextUtils.isEmpty(type) || TextUtils.isEmpty(name)) {
                                        this.onError(5, "the type and name should not be empty");
                                        return;
                                    }
                                    if (!customTokens) {
                                        AccountManagerService.this.saveAuthTokenToDatabase(new Account(name, type), authTokenType, authToken);
                                    }
                                }
                                if ((intent = (Intent)result.getParcelable("intent")) != null && notifyOnAuthFailure && !customTokens) {
                                    AccountManagerService.this.doNotification(account, result.getString("authFailedMessage"), intent);
                                }
                            }
                            super.onResult(result);
                        }
                    }.bind();
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var18_18 = null;
                    AccountManagerService.restoreCallingIdentity(identityToken);
                    throw throwable;
                }
            }
            AccountManagerService.restoreCallingIdentity(identityToken);
            return;
        }
        Object var18_17 = null;
        AccountManagerService.restoreCallingIdentity(identityToken);
    }

    private void createNoCredentialsPermissionNotification(Account account, Intent intent) {
        int uid = intent.getIntExtra(GRANTS_GRANTEE_UID, -1);
        String authTokenType = intent.getStringExtra("authTokenType");
        String authTokenLabel = intent.getStringExtra("authTokenLabel");
        Notification n = new Notification(17301642, null, 0L);
        String titleAndSubtitle = this.mContext.getString(17040236, account.name);
        int index = titleAndSubtitle.indexOf(10);
        String title = titleAndSubtitle.substring(0, index);
        String subtitle = titleAndSubtitle.substring(index + 1);
        n.setLatestEventInfo(this.mContext, title, subtitle, PendingIntent.getActivity(this.mContext, 0, intent, 0x10000000));
        ((NotificationManager)this.mContext.getSystemService("notification")).notify(this.getCredentialPermissionNotificationId(account, authTokenType, uid), n);
    }

    String getAccountLabel(String accountType) {
        Context authContext;
        RegisteredServicesCache.ServiceInfo<AuthenticatorDescription> serviceInfo = this.mAuthenticatorCache.getServiceInfo(AuthenticatorDescription.newKey(accountType));
        if (serviceInfo == null) {
            throw new IllegalArgumentException("unknown account type: " + accountType);
        }
        try {
            authContext = this.mContext.createPackageContext(((AuthenticatorDescription)serviceInfo.type).packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalArgumentException("unknown account type: " + accountType);
        }
        return authContext.getString(((AuthenticatorDescription)serviceInfo.type).labelId);
    }

    private Intent newGrantCredentialsPermissionIntent(Account account, int uid, AccountAuthenticatorResponse response, String authTokenType, String authTokenLabel) {
        Intent intent = new Intent(this.mContext, GrantCredentialsPermissionActivity.class);
        intent.setFlags(0x10000000);
        intent.addCategory(String.valueOf(this.getCredentialPermissionNotificationId(account, authTokenType, uid)));
        intent.putExtra("account", account);
        intent.putExtra("authTokenType", authTokenType);
        intent.putExtra("response", response);
        intent.putExtra(GRANTS_GRANTEE_UID, uid);
        return intent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getCredentialPermissionNotificationId(Account account, String authTokenType, int uid) {
        Integer id2;
        HashMap<Pair<Pair<Account, String>, Integer>, Integer> hashMap = this.mCredentialsPermissionNotificationIds;
        synchronized (hashMap) {
            Pair<Pair<Account, String>, Integer> key = new Pair<Pair<Account, String>, Integer>(new Pair<Account, String>(account, authTokenType), uid);
            id2 = this.mCredentialsPermissionNotificationIds.get(key);
            if (id2 == null) {
                id2 = this.mNotificationIds.incrementAndGet();
                this.mCredentialsPermissionNotificationIds.put(key, id2);
            }
        }
        return id2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getSigninRequiredNotificationId(Account account) {
        Integer id2;
        HashMap<Account, Integer> hashMap = this.mSigninRequiredNotificationIds;
        synchronized (hashMap) {
            id2 = this.mSigninRequiredNotificationIds.get(account);
            if (id2 == null) {
                id2 = this.mNotificationIds.incrementAndGet();
                this.mSigninRequiredNotificationIds.put(account, id2);
            }
        }
        return id2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAcount(IAccountManagerResponse response, final String accountType, final String authTokenType, final String[] requiredFeatures, boolean expectActivityLaunch, final Bundle options) {
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (accountType == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        this.checkManageAccountsPermission();
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            new Session(response, accountType, expectActivityLaunch, true){

                public void run() throws RemoteException {
                    this.mAuthenticator.addAccount(this, this.mAccountType, authTokenType, requiredFeatures, options);
                }

                protected String toDebugString(long now) {
                    return super.toDebugString(now) + ", addAccount" + ", accountType " + accountType + ", requiredFeatures " + (requiredFeatures != null ? TextUtils.join((CharSequence)",", requiredFeatures) : null);
                }
            }.bind();
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            AccountManagerService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(identityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void confirmCredentials(IAccountManagerResponse response, final Account account, final Bundle options, boolean expectActivityLaunch) {
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        this.checkManageAccountsPermission();
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            new Session(response, account.type, expectActivityLaunch, true){

                public void run() throws RemoteException {
                    this.mAuthenticator.confirmCredentials(this, account, options);
                }

                protected String toDebugString(long now) {
                    return super.toDebugString(now) + ", confirmCredentials" + ", " + account;
                }
            }.bind();
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            AccountManagerService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(identityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCredentials(IAccountManagerResponse response, final Account account, final String authTokenType, boolean expectActivityLaunch, final Bundle loginOptions) {
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (authTokenType == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        this.checkManageAccountsPermission();
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            new Session(response, account.type, expectActivityLaunch, true){

                public void run() throws RemoteException {
                    this.mAuthenticator.updateCredentials(this, account, authTokenType, loginOptions);
                }

                protected String toDebugString(long now) {
                    if (loginOptions != null) {
                        loginOptions.keySet();
                    }
                    return super.toDebugString(now) + ", updateCredentials" + ", " + account + ", authTokenType " + authTokenType + ", loginOptions " + loginOptions;
                }
            }.bind();
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            AccountManagerService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(identityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void editProperties(IAccountManagerResponse response, final String accountType, boolean expectActivityLaunch) {
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (accountType == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        this.checkManageAccountsPermission();
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            new Session(response, accountType, expectActivityLaunch, true){

                public void run() throws RemoteException {
                    this.mAuthenticator.editProperties(this, this.mAccountType);
                }

                protected String toDebugString(long now) {
                    return super.toDebugString(now) + ", editProperties" + ", accountType " + accountType;
                }
            }.bind();
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            AccountManagerService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(identityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Account[] getAccounts(String type) {
        Account[] accountArray;
        this.checkReadAccountsPermission();
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            accountArray = this.getAccountsByType(type);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            AccountManagerService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(identityToken);
        return accountArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void getAccountsByFeatures(IAccountManagerResponse response, String type, String[] features) {
        long identityToken;
        block9: {
            block8: {
                if (response == null) {
                    throw new IllegalArgumentException("response is null");
                }
                if (type == null) {
                    throw new IllegalArgumentException("accountType is null");
                }
                this.checkReadAccountsPermission();
                if (features != null && type == null) {
                    if (response == null) return;
                    try {
                        response.onError(7, "type is null");
                        return;
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                    return;
                }
                identityToken = AccountManagerService.clearCallingIdentity();
                try {
                    if (features == null || features.length == 0) {
                        Parcelable[] accounts = this.getAccountsByType(type);
                        Bundle result = new Bundle();
                        result.putParcelableArray(TABLE_ACCOUNTS, accounts);
                        this.onResult(response, result);
                        Object var9_8 = null;
                        break block8;
                    }
                    new GetAccountsByTypeAndFeatureSession(response, type, features).bind();
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    AccountManagerService.restoreCallingIdentity(identityToken);
                    throw throwable;
                }
            }
            AccountManagerService.restoreCallingIdentity(identityToken);
            return;
        }
        Object var9_9 = null;
        AccountManagerService.restoreCallingIdentity(identityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getAccountId(SQLiteDatabase db, Account account) {
        Cursor cursor;
        block3: {
            cursor = db.query(TABLE_ACCOUNTS, new String[]{"_id"}, "name=? AND type=?", new String[]{account.name, account.type}, null, null, null);
            try {
                if (!cursor.moveToNext()) break block3;
                long l = cursor.getLong(0);
                Object var7_6 = null;
                cursor.close();
                return l;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                cursor.close();
                throw throwable;
            }
        }
        long l = -1L;
        Object var7_7 = null;
        cursor.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getExtrasId(SQLiteDatabase db, long accountId, String key) {
        Cursor cursor;
        block3: {
            cursor = db.query(TABLE_EXTRAS, new String[]{"_id"}, "accounts_id=" + accountId + " AND " + "key" + "=?", new String[]{key}, null, null, null);
            try {
                if (!cursor.moveToNext()) break block3;
                long l = cursor.getLong(0);
                Object var9_7 = null;
                cursor.close();
                return l;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                cursor.close();
                throw throwable;
            }
        }
        long l = -1L;
        Object var9_8 = null;
        cursor.close();
        return l;
    }

    private static String getDatabaseName() {
        if (Environment.isEncryptedFilesystemEnabled()) {
            return Environment.getSystemSecureDirectory().getPath() + File.separator + DATABASE_NAME;
        }
        return DATABASE_NAME;
    }

    private void setMetaValue(String key, String value) {
        ContentValues values = new ContentValues();
        values.put("key", key);
        values.put("value", value);
        this.mOpenHelper.getWritableDatabase().replace(TABLE_META, "key", values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMetaValue(String key) {
        Cursor c;
        block3: {
            c = this.mOpenHelper.getReadableDatabase().query(TABLE_META, new String[]{"value"}, "key=?", new String[]{key}, null, null, null);
            try {
                if (!c.moveToNext()) break block3;
                String string2 = c.getString(0);
                Object var5_5 = null;
                c.close();
                return string2;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                c.close();
                throw throwable;
            }
        }
        String string3 = null;
        Object var5_6 = null;
        c.close();
        return string3;
    }

    public IBinder onBind(Intent intent) {
        return this.asBinder();
    }

    private static boolean scanArgs(String[] args, String value) {
        if (args != null) {
            for (String arg : args) {
                if (!value.equals(arg)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
        boolean isCheckinRequest;
        boolean bl = isCheckinRequest = AccountManagerService.scanArgs(args, "--checkin") || AccountManagerService.scanArgs(args, "-c");
        if (isCheckinRequest) {
            SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
            Cursor cursor = db.query(TABLE_ACCOUNTS, ACCOUNT_TYPE_COUNT_PROJECTION, null, null, "type", null, null);
            try {
                while (cursor.moveToNext()) {
                    fout.println(cursor.getString(0) + "," + cursor.getString(1));
                }
                Object var8_9 = null;
                if (cursor == null) return;
                cursor.close();
                return;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (cursor == null) throw throwable;
                cursor.close();
                throw throwable;
            }
        }
        Account[] accounts = this.getAccountsByType(null);
        fout.println("Accounts: " + accounts.length);
        for (Account account : accounts) {
            fout.println("  " + account);
        }
        fout.println();
        LinkedHashMap<String, Session> linkedHashMap = this.mSessions;
        synchronized (linkedHashMap) {
            long now = SystemClock.elapsedRealtime();
            fout.println("Active Sessions: " + this.mSessions.size());
            for (Session session : this.mSessions.values()) {
                fout.println("  " + session.toDebugString(now));
            }
        }
        fout.println();
        this.mAuthenticatorCache.dump(fd, fout, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNotification(Account account, CharSequence message, Intent intent) {
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "doNotification: " + message + " intent:" + intent);
            }
            if (intent.getComponent() != null && GrantCredentialsPermissionActivity.class.getName().equals(intent.getComponent().getClassName())) {
                this.createNoCredentialsPermissionNotification(account, intent);
            } else {
                Integer notificationId = this.getSigninRequiredNotificationId(account);
                intent.addCategory(String.valueOf(notificationId));
                Notification n = new Notification(17301642, null, 0L);
                String notificationTitleFormat = ((Object)this.mContext.getText(17039629)).toString();
                n.setLatestEventInfo(this.mContext, String.format(notificationTitleFormat, account.name), message, PendingIntent.getActivity(this.mContext, 0, intent, 0x10000000));
                ((NotificationManager)this.mContext.getSystemService("notification")).notify(notificationId, n);
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            AccountManagerService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(identityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelNotification(int id2) {
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            ((NotificationManager)this.mContext.getSystemService("notification")).cancel(id2);
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            AccountManagerService.restoreCallingIdentity(identityToken);
            throw throwable;
        }
        AccountManagerService.restoreCallingIdentity(identityToken);
    }

    private void checkBinderPermission(String ... permissions) {
        int uid = Binder.getCallingUid();
        for (String perm : permissions) {
            if (this.mContext.checkCallingOrSelfPermission(perm) != 0) continue;
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "caller uid " + uid + " has " + perm);
            }
            return;
        }
        String msg = "caller uid " + uid + " lacks any of " + TextUtils.join((CharSequence)",", permissions);
        Log.w(TAG, msg);
        throw new SecurityException(msg);
    }

    private boolean inSystemImage(int callerUid) {
        String[] packages;
        for (String name : packages = this.mPackageManager.getPackagesForUid(callerUid)) {
            try {
                PackageInfo packageInfo = this.mPackageManager.getPackageInfo(name, 0);
                if (packageInfo == null || (packageInfo.applicationInfo.flags & 1) == 0) continue;
                return true;
            }
            catch (PackageManager.NameNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    private boolean permissionIsGranted(Account account, String authTokenType, int callerUid) {
        boolean hasExplicitGrants;
        boolean inSystemImage = this.inSystemImage(callerUid);
        boolean fromAuthenticator = account != null && this.hasAuthenticatorUid(account.type, callerUid);
        boolean bl = hasExplicitGrants = account != null && this.hasExplicitlyGrantedPermission(account, authTokenType);
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "checkGrantsOrCallingUidAgainstAuthenticator: caller uid " + callerUid + ", " + account + ": is authenticator? " + fromAuthenticator + ", has explicit permission? " + hasExplicitGrants);
        }
        return fromAuthenticator || hasExplicitGrants || inSystemImage;
    }

    private boolean hasAuthenticatorUid(String accountType, int callingUid) {
        for (RegisteredServicesCache.ServiceInfo serviceInfo : this.mAuthenticatorCache.getAllServices()) {
            if (!((AuthenticatorDescription)serviceInfo.type).type.equals(accountType)) continue;
            return serviceInfo.uid == callingUid || this.mPackageManager.checkSignatures(serviceInfo.uid, callingUid) == 0;
        }
        return false;
    }

    private boolean hasExplicitlyGrantedPermission(Account account, String authTokenType) {
        boolean permissionGranted;
        if (Binder.getCallingUid() == 1000) {
            return true;
        }
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        String[] args = new String[]{String.valueOf(Binder.getCallingUid()), authTokenType, account.name, account.type};
        boolean bl = permissionGranted = DatabaseUtils.longForQuery(db, COUNT_OF_MATCHING_GRANTS, args) != 0L;
        if (!permissionGranted && isDebuggableMonkeyBuild) {
            Log.d(TAG, "no credentials permission for usage of " + account + ", " + authTokenType + " by uid " + Binder.getCallingUid() + " but ignoring since this is a monkey build");
            return true;
        }
        return permissionGranted;
    }

    private void checkCallingUidAgainstAuthenticator(Account account) {
        int uid = Binder.getCallingUid();
        if (account == null || !this.hasAuthenticatorUid(account.type, uid)) {
            String msg = "caller uid " + uid + " is different than the authenticator's uid";
            Log.w(TAG, msg);
            throw new SecurityException(msg);
        }
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "caller uid " + uid + " is the same as the authenticator's uid");
        }
    }

    private void checkAuthenticateAccountsPermission(Account account) {
        this.checkBinderPermission("android.permission.AUTHENTICATE_ACCOUNTS");
        this.checkCallingUidAgainstAuthenticator(account);
    }

    private void checkReadAccountsPermission() {
        this.checkBinderPermission("android.permission.GET_ACCOUNTS");
    }

    private void checkManageAccountsPermission() {
        this.checkBinderPermission("android.permission.MANAGE_ACCOUNTS");
    }

    private void checkManageAccountsOrUseCredentialsPermissions() {
        this.checkBinderPermission("android.permission.MANAGE_ACCOUNTS", "android.permission.USE_CREDENTIALS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantAppPermission(Account account, String authTokenType, int uid) {
        if (account == null || authTokenType == null) {
            Log.e(TAG, "grantAppPermission: called with invalid arguments", new Exception());
            return;
        }
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        db.beginTransaction();
        try {
            long accountId = this.getAccountId(db, account);
            if (accountId >= 0L) {
                ContentValues values = new ContentValues();
                values.put("accounts_id", accountId);
                values.put(GRANTS_AUTH_TOKEN_TYPE, authTokenType);
                values.put(GRANTS_GRANTEE_UID, uid);
                db.insert(TABLE_GRANTS, "accounts_id", values);
                db.setTransactionSuccessful();
            }
            Object var9_7 = null;
            db.endTransaction();
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            db.endTransaction();
            throw throwable;
        }
        this.cancelNotification(this.getCredentialPermissionNotificationId(account, authTokenType, uid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeAppPermission(Account account, String authTokenType, int uid) {
        if (account == null || authTokenType == null) {
            Log.e(TAG, "revokeAppPermission: called with invalid arguments", new Exception());
            return;
        }
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        db.beginTransaction();
        try {
            long accountId = this.getAccountId(db, account);
            if (accountId >= 0L) {
                db.delete(TABLE_GRANTS, "accounts_id=? AND auth_token_type=? AND uid=?", new String[]{String.valueOf(accountId), authTokenType, String.valueOf(uid)});
                db.setTransactionSuccessful();
            }
            Object var8_6 = null;
            db.endTransaction();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            db.endTransaction();
            throw throwable;
        }
        this.cancelNotification(this.getCredentialPermissionNotificationId(account, authTokenType, uid));
    }

    static {
        sThis = new AtomicReference();
        isDebuggableMonkeyBuild = SystemProperties.getBoolean("ro.monkey", false);
        EMPTY_ACCOUNT_ARRAY = new Account[0];
        ACCOUNTS_CHANGED_INTENT = new Intent("android.accounts.LOGIN_ACCOUNTS_CHANGED");
        ACCOUNTS_CHANGED_INTENT.setFlags(0x10000000);
    }

    private class DatabaseHelper
    extends SQLiteOpenHelper {
        public DatabaseHelper(Context context) {
            super(context, AccountManagerService.getDatabaseName(), null, 4);
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE accounts ( _id INTEGER PRIMARY KEY AUTOINCREMENT, name TEXT NOT NULL, type TEXT NOT NULL, password TEXT, UNIQUE(name,type))");
            db.execSQL("CREATE TABLE authtokens (  _id INTEGER PRIMARY KEY AUTOINCREMENT,  accounts_id INTEGER NOT NULL, type TEXT NOT NULL,  authtoken TEXT,  UNIQUE (accounts_id,type))");
            this.createGrantsTable(db);
            db.execSQL("CREATE TABLE extras ( _id INTEGER PRIMARY KEY AUTOINCREMENT, accounts_id INTEGER, key TEXT NOT NULL, value TEXT, UNIQUE(accounts_id,key))");
            db.execSQL("CREATE TABLE meta ( key TEXT PRIMARY KEY NOT NULL, value TEXT)");
            this.createAccountsDeletionTrigger(db);
        }

        private void createAccountsDeletionTrigger(SQLiteDatabase db) {
            db.execSQL(" CREATE TRIGGER accountsDelete DELETE ON accounts BEGIN   DELETE FROM authtokens     WHERE accounts_id=OLD._id ;   DELETE FROM extras     WHERE accounts_id=OLD._id ;   DELETE FROM grants     WHERE accounts_id=OLD._id ; END");
        }

        private void createGrantsTable(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE grants (  accounts_id INTEGER NOT NULL, auth_token_type STRING NOT NULL,  uid INTEGER NOT NULL,  UNIQUE (accounts_id,auth_token_type,uid))");
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            Log.e(AccountManagerService.TAG, "upgrade from version " + oldVersion + " to version " + newVersion);
            if (oldVersion == 1) {
                ++oldVersion;
            }
            if (oldVersion == 2) {
                this.createGrantsTable(db);
                db.execSQL("DROP TRIGGER accountsDelete");
                this.createAccountsDeletionTrigger(db);
                ++oldVersion;
            }
            if (oldVersion == 3) {
                db.execSQL("UPDATE accounts SET type = 'com.google' WHERE type == 'com.google.GAIA'");
                ++oldVersion;
            }
        }

        public void onOpen(SQLiteDatabase db) {
            if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                Log.v(AccountManagerService.TAG, "opened database accounts.db");
            }
        }
    }

    private class MessageHandler
    extends Handler {
        MessageHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 3: {
                    Session session = (Session)msg.obj;
                    session.onTimedOut();
                    break;
                }
                default: {
                    throw new IllegalStateException("unhandled message: " + msg.what);
                }
            }
        }
    }

    private abstract class Session
    extends IAccountAuthenticatorResponse.Stub
    implements IBinder.DeathRecipient,
    ServiceConnection {
        IAccountManagerResponse mResponse;
        final String mAccountType;
        final boolean mExpectActivityLaunch;
        final long mCreationTime;
        public int mNumResults = 0;
        private int mNumRequestContinued = 0;
        private int mNumErrors = 0;
        IAccountAuthenticator mAuthenticator = null;
        private final boolean mStripAuthTokenFromResult;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Session(IAccountManagerResponse response, String accountType, boolean expectActivityLaunch, boolean stripAuthTokenFromResult) {
            if (response == null) {
                throw new IllegalArgumentException("response is null");
            }
            if (accountType == null) {
                throw new IllegalArgumentException("accountType is null");
            }
            this.mStripAuthTokenFromResult = stripAuthTokenFromResult;
            this.mResponse = response;
            this.mAccountType = accountType;
            this.mExpectActivityLaunch = expectActivityLaunch;
            this.mCreationTime = SystemClock.elapsedRealtime();
            LinkedHashMap linkedHashMap = AccountManagerService.this.mSessions;
            synchronized (linkedHashMap) {
                AccountManagerService.this.mSessions.put(this.toString(), this);
            }
            try {
                response.asBinder().linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                this.mResponse = null;
                this.binderDied();
            }
        }

        IAccountManagerResponse getResponseAndClose() {
            if (this.mResponse == null) {
                return null;
            }
            IAccountManagerResponse response = this.mResponse;
            this.close();
            return response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() {
            LinkedHashMap linkedHashMap = AccountManagerService.this.mSessions;
            synchronized (linkedHashMap) {
                if (AccountManagerService.this.mSessions.remove(this.toString()) == null) {
                    return;
                }
            }
            if (this.mResponse != null) {
                this.mResponse.asBinder().unlinkToDeath(this, 0);
                this.mResponse = null;
            }
            this.cancelTimeout();
            this.unbind();
        }

        public void binderDied() {
            this.mResponse = null;
            this.close();
        }

        protected String toDebugString() {
            return this.toDebugString(SystemClock.elapsedRealtime());
        }

        protected String toDebugString(long now) {
            return "Session: expectLaunch " + this.mExpectActivityLaunch + ", connected " + (this.mAuthenticator != null) + ", stats (" + this.mNumResults + "/" + this.mNumRequestContinued + "/" + this.mNumErrors + ")" + ", lifetime " + (double)(now - this.mCreationTime) / 1000.0;
        }

        void bind() {
            if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                Log.v(AccountManagerService.TAG, "initiating bind to authenticator type " + this.mAccountType);
            }
            if (!this.bindToAuthenticator(this.mAccountType)) {
                Log.d(AccountManagerService.TAG, "bind attempt failed for " + this.toDebugString());
                this.onError(1, "bind failure");
            }
        }

        private void unbind() {
            if (this.mAuthenticator != null) {
                this.mAuthenticator = null;
                AccountManagerService.this.mContext.unbindService(this);
            }
        }

        public void scheduleTimeout() {
            AccountManagerService.this.mMessageHandler.sendMessageDelayed(AccountManagerService.this.mMessageHandler.obtainMessage(3, this), 60000L);
        }

        public void cancelTimeout() {
            AccountManagerService.this.mMessageHandler.removeMessages(3, this);
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            this.mAuthenticator = IAccountAuthenticator.Stub.asInterface(service);
            try {
                this.run();
            }
            catch (RemoteException e) {
                this.onError(1, "remote exception");
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            this.mAuthenticator = null;
            IAccountManagerResponse response = this.getResponseAndClose();
            if (response != null) {
                this.onError(1, "disconnected");
            }
        }

        public abstract void run() throws RemoteException;

        public void onTimedOut() {
            IAccountManagerResponse response = this.getResponseAndClose();
            if (response != null) {
                this.onError(1, "timeout");
            }
        }

        public void onResult(Bundle result) {
            block8: {
                IAccountManagerResponse response;
                ++this.mNumResults;
                if (result != null && !TextUtils.isEmpty(result.getString(AccountManagerService.AUTHTOKENS_AUTHTOKEN))) {
                    String accountName = result.getString("authAccount");
                    String accountType = result.getString("accountType");
                    if (!TextUtils.isEmpty(accountName) && !TextUtils.isEmpty(accountType)) {
                        Account account = new Account(accountName, accountType);
                        AccountManagerService.this.cancelNotification(AccountManagerService.this.getSigninRequiredNotificationId(account));
                    }
                }
                if ((response = this.mExpectActivityLaunch && result != null && result.containsKey("intent") ? this.mResponse : this.getResponseAndClose()) != null) {
                    try {
                        if (result == null) {
                            response.onError(5, "null bundle returned");
                        } else {
                            if (this.mStripAuthTokenFromResult) {
                                result.remove(AccountManagerService.AUTHTOKENS_AUTHTOKEN);
                            }
                            response.onResult(result);
                        }
                    }
                    catch (RemoteException e) {
                        if (!Log.isLoggable(AccountManagerService.TAG, 2)) break block8;
                        Log.v(AccountManagerService.TAG, "failure while notifying response", e);
                    }
                }
            }
        }

        public void onRequestContinued() {
            ++this.mNumRequestContinued;
        }

        public void onError(int errorCode, String errorMessage) {
            IAccountManagerResponse response;
            ++this.mNumErrors;
            if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                Log.v(AccountManagerService.TAG, "Session.onError: " + errorCode + ", " + errorMessage);
            }
            if ((response = this.getResponseAndClose()) != null) {
                if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                    Log.v(AccountManagerService.TAG, "Session.onError: responding");
                }
                try {
                    response.onError(errorCode, errorMessage);
                }
                catch (RemoteException e) {
                    if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                        Log.v(AccountManagerService.TAG, "Session.onError: caught RemoteException while responding", e);
                    }
                }
            } else if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                Log.v(AccountManagerService.TAG, "Session.onError: already closed");
            }
        }

        private boolean bindToAuthenticator(String authenticatorType) {
            RegisteredServicesCache.ServiceInfo<AuthenticatorDescription> authenticatorInfo = AccountManagerService.this.mAuthenticatorCache.getServiceInfo(AuthenticatorDescription.newKey(authenticatorType));
            if (authenticatorInfo == null) {
                if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                    Log.v(AccountManagerService.TAG, "there is no authenticator for " + authenticatorType + ", bailing out");
                }
                return false;
            }
            Intent intent = new Intent();
            intent.setAction("android.accounts.AccountAuthenticator");
            intent.setComponent(authenticatorInfo.componentName);
            if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                Log.v(AccountManagerService.TAG, "performing bindService to " + authenticatorInfo.componentName);
            }
            if (!AccountManagerService.this.mContext.bindService(intent, this, 1)) {
                if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                    Log.v(AccountManagerService.TAG, "bindService to " + authenticatorInfo.componentName + " failed");
                }
                return false;
            }
            return true;
        }
    }

    private class GetAccountsByTypeAndFeatureSession
    extends Session {
        private final String[] mFeatures;
        private volatile Account[] mAccountsOfType;
        private volatile ArrayList<Account> mAccountsWithFeatures;
        private volatile int mCurrentAccount;

        public GetAccountsByTypeAndFeatureSession(IAccountManagerResponse response, String type, String[] features) {
            super(response, type, false, true);
            this.mAccountsOfType = null;
            this.mAccountsWithFeatures = null;
            this.mCurrentAccount = 0;
            this.mFeatures = features;
        }

        public void run() throws RemoteException {
            this.mAccountsOfType = AccountManagerService.this.getAccountsByType(this.mAccountType);
            this.mAccountsWithFeatures = new ArrayList(this.mAccountsOfType.length);
            this.mCurrentAccount = 0;
            this.checkAccount();
        }

        public void checkAccount() {
            if (this.mCurrentAccount >= this.mAccountsOfType.length) {
                this.sendResult();
                return;
            }
            IAccountAuthenticator accountAuthenticator = this.mAuthenticator;
            if (accountAuthenticator == null) {
                if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                    Log.v(AccountManagerService.TAG, "checkAccount: aborting session since we are no longer connected to the authenticator, " + this.toDebugString());
                }
                return;
            }
            try {
                accountAuthenticator.hasFeatures(this, this.mAccountsOfType[this.mCurrentAccount], this.mFeatures);
            }
            catch (RemoteException e) {
                this.onError(1, "remote exception");
            }
        }

        public void onResult(Bundle result) {
            ++this.mNumResults;
            if (result == null) {
                this.onError(5, "null bundle");
                return;
            }
            if (result.getBoolean("booleanResult", false)) {
                this.mAccountsWithFeatures.add(this.mAccountsOfType[this.mCurrentAccount]);
            }
            ++this.mCurrentAccount;
            this.checkAccount();
        }

        public void sendResult() {
            block4: {
                IAccountManagerResponse response = this.getResponseAndClose();
                if (response != null) {
                    try {
                        Parcelable[] accounts = new Account[this.mAccountsWithFeatures.size()];
                        for (int i = 0; i < accounts.length; ++i) {
                            accounts[i] = this.mAccountsWithFeatures.get(i);
                        }
                        Bundle result = new Bundle();
                        result.putParcelableArray(AccountManagerService.TABLE_ACCOUNTS, accounts);
                        response.onResult(result);
                    }
                    catch (RemoteException e) {
                        if (!Log.isLoggable(AccountManagerService.TAG, 2)) break block4;
                        Log.v(AccountManagerService.TAG, "failure while notifying response", e);
                    }
                }
            }
        }

        protected String toDebugString(long now) {
            return super.toDebugString(now) + ", getAccountsByTypeAndFeatures" + ", " + (this.mFeatures != null ? TextUtils.join((CharSequence)",", this.mFeatures) : null);
        }
    }

    private class RemoveAccountSession
    extends Session {
        final Account mAccount;

        public RemoveAccountSession(IAccountManagerResponse response, Account account) {
            super(response, account.type, false, true);
            this.mAccount = account;
        }

        protected String toDebugString(long now) {
            return super.toDebugString(now) + ", removeAccount" + ", account " + this.mAccount;
        }

        public void run() throws RemoteException {
            this.mAuthenticator.getAccountRemovalAllowed(this, this.mAccount);
        }

        public void onResult(Bundle result) {
            if (result != null && result.containsKey("booleanResult") && !result.containsKey("intent")) {
                IAccountManagerResponse response;
                boolean removalAllowed = result.getBoolean("booleanResult");
                if (removalAllowed) {
                    AccountManagerService.this.removeAccount(this.mAccount);
                }
                if ((response = this.getResponseAndClose()) != null) {
                    Bundle result2 = new Bundle();
                    result2.putBoolean("booleanResult", removalAllowed);
                    try {
                        response.onResult(result2);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
            }
            super.onResult(result);
        }
    }

    private class TestFeaturesSession
    extends Session {
        private final String[] mFeatures;
        private final Account mAccount;

        public TestFeaturesSession(IAccountManagerResponse response, Account account, String[] features) {
            super(response, account.type, false, true);
            this.mFeatures = features;
            this.mAccount = account;
        }

        public void run() throws RemoteException {
            try {
                this.mAuthenticator.hasFeatures(this, this.mAccount, this.mFeatures);
            }
            catch (RemoteException e) {
                this.onError(1, "remote exception");
            }
        }

        public void onResult(Bundle result) {
            block4: {
                IAccountManagerResponse response = this.getResponseAndClose();
                if (response != null) {
                    try {
                        if (result == null) {
                            this.onError(5, "null bundle");
                            return;
                        }
                        Bundle newResult = new Bundle();
                        newResult.putBoolean("booleanResult", result.getBoolean("booleanResult", false));
                        response.onResult(newResult);
                    }
                    catch (RemoteException e) {
                        if (!Log.isLoggable(AccountManagerService.TAG, 2)) break block4;
                        Log.v(AccountManagerService.TAG, "failure while notifying response", e);
                    }
                }
            }
        }

        protected String toDebugString(long now) {
            return super.toDebugString(now) + ", hasFeatures" + ", " + this.mAccount + ", " + (this.mFeatures != null ? TextUtils.join((CharSequence)",", this.mFeatures) : null);
        }
    }

    public class AuthTokenKey {
        public final Account mAccount;
        public final String mAuthTokenType;
        private final int mHashCode;

        public AuthTokenKey(Account account, String authTokenType) {
            this.mAccount = account;
            this.mAuthTokenType = authTokenType;
            this.mHashCode = this.computeHashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuthTokenKey)) {
                return false;
            }
            AuthTokenKey other = (AuthTokenKey)o;
            if (!this.mAccount.equals(other.mAccount)) {
                return false;
            }
            return this.mAuthTokenType == null ? other.mAuthTokenType == null : this.mAuthTokenType.equals(other.mAuthTokenType);
        }

        private int computeHashCode() {
            int result = 17;
            result = 31 * result + this.mAccount.hashCode();
            result = 31 * result + (this.mAuthTokenType == null ? 0 : this.mAuthTokenType.hashCode());
            return result;
        }

        public int hashCode() {
            return this.mHashCode;
        }
    }
}

