/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceConnection;
import android.accessibilityservice.IEventListener;
import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;
import com.android.internal.os.HandlerCaller;

public abstract class AccessibilityService
extends Service {
    public static final String SERVICE_INTERFACE = "android.accessibilityservice.AccessibilityService";
    private static final String LOG_TAG = "AccessibilityService";
    private AccessibilityServiceInfo mInfo;
    IAccessibilityServiceConnection mConnection;

    public abstract void onAccessibilityEvent(AccessibilityEvent var1);

    public abstract void onInterrupt();

    protected void onServiceConnected() {
    }

    public final void setServiceInfo(AccessibilityServiceInfo info) {
        this.mInfo = info;
        this.sendServiceInfo();
    }

    private void sendServiceInfo() {
        if (this.mInfo != null && this.mConnection != null) {
            try {
                this.mConnection.setServiceInfo(this.mInfo);
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while setting AccessibilityServiceInfo", re);
            }
        }
    }

    public final IBinder onBind(Intent intent) {
        return new IEventListenerWrapper(this);
    }

    class IEventListenerWrapper
    extends IEventListener.Stub
    implements HandlerCaller.Callback {
        private static final int DO_SET_SET_CONNECTION = 10;
        private static final int DO_ON_INTERRUPT = 20;
        private static final int DO_ON_ACCESSIBILITY_EVENT = 30;
        private final HandlerCaller mCaller;
        private final AccessibilityService mTarget;

        public IEventListenerWrapper(AccessibilityService context) {
            this.mTarget = context;
            this.mCaller = new HandlerCaller(context, this);
        }

        public void setConnection(IAccessibilityServiceConnection connection) {
            Message message = this.mCaller.obtainMessageO(10, connection);
            this.mCaller.sendMessage(message);
        }

        public void onInterrupt() {
            Message message = this.mCaller.obtainMessage(20);
            this.mCaller.sendMessage(message);
        }

        public void onAccessibilityEvent(AccessibilityEvent event) {
            Message message = this.mCaller.obtainMessageO(30, event);
            this.mCaller.sendMessage(message);
        }

        public void executeMessage(Message message) {
            switch (message.what) {
                case 30: {
                    AccessibilityEvent event = (AccessibilityEvent)message.obj;
                    if (event != null) {
                        this.mTarget.onAccessibilityEvent(event);
                        event.recycle();
                    }
                    return;
                }
                case 20: {
                    this.mTarget.onInterrupt();
                    return;
                }
                case 10: {
                    AccessibilityService.this.mConnection = (IAccessibilityServiceConnection)message.obj;
                    this.mTarget.onServiceConnected();
                    return;
                }
            }
            Log.w(AccessibilityService.LOG_TAG, "Unknown message type " + message.what);
        }
    }
}

