/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.android.internal.util.HierarchicalState;
import com.android.internal.util.ProcessedMessages;
import java.util.ArrayList;
import java.util.HashMap;

public class HierarchicalStateMachine {
    private static final String TAG = "HierarchicalStateMachine";
    private String mName;
    public static final int HSM_QUIT_CMD = -1;
    public static final int HSM_INIT_CMD = -1;
    public static final boolean HANDLED = true;
    public static final boolean NOT_HANDLED = false;
    private HsmHandler mHsmHandler;
    private HandlerThread mHsmThread;

    private void initStateMachine(String name, Looper looper) {
        this.mName = name;
        this.mHsmHandler = new HsmHandler(looper, this);
    }

    protected HierarchicalStateMachine(String name) {
        this.mHsmThread = new HandlerThread(name);
        this.mHsmThread.start();
        Looper looper = this.mHsmThread.getLooper();
        this.initStateMachine(name, looper);
    }

    protected HierarchicalStateMachine(String name, Looper looper) {
        this.initStateMachine(name, looper);
    }

    protected final void addState(HierarchicalState state, HierarchicalState parent) {
        this.mHsmHandler.addState(state, parent);
    }

    protected final Message getCurrentMessage() {
        return this.mHsmHandler.getCurrentMessage();
    }

    protected final HierarchicalState getCurrentState() {
        return this.mHsmHandler.getCurrentState();
    }

    protected final void addState(HierarchicalState state) {
        this.mHsmHandler.addState(state, null);
    }

    protected final void setInitialState(HierarchicalState initialState) {
        this.mHsmHandler.setInitialState(initialState);
    }

    protected final void transitionTo(HierarchicalState destState) {
        this.mHsmHandler.transitionTo(destState);
    }

    protected final void transitionToHaltingState() {
        this.mHsmHandler.transitionTo(this.mHsmHandler.mHaltingState);
    }

    protected final void deferMessage(Message msg) {
        this.mHsmHandler.deferMessage(msg);
    }

    protected void unhandledMessage(Message msg) {
    }

    protected void haltedProcessMessage(Message msg) {
    }

    protected void halting() {
    }

    protected void quitting() {
    }

    public final String getName() {
        return this.mName;
    }

    public final void setProcessedMessagesSize(int maxSize) {
        this.mHsmHandler.setProcessedMessagesSize(maxSize);
    }

    public final int getProcessedMessagesSize() {
        return this.mHsmHandler.getProcessedMessagesSize();
    }

    public final int getProcessedMessagesCount() {
        return this.mHsmHandler.getProcessedMessagesCount();
    }

    public final ProcessedMessages.Info getProcessedMessage(int index) {
        return this.mHsmHandler.getProcessedMessage(index);
    }

    public final Handler getHandler() {
        return this.mHsmHandler;
    }

    public final Message obtainMessage() {
        return Message.obtain(this.mHsmHandler);
    }

    public final Message obtainMessage(int what) {
        return Message.obtain((Handler)this.mHsmHandler, what);
    }

    public final Message obtainMessage(int what, Object obj) {
        return Message.obtain(this.mHsmHandler, what, obj);
    }

    public final void sendMessage(int what) {
        this.mHsmHandler.sendMessage(this.obtainMessage(what));
    }

    public final void sendMessage(int what, Object obj) {
        this.mHsmHandler.sendMessage(this.obtainMessage(what, obj));
    }

    public final void sendMessage(Message msg) {
        this.mHsmHandler.sendMessage(msg);
    }

    public final void sendMessageDelayed(int what, long delayMillis) {
        this.mHsmHandler.sendMessageDelayed(this.obtainMessage(what), delayMillis);
    }

    public final void sendMessageDelayed(int what, Object obj, long delayMillis) {
        this.mHsmHandler.sendMessageDelayed(this.obtainMessage(what, obj), delayMillis);
    }

    public final void sendMessageDelayed(Message msg, long delayMillis) {
        this.mHsmHandler.sendMessageDelayed(msg, delayMillis);
    }

    protected final void sendMessageAtFrontOfQueue(int what, Object obj) {
        this.mHsmHandler.sendMessageAtFrontOfQueue(this.obtainMessage(what, obj));
    }

    protected final void sendMessageAtFrontOfQueue(int what) {
        this.mHsmHandler.sendMessageAtFrontOfQueue(this.obtainMessage(what));
    }

    protected final void sendMessageAtFrontOfQueue(Message msg) {
        this.mHsmHandler.sendMessageAtFrontOfQueue(msg);
    }

    public final void quit() {
        this.mHsmHandler.quit();
    }

    protected final boolean isQuit(Message msg) {
        return this.mHsmHandler.isQuit(msg);
    }

    public boolean isDbg() {
        return this.mHsmHandler.isDbg();
    }

    public void setDbg(boolean dbg) {
        this.mHsmHandler.setDbg(dbg);
    }

    public void start() {
        this.mHsmHandler.completeConstruction();
    }

    private static class HsmHandler
    extends Handler {
        private boolean mDbg = false;
        private static final Object mQuitObj = new Object();
        private static final Message mInitMsg = null;
        private Message mMsg;
        private ProcessedMessages mProcessedMessages = new ProcessedMessages();
        private boolean mIsConstructionCompleted;
        private StateInfo[] mStateStack;
        private int mStateStackTopIndex = -1;
        private StateInfo[] mTempStateStack;
        private int mTempStateStackCount;
        private HaltingState mHaltingState = new HaltingState();
        private QuittingState mQuittingState = new QuittingState();
        private HierarchicalStateMachine mHsm;
        private HashMap<HierarchicalState, StateInfo> mStateInfo = new HashMap();
        private HierarchicalState mInitialState;
        private HierarchicalState mDestState;
        private ArrayList<Message> mDeferredMessages = new ArrayList();

        public final void handleMessage(Message msg) {
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "handleMessage: E msg.what=" + msg.what);
            }
            this.mMsg = msg;
            if (!this.mIsConstructionCompleted) {
                Log.e(HierarchicalStateMachine.TAG, "The start method not called, ignore msg: " + msg);
                return;
            }
            this.processMsg(msg);
            this.performTransitions();
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "handleMessage: X");
            }
        }

        private void performTransitions() {
            HierarchicalState destState = null;
            while (this.mDestState != null) {
                if (this.mDbg) {
                    Log.d(HierarchicalStateMachine.TAG, "handleMessage: new destination call exit");
                }
                destState = this.mDestState;
                this.mDestState = null;
                StateInfo commonStateInfo = this.setupTempStateStackWithStatesToEnter(destState);
                this.invokeExitMethods(commonStateInfo);
                int stateStackEnteringIndex = this.moveTempStateStackToStateStack();
                this.invokeEnterMethods(stateStackEnteringIndex);
                this.moveDeferredMessageAtFrontOfQueue();
            }
            if (destState != null) {
                if (destState == this.mQuittingState) {
                    this.mHsm.quitting();
                    if (this.mHsm.mHsmThread != null) {
                        this.getLooper().quit();
                    }
                } else if (destState == this.mHaltingState) {
                    this.mHsm.halting();
                }
            }
        }

        private final void completeConstruction() {
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "completeConstruction: E");
            }
            int maxDepth = 0;
            for (StateInfo si : this.mStateInfo.values()) {
                int depth = 0;
                StateInfo i = si;
                while (i != null) {
                    i = i.parentStateInfo;
                    ++depth;
                }
                if (maxDepth >= depth) continue;
                maxDepth = depth;
            }
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "completeConstruction: maxDepth=" + maxDepth);
            }
            this.mStateStack = new StateInfo[maxDepth];
            this.mTempStateStack = new StateInfo[maxDepth];
            this.setupInitialStateStack();
            this.mIsConstructionCompleted = true;
            this.mMsg = this.obtainMessage(-1);
            this.invokeEnterMethods(0);
            this.performTransitions();
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "completeConstruction: X");
            }
        }

        private final void processMsg(Message msg) {
            StateInfo curStateInfo = this.mStateStack[this.mStateStackTopIndex];
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "processMsg: " + curStateInfo.state.getName());
            }
            while (!curStateInfo.state.processMessage(msg)) {
                curStateInfo = curStateInfo.parentStateInfo;
                if (curStateInfo == null) {
                    this.mHsm.unhandledMessage(msg);
                    if (!this.isQuit(msg)) break;
                    this.transitionTo(this.mQuittingState);
                    break;
                }
                if (!this.mDbg) continue;
                Log.d(HierarchicalStateMachine.TAG, "processMsg: " + curStateInfo.state.getName());
            }
            if (curStateInfo != null) {
                HierarchicalState orgState = this.mStateStack[this.mStateStackTopIndex].state;
                this.mProcessedMessages.add(msg, curStateInfo.state, orgState);
            } else {
                this.mProcessedMessages.add(msg, null, null);
            }
        }

        private final void invokeExitMethods(StateInfo commonStateInfo) {
            while (this.mStateStackTopIndex >= 0 && this.mStateStack[this.mStateStackTopIndex] != commonStateInfo) {
                HierarchicalState curState = this.mStateStack[this.mStateStackTopIndex].state;
                if (this.mDbg) {
                    Log.d(HierarchicalStateMachine.TAG, "invokeExitMethods: " + curState.getName());
                }
                curState.exit();
                this.mStateStack[this.mStateStackTopIndex].active = false;
                --this.mStateStackTopIndex;
            }
        }

        private final void invokeEnterMethods(int stateStackEnteringIndex) {
            for (int i = stateStackEnteringIndex; i <= this.mStateStackTopIndex; ++i) {
                if (this.mDbg) {
                    Log.d(HierarchicalStateMachine.TAG, "invokeEnterMethods: " + this.mStateStack[i].state.getName());
                }
                this.mStateStack[i].state.enter();
                this.mStateStack[i].active = true;
            }
        }

        private final void moveDeferredMessageAtFrontOfQueue() {
            for (int i = this.mDeferredMessages.size() - 1; i >= 0; --i) {
                Message curMsg = this.mDeferredMessages.get(i);
                if (this.mDbg) {
                    Log.d(HierarchicalStateMachine.TAG, "moveDeferredMessageAtFrontOfQueue; what=" + curMsg.what);
                }
                this.sendMessageAtFrontOfQueue(curMsg);
            }
            this.mDeferredMessages.clear();
        }

        private final int moveTempStateStackToStateStack() {
            int startingIndex = this.mStateStackTopIndex + 1;
            int j = startingIndex;
            for (int i = this.mTempStateStackCount - 1; i >= 0; --i) {
                if (this.mDbg) {
                    Log.d(HierarchicalStateMachine.TAG, "moveTempStackToStateStack: i=" + i + ",j=" + j);
                }
                this.mStateStack[j] = this.mTempStateStack[i];
                ++j;
            }
            this.mStateStackTopIndex = j - 1;
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "moveTempStackToStateStack: X mStateStackTop=" + this.mStateStackTopIndex + ",startingIndex=" + startingIndex + ",Top=" + this.mStateStack[this.mStateStackTopIndex].state.getName());
            }
            return startingIndex;
        }

        private final StateInfo setupTempStateStackWithStatesToEnter(HierarchicalState destState) {
            this.mTempStateStackCount = 0;
            StateInfo curStateInfo = this.mStateInfo.get(destState);
            do {
                this.mTempStateStack[this.mTempStateStackCount++] = curStateInfo;
            } while ((curStateInfo = curStateInfo.parentStateInfo) != null && !curStateInfo.active);
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "setupTempStateStackWithStatesToEnter: X mTempStateStackCount=" + this.mTempStateStackCount + ",curStateInfo: " + curStateInfo);
            }
            return curStateInfo;
        }

        private final void setupInitialStateStack() {
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "setupInitialStateStack: E mInitialState=" + this.mInitialState.getName());
            }
            StateInfo curStateInfo = this.mStateInfo.get(this.mInitialState);
            this.mTempStateStackCount = 0;
            while (curStateInfo != null) {
                this.mTempStateStack[this.mTempStateStackCount] = curStateInfo;
                curStateInfo = curStateInfo.parentStateInfo;
                ++this.mTempStateStackCount;
            }
            this.mStateStackTopIndex = -1;
            this.moveTempStateStackToStateStack();
        }

        private final Message getCurrentMessage() {
            return this.mMsg;
        }

        private final HierarchicalState getCurrentState() {
            return this.mStateStack[this.mStateStackTopIndex].state;
        }

        private final StateInfo addState(HierarchicalState state, HierarchicalState parent) {
            StateInfo stateInfo;
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "addStateInternal: E state=" + state.getName() + ",parent=" + (parent == null ? "" : parent.getName()));
            }
            StateInfo parentStateInfo = null;
            if (parent != null && (parentStateInfo = this.mStateInfo.get(parent)) == null) {
                parentStateInfo = this.addState(parent, null);
            }
            if ((stateInfo = this.mStateInfo.get(state)) == null) {
                stateInfo = new StateInfo();
                this.mStateInfo.put(state, stateInfo);
            }
            if (stateInfo.parentStateInfo != null && stateInfo.parentStateInfo != parentStateInfo) {
                throw new RuntimeException("state already added");
            }
            stateInfo.state = state;
            stateInfo.parentStateInfo = parentStateInfo;
            stateInfo.active = false;
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "addStateInternal: X stateInfo: " + stateInfo);
            }
            return stateInfo;
        }

        private HsmHandler(Looper looper, HierarchicalStateMachine hsm) {
            super(looper);
            this.mHsm = hsm;
            this.addState(this.mHaltingState, null);
            this.addState(this.mQuittingState, null);
        }

        private final void setInitialState(HierarchicalState initialState) {
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "setInitialState: initialState" + initialState.getName());
            }
            this.mInitialState = initialState;
        }

        private final void transitionTo(HierarchicalState destState) {
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "StateMachine.transitionTo EX destState" + destState.getName());
            }
            this.mDestState = destState;
        }

        private final void deferMessage(Message msg) {
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "deferMessage: msg=" + msg.what);
            }
            Message newMsg = this.obtainMessage();
            newMsg.copyFrom(msg);
            this.mDeferredMessages.add(newMsg);
        }

        private final void quit() {
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "quit:");
            }
            this.sendMessage(this.obtainMessage(-1, mQuitObj));
        }

        private final boolean isQuit(Message msg) {
            return msg.what == -1 && msg.obj == mQuitObj;
        }

        private final boolean isDbg() {
            return this.mDbg;
        }

        private final void setDbg(boolean dbg) {
            this.mDbg = dbg;
        }

        private final void setProcessedMessagesSize(int maxSize) {
            this.mProcessedMessages.setSize(maxSize);
        }

        private final int getProcessedMessagesSize() {
            return this.mProcessedMessages.size();
        }

        private final int getProcessedMessagesCount() {
            return this.mProcessedMessages.count();
        }

        private final ProcessedMessages.Info getProcessedMessage(int index) {
            return this.mProcessedMessages.get(index);
        }

        private class QuittingState
        extends HierarchicalState {
            private QuittingState() {
            }

            public boolean processMessage(Message msg) {
                return false;
            }
        }

        private class HaltingState
        extends HierarchicalState {
            private HaltingState() {
            }

            public boolean processMessage(Message msg) {
                HsmHandler.this.mHsm.haltedProcessMessage(msg);
                return true;
            }
        }

        private class StateInfo {
            HierarchicalState state;
            StateInfo parentStateInfo;
            boolean active;

            private StateInfo() {
            }

            public String toString() {
                return "state=" + this.state.getName() + ",active=" + this.active + ",parent=" + (this.parentStateInfo == null ? "null" : this.parentStateInfo.state.getName());
            }
        }
    }
}

