/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.test;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.telephony.PhoneNumberUtils;
import android.util.Log;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.test.CallInfo;
import com.android.internal.telephony.test.InvalidStateEx;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimulatedGsmCallState
extends Handler {
    CallInfo[] calls = new CallInfo[7];
    private boolean autoProgressConnecting = true;
    private boolean nextDialFailImmediately;
    static final int EVENT_PROGRESS_CALL_STATE = 1;
    static final int MAX_CALLS = 7;
    static final int CONNECTING_PAUSE_MSEC = 500;

    public SimulatedGsmCallState(Looper looper) {
        super(looper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            switch (msg.what) {
                case 1: {
                    this.progressConnectingCallState();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean triggerRing(String number) {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            int empty = -1;
            boolean isCallWaiting = false;
            for (int i = 0; i < this.calls.length; ++i) {
                CallInfo call = this.calls[i];
                if (call == null && empty < 0) {
                    empty = i;
                    continue;
                }
                if (call != null && (call.state == CallInfo.State.INCOMING || call.state == CallInfo.State.WAITING)) {
                    Log.w("ModelInterpreter", "triggerRing failed; phone already ringing");
                    return false;
                }
                if (call == null) continue;
                isCallWaiting = true;
            }
            if (empty < 0) {
                Log.w("ModelInterpreter", "triggerRing failed; all full");
                return false;
            }
            this.calls[empty] = CallInfo.createIncomingCall(PhoneNumberUtils.extractNetworkPortion(number));
            if (isCallWaiting) {
                this.calls[empty].state = CallInfo.State.WAITING;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressConnectingCallState() {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            for (int i = 0; i < this.calls.length; ++i) {
                CallInfo call = this.calls[i];
                if (call != null && call.state == CallInfo.State.DIALING) {
                    call.state = CallInfo.State.ALERTING;
                    if (!this.autoProgressConnecting) break;
                    this.sendMessageDelayed(this.obtainMessage(1, call), 500L);
                    break;
                }
                if (call == null || call.state != CallInfo.State.ALERTING) continue;
                call.state = CallInfo.State.ACTIVE;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressConnectingToActive() {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            for (int i = 0; i < this.calls.length; ++i) {
                CallInfo call = this.calls[i];
                if (call == null || call.state != CallInfo.State.DIALING && call.state != CallInfo.State.ALERTING) continue;
                call.state = CallInfo.State.ACTIVE;
                break;
            }
        }
    }

    public void setAutoProgressConnectingCall(boolean b) {
        this.autoProgressConnecting = b;
    }

    public void setNextDialFailImmediately(boolean b) {
        this.nextDialFailImmediately = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean triggerHangupForeground() {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            CallInfo call;
            int i;
            boolean found = false;
            for (i = 0; i < this.calls.length; ++i) {
                call = this.calls[i];
                if (call == null || call.state != CallInfo.State.INCOMING && call.state != CallInfo.State.WAITING) continue;
                this.calls[i] = null;
                found = true;
            }
            for (i = 0; i < this.calls.length; ++i) {
                call = this.calls[i];
                if (call == null || call.state != CallInfo.State.DIALING && call.state != CallInfo.State.ACTIVE && call.state != CallInfo.State.ALERTING) continue;
                this.calls[i] = null;
                found = true;
            }
            return found;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean triggerHangupBackground() {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            boolean found = false;
            for (int i = 0; i < this.calls.length; ++i) {
                CallInfo call = this.calls[i];
                if (call == null || call.state != CallInfo.State.HOLDING) continue;
                this.calls[i] = null;
                found = true;
            }
            return found;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean triggerHangupAll() {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            boolean found = false;
            for (int i = 0; i < this.calls.length; ++i) {
                CallInfo call = this.calls[i];
                if (this.calls[i] != null) {
                    found = true;
                }
                this.calls[i] = null;
            }
            return found;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onAnswer() {
        SimulatedGsmCallState simulatedGsmCallState = this;
        synchronized (simulatedGsmCallState) {
            for (int i = 0; i < this.calls.length; ++i) {
                CallInfo call = this.calls[i];
                if (call == null || call.state != CallInfo.State.INCOMING && call.state != CallInfo.State.WAITING) continue;
                return this.switchActiveAndHeldOrWaiting();
            }
        }
        return false;
    }

    public boolean onHangup() {
        boolean found = false;
        for (int i = 0; i < this.calls.length; ++i) {
            CallInfo call = this.calls[i];
            if (call == null || call.state == CallInfo.State.WAITING) continue;
            this.calls[i] = null;
            found = true;
        }
        return found;
    }

    public boolean onChld(char c0, char c1) {
        boolean ret;
        int callIndex = 0;
        if (c1 != '\u0000' && ((callIndex = c1 - 49) < 0 || callIndex >= this.calls.length)) {
            return false;
        }
        switch (c0) {
            case '0': {
                ret = this.releaseHeldOrUDUB();
                break;
            }
            case '1': {
                if (c1 <= '\u0000') {
                    ret = this.releaseActiveAcceptHeldOrWaiting();
                    break;
                }
                if (this.calls[callIndex] == null) {
                    ret = false;
                    break;
                }
                this.calls[callIndex] = null;
                ret = true;
                break;
            }
            case '2': {
                if (c1 <= '\u0000') {
                    ret = this.switchActiveAndHeldOrWaiting();
                    break;
                }
                ret = this.separateCall(callIndex);
                break;
            }
            case '3': {
                ret = this.conference();
                break;
            }
            case '4': {
                ret = this.explicitCallTransfer();
                break;
            }
            case '5': {
                ret = false;
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }

    public boolean releaseHeldOrUDUB() {
        CallInfo c;
        int i;
        boolean found = false;
        for (i = 0; i < this.calls.length; ++i) {
            c = this.calls[i];
            if (c == null || !c.isRinging()) continue;
            found = true;
            this.calls[i] = null;
            break;
        }
        if (!found) {
            for (i = 0; i < this.calls.length; ++i) {
                c = this.calls[i];
                if (c == null || c.state != CallInfo.State.HOLDING) continue;
                found = true;
                this.calls[i] = null;
            }
        }
        return true;
    }

    public boolean releaseActiveAcceptHeldOrWaiting() {
        CallInfo c;
        int i;
        boolean foundHeld = false;
        boolean foundActive = false;
        for (i = 0; i < this.calls.length; ++i) {
            c = this.calls[i];
            if (c == null || c.state != CallInfo.State.ACTIVE) continue;
            this.calls[i] = null;
            foundActive = true;
        }
        if (!foundActive) {
            for (i = 0; i < this.calls.length; ++i) {
                c = this.calls[i];
                if (c == null || c.state != CallInfo.State.DIALING && c.state != CallInfo.State.ALERTING) continue;
                this.calls[i] = null;
                foundActive = true;
            }
        }
        for (i = 0; i < this.calls.length; ++i) {
            c = this.calls[i];
            if (c == null || c.state != CallInfo.State.HOLDING) continue;
            c.state = CallInfo.State.ACTIVE;
            foundHeld = true;
        }
        if (foundHeld) {
            return true;
        }
        for (i = 0; i < this.calls.length; ++i) {
            c = this.calls[i];
            if (c == null || !c.isRinging()) continue;
            c.state = CallInfo.State.ACTIVE;
            return true;
        }
        return true;
    }

    public boolean switchActiveAndHeldOrWaiting() {
        CallInfo c;
        int i;
        boolean hasHeld = false;
        for (i = 0; i < this.calls.length; ++i) {
            c = this.calls[i];
            if (c == null || c.state != CallInfo.State.HOLDING) continue;
            hasHeld = true;
            break;
        }
        for (i = 0; i < this.calls.length; ++i) {
            c = this.calls[i];
            if (c == null) continue;
            if (c.state == CallInfo.State.ACTIVE) {
                c.state = CallInfo.State.HOLDING;
                continue;
            }
            if (c.state == CallInfo.State.HOLDING) {
                c.state = CallInfo.State.ACTIVE;
                continue;
            }
            if (hasHeld || !c.isRinging()) continue;
            c.state = CallInfo.State.ACTIVE;
        }
        return true;
    }

    public boolean separateCall(int index) {
        try {
            CallInfo c = this.calls[index];
            if (c == null || c.isConnecting() || this.countActiveLines() != 1) {
                return false;
            }
            c.state = CallInfo.State.ACTIVE;
            c.isMpty = false;
            for (int i = 0; i < this.calls.length; ++i) {
                CallInfo cb;
                int countHeld = 0;
                int lastHeld = 0;
                if (i != index && (cb = this.calls[i]) != null && cb.state == CallInfo.State.ACTIVE) {
                    cb.state = CallInfo.State.HOLDING;
                    ++countHeld;
                    lastHeld = i;
                }
                if (countHeld != true) continue;
                this.calls[lastHeld].isMpty = false;
            }
            return true;
        }
        catch (InvalidStateEx ex) {
            return false;
        }
    }

    public boolean conference() {
        CallInfo c;
        int i;
        int countCalls = 0;
        for (i = 0; i < this.calls.length; ++i) {
            c = this.calls[i];
            if (c == null) continue;
            ++countCalls;
            if (!c.isConnecting()) continue;
            return false;
        }
        for (i = 0; i < this.calls.length; ++i) {
            c = this.calls[i];
            if (c == null) continue;
            c.state = CallInfo.State.ACTIVE;
            if (countCalls <= 0) continue;
            c.isMpty = true;
        }
        return true;
    }

    public boolean explicitCallTransfer() {
        int countCalls = 0;
        for (int i = 0; i < this.calls.length; ++i) {
            CallInfo c = this.calls[i];
            if (c == null) continue;
            ++countCalls;
            if (!c.isConnecting()) continue;
            return false;
        }
        return this.triggerHangupAll();
    }

    public boolean onDial(String address) {
        int freeSlot = -1;
        Log.d("GSM", "SC> dial '" + address + "'");
        if (this.nextDialFailImmediately) {
            this.nextDialFailImmediately = false;
            Log.d("GSM", "SC< dial fail (per request)");
            return false;
        }
        String phNum = PhoneNumberUtils.extractNetworkPortion(address);
        if (phNum.length() == 0) {
            Log.d("GSM", "SC< dial fail (invalid ph num)");
            return false;
        }
        if (phNum.startsWith("*99") && phNum.endsWith("#")) {
            Log.d("GSM", "SC< dial ignored (gprs)");
            return true;
        }
        try {
            if (this.countActiveLines() > 1) {
                Log.d("GSM", "SC< dial fail (invalid call state)");
                return false;
            }
        }
        catch (InvalidStateEx ex) {
            Log.d("GSM", "SC< dial fail (invalid call state)");
            return false;
        }
        for (int i = 0; i < this.calls.length; ++i) {
            if (freeSlot < 0 && this.calls[i] == null) {
                freeSlot = i;
            }
            if (this.calls[i] != null && !this.calls[i].isActiveOrHeld()) {
                Log.d("GSM", "SC< dial fail (invalid call state)");
                return false;
            }
            if (this.calls[i] == null || this.calls[i].state != CallInfo.State.ACTIVE) continue;
            this.calls[i].state = CallInfo.State.HOLDING;
        }
        if (freeSlot < 0) {
            Log.d("GSM", "SC< dial fail (invalid call state)");
            return false;
        }
        this.calls[freeSlot] = CallInfo.createOutgoingCall(phNum);
        if (this.autoProgressConnecting) {
            this.sendMessageDelayed(this.obtainMessage(1, this.calls[freeSlot]), 500L);
        }
        Log.d("GSM", "SC< dial (slot = " + freeSlot + ")");
        return true;
    }

    public List<DriverCall> getDriverCalls() {
        ArrayList<DriverCall> ret = new ArrayList<DriverCall>(this.calls.length);
        for (int i = 0; i < this.calls.length; ++i) {
            CallInfo c = this.calls[i];
            if (c == null) continue;
            DriverCall dc = c.toDriverCall(i + 1);
            ret.add(dc);
        }
        Log.d("GSM", "SC< getDriverCalls " + ret);
        return ret;
    }

    public List<String> getClccLines() {
        ArrayList<String> ret = new ArrayList<String>(this.calls.length);
        for (int i = 0; i < this.calls.length; ++i) {
            CallInfo c = this.calls[i];
            if (c == null) continue;
            ret.add(c.toCLCCLine(i + 1));
        }
        return ret;
    }

    private int countActiveLines() throws InvalidStateEx {
        boolean hasMpty = false;
        boolean hasHeld = false;
        boolean hasActive = false;
        boolean hasConnecting = false;
        boolean hasRinging = false;
        boolean mptyIsHeld = false;
        for (int i = 0; i < this.calls.length; ++i) {
            CallInfo call = this.calls[i];
            if (call == null) continue;
            if (!hasMpty && call.isMpty) {
                mptyIsHeld = call.state == CallInfo.State.HOLDING;
            } else {
                if (call.isMpty && mptyIsHeld && call.state == CallInfo.State.ACTIVE) {
                    Log.e("ModelInterpreter", "Invalid state");
                    throw new InvalidStateEx();
                }
                if (!call.isMpty && hasMpty && mptyIsHeld && call.state == CallInfo.State.HOLDING) {
                    Log.e("ModelInterpreter", "Invalid state");
                    throw new InvalidStateEx();
                }
            }
            hasMpty |= call.isMpty;
            hasHeld |= call.state == CallInfo.State.HOLDING;
            hasActive |= call.state == CallInfo.State.ACTIVE;
            hasConnecting |= call.isConnecting();
            hasRinging |= call.isRinging();
        }
        int ret = 0;
        if (hasHeld) {
            ++ret;
        }
        if (hasActive) {
            ++ret;
        }
        if (hasConnecting) {
            ++ret;
        }
        if (hasRinging) {
            ++ret;
        }
        return ret;
    }
}

